(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 12.1' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[    537311,      14421]
NotebookOptionsPosition[    488340,      13669]
NotebookOutlinePosition[    488774,      13686]
CellTagsIndexPosition[    488731,      13683]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{"Define", " ", "relevant", " ", "functions"}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"chiSpecial1", "[", 
      RowBox[{"psi_", ",", " ", "zetasq_"}], "]"}], " ", ":=", " ", 
     RowBox[{
      RowBox[{"-", 
       RowBox[{"(", 
        RowBox[{"1", "/", "2"}], ")"}]}], " ", "*", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"psi", "*", "zetasq"}], " ", "-", " ", "zetasq", " ", 
               "-", "1"}], ")"}], "^", "2"}], " ", "+", " ", 
            RowBox[{"4", " ", "*", " ", "zetasq", " ", "*", " ", "psi"}]}], 
           ")"}], "^", 
          RowBox[{"(", 
           RowBox[{"1", "/", "2"}], ")"}]}], " ", "+", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"psi", "*", "zetasq"}], " ", "-", "\[IndentingNewLine]", 
           "zetasq", " ", "-", "1"}], ")"}]}], ")"}], " ", "/", " ", 
       "zetasq"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"d0Special1", "[", 
      RowBox[{"zetasq_", ",", "psi1_", ",", "psi2_"}], "]"}], ":=", 
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", "chival", "}"}], ",", 
       RowBox[{
        RowBox[{"chival", "=", 
         RowBox[{"chiSpecial1", "[", 
          RowBox[{
           RowBox[{"Min", "[", 
            RowBox[{"psi1", ",", "psi2"}], "]"}], ",", "zetasq"}], "]"}]}], 
        ";", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{
          RowBox[{"chival", "^", "5"}], "*", 
          RowBox[{"zetasq", "^", "3"}]}], " ", "-", " ", 
         RowBox[{"3", "*", 
          RowBox[{"chival", "^", "4"}], "*", 
          RowBox[{"zetasq", "^", "2"}]}], "-", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"psi1", "*", "psi2"}], "-", "psi2", "-", "psi1", "+", 
            "1"}], ")"}], "*", 
          RowBox[{"chival", "^", "3"}], "*", 
          RowBox[{"zetasq", "^", "3"}]}], " ", "+", " ", 
         RowBox[{"2", "*", 
          RowBox[{"chival", "^", "3"}], "*", 
          RowBox[{"zetasq", "^", "2"}]}], " ", "+", " ", 
         RowBox[{"3", "*", 
          RowBox[{"chival", "^", "3"}], "*", "zetasq"}], " ", "-", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"psi1", "+", "psi2", "-", 
            RowBox[{"3", "*", "psi1", "*", "psi2"}], "+", "1"}], ")"}], "*", 
          RowBox[{"chival", "^", "2"}], "*", 
          RowBox[{"zetasq", "^", "2"}]}], " ", "-", " ", 
         RowBox[{"2", "*", 
          RowBox[{"chival", "^", "2"}], "*", "zetasq"}], " ", "-", " ", 
         RowBox[{"chival", "^", "2"}], " ", "-", " ", 
         RowBox[{
         "3", "*", "psi1", "*", "psi2", "*", "chival", "*", "zetasq"}], " ", 
         "+", " ", 
         RowBox[{"psi1", "*", "psi2"}]}]}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"d0Special1mod", "[", 
      RowBox[{"zetasq_", ",", "psi1_", ",", "psi2_", ",", " ", "chi_"}], 
      "]"}], ":=", 
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", "chival", "}"}], ",", 
       RowBox[{
        RowBox[{"chival", "=", " ", "chi"}], ";", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{
          RowBox[{"chival", "^", "5"}], "*", 
          RowBox[{"zetasq", "^", "3"}]}], " ", "-", " ", 
         RowBox[{"3", "*", 
          RowBox[{"chival", "^", "4"}], "*", 
          RowBox[{"zetasq", "^", "2"}]}], "-", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"psi1", "*", "psi2"}], "-", "psi2", "-", "psi1", "+", 
            "1"}], ")"}], "*", 
          RowBox[{"chival", "^", "3"}], "*", 
          RowBox[{"zetasq", "^", "3"}]}], " ", "+", " ", 
         RowBox[{"2", "*", 
          RowBox[{"chival", "^", "3"}], "*", 
          RowBox[{"zetasq", "^", "2"}]}], " ", "+", " ", 
         RowBox[{"3", "*", 
          RowBox[{"chival", "^", "3"}], "*", "zetasq"}], " ", "-", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"psi1", "+", "psi2", "-", 
            RowBox[{"3", "*", "psi1", "*", "psi2"}], "+", "1"}], ")"}], "*", 
          RowBox[{"chival", "^", "2"}], "*", 
          RowBox[{"zetasq", "^", "2"}]}], " ", "-", " ", 
         RowBox[{"2", "*", 
          RowBox[{"chival", "^", "2"}], "*", "zetasq"}], " ", "-", " ", 
         RowBox[{"chival", "^", "2"}], " ", "-", " ", 
         RowBox[{
         "3", "*", "psi1", "*", "psi2", "*", "chival", "*", "zetasq"}], " ", 
         "+", " ", 
         RowBox[{"psi1", "*", "psi2"}]}]}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"d1Special1", "[", 
      RowBox[{"zetasq_", ",", "psi1_", ",", "psi2_"}], "]"}], ":=", 
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", "chival", "}"}], ",", 
       RowBox[{
        RowBox[{"chival", "=", 
         RowBox[{"chiSpecial1", "[", 
          RowBox[{
           RowBox[{"Min", "[", 
            RowBox[{"psi1", ",", "psi2"}], "]"}], ",", "zetasq"}], "]"}]}], 
        ";", 
        RowBox[{
         RowBox[{
          RowBox[{"chival", "^", "6"}], "*", 
          RowBox[{"zetasq", "^", "3"}]}], " ", "-", " ", 
         RowBox[{"2", "*", 
          RowBox[{"chival", "^", "5"}], "*", 
          RowBox[{"zetasq", "^", "2"}]}], "-", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"psi1", "*", "psi2"}], "-", "psi1", "-", "psi2", "+", 
            "1"}], ")"}], "*", 
          RowBox[{"chival", "^", "4"}], "*", 
          RowBox[{"zetasq", "^", "3"}]}], " ", "+", " ", 
         RowBox[{
          RowBox[{"chival", "^", "4"}], "*", 
          RowBox[{"zetasq", "^", "2"}]}], " ", "+", " ", 
         RowBox[{
          RowBox[{"chival", "^", "4"}], "*", "zetasq"}], " ", "-", 
         RowBox[{"2", "*", 
          RowBox[{"(", 
           RowBox[{"1", "-", 
            RowBox[{"(", 
             RowBox[{"psi1", " ", "*", " ", "psi2"}], ")"}]}], ")"}], "*", 
          RowBox[{"chival", "^", "3"}], "*", 
          RowBox[{"zetasq", "^", "2"}]}], " ", "-", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"psi1", " ", "+", " ", "psi2", " ", "+", " ", 
            RowBox[{"psi1", "*", "psi2"}], " ", "+", " ", "1"}], ")"}], "*", 
          RowBox[{"chival", "^", "2"}], "*", "zetasq"}], "  ", "-", " ", 
         RowBox[{"chival", "^", "2"}]}]}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"d1Special1mod", "[", 
      RowBox[{"zetasq_", ",", "psi1_", ",", "psi2_", ",", " ", "chi_"}], 
      "]"}], ":=", 
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", "chival", "}"}], ",", 
       RowBox[{
        RowBox[{"chival", "=", "chi"}], ";", 
        RowBox[{
         RowBox[{
          RowBox[{"chival", "^", "6"}], "*", 
          RowBox[{"zetasq", "^", "3"}]}], " ", "-", " ", 
         RowBox[{"2", "*", 
          RowBox[{"chival", "^", "5"}], "*", 
          RowBox[{"zetasq", "^", "2"}]}], "-", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"psi1", "*", "psi2"}], "-", "psi1", "-", "psi2", "+", 
            "1"}], ")"}], "*", 
          RowBox[{"chival", "^", "4"}], "*", 
          RowBox[{"zetasq", "^", "3"}]}], " ", "+", " ", 
         RowBox[{
          RowBox[{"chival", "^", "4"}], "*", 
          RowBox[{"zetasq", "^", "2"}]}], " ", "+", " ", 
         RowBox[{
          RowBox[{"chival", "^", "4"}], "*", "zetasq"}], " ", "-", 
         RowBox[{"2", "*", 
          RowBox[{"(", 
           RowBox[{"1", "-", 
            RowBox[{"(", 
             RowBox[{"psi1", " ", "*", " ", "psi2"}], ")"}]}], ")"}], "*", 
          RowBox[{"chival", "^", "3"}], "*", 
          RowBox[{"zetasq", "^", "2"}]}], " ", "-", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"psi1", " ", "+", " ", "psi2", " ", "+", " ", 
            RowBox[{"psi1", "*", "psi2"}], " ", "+", " ", "1"}], ")"}], "*", 
          RowBox[{"chival", "^", "2"}], "*", "zetasq"}], "  ", "-", " ", 
         RowBox[{"chival", "^", "2"}]}]}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"d2Special1", " ", "[", 
      RowBox[{"zetasq_", ",", "psi1_", ",", "psi2_"}], "]"}], ":=", 
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", "chival", "}"}], ",", 
       RowBox[{
        RowBox[{"chival", "=", 
         RowBox[{"chiSpecial1", "[", 
          RowBox[{
           RowBox[{"Min", "[", 
            RowBox[{"psi1", ",", "psi2"}], "]"}], ",", "zetasq"}], "]"}]}], 
        ";", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{
          RowBox[{"-", 
           RowBox[{"(", 
            RowBox[{"psi1", "-", "1"}], ")"}]}], "*", 
          RowBox[{"chival", "^", "3"}], " ", "*", " ", 
          RowBox[{"zetasq", "^", "2"}]}], " ", "-", " ", 
         RowBox[{
          RowBox[{"chival", "^", "3"}], " ", "*", " ", "zetasq"}], " ", "+", 
         " ", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"psi1", "+", "1"}], ")"}], "*", 
          RowBox[{"chival", "^", "2"}], "*", "zetasq"}], " ", "+", " ", 
         RowBox[{"chival", "^", "2"}]}]}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"d2Special1mod", " ", "[", 
      RowBox[{"zetasq_", ",", "psi1_", ",", "psi2_", ",", " ", "chi_"}], 
      "]"}], ":=", 
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", "chival", "}"}], ",", 
       RowBox[{
        RowBox[{"chival", "=", "chi"}], ";", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{
          RowBox[{"-", 
           RowBox[{"(", 
            RowBox[{"psi1", "-", "1"}], ")"}]}], "*", 
          RowBox[{"chival", "^", "3"}], " ", "*", " ", 
          RowBox[{"zetasq", "^", "2"}]}], " ", "-", " ", 
         RowBox[{
          RowBox[{"chival", "^", "3"}], " ", "*", " ", "zetasq"}], " ", "+", 
         " ", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"psi1", "+", "1"}], ")"}], "*", 
          RowBox[{"chival", "^", "2"}], "*", "zetasq"}], " ", "+", " ", 
         RowBox[{"chival", "^", "2"}]}]}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"SSpecial1", "[", 
      RowBox[{
      "F1_", ",", " ", "Fs_", ",", " ", "tau_", ",", "psi1_", ",", "psi2_", 
       ",", "zetasq_"}], "]"}], ":=", "\[IndentingNewLine]", 
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", "chival", "}"}], ",", 
       RowBox[{
        RowBox[{"chival", "=", 
         RowBox[{"chiSpecial1", "[", 
          RowBox[{
           RowBox[{"Min", "[", 
            RowBox[{"psi1", ",", "psi2"}], "]"}], ",", "zetasq"}], "]"}]}], 
        ";", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{
          RowBox[{"F1", "^", "2"}], " ", "*", 
          RowBox[{"(", "zetasq", ")"}], "*", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"d1Special1", "[", 
             RowBox[{"zetasq", ",", "psi1", ",", "psi2"}], "]"}], "/", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{"chival", " ", "*", 
                 RowBox[{"(", "zetasq", ")"}]}], " ", "-", "1"}], " ", ")"}], 
              "*", 
              RowBox[{"d0Special1", "[", 
               RowBox[{"zetasq", ",", "psi1", ",", "psi2"}], "]"}]}], ")"}]}],
            ")"}]}], "+", " ", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"tau", "^", "2"}], "+", 
            RowBox[{"Fs", "^", "2"}]}], ")"}], "*", 
          RowBox[{"(", "zetasq", ")"}], "*", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"d2Special1", "[", 
             RowBox[{"zetasq", ",", "psi1", ",", "psi2"}], "]"}], "/", 
            RowBox[{"d0Special1", "[", 
             RowBox[{"zetasq", ",", "psi1", ",", "psi2"}], "]"}]}], 
           ")"}]}]}]}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"SSpecialmod", "[", 
      RowBox[{
      "F1_", ",", " ", "Fs_", ",", " ", "tau_", ",", "psi1_", ",", "psi2_", 
       ",", "zetasq_", ",", " ", "chi_"}], "]"}], ":=", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
       RowBox[{"F1", "^", "2"}], " ", "*", 
       RowBox[{"(", "zetasq", ")"}], "*", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"d1Special1mod", "[", 
          RowBox[{"zetasq", ",", "psi1", ",", "psi2", ",", " ", "chi"}], 
          "]"}], "/", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"chi", " ", "*", 
              RowBox[{"(", "zetasq", ")"}]}], " ", "-", "1"}], " ", ")"}], 
           "*", 
           RowBox[{"d0Special1mod", "[", 
            RowBox[{"zetasq", ",", "psi1", ",", "psi2", ",", " ", "chi"}], 
            "]"}]}], ")"}]}], ")"}]}], "+", " ", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"tau", "^", "2"}], "+", 
         RowBox[{"Fs", "^", "2"}]}], ")"}], "*", 
       RowBox[{"(", "zetasq", ")"}], "*", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"d2Special1mod", "[", 
          RowBox[{"zetasq", ",", "psi1", ",", "psi2", ",", " ", "chi"}], 
          "]"}], "/", 
         RowBox[{"d0Special1mod", "[", 
          RowBox[{"zetasq", ",", "psi1", ",", "psi2", ",", " ", "chi"}], 
          "]"}]}], ")"}]}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"chiSpecial1", "[", 
      RowBox[{"psi_", ",", " ", "zetasq_"}], "]"}], " ", ":=", " ", 
     RowBox[{
      RowBox[{"-", 
       RowBox[{"(", 
        RowBox[{"1", "/", "2"}], ")"}]}], " ", "*", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"psi", "*", "zetasq"}], " ", "-", " ", "zetasq", " ", 
               "-", "1"}], ")"}], "^", "2"}], " ", "+", " ", 
            RowBox[{"4", " ", "*", " ", "zetasq", " ", "*", " ", "psi"}]}], 
           ")"}], "^", 
          RowBox[{"(", 
           RowBox[{"1", "/", "2"}], ")"}]}], " ", "+", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"psi", "*", "zetasq"}], " ", "-", "\[IndentingNewLine]", 
           "zetasq", " ", "-", "1"}], ")"}]}], ")"}], " ", "/", " ", 
       "zetasq"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"eps0", "[", 
      RowBox[{"zetasq_", ",", " ", "psi1_", ",", " ", "psi2_"}], "]"}], " ", ":=", 
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", "chival", "}"}], ",", " ", 
       RowBox[{
        RowBox[{"chival", " ", "=", " ", 
         RowBox[{"chiSpecial1", "[", 
          RowBox[{
           RowBox[{"Min", "[", 
            RowBox[{"psi1", ",", " ", "psi2"}], "]"}], ",", " ", "zetasq"}], 
          "]"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{
          RowBox[{"-", 
           RowBox[{"chival", "^", "5"}]}], "*", 
          RowBox[{"zetasq", "^", "3"}]}], "+", 
         RowBox[{"3", "*", 
          RowBox[{"chival", "^", "4"}], "*", 
          RowBox[{"zetasq", "^", "2"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"psi1", "*", "psi2"}], "-", "psi2", "-", "psi1", "+", 
            "1"}], ")"}], "*", 
          RowBox[{"chival", "^", "3"}], "*", 
          RowBox[{"zetasq", "^", "3"}]}], "-", 
         RowBox[{"2", "*", 
          RowBox[{"chival", "^", "3"}], "*", 
          RowBox[{"zetasq", "^", "2"}]}], "-", 
         RowBox[{"3", "*", 
          RowBox[{"chival", "^", "3"}], "*", "zetasq"}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"psi1", "+", "psi2", "-", 
            RowBox[{"3", "*", "psi1", "*", "psi2"}], "+", "1"}], ")"}], "*", 
          RowBox[{"chival", "^", "2"}], "*", 
          RowBox[{"zetasq", "^", "2"}]}], "+", 
         RowBox[{"2", "*", 
          RowBox[{"chival", "^", "2"}], "*", "zetasq"}], "+", 
         RowBox[{"chival", "^", "2"}], "+", 
         RowBox[{
         "3", "*", "psi1", "*", "psi2", "*", "chival", "*", "zetasq"}], "-", 
         RowBox[{"psi1", "*", "psi2"}]}]}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"eps0mod", "[", 
      RowBox[{
      "zetasq_", ",", " ", "psi1_", ",", " ", "psi2_", ",", " ", "chi_"}], 
      "]"}], " ", ":=", 
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", "chival", "}"}], ",", " ", 
       RowBox[{
        RowBox[{"chival", " ", "=", " ", "chi"}], ";", "\[IndentingNewLine]", 
        
        RowBox[{
         RowBox[{
          RowBox[{"-", 
           RowBox[{"chival", "^", "5"}]}], "*", 
          RowBox[{"zetasq", "^", "3"}]}], "+", 
         RowBox[{"3", "*", 
          RowBox[{"chival", "^", "4"}], "*", 
          RowBox[{"zetasq", "^", "2"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"psi1", "*", "psi2"}], "-", "psi2", "-", "psi1", "+", 
            "1"}], ")"}], "*", 
          RowBox[{"chival", "^", "3"}], "*", 
          RowBox[{"zetasq", "^", "3"}]}], "-", 
         RowBox[{"2", "*", 
          RowBox[{"chival", "^", "3"}], "*", 
          RowBox[{"zetasq", "^", "2"}]}], "-", 
         RowBox[{"3", "*", 
          RowBox[{"chival", "^", "3"}], "*", "zetasq"}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"psi1", "+", "psi2", "-", 
            RowBox[{"3", "*", "psi1", "*", "psi2"}], "+", "1"}], ")"}], "*", 
          RowBox[{"chival", "^", "2"}], "*", 
          RowBox[{"zetasq", "^", "2"}]}], "+", 
         RowBox[{"2", "*", 
          RowBox[{"chival", "^", "2"}], "*", "zetasq"}], "+", 
         RowBox[{"chival", "^", "2"}], "+", 
         RowBox[{
         "3", "*", "psi1", "*", "psi2", "*", "chival", "*", "zetasq"}], "-", 
         RowBox[{"psi1", "*", "psi2"}]}]}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"eps1", "[", 
      RowBox[{"zetasq_", ",", " ", "psi1_", ",", " ", "psi2_"}], "]"}], " ", ":=",
      " ", 
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", "chival", "}"}], ",", " ", 
       RowBox[{
        RowBox[{"chival", " ", "=", " ", 
         RowBox[{"chiSpecial1", "[", 
          RowBox[{
           RowBox[{"Min", "[", 
            RowBox[{"psi1", ",", " ", "psi2"}], "]"}], ",", " ", "zetasq"}], 
          "]"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"psi2", "*", 
          RowBox[{"chival", "^", "3"}], "*", 
          RowBox[{"zetasq", "^", "2"}]}], "-", 
         RowBox[{"psi2", "*", 
          RowBox[{"(", 
           RowBox[{"chival", "^", "2"}], ")"}], "*", "zetasq"}], "+", 
         RowBox[{"psi1", "*", "psi2", "*", "chival", "*", "zetasq"}], "-", 
         RowBox[{"psi1", "*", "psi2"}]}]}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"eps1mod", "[", 
      RowBox[{
      "zetasq_", ",", " ", "psi1_", ",", " ", "psi2_", ",", " ", "chi_"}], 
      "]"}], " ", ":=", " ", 
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", "chival", "}"}], ",", " ", 
       RowBox[{
        RowBox[{"chival", " ", "=", " ", "chi"}], ";", "\[IndentingNewLine]", 
        
        RowBox[{
         RowBox[{"psi2", "*", 
          RowBox[{"chival", "^", "3"}], "*", 
          RowBox[{"zetasq", "^", "2"}]}], "-", 
         RowBox[{"psi2", "*", 
          RowBox[{"(", 
           RowBox[{"chival", "^", "2"}], ")"}], "*", "zetasq"}], "+", 
         RowBox[{"psi1", "*", "psi2", "*", "chival", "*", "zetasq"}], "-", 
         RowBox[{"psi1", "*", "psi2"}]}]}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"eps2", "[", 
      RowBox[{"zetasq_", ",", " ", "psi1_", ",", " ", "psi2_"}], "]"}], " ", ":=",
      " ", 
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", "chival", "}"}], ",", " ", 
       RowBox[{
        RowBox[{"chival", " ", "=", " ", 
         RowBox[{"chiSpecial1", "[", 
          RowBox[{
           RowBox[{"Min", "[", 
            RowBox[{"psi1", ",", " ", "psi2"}], "]"}], ",", " ", "zetasq"}], 
          "]"}]}], ";", 
        RowBox[{
         RowBox[{
          RowBox[{"chival", "^", "5"}], "*", 
          RowBox[{"zetasq", "^", "3"}]}], "-", 
         RowBox[{"3", "*", 
          RowBox[{"chival", "^", "4"}], "*", 
          RowBox[{"zetasq", "^", "2"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"psi1", "-", "1"}], ")"}], "*", 
          RowBox[{"chival", "^", "3"}], "*", 
          RowBox[{"zetasq", "^", "3"}]}], "+", 
         RowBox[{"2", "*", 
          RowBox[{"chival", "^", "3"}], "*", 
          RowBox[{"zetasq", "^", "2"}]}], "+", 
         RowBox[{"3", "*", 
          RowBox[{"chival", "^", "3"}], "*", "zetasq"}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "psi1"}], "-", "1"}], ")"}], "*", 
          RowBox[{"(", 
           RowBox[{"chival", "^", "2"}], ")"}], "*", 
          RowBox[{"(", 
           RowBox[{"zetasq", "^", "2"}], ")"}]}], "-", 
         RowBox[{"2", "*", 
          RowBox[{"(", 
           RowBox[{"chival", "^", "2"}], ")"}], "*", "zetasq"}], "-", 
         RowBox[{"(", 
          RowBox[{"chival", "^", "2"}], ")"}]}]}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"eps2mod", "[", 
      RowBox[{
      "zetasq_", ",", " ", "psi1_", ",", " ", "psi2_", ",", " ", "chi_"}], 
      "]"}], " ", ":=", " ", 
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", "chival", "}"}], ",", " ", 
       RowBox[{
        RowBox[{"chival", " ", "=", " ", "chi"}], ";", "\[IndentingNewLine]", 
        
        RowBox[{
         RowBox[{
          RowBox[{"chival", "^", "5"}], "*", 
          RowBox[{"zetasq", "^", "3"}]}], "-", 
         RowBox[{"3", "*", 
          RowBox[{"chival", "^", "4"}], "*", 
          RowBox[{"zetasq", "^", "2"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"psi1", "-", "1"}], ")"}], "*", 
          RowBox[{"chival", "^", "3"}], "*", 
          RowBox[{"zetasq", "^", "3"}]}], "+", 
         RowBox[{"2", "*", 
          RowBox[{"chival", "^", "3"}], "*", 
          RowBox[{"zetasq", "^", "2"}]}], "+", 
         RowBox[{"3", "*", 
          RowBox[{"chival", "^", "3"}], "*", "zetasq"}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "psi1"}], "-", "1"}], ")"}], "*", 
          RowBox[{"(", 
           RowBox[{"chival", "^", "2"}], ")"}], "*", 
          RowBox[{"(", 
           RowBox[{"zetasq", "^", "2"}], ")"}]}], "-", 
         RowBox[{"2", "*", 
          RowBox[{"(", 
           RowBox[{"chival", "^", "2"}], ")"}], "*", "zetasq"}], "-", 
         RowBox[{"(", 
          RowBox[{"chival", "^", "2"}], ")"}]}]}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"B", "[", 
      RowBox[{"zetasq_", ",", " ", "psi1_", ",", " ", "psi2_"}], "]"}], " ", ":=",
      " ", 
     RowBox[{
      RowBox[{"eps1", "[", 
       RowBox[{"zetasq", ",", " ", "psi1", ",", " ", "psi2"}], "]"}], " ", 
      "/", 
      RowBox[{"eps0", "[", 
       RowBox[{"zetasq", ",", " ", "psi1", ",", " ", "psi2"}], "]"}]}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"Bmod", "[", 
      RowBox[{
      "zetasq_", ",", " ", "psi1_", ",", " ", "psi2_", ",", " ", "chi_"}], 
      "]"}], " ", ":=", " ", 
     RowBox[{
      RowBox[{"eps1mod", "[", 
       RowBox[{
       "zetasq", ",", " ", "psi1", ",", " ", "psi2", ",", " ", "chi"}], "]"}],
       " ", "/", 
      RowBox[{"eps0mod", "[", 
       RowBox[{
       "zetasq", ",", " ", "psi1", ",", " ", "psi2", ",", " ", "chi"}], 
       "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"V", "[", 
      RowBox[{"zetasq_", ",", " ", "psi1_", ",", " ", "psi2_"}], "]"}], " ", ":=",
      " ", 
     RowBox[{
      RowBox[{"eps2", "[", 
       RowBox[{"zetasq", ",", " ", "psi1", ",", " ", "psi2"}], "]"}], " ", 
      "/", 
      RowBox[{"eps0", "[", 
       RowBox[{"zetasq", ",", " ", "psi1", ",", " ", "psi2"}], "]"}]}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"Vmod", "[", 
      RowBox[{
      "zetasq_", ",", " ", "psi1_", ",", " ", "psi2_", ",", " ", "chi_"}], 
      "]"}], " ", ":=", " ", 
     RowBox[{
      RowBox[{"eps2mod", "[", 
       RowBox[{
       "zetasq", ",", " ", "psi1", ",", " ", "psi2", ",", " ", "chi"}], "]"}],
       " ", "/", 
      RowBox[{"eps0mod", "[", 
       RowBox[{
       "zetasq", ",", " ", "psi1", ",", " ", "psi2", ",", " ", "chi"}], 
       "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"R", "[", 
      RowBox[{
      "F1_", ",", "Fs_", ",", "tau_", ",", "psi1_", ",", "psi2_", ",", 
       "zetasq_"}], "]"}], " ", ":=", " ", 
     RowBox[{
      RowBox[{
       RowBox[{"F1", "^", "2"}], "*", 
       RowBox[{"B", "[", 
        RowBox[{"zetasq", ",", "psi1", ",", "psi2"}], "]"}]}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"Fs", "^", "2"}], "+", 
         RowBox[{"tau", "^", "2"}]}], ")"}], "*", 
       RowBox[{"V", "[", 
        RowBox[{"zetasq", ",", "psi1", ",", "psi2"}], "]"}]}], "+", 
      RowBox[{"Fs", "^", "2"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"Rmod", "[", 
      RowBox[{
      "F1_", ",", "Fs_", ",", "tau_", ",", "psi1_", ",", "psi2_", ",", 
       "zetasq_", ",", " ", "chi_"}], "]"}], " ", ":=", " ", 
     RowBox[{
      RowBox[{
       RowBox[{"F1", "^", "2"}], "*", 
       RowBox[{"Bmod", "[", 
        RowBox[{"zetasq", ",", "psi1", ",", "psi2", ",", " ", "chi"}], 
        "]"}]}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"Fs", "^", "2"}], "+", 
         RowBox[{"tau", "^", "2"}]}], ")"}], "*", 
       RowBox[{"Vmod", "[", 
        RowBox[{"zetasq", ",", "psi1", ",", "psi2", ",", " ", "chi"}], 
        "]"}]}], "+", 
      RowBox[{"Fs", "^", "2"}]}]}], ";"}]}]}]], "Input",
 CellLabel->"In[1]:=",ExpressionUUID->"25467969-791d-4b11-987b-7ede8f2285ce"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"alpha", " ", "=", " ", "0.5"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"F1", "=", "1"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"Fs", "=", 
   RowBox[{"Sqrt", "[", "0.5", "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"psi2", "=", "3"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"tau", "=", "0"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"zetasq", " ", "=", " ", "2"}], ";"}]}], "Input",
 CellChangeTimes->{{3.879285086742477*^9, 3.879285087346456*^9}, {
  3.879509107066104*^9, 3.879509107367835*^9}, {3.879509318078424*^9, 
  3.879509326271227*^9}, {3.879510693271627*^9, 3.879510693600541*^9}, {
  3.879510742326865*^9, 3.879510751765588*^9}, {3.879635497405302*^9, 
  3.879635498627038*^9}, {3.87963591482897*^9, 3.879635917617807*^9}, {
  3.87963595456593*^9, 3.8796359579447193`*^9}, {3.8796363512892427`*^9, 
  3.879636352149962*^9}, {3.879636846389739*^9, 3.8796368553436937`*^9}, {
  3.8796368994880447`*^9, 3.879636899780013*^9}, {3.879767650462882*^9, 
  3.879767654477157*^9}, {3.879768536585259*^9, 3.879768546827557*^9}, {
  3.879769023465102*^9, 3.879769023710949*^9}, {3.879769265215611*^9, 
  3.879769272602169*^9}, {3.8797703698504543`*^9, 3.879770374284216*^9}},
 CellLabel->"In[46]:=",ExpressionUUID->"bc488d36-3fda-4ed6-b61d-6ea2c7e3353b"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"chiSpecial1", "[", 
   RowBox[{"3.0", ",", " ", "2.7519316165878034`"}], "]"}], " "}]], "Input",
 CellChangeTimes->{{3.879285124064746*^9, 3.879285125749687*^9}, {
  3.879285166327951*^9, 3.879285166446351*^9}, {3.8795093641811028`*^9, 
  3.879509364275387*^9}, {3.879509453175646*^9, 3.8795094534505587`*^9}, {
  3.87951062969468*^9, 3.879510630273457*^9}},
 CellLabel->"In[60]:=",ExpressionUUID->"7e01b3fa-0310-468b-9557-bfa27963979f"],

Cell[BoxData[
 RowBox[{"-", "2.14487406404534`"}]], "Output",
 CellChangeTimes->{
  3.8792852302893753`*^9, 3.8792853168194637`*^9, {3.879509351113216*^9, 
   3.87950936656948*^9}, 3.879509457634005*^9, 3.879510633469632*^9, 
   3.879510713456512*^9, {3.8795107574603024`*^9, 3.879510774734318*^9}, 
   3.8795110177816963`*^9},
 CellLabel->"Out[60]=",ExpressionUUID->"fe8c57c1-34bd-433a-a6e3-5e5914bfc98e"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"g1", " ", "=", " ", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"Rmod", "[", 
      RowBox[{"F1", ",", "Fs", ",", "tau", ",", 
       RowBox[{"x", "*", "psi2"}], ",", "psi2", ",", "zetasq", ",", " ", 
       RowBox[{"chiSpecial1", "[", 
        RowBox[{
         RowBox[{"Min", "[", 
          RowBox[{
           RowBox[{"x", "*", "psi2"}], ",", " ", "psi2"}], "]"}], ",", " ", 
         "zetasq"}], "]"}]}], "]"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"x", ",", " ", "0", ",", " ", "5"}], "}"}]}], "]"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.8792852859575872`*^9, 3.879285303079143*^9}, {
  3.87950937059277*^9, 3.879509397531146*^9}, {3.87950946074275*^9, 
  3.879509466021978*^9}, {3.879510637353962*^9, 3.87951064005525*^9}, {
  3.879635524044408*^9, 3.879635543333692*^9}, {3.8796355741144047`*^9, 
  3.879635597830207*^9}, {3.8796356527704363`*^9, 3.879635713953294*^9}, {
  3.879768550306493*^9, 3.879768558203326*^9}},
 CellLabel->"In[52]:=",ExpressionUUID->"11605629-d5ac-4419-ad7a-beeb1d07c7ac"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Show", "[", "g1", "]"}]], "Input",
 CellChangeTimes->{{3.8796357392706213`*^9, 3.8796357501045713`*^9}},
 CellLabel->"In[53]:=",ExpressionUUID->"e94d3fbe-ca0d-4751-a1c1-8a9062b713bd"],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    TagBox[
     {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], Opacity[
      1.], LineBox[CompressedData["
1:eJwV1Xk8VvkXB3BLskVGyzTGoCJKCUlG+NwoIbQhKZSylX1+DEJNREmFkUFj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       "]], LineBox[CompressedData["
1:eJwV1Xk01YkXAPD3nvesL+GZRlIkZSelEuVetFiiBS2WsiTFJFn6SbbsFSFb
kexTjUqkKZEtLfamMcaI8rNOPYT3vs9b+fn9cc89n3Pvufefe85d73XhiA+F
RCKVLMf/c9aVSZV1YSyg9e2y1eiRRdKfw1gfzoKAXCUXiTpZjP/WUBx+lQWn
p9yiL1+XRSlSAWVnMgtI19tkyl1kUUH/ROvzbBbsONxOUhKtwI1Jf+yvfMqC
WR2HYLLtCrQ1a3EomWCBV2b+bwMkOnYfLqr0mGZBerN1hdGADDqejZJTZbNg
82TJTXqNDLplm37KJ7MhadQj2+qcDAb8qHbOVmGDtPhw4sV/pDGztNQt+Qgb
FLRzSvu6pVDp1dXX+06wgSj628upUgrvfjy1jubBBq2GoD1b06XwV9Ga4avn
2ZC5OTB6haMUvjyW5X0lmQ398843aEOSOCiT4BfQwIaZvwXJT0mS6KHu3aH3
lg3lDCWn+AkJHDex0GN2sKF2n/uL4k4JnPERTfv+wwbJIvPwmjsSSG4KvejJ
ZsOXeJn21TskcFPImTAnHQKmJx5QOZHiqG/61bFwMwG+2lhy/Jw4GpOOG37f
TsDcHV/StJM4WqbYTERbEXDIsMr4gZ44nizTc6pwI0DM8/xT5y80zOmdN6Sk
EbBouDeZZEvDgjx/GftsAppc4wkjExqWeYxN5OYT0OfBO35jEw2rp/4q0H9A
gLuiyvQzMRp2U2tlTjQT8PItd2t3IxVp26InK1kEDNYNxb82pyJdsNDC5xFg
r1nhYGxIRYXmwHt7SRyoklV83KFKRTV7L+fPdA5sSVHOcCFTcZfP3jfimzgQ
aVS1ZeatGIZkyxS6H+eAifW1lnwnMRwjco/KvObAe3qSdXcCBUsstgYPvVm2
2qL5b2EUPJXanVbZzoGP9/bkFflTcECD1ubYvzy/ttzq82EK/uEYZHaXxYGs
DHNqjCoFG6oOqOnrLIA3L49u3UjG3PPk7w65CzBg0zG/YiUZnWrviq+/twCW
c9u5VVQyKtBMNrDKFkDnlmb4WT4Jb94NcMutXgC/VnFD+gQJ4zs+d3/tWoBn
t13UtRtIGKj9+7NAKhdGZkhBGRdJaDvuF3nrIhd2TQy+XXi/BPsiNzzaE8aF
WTujpIQXS2D50+AAJ2q5f63CNv37S2C6197ENYULtmntXm2JS6BTbsjacJ8L
5iEZCQb7l0DGh332+SAXLh3sMwrvXITOsUin/v08iBoskquYFMGHiO1x1x14
8Ms9lsSKARG0Kv6o2uXMA8rrkGuxnSKo3+OxstiLB9UvX8TdrxLBozLL9nOR
PKCHSw/2Rogg9bQECqp50HuqszVvlQgcxtJ1163jQ8uFGHrfUSF06o71umnw
gfpXYeTGA0KwC94Rla/DBw/lYrlYCyFYU758VNrBhxFJlpmXnhAs1XQvMQ7x
wSTHTKGeIoRtbm+bJGP5EGEw8aG5SgAqvTxn1jgf9Lb9FByjJIC8NfZLRlN8
UNL1u2SzUgCrvYseBM7zISxyvUhFXACr5vcJphf5IIny9qMsPsjJZRX9+7MA
wpTNpZk9fBA7YMAcshFAolk/o/8aH76/8Yr58FgAxz/YPXpJ5YNqRr/fzRoB
nEwvb6YKeeB00sHZqU4A1caRoy4sHjRwd+oMfxCA6ewxiY0jPLilL9+7MCqA
WAkzlkETD8xyGzU1lYUg1/uCLR3FgxQ/lZ6ERCEsRj169h8SD5p33Kq1SxVC
rPHDqAkuFzhUyTL5LCFQ6d8uuM9xwaOQFVZQLIRfRprTvUe4YNzbrv68Xghc
yrBXTysXhnZfvjQ2LwQ/3ZsnlG9wwUC+b63VKRGo7ZrZr7uWCxOpE7HZPiJI
fm0XwF3FhQLphclJfxHkCFL8O+S4QKcqVaeEiSBiTX9b7PIdfuec2NeXIQLS
15dbtk8tQPngUMC5VhEMCF70PKhfAJUH441p2ovA3n3ge7LnAkgD4TnIWoRi
f6uauloOhFloSf7OXwQP/9kLbjUcmLByfZJGXoLhyB0MSiUHWqyb+ZYrl0DZ
uJtwLeNA+JHUzIc6S1AY7hpkk8YBps/Gt5c8l+C3jJCHtDMc6Exx1pLvWQJy
zCm3/lUc2D/tsqDuTML+Us6G6ngC7inG/Rl9nIRjxxqmg2IIYJtVVA66krC+
yEZ9RwQBRdcFvjleJHQx2lnXFkwAX/Nuv1QgCVMUe0x/9ibgkddQ7ez15Xqz
D/egJQFy/aciGppImJhU922tGAH9LafJLnpkLJvFlnOpbJi1GFCONCRj8ozc
E43rbJBoPmhctIWMcnGjvf9NZMP2RlPfCRMyKmWGtnvFsCGrTq4raC8Z/2nf
vSo6mA0Ha+pv3zhJxvitHyxUXdjwrlxx8+t0MmoFb6D/0GLD8+TWk2oEGb+c
cz90spMFZ2ihw93dFOw6dlyqVpkF3kFXntPzxPDosLbmyZR5MPTV7T7gScUc
P5JessI89CjoyYTupCE5d2985r05qHsSm68nJo4jb+ImueZzcIWsc6hzSBzv
+kQ97RyZBenBcOuAGglUU1AsXXlrFsZ/XZ9VGCGJWl8j2JoOs5CltZpa6yyF
R2fSBwNlZiE978x7TzVpFHd6NZJb/gNcsty76ZPSaGduodIIP4C7p5xX2LD8
VyPWqNgOzMDouGVYSxIdtxuvtVCPm4GS3UZrujxXYKCTh/ao7gw8TgiV99WX
xckcwcaw4WlIcva2EyNkMcv0vWVe/jRsGyx+mNS1EuMfJcqSj07Dbe38x112
chhhGt3mvnoaoptSb9vVymGi7Wvxyc9TYL/GubxdQx4Pk45icOkUWAS8d5W/
Jo8Gue+i5i9OQaGKl0YnIY8N9W4S52AKNN7cz3FwVUDBv7VZ0wpTkK7fovOp
QQH93qTHlH1jwhkW9Y82HQZyKOvdzBuZ4FU1r3YtjYGWrpdfNd1hwi+xjkLb
DAYqefoUr112qGPN3/RMBsa5qT4Ov82EZCL0ZnoOA/39OrZsy2XCk508QW4B
A7NuPyAqspjAa17q+7WCgUc2VzoUpTEh/RM9tfU9A7vIXdzSBCbklZ4/m9jG
QMrZFk/asktDuq2sOxh4aYY8cyaeCb+vSud3dDOQab05UCeOCYMujLN//sVA
g09k5WcxTNAcXW01MsrAd3r7eO1XmLC5Jnxd2TgDFVefzjBYtmnCZ57P5PI+
I4UDt8KZcECz4Om37wz8tG5Oy+UyE4L81dbNzTHwZWR4NPMSEyJ2XeVVsxgY
jgM6h5adsGKkN4RgoKrqBW5NKBNuV5be4HIZOCAuw48KYUJJDNX3FZ+BLUkC
/bFgJlQc9rGMEDJQT5EdZ7PsGvV3a80XGege8k3wJIgJDaxNvKUlBqaEfsxW
XPb/ACvi4EI=
       "]]},
     Annotation[#, "Charting`Private`Tag$15873#1"]& ]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0.8576758314190314},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{0, 5}, {0.8576758314190314, 3.8511434364143065`}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{3.879635753683136*^9, 3.8797692818653593`*^9, 
  3.879770392356805*^9},
 CellLabel->"Out[53]=",ExpressionUUID->"761bdddf-7917-4d86-be94-cfa7855c0ba3"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"g2", " ", "=", " ", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"Rmod", "[", 
      RowBox[{"F1", ",", "Fs", ",", "tau", ",", 
       RowBox[{"x", "*", "psi2"}], ",", "psi2", ",", "zetasq", ",", " ", 
       RowBox[{"chiSpecial1", "[", 
        RowBox[{
         RowBox[{"Min", "[", 
          RowBox[{
           RowBox[{"x", "*", "psi2"}], ",", " ", "psi2"}], "]"}], ",", " ", 
         "zetasq"}], "]"}]}], "]"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"x", ",", " ", "0", ",", " ", "5"}], "}"}]}], "]"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.8796358890801563`*^9, 3.879635889242836*^9}, {
  3.879768565140733*^9, 
  3.879768571825657*^9}},ExpressionUUID->"4a1275f9-8e9b-4b00-bfcd-\
505a71c1b2f9"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Show", "[", "g2", "]"}]], "Input",
 CellChangeTimes->{{3.8796359956322823`*^9, 3.8796359957954397`*^9}},
 CellLabel->"In[29]:=",ExpressionUUID->"0d36ca8a-46a9-4fc8-9a35-0cad04f91f6c"],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    TagBox[
     {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], Opacity[
      1.], LineBox[CompressedData["
1:eJwV1Hk4VfkfB3CuNUspbfqRaFEYhZJq8j6lSEllzxh0ZUmIRiakDUlZGxlJ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       "]], LineBox[CompressedData["
1:eJwV1Hk41HsXAPAZY5jMhDG9smUpkrGkriVLna+x5NoqS2VJlmuJyxtFKipF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       "]]},
     Annotation[#, "Charting`Private`Tag$7138#1"]& ]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0.8501260007191855},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{0, 5}, {0.8501260007191855, 3.567345011153198}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{3.879635998484025*^9, 3.879767902841342*^9},
 CellLabel->"Out[29]=",ExpressionUUID->"5b7612cb-f6cb-479e-97f0-1db33f7548dc"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"g3", " ", "=", " ", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"SSpecialmod", "[", 
      RowBox[{"F1", ",", " ", "Fs", ",", " ", "tau", ",", 
       RowBox[{"x", "*", "psi2"}], ",", "psi2", ",", "zetasq", ",", "  ", 
       RowBox[{"chiSpecial1", "[", 
        RowBox[{
         RowBox[{"Min", "[", 
          RowBox[{
           RowBox[{"x", "*", "psi2"}], ",", " ", "psi2"}], "]"}], ",", " ", 
         "zetasq"}], "]"}]}], "]"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"x", ",", " ", "0", ",", " ", "5"}], "}"}]}], "]"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.879636081984194*^9, 3.8796360838519163`*^9}, {
  3.879636260734345*^9, 3.8796363340459633`*^9}, {3.879636642821534*^9, 
  3.879636655181696*^9}, {3.879768580099186*^9, 3.8797685857592087`*^9}},
 CellLabel->"In[44]:=",ExpressionUUID->"5c32e082-a504-4b43-87af-ccac94003db4"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Show", "[", "g3", "]"}]], "Input",
 CellChangeTimes->{{3.879636370338917*^9, 3.879636370611478*^9}},
 CellLabel->"In[45]:=",ExpressionUUID->"5280010b-3199-4e15-bbb8-6f8e34dbcae7"],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    TagBox[
     {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], Opacity[
      1.], LineBox[CompressedData["
1:eJwB8QEO/iFib1JlAgAAAB4AAAACAAAA+gMrYF+U3T8FVPggsFfiPwohhCff
OOA/2PkqX72Q4z+OEMsqoWDjP/XNMEkYLuY/uTcdtU5u4z/aLHn1qDnmP+Re
bz/8e+M/UPiU8T1F5j87rRNUV5fjP8UhPGp1XOY/6ElcfQ3O4z/fA0ZzHovm
P0OD7c95O+Q/Je4MjHvp5j/49Q91UhblP3PfRWubq+c/Ix1i//8j5T/qz2mT
CLjnP05EtImtMeU/PVin5n/E5z+lklieCE3lP48XlQWO3ec/Ui+hx76D5T8s
ChopLxDoP61oMhor8eU/ys+DVcF36D9i21S/A8zmP3MlMM9WUuk/CpvhbXHZ
5j8Kkb3KWGDpP7Jabhzf5uY/RCbbzW5u6T8D2od5ugHnP+OCtqzYiuk/pNi6
M3E35z8Rbf6rsMTpP+bVIKjeouc/NElqC+I86j+Ola1WTLDnP/KAkgZfTOo/
NlU6Bbq95z/hhoVk+FvqP4fUU2KV2Oc/D/Yk2IJ76j8o04YcTA7oP92TtXYJ
vOo/atDskLl56D87Z2LEg0PrPxKQeT8nh+g/qI5APh1V6z+6TwbulJToP1Yf
eYjfZus/C88fS3Cv6D9dOcVz4orrP6zNUgUn5eg//8Efhf7U6z83pYbA3vfo
P43b6vty8Os/Rjj3GQ==
       "]], LineBox[CompressedData["
1:eJwV0ns8lPkXB/AZIQy5PG2bJT+hMIT6lSR1vm4ll9RmiqgYoVhWLq3KXQpR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       "]]},
     Annotation[#, "Charting`Private`Tag$13560#1"]& ]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0.573204101938814},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{0, 5}, {0.573204101938814, 0.8731017036687817}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{3.879636372576964*^9, 3.87976980961749*^9},
 CellLabel->"Out[45]=",ExpressionUUID->"dd6cf566-1af5-4c2b-9acf-eb44ed982b03"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"g4", " ", "=", " ", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"0.5", " ", "*", " ", 
       RowBox[{"SSpecialmod", "[", 
        RowBox[{"F1", ",", " ", "Fs", ",", " ", "tau", ",", 
         RowBox[{"x", "*", "psi2"}], ",", "psi2", ",", "zetasq", ",", "  ", 
         RowBox[{"chiSpecial1", "[", 
          RowBox[{
           RowBox[{"Min", "[", 
            RowBox[{
             RowBox[{"x", "*", "psi2"}], ",", " ", "psi2"}], "]"}], ",", " ", 
           "zetasq"}], "]"}]}], "]"}]}], " ", "+", " ", 
      RowBox[{"0.5", " ", "*", 
       RowBox[{"Rmod", "[", 
        RowBox[{"F1", ",", "Fs", ",", "tau", ",", 
         RowBox[{"x", "*", "psi2"}], ",", "psi2", ",", "zetasq", ",", " ", 
         RowBox[{"chiSpecial1", "[", 
          RowBox[{
           RowBox[{"Min", "[", 
            RowBox[{
             RowBox[{"x", "*", "psi2"}], ",", " ", "psi2"}], "]"}], ",", " ", 
           "zetasq"}], "]"}]}], "]"}]}]}], " ", ",", " ", 
     RowBox[{"{", 
      RowBox[{"x", ",", " ", "0", ",", " ", "5"}], "}"}]}], "]"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.8796366636474867`*^9, 3.8796366862087603`*^9}, {
  3.87976872808104*^9, 
  3.87976873776902*^9}},ExpressionUUID->"2df0b080-8140-4eda-a59f-\
4e919995ff2e"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Show", "[", "g4", "]"}]], "Input",
 CellChangeTimes->{{3.879636701913612*^9, 3.879636702044183*^9}},
 CellLabel->"In[61]:=",ExpressionUUID->"e58c3ee1-7e13-4fff-9d1d-0cab66ea1f88"],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    TagBox[
     {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], Opacity[
      1.], LineBox[CompressedData["
1:eJwVk3k41IkDxmWSDsmyXbKNDsmRo6xQvDokQq0UySKrSFJsKSm1S0SIGpII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       "]], 
      LineBox[CompressedData["
1:eJwVzWk4FHoDBfAZW0SFKS1atKqRS5eIlvNHliK3Qilu9nQr0qKrUl2VSBSl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       "]]},
     Annotation[#, "Charting`Private`Tag$36540#1"]& ]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0.4061503565092493},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{0, 5}, {0.4061503565092493, 0.9634848149781219}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.879636704633403*^9, 3.879636875504737*^9, {3.879636909649715*^9, 
   3.87963692622703*^9}},
 CellLabel->"Out[61]=",ExpressionUUID->"4c430579-f2ee-4aaf-b9db-1aaa0506bd5d"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SSpecialmod", "[", 
  RowBox[{
  "F1", ",", "Fs", ",", "tau", ",", "psi1", ",", "psi2", ",", 
   "2.7519316165878034`", ",", " ", 
   RowBox[{"chiSpecial1", "[", 
    RowBox[{"3.0", ",", " ", "2.7519316165878034`"}], "]"}]}], "]"}]], "Input",\

 CellChangeTimes->{{3.8795109919139147`*^9, 3.879511007676641*^9}},
 CellLabel->"In[59]:=",ExpressionUUID->"7ee87d80-8f7f-4bde-9994-4a7319e90e5d"],

Cell[BoxData["0.7483289325984372`"], "Output",
 CellChangeTimes->{3.879511011314505*^9},
 CellLabel->"Out[59]=",ExpressionUUID->"446865fc-8234-4d84-82e8-ae57fc799a93"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
   "Find", " ", "zetasq", " ", "as", " ", "a", " ", "function", " ", "of", 
    " ", "chi"}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"Solve", "[", 
    RowBox[{
     RowBox[{"chi", "==", 
      RowBox[{"chiSpecial1", "[", 
       RowBox[{"psi", ",", " ", "zetasq"}], "]"}]}], ",", "zetasq"}], "]"}], 
   "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{{3.86614510387362*^9, 3.86614510628922*^9}, {
  3.86614514376896*^9, 3.866145208716907*^9}},
 CellLabel->"In[23]:=",ExpressionUUID->"6eeba0a4-55d5-4e3c-9fe2-aa2d9ccf532d"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"zetasq", "\[Rule]", 
    FractionBox[
     RowBox[{"chi", "+", "psi"}], 
     RowBox[{"chi", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", "chi", "+", "psi"}], ")"}]}]]}], "}"}], 
  "}"}]], "Output",
 CellChangeTimes->{{3.8661452046642714`*^9, 3.8661452092711554`*^9}, 
   3.866639138768278*^9, 3.867781846945369*^9, 3.868217046573524*^9},
 CellLabel->"Out[23]=",ExpressionUUID->"0a4c5b9c-0c9c-4a59-bb00-932a4ef2c98d"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
   "In", " ", "the", " ", "paper", " ", "we", " ", "identify", " ", "x", " ", 
    "by", " ", 
    RowBox[{"chi", ".", " ", "Find"}], " ", "max", " ", "and", " ", "min", 
    " ", "of", " ", "x"}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"FullSimplify", "[", 
    RowBox[{
     RowBox[{"Maximize", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"chiSpecial1", "[", 
          RowBox[{"psi", ",", " ", "zetasq"}], "]"}], ",", 
         RowBox[{"zetasq", "\[GreaterEqual]", "0"}]}], "}"}], ",", "zetasq"}],
       "]"}], ",", 
     RowBox[{"Assumptions", "\[Rule]", 
      RowBox[{"psi", ">", "0"}]}]}], "]"}], "\[IndentingNewLine]", 
   RowBox[{"FullSimplify", "[", 
    RowBox[{
     RowBox[{"Minimize", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"chiSpecial1", "[", 
          RowBox[{"psi", ",", " ", "zetasq"}], "]"}], ",", 
         RowBox[{"zetasq", "\[GreaterEqual]", "0"}]}], "}"}], ",", "zetasq"}],
       "]"}], ",", 
     RowBox[{"Assumptions", "\[Rule]", 
      RowBox[{"psi", ">", "0"}]}]}], "]"}], 
   "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{{3.866145275220343*^9, 3.8661454745231657`*^9}},
 CellLabel->"In[24]:=",ExpressionUUID->"a53be0c8-dc6b-4ea0-9da6-ec791971f003"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[GridBox[{
      {"\[Piecewise]", GridBox[{
         {
          RowBox[{"1", "-", "psi"}], 
          RowBox[{"psi", ">", "1"}]},
         {"0", 
          TagBox["True",
           "PiecewiseDefault",
           AutoDelete->True]}
        },
        AllowedDimensions->{2, Automatic},
        Editable->True,
        GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Baseline}}},
        GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{1.}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.84]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}},
        Selectable->True]}
     },
     GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Baseline}}},
     GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{1.}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.35]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    "Piecewise",
    DeleteWithContents->True,
    Editable->False,
    SelectWithContents->True,
    Selectable->False,
    StripWrapperBoxes->True], ",", 
   RowBox[{"{", 
    RowBox[{"zetasq", "\[Rule]", "Indeterminate"}], "}"}]}], "}"}]], "Output",\

 CellChangeTimes->{{3.866145395841709*^9, 3.8661454748897257`*^9}, 
   3.86663914255121*^9, 3.86778185071209*^9, 3.8682170502105017`*^9},
 CellLabel->"Out[24]=",ExpressionUUID->"f48cc5c1-9369-4621-8f66-04049e2cd465"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "psi"}], ",", 
   RowBox[{"{", 
    RowBox[{"zetasq", "\[Rule]", "Indeterminate"}], "}"}]}], "}"}]], "Output",\

 CellChangeTimes->{{3.866145395841709*^9, 3.8661454748897257`*^9}, 
   3.86663914255121*^9, 3.86778185071209*^9, 3.868217050231855*^9},
 CellLabel->"Out[25]=",ExpressionUUID->"8f4e8b03-97a7-40fa-9bb1-9e23c2f3a8bf"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"CASE", " ", "1", " ", "WHEN", " ", "psi1"}], " ", "<", " ", 
    "psi2"}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
    "Define", " ", "our", " ", "objective", " ", "function", " ", "for", " ", 
     "when", " ", "psi1"}], " ", "<", " ", "psi2"}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"objective", "=", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"(", "\[Alpha]", ")"}], 
          RowBox[{"SSpecialmod", "[", 
           RowBox[{
           "F1", ",", "Fs", ",", "tau", ",", " ", "psi1", ",", "psi2", ",", 
            "zetasq", ",", "chi"}], "]"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "-", "\[Alpha]"}], ")"}], "*", 
          RowBox[{"Rmod", "[", 
           RowBox[{
           "F1", ",", "Fs", ",", "tau", ",", "psi1", ",", " ", "psi2", ",", 
            "zetasq", ",", "chi"}], "]"}]}]}], "/.", 
        RowBox[{"{", 
         RowBox[{"zetasq", "->", 
          FractionBox[
           RowBox[{"chi", "+", "psi1"}], 
           RowBox[{"chi", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", "chi", "+", "psi1"}], ")"}]}]]}], 
         "}"}]}], ")"}], "//", "FullSimplify"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
     RowBox[{
     "Check", " ", "that", " ", "the", " ", "objective", " ", "is", " ", "a", 
      " ", "decreasing", " ", "line", " ", "when", " ", "alpha"}], " ", "=", 
     " ", "0"}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"D", "[", 
     RowBox[{
      RowBox[{"objective", "/.", 
       RowBox[{"{", 
        RowBox[{"\[Alpha]", "\[Rule]", "0"}], "}"}]}], ",", "chi"}], "]"}], "//",
     "FullSimplify"}]}]}]], "Input",
 CellChangeTimes->{{3.8660675399569387`*^9, 3.866067543965659*^9}, 
   3.866145262519367*^9, {3.866145834433696*^9, 3.866145844829687*^9}, 
   3.8661477404098988`*^9, {3.866147773911875*^9, 3.866147805762862*^9}, {
   3.8661483169224787`*^9, 3.866148341019464*^9}},
 CellLabel->"In[26]:=",ExpressionUUID->"210fa892-f26e-4ea3-b590-99acbaa52fca"],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SuperscriptBox["F1", "2"], " ", "psi2"}], 
  RowBox[{"psi1", "-", "psi2"}]]], "Output",
 CellChangeTimes->{{3.86614778899656*^9, 3.866147806007267*^9}, 
   3.866148341553946*^9, 3.866639339399172*^9, 3.867781854704443*^9, 
   3.8682170921466637`*^9},
 CellLabel->"Out[27]=",ExpressionUUID->"79655aa8-7b94-4527-8226-1aa189f1a138"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
   "Compute", " ", "second", " ", "derivative", " ", "with", " ", "respect", 
    " ", "to", " ", "chi", " ", "MINUS", " ", "basedline", " ", 
    RowBox[{"function", ".", " ", "This"}], " ", "is", " ", "Otilde", " ", 
    "in", " ", "the", " ", "paper"}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{"secondDerMinusBaseline", "=", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"D", "[", 
       RowBox[{"objective", ",", 
        RowBox[{"{", 
         RowBox[{"chi", ",", "2"}], "}"}]}], "]"}], "-", 
      FractionBox[
       RowBox[{"2", " ", 
        SuperscriptBox["F1", "2"], " ", "\[Alpha]"}], 
       RowBox[{"psi1", "-", "psi2"}]]}], "//", "Together"}], "//", 
    "FullSimplify"}]}]}]], "Input",
 CellChangeTimes->{{3.866145864478922*^9, 3.86614587077956*^9}},
 CellLabel->"In[28]:=",ExpressionUUID->"549ef418-3a5c-420b-a897-8c2fa5e10214"],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox[
   RowBox[{"2", " ", 
    SuperscriptBox["F1", "2"], " ", "psi1", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "2"}], " ", 
       SuperscriptBox["chi", "3"]}], "-", 
      RowBox[{"3", " ", 
       SuperscriptBox["chi", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "psi1"}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "psi1"}], ")"}], "2"], " ", "psi1"}]}], 
     ")"}], " ", "\[Alpha]"}], 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "psi1"}], "+", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"chi", "+", "psi1"}], ")"}], "2"]}], ")"}], "3"]]}]], "Output",\

 CellChangeTimes->{3.866067787531315*^9, 3.866116229427947*^9, 
  3.866639346861311*^9, 3.8677818579712753`*^9, 3.868217100230864*^9},
 CellLabel->"Out[28]=",ExpressionUUID->"26a326cd-a308-4ff9-88a5-61f1ebf43a13"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
   "Show", " ", "that", " ", "secondDerMinusBaseline", " ", "is", " ", 
    "always", " ", "convex"}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
    "We", " ", "will", " ", "assume", " ", "without", " ", "loss", " ", "of", 
     " ", "generality", " ", "that", " ", "F1"}], " ", "=", " ", 
    RowBox[{"alpha", " ", "=", " ", "1"}]}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
   "First", " ", "observe", " ", "that", " ", "the", " ", "second", " ", 
    "derivative", " ", "of", " ", "Otilde", " ", "is", " ", "a", " ", 
    "rational", " ", "function", " ", "of", " ", "x"}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"secondDerOfsecondDerMinusBaseline", "=", 
     RowBox[{
      RowBox[{
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{"secondDerMinusBaseline", "/.", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"F1", "\[Rule]", "1"}], ",", 
            RowBox[{"\[Alpha]", "\[Rule]", "1"}]}], "}"}]}], ",", 
         RowBox[{"{", 
          RowBox[{"chi", ",", "2"}], "}"}]}], "]"}], "//", "Together"}], "//",
       "FullSimplify"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"num", "=", 
     RowBox[{
      RowBox[{"Numerator", "[", "secondDerOfsecondDerMinusBaseline", "]"}], "//",
       "FullSimplify"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"den", "=", 
     RowBox[{
      RowBox[{"Denominator", "[", "secondDerOfsecondDerMinusBaseline", "]"}], 
      "//", "FullSimplify"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
     RowBox[{
     "We", " ", "show", " ", "that", " ", "both", " ", "the", " ", 
      "numerator", " ", "and", " ", "denominator", " ", "of", " ", "the", " ",
       "second", " ", "derivative", " ", "are", " ", "non"}], "-", 
     "positive"}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{"Maximize", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"den", ",", 
       RowBox[{
        RowBox[{"chi", "\[GreaterEqual]", 
         RowBox[{"-", "psi1"}]}], "&&", 
        RowBox[{"chi", "\[LessEqual]", "0"}], "&&", 
        RowBox[{"chi", "\[LessEqual]", 
         RowBox[{"1", "-", "psi1"}]}], "&&", 
        RowBox[{"psi1", ">", "0"}], "&&", 
        RowBox[{"psi1", "\[NotEqual]", "1"}]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"chi", ",", "psi1"}], "}"}]}], "]"}], "\[IndentingNewLine]", 
   RowBox[{"Maximize", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"num", ",", 
       RowBox[{
        RowBox[{"chi", "\[GreaterEqual]", 
         RowBox[{"-", "psi1"}]}], "&&", 
        RowBox[{"chi", "\[LessEqual]", "0"}], "&&", 
        RowBox[{"chi", "\[LessEqual]", 
         RowBox[{"1", "-", "psi1"}]}], "&&", 
        RowBox[{"psi1", ">", "0"}], "&&", 
        RowBox[{"psi1", "\[NotEqual]", "1"}]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"chi", ",", "psi1"}], "}"}]}], "]"}], "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
    "With", " ", "a", " ", "bit", " ", "more", " ", "of", " ", "effort", " ", 
     "on", " ", "can", " ", "see", " ", "that", " ", "since", " ", "psi1", 
     " ", "neq", " ", "1", " ", "the", " ", "denominator", " ", "is", " ", 
     "actually", " ", "strictly", " ", "negative"}], "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Solve", "[", 
     RowBox[{
      RowBox[{"den", "\[Equal]", "0"}], ",", "chi"}], "]"}], "//", 
    "FullSimplify"}], "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{"chi", " ", "=", 
     RowBox[{
      RowBox[{"-", 
       SqrtBox["psi1"]}], "-", 
      RowBox[{
      "psi1", " ", "is", " ", "cearly", " ", "outside", " ", "the", " ", 
       "bounds", " ", "for", " ", "chi", " ", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"note", " ", "chi"}], " ", "=", " ", "x"}], ")"}], 
        "."}]}]}]}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
     RowBox[{
      SqrtBox["psi1"], "-", 
      RowBox[{"psi1", " ", "is", " ", "only", " ", 
       RowBox[{"inside", " ", "[", 
        RowBox[{"xL", ",", "xR"}], "]"}], " ", "if", " ", "psi1"}]}], 
     "\[Equal]", 
     RowBox[{"1", " ", "since", " ", "psi1"}], ">", "0"}], "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{"Minimize", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        SqrtBox["psi1"], "-", "psi1", "-", 
        RowBox[{"Min", "[", 
         RowBox[{"0", ",", 
          RowBox[{"1", "-", "psi1"}]}], "]"}]}], ",", 
       RowBox[{"psi1", ">", "0"}]}], "}"}], ",", "psi1"}], "]"}]}]}]], "Input",\

 CellChangeTimes->{{3.866145921984007*^9, 3.866146154483927*^9}, {
   3.866146225236443*^9, 3.866146586237597*^9}, 3.86614663369341*^9, {
   3.866146665846673*^9, 3.8661467090461273`*^9}, {3.866146791346137*^9, 
   3.866146927545158*^9}, {3.8661469725963287`*^9, 3.866147015050831*^9}, {
   3.866147052148932*^9, 3.866147075596169*^9}, {3.8661471102523127`*^9, 
   3.866147114551499*^9}, {3.866147151202764*^9, 3.866147152498927*^9}, {
   3.866147190950163*^9, 3.866147281102017*^9}, {3.8661474462545967`*^9, 
   3.866147461908259*^9}, 3.873374774925535*^9},
 CellLabel->"In[29]:=",ExpressionUUID->"99d40d31-56e2-4109-9cf0-a8e2e0e6bfe7"],

Cell[BoxData[
 TemplateBox[{
  "Maximize", "wksol", 
   "\"Warning: there is no maximum in the region in which the objective \
function is defined and the constraints are satisfied; a result on the \
boundary will be returned.\"", 2, 32, 1, 16461797715388458994, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.866639421133926*^9, 3.867781861494112*^9, 
  3.868217107010023*^9},
 CellLabel->
  "During evaluation of \
In[29]:=",ExpressionUUID->"42a6e36f-64fc-4bc6-a6e4-b835a3ed6eb3"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"chi", "\[Rule]", "0"}], ",", 
     RowBox[{"psi1", "\[Rule]", "0"}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.8661162879400463`*^9, 3.866145978337736*^9, {3.866146254632389*^9, 
   3.866146267722394*^9}, {3.866146299724049*^9, 3.8661463465584917`*^9}, {
   3.866146390437357*^9, 3.866146409207963*^9}, {3.866146466398732*^9, 
   3.866146485196245*^9}, {3.866146518647347*^9, 3.866146526630864*^9}, 
   3.866146634215217*^9, {3.866146666429329*^9, 3.86614668827455*^9}, {
   3.866146811376318*^9, 3.8661468374819613`*^9}, 3.8661470775424757`*^9, 
   3.866147114892827*^9, 3.866147160742735*^9, 3.866147222746934*^9, {
   3.866147262055071*^9, 3.866147283658102*^9}, 3.866147462764823*^9, 
   3.8666394211655807`*^9, 3.8677818614994993`*^9, 3.8682171070151052`*^9},
 CellLabel->"Out[32]=",ExpressionUUID->"cb7061fa-7a5e-4bb0-a976-da642badf5ae"],

Cell[BoxData[
 TemplateBox[{
  "Maximize", "natt", 
   "\"The maximum is not attained at any point satisfying the given \
constraints. \"", 2, 33, 2, 16461797715388458994, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.866639421133926*^9, 3.867781861494112*^9, 
  3.8682171071004143`*^9},
 CellLabel->
  "During evaluation of \
In[29]:=",ExpressionUUID->"174efe51-5aca-466d-99b3-381d458aed76"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"chi", "\[Rule]", "Indeterminate"}], ",", 
     RowBox[{"psi1", "\[Rule]", "0"}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.8661162879400463`*^9, 3.866145978337736*^9, {3.866146254632389*^9, 
   3.866146267722394*^9}, {3.866146299724049*^9, 3.8661463465584917`*^9}, {
   3.866146390437357*^9, 3.866146409207963*^9}, {3.866146466398732*^9, 
   3.866146485196245*^9}, {3.866146518647347*^9, 3.866146526630864*^9}, 
   3.866146634215217*^9, {3.866146666429329*^9, 3.86614668827455*^9}, {
   3.866146811376318*^9, 3.8661468374819613`*^9}, 3.8661470775424757`*^9, 
   3.866147114892827*^9, 3.866147160742735*^9, 3.866147222746934*^9, {
   3.866147262055071*^9, 3.866147283658102*^9}, 3.866147462764823*^9, 
   3.8666394211655807`*^9, 3.8677818614994993`*^9, 3.8682171071063223`*^9},
 CellLabel->"Out[33]=",ExpressionUUID->"a3176815-66ec-42ff-b40c-bb582340b4e0"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"chi", "\[Rule]", 
     RowBox[{
      RowBox[{"-", 
       SqrtBox["psi1"]}], "-", "psi1"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"chi", "\[Rule]", 
     RowBox[{
      RowBox[{"-", 
       SqrtBox["psi1"]}], "-", "psi1"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"chi", "\[Rule]", 
     RowBox[{
      RowBox[{"-", 
       SqrtBox["psi1"]}], "-", "psi1"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"chi", "\[Rule]", 
     RowBox[{
      RowBox[{"-", 
       SqrtBox["psi1"]}], "-", "psi1"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"chi", "\[Rule]", 
     RowBox[{
      RowBox[{"-", 
       SqrtBox["psi1"]}], "-", "psi1"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"chi", "\[Rule]", 
     RowBox[{
      SqrtBox["psi1"], "-", "psi1"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"chi", "\[Rule]", 
     RowBox[{
      SqrtBox["psi1"], "-", "psi1"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"chi", "\[Rule]", 
     RowBox[{
      SqrtBox["psi1"], "-", "psi1"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"chi", "\[Rule]", 
     RowBox[{
      SqrtBox["psi1"], "-", "psi1"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"chi", "\[Rule]", 
     RowBox[{
      SqrtBox["psi1"], "-", "psi1"}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.8661162879400463`*^9, 3.866145978337736*^9, {3.866146254632389*^9, 
   3.866146267722394*^9}, {3.866146299724049*^9, 3.8661463465584917`*^9}, {
   3.866146390437357*^9, 3.866146409207963*^9}, {3.866146466398732*^9, 
   3.866146485196245*^9}, {3.866146518647347*^9, 3.866146526630864*^9}, 
   3.866146634215217*^9, {3.866146666429329*^9, 3.86614668827455*^9}, {
   3.866146811376318*^9, 3.8661468374819613`*^9}, 3.8661470775424757`*^9, 
   3.866147114892827*^9, 3.866147160742735*^9, 3.866147222746934*^9, {
   3.866147262055071*^9, 3.866147283658102*^9}, 3.866147462764823*^9, 
   3.8666394211655807`*^9, 3.8677818614994993`*^9, 3.868217107128222*^9},
 CellLabel->"Out[34]=",ExpressionUUID->"9dee1f2b-5a37-488e-aed4-ddf5518b2e1d"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", 
   RowBox[{"{", 
    RowBox[{"psi1", "\[Rule]", "1"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.8661162879400463`*^9, 3.866145978337736*^9, {3.866146254632389*^9, 
   3.866146267722394*^9}, {3.866146299724049*^9, 3.8661463465584917`*^9}, {
   3.866146390437357*^9, 3.866146409207963*^9}, {3.866146466398732*^9, 
   3.866146485196245*^9}, {3.866146518647347*^9, 3.866146526630864*^9}, 
   3.866146634215217*^9, {3.866146666429329*^9, 3.86614668827455*^9}, {
   3.866146811376318*^9, 3.8661468374819613`*^9}, 3.8661470775424757`*^9, 
   3.866147114892827*^9, 3.866147160742735*^9, 3.866147222746934*^9, {
   3.866147262055071*^9, 3.866147283658102*^9}, 3.866147462764823*^9, 
   3.8666394211655807`*^9, 3.8677818614994993`*^9, 3.868217107254107*^9},
 CellLabel->"Out[35]=",ExpressionUUID->"912b0688-082e-4c99-a21a-20045cd62d18"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
   "Compute", " ", "the", " ", "left", " ", "end", " ", "points", " ", "of", 
    " ", "secondDerMinusBaseline", " ", "and", " ", "also", " ", "for", " ", 
    "A1"}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"This", " ", "value", " ", "is", " ", "the", " ", "y"}], "-", 
    RowBox[{
    "coordinate", " ", "of", " ", "the", " ", "A1", " ", "mentioned", " ", 
     "in", " ", "the", " ", "proof", " ", "after", " ", "it", " ", "is", " ", 
     "divided", " ", "by", " ", 
     RowBox[{"F", "^", "2"}], "_", "1", " ", "alpha"}]}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"OtildexL", "=", 
   RowBox[{
    RowBox[{"secondDerMinusBaseline", "/.", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"F1", "\[Rule]", "1"}], ",", 
       RowBox[{"\[Alpha]", "\[Rule]", "1"}], ",", 
       RowBox[{"chi", "\[Rule]", 
        RowBox[{"-", "psi1"}]}]}], "}"}]}], "//", 
    "FullSimplify"}]}]}]], "Input",
 CellChangeTimes->{{3.8661168745351963`*^9, 3.8661168970884323`*^9}, {
  3.866119751902166*^9, 3.8661197580806923`*^9}, {3.866147350201166*^9, 
  3.866147375853072*^9}, {3.867782224548635*^9, 3.86778224759243*^9}, {
  3.867782298493572*^9, 3.86778231909573*^9}},
 CellLabel->"In[36]:=",ExpressionUUID->"bda6e97a-445b-4071-a4bb-cb816f8dc88d"],

Cell[BoxData[
 RowBox[{"2", "+", 
  FractionBox["2", "psi1"]}]], "Output",
 CellChangeTimes->{3.867782225107583*^9, 3.868217121086432*^9},
 CellLabel->"Out[36]=",ExpressionUUID->"491d43dc-a581-4780-904a-2e0936eef6cb"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
   "Compute", " ", "the", " ", "right", " ", "end", " ", "points", " ", "of", 
    " ", "secondDerMinusBaseline", " ", "abd", " ", "also", " ", "for", " ", 
    "A3"}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
     RowBox[{"This", " ", "value", " ", "is", " ", "the", " ", "y"}], "-", 
     RowBox[{
     "coordinate", " ", "of", " ", "the", " ", "A3", " ", "mentioned", " ", 
      "in", " ", "the", " ", "proof", " ", "when", " ", "psi1"}]}], " ", "<", 
    " ", 
    RowBox[{
    "1", " ", "after", " ", "it", " ", "is", " ", "divided", " ", "by", " ", 
     RowBox[{"F", "^", "2"}], "_", "1", " ", "alpha"}]}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"OtildexR1", "=", 
    RowBox[{
     RowBox[{"secondDerMinusBaseline", "/.", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"F1", "\[Rule]", "1"}], ",", 
        RowBox[{"\[Alpha]", "\[Rule]", "1"}], ",", 
        RowBox[{"chi", "\[Rule]", "0"}]}], "}"}]}], "//", "FullSimplify"}]}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
     RowBox[{
      RowBox[{"This", " ", "value", " ", "is", " ", "the", " ", "y"}], "-", 
      RowBox[{
      "coordinate", " ", "of", " ", "the", " ", "A3", " ", "mentioned", " ", 
       "in", " ", "the", " ", "proof", " ", "when", " ", "psi"}]}], " ", ">", 
     " ", 
     RowBox[{
     "1", " ", "after", " ", "it", " ", "is", " ", "divided", " ", "by", " ", 
      
      RowBox[{"F", "^", "2"}], "_", "1", " ", "alpha"}]}], "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{"OtildexR2", "=", 
    RowBox[{
     RowBox[{"secondDerMinusBaseline", "/.", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"F1", "\[Rule]", "1"}], ",", 
        RowBox[{"\[Alpha]", "\[Rule]", "1"}], ",", 
        RowBox[{"chi", "\[Rule]", 
         RowBox[{"1", "-", "psi1"}]}]}], "}"}]}], "//", 
     "FullSimplify"}]}]}]}]], "Input",
 CellChangeTimes->{{3.8661168745351963`*^9, 3.8661168970884323`*^9}, {
   3.866119836736802*^9, 3.86611984033876*^9}, {3.866147363252038*^9, 
   3.866147379452743*^9}, {3.867782251992507*^9, 3.867782269343053*^9}, 
   3.867782331404613*^9, {3.86778236504497*^9, 3.867782395244555*^9}},
 CellLabel->"In[37]:=",ExpressionUUID->"45b42e55-a8e3-4823-8fe3-8cff4ccc0450"],

Cell[BoxData[
 FractionBox["2", 
  RowBox[{"psi1", "-", 
   SuperscriptBox["psi1", "2"]}]]], "Output",
 CellChangeTimes->{3.867782269760826*^9, 3.867782489864303*^9, 
  3.868217125582809*^9},
 CellLabel->"Out[37]=",ExpressionUUID->"46f21af2-df36-444b-8511-5443819f6d75"],

Cell[BoxData[
 FractionBox[
  RowBox[{"2", " ", "psi1"}], 
  RowBox[{
   RowBox[{"-", "1"}], "+", "psi1"}]]], "Output",
 CellChangeTimes->{3.867782269760826*^9, 3.867782489864303*^9, 
  3.868217125607587*^9},
 CellLabel->"Out[38]=",ExpressionUUID->"332af392-9814-454d-b13a-3e89721cbafe"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
   "Show", " ", "that", " ", "the", " ", "left", " ", "most", " ", "value", 
    " ", "of", " ", "secondDerMinusBaseline", " ", "is", " ", "always", " ", 
    "smaller", " ", "than", " ", "the", " ", "right", " ", "most", " ", 
    "value", " ", "of", " ", "secondDerMinusBaseline"}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"Minimize", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"Max", "[", 
        RowBox[{"OtildexR1", ",", "OtildexR2"}], "]"}], "-", "OtildexL"}], 
      ",", 
      RowBox[{"psi1", ">", "0"}]}], "}"}], ",", "psi1"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.8661474058047523`*^9, 3.8661474207024508`*^9}},
 CellLabel->"In[39]:=",ExpressionUUID->"27b5443c-b50d-4e2c-97ee-ce47da993881"],

Cell[BoxData[
 TemplateBox[{
  "Minimize", "wksol", 
   "\"Warning: there is no minimum in the region in which the objective \
function is defined and the constraints are satisfied; returning a result on \
the boundary.\"", 2, 39, 3, 16461797715388458994, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.8677818706470118`*^9, 3.868217131378491*^9},
 CellLabel->
  "During evaluation of \
In[39]:=",ExpressionUUID->"2a27ec38-4173-406e-85d8-bc023356218f"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", 
   RowBox[{"{", 
    RowBox[{"psi1", "\[Rule]", "0"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.866116918526554*^9, 3.866147421772765*^9, 
  3.86778187065171*^9, 3.868217131384411*^9},
 CellLabel->"Out[39]=",ExpressionUUID->"1e57f65b-22d2-4165-9cf0-3072f7804356"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{
   RowBox[{
    RowBox[{
    "show", " ", "that", " ", "left", " ", "side", " ", "is", " ", 
     "decreasing", " ", "given", " ", "that", " ", "F1"}], ">", "0"}], ",", 
   " ", 
   RowBox[{"psi1", ">", 
    RowBox[{"0", " ", "and", " ", "alpha"}], " ", ">", "0"}]}], 
  "*)"}]], "Input",
 CellChangeTimes->{{3.866117010467339*^9, 3.86611701066896*^9}, {
  3.866147602107991*^9, 3.8661476118079042`*^9}, {3.8661482196709843`*^9, 
  3.866148222020961*^9}},
 CellLabel->
  "In[277]:=",ExpressionUUID->"70b537a6-6084-4d55-820f-f1ca95a76c43"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"D", "[", 
    RowBox[{"secondDerMinusBaseline", ",", " ", "chi"}], "]"}], "/.", 
   RowBox[{"{", 
    RowBox[{"chi", "\[Rule]", 
     RowBox[{"-", "psi1"}]}], "}"}]}], "//", "FullSimplify"}]], "Input",
 CellLabel->"In[40]:=",ExpressionUUID->"5b337fda-25e9-4388-9518-413ebc193f4d"],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox[
   RowBox[{"12", " ", 
    SuperscriptBox["F1", "2"], " ", "\[Alpha]"}], "psi1"]}]], "Output",
 CellChangeTimes->{3.866116981453093*^9, 3.866147598832263*^9, 
  3.866148226290769*^9, 3.8677818925046473`*^9, 3.8682171353858633`*^9},
 CellLabel->"Out[40]=",ExpressionUUID->"f8289e6c-0869-48d1-8cfa-bc0fdc778334"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{"Calculation", " ", "of", " ", "A1"}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{"See", " ", "above"}], "*)"}]}]], "Input",
 CellChangeTimes->{{3.8677824219437838`*^9, 3.8677824496444902`*^9}, {
  3.867782592796029*^9, 
  3.867782593196589*^9}},ExpressionUUID->"4abc83ab-698a-4552-80e5-\
c54b7e68c8f8"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"Calculation", " ", "of", " ", "y"}], "-", 
    RowBox[{
    "coordinate", " ", "of", " ", "A2", " ", "after", " ", "we", " ", 
     "divide", " ", "it", " ", "by", " ", 
     RowBox[{"F", "^", "2"}], "_", "1", " ", "alpha"}]}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"Minimize", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"secondDerMinusBaseline", "/.", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"\[Alpha]", "\[Rule]", "1"}], ",", 
           RowBox[{"F1", "\[Rule]", "1"}]}], "}"}]}], ",", 
        RowBox[{
         RowBox[{"chi", "\[GreaterEqual]", 
          RowBox[{"-", "psi1"}]}], "&&", 
         RowBox[{"chi", "\[LessEqual]", "0"}], "&&", 
         RowBox[{"chi", "\[LessEqual]", 
          RowBox[{"1", "-", "psi1"}]}], "&&", 
         RowBox[{"psi1", "\[GreaterEqual]", "0"}]}]}], "}"}], ",", "chi"}], 
     "]"}], "//", "FullSimplify"}], "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{{3.866119509239758*^9, 3.866119529835972*^9}, {
  3.866119777884797*^9, 3.866119778015839*^9}, {3.866119821117312*^9, 
  3.866119821655015*^9}, {3.867782597697261*^9, 3.8677826576468887`*^9}},
 CellLabel->"In[41]:=",ExpressionUUID->"e77235ec-7005-4968-98c8-bf8c77b6871c"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[GridBox[{
      {"\[Piecewise]", GridBox[{
         {
          RowBox[{
           RowBox[{"-", 
            FractionBox["1", "2"]}], "+", 
           FractionBox[
            RowBox[{"1", "+", 
             SqrtBox[
              RowBox[{"1", "-", "psi1"}]]}], "psi1"]}], 
          RowBox[{"0", "<", "psi1", "\[LessEqual]", "1"}]},
         {
          RowBox[{"1", "+", 
           SqrtBox[
            FractionBox[
             RowBox[{
              RowBox[{"-", "1"}], "+", "psi1"}], "psi1"]], "-", 
           FractionBox["1", 
            RowBox[{"2", " ", "psi1"}]]}], 
          RowBox[{"psi1", ">", "1"}]},
         {"\[Infinity]", 
          TagBox["True",
           "PiecewiseDefault",
           AutoDelete->True]}
        },
        AllowedDimensions->{2, Automatic},
        Editable->True,
        GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Baseline}}},
        GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{1.}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.84]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}},
        Selectable->True]}
     },
     GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Baseline}}},
     GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{1.}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.35]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    "Piecewise",
    DeleteWithContents->True,
    Editable->False,
    SelectWithContents->True,
    Selectable->False,
    StripWrapperBoxes->True], ",", 
   RowBox[{"{", 
    RowBox[{"chi", "\[Rule]", 
     TagBox[GridBox[{
        {"\[Piecewise]", GridBox[{
           {
            RowBox[{"Root", "[", 
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{"5", " ", 
                 SuperscriptBox["psi1", "2"]}], "-", 
                RowBox[{"2", " ", 
                 SqrtBox[
                  RowBox[{
                   RowBox[{"-", "1"}], "+", "psi1"}]], " ", 
                 SuperscriptBox["psi1", 
                  RowBox[{"5", "/", "2"}]]}], "-", 
                RowBox[{"13", " ", 
                 SuperscriptBox["psi1", "3"]}], "+", 
                RowBox[{"6", " ", 
                 SqrtBox[
                  RowBox[{
                   RowBox[{"-", "1"}], "+", "psi1"}]], " ", 
                 SuperscriptBox["psi1", 
                  RowBox[{"7", "/", "2"}]]}], "+", 
                RowBox[{"13", " ", 
                 SuperscriptBox["psi1", "4"]}], "-", 
                RowBox[{"6", " ", 
                 SqrtBox[
                  RowBox[{
                   RowBox[{"-", "1"}], "+", "psi1"}]], " ", 
                 SuperscriptBox["psi1", 
                  RowBox[{"9", "/", "2"}]]}], "-", 
                RowBox[{"7", " ", 
                 SuperscriptBox["psi1", "5"]}], "+", 
                RowBox[{"2", " ", 
                 SqrtBox[
                  RowBox[{
                   RowBox[{"-", "1"}], "+", "psi1"}]], " ", 
                 SuperscriptBox["psi1", 
                  RowBox[{"11", "/", "2"}]]}], "+", 
                RowBox[{"2", " ", 
                 SuperscriptBox["psi1", "6"]}], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"-", "6"}], " ", 
                    SuperscriptBox["psi1", "2"]}], "+", 
                   RowBox[{"12", " ", 
                    SqrtBox[
                    RowBox[{
                    RowBox[{"-", "1"}], "+", "psi1"}]], " ", 
                    SuperscriptBox["psi1", 
                    RowBox[{"5", "/", "2"}]]}], "+", 
                   RowBox[{"24", " ", 
                    SuperscriptBox["psi1", "3"]}], "-", 
                   RowBox[{"24", " ", 
                    SqrtBox[
                    RowBox[{
                    RowBox[{"-", "1"}], "+", "psi1"}]], " ", 
                    SuperscriptBox["psi1", 
                    RowBox[{"7", "/", "2"}]]}], "-", 
                   RowBox[{"30", " ", 
                    SuperscriptBox["psi1", "4"]}], "+", 
                   RowBox[{"12", " ", 
                    SqrtBox[
                    RowBox[{
                    RowBox[{"-", "1"}], "+", "psi1"}]], " ", 
                    SuperscriptBox["psi1", 
                    RowBox[{"9", "/", "2"}]]}], "+", 
                   RowBox[{"12", " ", 
                    SuperscriptBox["psi1", "5"]}]}], ")"}], " ", "#1"}], "+", 
                
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"9", " ", "psi1"}], "+", 
                   RowBox[{"6", " ", 
                    SqrtBox[
                    RowBox[{
                    RowBox[{"-", "1"}], "+", "psi1"}]], " ", 
                    SuperscriptBox["psi1", 
                    RowBox[{"3", "/", "2"}]]}], "+", 
                   RowBox[{"12", " ", 
                    SuperscriptBox["psi1", "2"]}], "-", 
                   RowBox[{"36", " ", 
                    SqrtBox[
                    RowBox[{
                    RowBox[{"-", "1"}], "+", "psi1"}]], " ", 
                    SuperscriptBox["psi1", 
                    RowBox[{"5", "/", "2"}]]}], "-", 
                   RowBox[{"51", " ", 
                    SuperscriptBox["psi1", "3"]}], "+", 
                   RowBox[{"30", " ", 
                    SqrtBox[
                    RowBox[{
                    RowBox[{"-", "1"}], "+", "psi1"}]], " ", 
                    SuperscriptBox["psi1", 
                    RowBox[{"7", "/", "2"}]]}], "+", 
                   RowBox[{"30", " ", 
                    SuperscriptBox["psi1", "4"]}]}], ")"}], " ", 
                 SuperscriptBox["#1", "2"]}], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"4", " ", "psi1"}], "-", 
                   RowBox[{"24", " ", 
                    SqrtBox[
                    RowBox[{
                    RowBox[{"-", "1"}], "+", "psi1"}]], " ", 
                    SuperscriptBox["psi1", 
                    RowBox[{"3", "/", "2"}]]}], "-", 
                   RowBox[{"44", " ", 
                    SuperscriptBox["psi1", "2"]}], "+", 
                   RowBox[{"40", " ", 
                    SqrtBox[
                    RowBox[{
                    RowBox[{"-", "1"}], "+", "psi1"}]], " ", 
                    SuperscriptBox["psi1", 
                    RowBox[{"5", "/", "2"}]]}], "+", 
                   RowBox[{"40", " ", 
                    SuperscriptBox["psi1", "3"]}]}], ")"}], " ", 
                 SuperscriptBox["#1", "3"]}], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"3", "-", 
                   RowBox[{"21", " ", "psi1"}], "+", 
                   RowBox[{"30", " ", 
                    SqrtBox[
                    RowBox[{
                    RowBox[{"-", "1"}], "+", "psi1"}]], " ", 
                    SuperscriptBox["psi1", 
                    RowBox[{"3", "/", "2"}]]}], "+", 
                   RowBox[{"30", " ", 
                    SuperscriptBox["psi1", "2"]}], "-", 
                   RowBox[{"6", " ", 
                    SqrtBox[
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "1"}], "+", "psi1"}], ")"}], " ", 
                    "psi1"}]]}]}], ")"}], " ", 
                 SuperscriptBox["#1", "4"]}], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "6"}], "+", 
                   RowBox[{"12", " ", "psi1"}], "+", 
                   RowBox[{"12", " ", 
                    SqrtBox[
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "1"}], "+", "psi1"}], ")"}], " ", 
                    "psi1"}]]}]}], ")"}], " ", 
                 SuperscriptBox["#1", "5"]}], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"2", "+", 
                   RowBox[{"2", " ", 
                    SqrtBox[
                    FractionBox[
                    RowBox[{
                    RowBox[{"-", "1"}], "+", "psi1"}], "psi1"]]}], "-", 
                   FractionBox["1", "psi1"]}], ")"}], " ", 
                 SuperscriptBox["#1", "6"]}]}], "&"}], ",", "1"}], "]"}], 
            RowBox[{"psi1", ">", "1"}]},
           {
            RowBox[{"Root", "[", 
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{"2", " ", 
                 SuperscriptBox["psi1", "2"]}], "-", 
                RowBox[{"2", " ", 
                 SqrtBox[
                  RowBox[{"1", "-", "psi1"}]], " ", 
                 SuperscriptBox["psi1", "2"]}], "-", 
                SuperscriptBox["psi1", "3"], "+", 
                RowBox[{"6", " ", 
                 SqrtBox[
                  RowBox[{"1", "-", "psi1"}]], " ", 
                 SuperscriptBox["psi1", "3"]}], "-", 
                RowBox[{"5", " ", 
                 SuperscriptBox["psi1", "4"]}], "-", 
                RowBox[{"6", " ", 
                 SqrtBox[
                  RowBox[{"1", "-", "psi1"}]], " ", 
                 SuperscriptBox["psi1", "4"]}], "+", 
                RowBox[{"5", " ", 
                 SuperscriptBox["psi1", "5"]}], "+", 
                RowBox[{"2", " ", 
                 SqrtBox[
                  RowBox[{"1", "-", "psi1"}]], " ", 
                 SuperscriptBox["psi1", "5"]}], "-", 
                SuperscriptBox["psi1", "6"], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"12", " ", 
                    SuperscriptBox["psi1", "2"]}], "+", 
                   RowBox[{"12", " ", 
                    SqrtBox[
                    RowBox[{"1", "-", "psi1"}]], " ", 
                    SuperscriptBox["psi1", "2"]}], "-", 
                   RowBox[{"30", " ", 
                    SuperscriptBox["psi1", "3"]}], "-", 
                   RowBox[{"24", " ", 
                    SqrtBox[
                    RowBox[{"1", "-", "psi1"}]], " ", 
                    SuperscriptBox["psi1", "3"]}], "+", 
                   RowBox[{"24", " ", 
                    SuperscriptBox["psi1", "4"]}], "+", 
                   RowBox[{"12", " ", 
                    SqrtBox[
                    RowBox[{"1", "-", "psi1"}]], " ", 
                    SuperscriptBox["psi1", "4"]}], "-", 
                   RowBox[{"6", " ", 
                    SuperscriptBox["psi1", "5"]}]}], ")"}], " ", "#1"}], "+", 
                
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"18", " ", "psi1"}], "+", 
                   RowBox[{"6", " ", 
                    SqrtBox[
                    RowBox[{"1", "-", "psi1"}]], " ", "psi1"}], "-", 
                   RowBox[{"51", " ", 
                    SuperscriptBox["psi1", "2"]}], "-", 
                   RowBox[{"36", " ", 
                    SqrtBox[
                    RowBox[{"1", "-", "psi1"}]], " ", 
                    SuperscriptBox["psi1", "2"]}], "+", 
                   RowBox[{"48", " ", 
                    SuperscriptBox["psi1", "3"]}], "+", 
                   RowBox[{"30", " ", 
                    SqrtBox[
                    RowBox[{"1", "-", "psi1"}]], " ", 
                    SuperscriptBox["psi1", "3"]}], "-", 
                   RowBox[{"15", " ", 
                    SuperscriptBox["psi1", "4"]}]}], ")"}], " ", 
                 SuperscriptBox["#1", "2"]}], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"-", "32"}], " ", "psi1"}], "-", 
                   RowBox[{"24", " ", 
                    SqrtBox[
                    RowBox[{"1", "-", "psi1"}]], " ", "psi1"}], "+", 
                   RowBox[{"52", " ", 
                    SuperscriptBox["psi1", "2"]}], "+", 
                   RowBox[{"40", " ", 
                    SqrtBox[
                    RowBox[{"1", "-", "psi1"}]], " ", 
                    SuperscriptBox["psi1", "2"]}], "-", 
                   RowBox[{"20", " ", 
                    SuperscriptBox["psi1", "3"]}]}], ")"}], " ", 
                 SuperscriptBox["#1", "3"]}], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "6"}], "-", 
                   RowBox[{"6", " ", 
                    SqrtBox[
                    RowBox[{"1", "-", "psi1"}]]}], "+", 
                   RowBox[{"33", " ", "psi1"}], "+", 
                   RowBox[{"30", " ", 
                    SqrtBox[
                    RowBox[{"1", "-", "psi1"}]], " ", "psi1"}], "-", 
                   RowBox[{"15", " ", 
                    SuperscriptBox["psi1", "2"]}]}], ")"}], " ", 
                 SuperscriptBox["#1", "4"]}], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"12", "+", 
                   RowBox[{"12", " ", 
                    SqrtBox[
                    RowBox[{"1", "-", "psi1"}]]}], "-", 
                   RowBox[{"6", " ", "psi1"}]}], ")"}], " ", 
                 SuperscriptBox["#1", "5"]}], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "1"}], "+", 
                   FractionBox["2", "psi1"], "+", 
                   FractionBox[
                    RowBox[{"2", " ", 
                    SqrtBox[
                    RowBox[{"1", "-", "psi1"}]]}], "psi1"]}], ")"}], " ", 
                 SuperscriptBox["#1", "6"]}]}], "&"}], ",", "1"}], "]"}], 
            RowBox[{"0", "<", "psi1", "<", "1"}]},
           {"Indeterminate", 
            TagBox["True",
             "PiecewiseDefault",
             AutoDelete->True]}
          },
          AllowedDimensions->{2, Automatic},
          Editable->True,
          GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Baseline}}},
          GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{1.}}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.84]}, 
              Offset[0.27999999999999997`]}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}},
          Selectable->True]}
       },
       GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Baseline}}},
       GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{1.}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.35]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      "Piecewise",
      DeleteWithContents->True,
      Editable->False,
      SelectWithContents->True,
      Selectable->False,
      StripWrapperBoxes->True]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.866119830085999*^9, 3.868217147105681*^9},
 CellLabel->"Out[41]=",ExpressionUUID->"19b13fc6-33fe-49fe-9bbc-c2777cb7ddf8"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{"Calculation", " ", "of", " ", "A3"}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{"See", " ", "above"}], " ", "*)"}]}]], "Input",
 CellChangeTimes->{{3.867782466444625*^9, 3.8677824832452374`*^9}, {
  3.8677826155961523`*^9, 
  3.867782617245932*^9}},ExpressionUUID->"712352e9-3d60-4757-8260-\
e0973dd3bb6d"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{"calculation", " ", "of", " ", "beta_", "1"}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"Case", " ", "when", " ", "psi1"}], " ", "\[LessEqual]", "1"}], 
   "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"Solve", "[", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"-", 
         FractionBox["1", "2"]}], "+", 
        FractionBox[
         RowBox[{"1", "+", 
          SqrtBox[
           RowBox[{"1", "-", "psi1"}]]}], "psi1"]}], "==", 
       RowBox[{"-", 
        FractionBox[
         RowBox[{"2", " "}], 
         RowBox[{"psi1", "-", "psi2"}]]}]}], ",", "psi2"}], "]"}], "//", 
    "FullSimplify"}], "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
     RowBox[{"Case", " ", "when", " ", "psi1"}], " ", ">=", "1"}], "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Solve", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"1", "+", 
        SqrtBox[
         FractionBox[
          RowBox[{
           RowBox[{"-", "1"}], "+", "psi1"}], "psi1"]], "-", 
        FractionBox["1", 
         RowBox[{"2", " ", "psi1"}]]}], "==", 
       RowBox[{"-", 
        FractionBox[
         RowBox[{"2", " "}], 
         RowBox[{"psi1", "-", "psi2"}]]}]}], ",", "psi2"}], "]"}], "//", 
    "FullSimplify"}]}]}]], "Input",
 CellChangeTimes->{{3.866119856016932*^9, 3.86611987353861*^9}, {
  3.8661199194908543`*^9, 3.8661199827032127`*^9}, {3.867782722549094*^9, 
  3.867782751049674*^9}},
 CellLabel->"In[42]:=",ExpressionUUID->"735b8073-07e6-4032-8f4b-3344d19e3cd6"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"psi2", "\[Rule]", 
    FractionBox[
     RowBox[{"8", "-", 
      RowBox[{"8", " ", 
       SqrtBox[
        RowBox[{"1", "-", "psi1"}]]}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "4"}], "+", "psi1"}], ")"}], " ", "psi1"}]}], "psi1"]}],
    "}"}], "}"}]], "Output",
 CellChangeTimes->{3.8661200698566923`*^9, 3.8677827444955177`*^9, 
  3.868217201368637*^9},
 CellLabel->"Out[42]=",ExpressionUUID->"a0392c4e-5b1a-45dc-85a9-7193d929e710"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"psi2", "\[Rule]", 
    RowBox[{"psi1", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "3"}], "-", 
       RowBox[{"8", " ", 
        SqrtBox[
         RowBox[{
          RowBox[{"-", "1"}], "+", "psi1"}]], " ", 
        SqrtBox["psi1"]}], "+", 
       RowBox[{"8", " ", "psi1"}]}], ")"}]}]}], "}"}], "}"}]], "Output",
 CellChangeTimes->{3.8661200698566923`*^9, 3.8677827444955177`*^9, 
  3.8682172014146557`*^9},
 CellLabel->"Out[43]=",ExpressionUUID->"d54ccb34-af23-416c-868a-581147ca4bc9"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{"calculation", " ", "of", " ", "beta_", "2"}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"Solve", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"2", "+", 
       FractionBox["2", "psi1"]}], "==", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{"2", " "}], 
        RowBox[{"psi1", "-", "psi2"}]]}]}], ",", "psi2"}], "]"}], "//", 
   "FullSimplify"}]}]], "Input",
 CellChangeTimes->{{3.866119856016932*^9, 3.86611987353861*^9}, {
  3.8661199194908543`*^9, 3.866119977893003*^9}, {3.8677827966506977`*^9, 
  3.867782797149116*^9}},
 CellLabel->"In[44]:=",ExpressionUUID->"0458fdda-0ac4-4eec-81c4-b556e91c97b7"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"psi2", "\[Rule]", 
    FractionBox[
     RowBox[{"psi1", " ", 
      RowBox[{"(", 
       RowBox[{"2", "+", "psi1"}], ")"}]}], 
     RowBox[{"1", "+", "psi1"}]]}], "}"}], "}"}]], "Output",
 CellChangeTimes->{3.8661199222282*^9, 3.8661199727855473`*^9, 
  3.866120080212373*^9, 3.8682172050706244`*^9},
 CellLabel->"Out[44]=",ExpressionUUID->"7737fc63-c991-415a-9865-5373565ea007"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{"calculation", " ", "of", " ", "beta_", "3"}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"Case", " ", "when", " ", "psi1"}], " ", "\[LessEqual]", " ", 
    "1"}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"Solve", "[", 
     RowBox[{
      RowBox[{
       FractionBox["2", 
        RowBox[{"psi1", "-", 
         SuperscriptBox["psi1", "2"]}]], "==", 
       RowBox[{"-", 
        FractionBox[
         RowBox[{"2", " "}], 
         RowBox[{"psi1", "-", "psi2"}]]}]}], ",", "psi2"}], "]"}], "//", 
    "FullSimplify"}], "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
     RowBox[{"Case", " ", "when", " ", "psi1"}], " ", ">=", " ", "1"}], 
    "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Solve", "[", 
     RowBox[{
      RowBox[{
       FractionBox[
        RowBox[{"2", " ", "psi1"}], 
        RowBox[{
         RowBox[{"-", "1"}], "+", "psi1"}]], "==", 
       RowBox[{"-", 
        FractionBox[
         RowBox[{"2", " "}], 
         RowBox[{"psi1", "-", "psi2"}]]}]}], ",", "psi2"}], "]"}], "//", 
    "FullSimplify"}]}]}]], "Input",
 CellChangeTimes->{{3.867782783749785*^9, 3.867782784250433*^9}, {
  3.86778283160081*^9, 3.867782848401692*^9}},
 CellLabel->"In[45]:=",ExpressionUUID->"c2989c20-80c3-4e78-a806-136e56172813"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"psi2", "\[Rule]", 
    RowBox[{
     RowBox[{"-", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "2"}], "+", "psi1"}], ")"}]}], " ", "psi1"}]}], "}"}], 
  "}"}]], "Output",
 CellChangeTimes->{3.8677828574907293`*^9, 3.8682172084873238`*^9},
 CellLabel->"Out[45]=",ExpressionUUID->"16679a68-e8b1-448e-b4b8-744f2d7a0a5c"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"psi2", "\[Rule]", 
    RowBox[{"1", "-", 
     FractionBox["1", "psi1"], "+", "psi1"}]}], "}"}], "}"}]], "Output",
 CellChangeTimes->{3.8677828574907293`*^9, 3.868217208510695*^9},
 CellLabel->"Out[46]=",ExpressionUUID->"5073624b-2a4b-4f4d-91f9-c02e3e4338df"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
   "Compute", " ", "the", " ", "poly", " ", "for", " ", "critical", " ", 
    "points", " ", "of", " ", "the", " ", "objective", " ", "when", " ", 
    "psi1", " ", "neq", " ", "1"}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"derObj", "=", 
    RowBox[{
     RowBox[{
      RowBox[{"D", "[", 
       RowBox[{"objective", ",", "chi"}], "]"}], "//", "Together"}], "//", 
     "FullSimplify"}]}], ";"}]}]], "Input",
 CellChangeTimes->{{3.866127777074565*^9, 3.866127782130705*^9}, 
   3.8677831633530293`*^9},
 CellLabel->"In[47]:=",ExpressionUUID->"2db69fb7-4ace-493a-b7e2-b9b2f8e305b5"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
   "Get", " ", "numerator", " ", "of", " ", "the", " ", "above", " ", 
    "polynomial"}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"num", "=", 
    RowBox[{
     RowBox[{"Numerator", "[", "derObj", "]"}], "//", "FullSimplify"}]}], 
   ";"}]}]], "Input",
 CellChangeTimes->{{3.866127777074565*^9, 3.866127848986706*^9}, {
   3.8661279083804703`*^9, 3.866127908895051*^9}, {3.866127991749174*^9, 
   3.866128020076376*^9}, 3.867783165658478*^9},
 CellLabel->"In[48]:=",ExpressionUUID->"a64b6d99-d360-4170-a4c0-96fbdf28c6ec"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
   "Compute", " ", "coefficients", " ", "for", " ", "poly", " ", "when", " ", 
    "psi1", " ", "neq", " ", "1"}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"CoefficientList", "[", 
        RowBox[{"num", ",", "chi"}], "]"}], "/.", 
       RowBox[{"{", 
        RowBox[{
         SuperscriptBox["F1", "2"], "\[Rule]", 
         RowBox[{"\[Rho]", "*", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["Fs", "2"], "+", 
            SuperscriptBox["tau", "2"]}], ")"}]}]}], "}"}]}], ")"}], "/", 
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["Fs", "2"], "+", 
       SuperscriptBox["tau", "2"]}], ")"}]}], ")"}], "//", 
   "FullSimplify"}]}]], "Input",
 CellChangeTimes->{{3.867783263108388*^9, 3.867783296656666*^9}},
 CellLabel->"In[49]:=",ExpressionUUID->"7d9d1fa0-9af1-4b62-9f76-a6864cc5ae86"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", "psi1"}], ")"}], "2"], " ", 
    SuperscriptBox["psi1", "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"psi2", " ", "\[Rho]"}], "+", 
      RowBox[{"\[Alpha]", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", 
            RowBox[{"4", " ", "psi1"}], "-", 
            RowBox[{"3", " ", "psi2"}]}], ")"}], " ", "\[Rho]"}]}], ")"}]}]}],
      ")"}]}], ",", 
   RowBox[{"2", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", "psi1"}], ")"}], " ", "psi1", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"9", " ", 
       SuperscriptBox["psi1", "2"], " ", "\[Alpha]", " ", "\[Rho]"}], "+", 
      RowBox[{"psi2", " ", "\[Alpha]", " ", "\[Rho]"}], "-", 
      RowBox[{"2", " ", "psi1", " ", 
       RowBox[{"(", 
        RowBox[{"\[Alpha]", "-", 
         RowBox[{"psi2", " ", "\[Rho]"}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"2", "+", 
            RowBox[{"3", " ", "psi2"}]}], ")"}], " ", "\[Alpha]", " ", 
          "\[Rho]"}]}], ")"}]}]}], ")"}]}], ",", 
   RowBox[{"2", " ", "psi1", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         RowBox[{"3", " ", "psi1"}]}], ")"}], " ", "psi2", " ", "\[Rho]"}], 
      "+", 
      RowBox[{"\[Alpha]", " ", 
       RowBox[{"(", 
        RowBox[{"1", "-", 
         RowBox[{"3", " ", "psi1"}], "+", "\[Rho]", "+", 
         RowBox[{"psi1", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "12"}], "+", 
            RowBox[{"16", " ", "psi1"}], "-", 
            RowBox[{"9", " ", "psi2"}]}], ")"}], " ", "\[Rho]"}], "+", 
         RowBox[{"4", " ", "psi2", " ", "\[Rho]"}]}], ")"}]}]}], ")"}]}], ",", 
   RowBox[{"4", " ", "psi1", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"psi2", " ", "\[Rho]"}], "+", 
      RowBox[{"\[Alpha]", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "2"}], "+", 
            RowBox[{"7", " ", "psi1"}], "-", 
            RowBox[{"3", " ", "psi2"}]}], ")"}], " ", "\[Rho]"}]}], ")"}]}]}],
      ")"}]}], ",", 
   RowBox[{
    RowBox[{"psi2", " ", "\[Rho]"}], "+", 
    RowBox[{"\[Alpha]", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          RowBox[{"12", " ", "psi1"}], "-", 
          RowBox[{"3", " ", "psi2"}]}], ")"}], " ", "\[Rho]"}]}], ")"}]}]}], 
   ",", 
   RowBox[{"2", " ", "\[Alpha]", " ", "\[Rho]"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.866127969942129*^9, {3.867783279028139*^9, 3.867783297149775*^9}, 
   3.868217222512959*^9},
 CellLabel->"Out[49]=",ExpressionUUID->"826996c0-0c63-45c1-8ce1-857a59e2f54a"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
   "get", " ", "expression", " ", "for", " ", "the", " ", "denominator"}], 
   "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"den", "=", 
    RowBox[{
     RowBox[{"Denominator", "[", "derObj", "]"}], "//", "FullSimplify"}]}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
    "check", " ", "that", " ", "the", " ", "roots", " ", "of", " ", "the", 
     " ", "denominator", " ", "do", " ", "not", " ", "make", " ", "the", " ", 
     "numerator", " ", "be", " ", "zero"}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
    "first", " ", "compute", " ", "the", " ", "roots", " ", "of", " ", "the", 
     " ", "denominator"}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{"Solve", "[", 
    RowBox[{
     RowBox[{"den", "\[Equal]", "0"}], ",", "chi"}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.866127777074565*^9, 3.866127848986706*^9}, 
   3.867783174854742*^9, 3.867783493607359*^9, {3.867783533505713*^9, 
   3.867783577108491*^9}},
 CellLabel->"In[50]:=",ExpressionUUID->"ced51ac4-66b9-49ea-8d90-8f3c665eb9b9"],

Cell[BoxData[
 RowBox[{
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{"psi1", "-", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"chi", "+", "psi1"}], ")"}], "2"]}], ")"}], "2"], " ", 
  RowBox[{"(", 
   RowBox[{"psi1", "-", "psi2"}], ")"}]}]], "Output",
 CellChangeTimes->{
  3.8661279384393997`*^9, 3.867783077296327*^9, 3.867783175134027*^9, 
   3.8677834941830606`*^9, {3.867783550278985*^9, 3.8677835776714153`*^9}, 
   3.8682172260286016`*^9},
 CellLabel->"Out[50]=",ExpressionUUID->"abcde660-0d60-4f58-adec-9fafe3248693"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"chi", "\[Rule]", 
     RowBox[{
      RowBox[{"-", 
       SqrtBox["psi1"]}], "-", "psi1"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"chi", "\[Rule]", 
     RowBox[{
      RowBox[{"-", 
       SqrtBox["psi1"]}], "-", "psi1"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"chi", "\[Rule]", 
     RowBox[{
      SqrtBox["psi1"], "-", "psi1"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"chi", "\[Rule]", 
     RowBox[{
      SqrtBox["psi1"], "-", "psi1"}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.8661279384393997`*^9, 3.867783077296327*^9, 3.867783175134027*^9, 
   3.8677834941830606`*^9, {3.867783550278985*^9, 3.8677835776714153`*^9}, 
   3.8682172260349407`*^9},
 CellLabel->"Out[51]=",ExpressionUUID->"504769d7-dd08-44e6-ae77-6d4e51e96ce8"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
   "Now", " ", "check", " ", "if", " ", "the", " ", "roots", " ", "of", " ", 
    "the", " ", "denominator", " ", "will", " ", "make", " ", "numerator", 
    " ", "0"}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
     RowBox[{
     "Observe", " ", "that", " ", "the", " ", "numerator", " ", "will", " ", 
      "not", " ", "be", " ", "zero", " ", "since", " ", "F1"}], " ", ">", 
     "0"}], ",", " ", 
    RowBox[{"alpha", " ", ">", " ", "0"}], ",", " ", 
    RowBox[{"psi1", " ", ">", " ", "psi2"}], ",", " ", 
    RowBox[{"and", " ", "psi1", " ", "neq", " ", "1"}]}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"num", "/.", 
     RowBox[{"{", 
      RowBox[{"chi", "\[Rule]", 
       RowBox[{
        RowBox[{"-", 
         SqrtBox["psi1"]}], "-", "psi1"}]}], "}"}]}], "//", "FullSimplify"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"num", "/.", 
     RowBox[{"{", 
      RowBox[{"chi", "\[Rule]", 
       RowBox[{
        SqrtBox["psi1"], "-", "psi1"}]}], "}"}]}], "//", 
    "FullSimplify"}]}]}]], "Input",
 CellChangeTimes->{{3.8677831980563593`*^9, 3.867783226705861*^9}, {
  3.8677835612064323`*^9, 3.867783586412902*^9}, {3.869271007652627*^9, 
  3.869271027369018*^9}},ExpressionUUID->"9c975f8a-67e6-4e55-9078-\
8a295d1e494c"],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "2"}], " ", 
  SuperscriptBox["F1", "2"], " ", 
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{"1", "+", 
     SqrtBox["psi1"]}], ")"}], "2"], " ", 
  SuperscriptBox["psi1", 
   RowBox[{"3", "/", "2"}]], " ", 
  RowBox[{"(", 
   RowBox[{"psi1", "-", "psi2"}], ")"}], " ", "\[Alpha]"}]], "Output",
 CellChangeTimes->{3.866127960142157*^9, 3.867783588640263*^9, 
  3.868217231243022*^9},
 CellLabel->"Out[52]=",ExpressionUUID->"82d67356-681f-4746-bf5e-734f42455ad1"],

Cell[BoxData[
 RowBox[{"2", " ", 
  SuperscriptBox["F1", "2"], " ", 
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "1"}], "+", 
     SqrtBox["psi1"]}], ")"}], "2"], " ", 
  SuperscriptBox["psi1", 
   RowBox[{"3", "/", "2"}]], " ", 
  RowBox[{"(", 
   RowBox[{"psi1", "-", "psi2"}], ")"}], " ", "\[Alpha]"}]], "Output",
 CellChangeTimes->{3.866127960142157*^9, 3.867783588640263*^9, 
  3.868217231269621*^9},
 CellLabel->"Out[53]=",ExpressionUUID->"8431f729-87e6-4e0e-b1d5-5698e57342fe"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{
   RowBox[{
   "Compute", " ", "the", " ", "poly", " ", "for", " ", "critical", " ", 
    "points", " ", "of", " ", "the", " ", "objective", " ", "when", " ", 
    "psi1"}], " ", "=", " ", "1"}], "*)"}]], "Input",
 CellChangeTimes->{{3.8661280259016733`*^9, 3.866128028852517*^9}, 
   3.867783446805987*^9},ExpressionUUID->"3d872519-9c39-47f6-a7de-\
9204fc0a7cd9"],

Cell[BoxData[
 RowBox[{
  RowBox[{"derObj", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"D", "[", 
      RowBox[{
       RowBox[{"objective", "/.", 
        RowBox[{"{", 
         RowBox[{"psi1", "\[Rule]", "1"}], "}"}]}], ",", "chi"}], "]"}], "//",
      "Together"}], "//", "FullSimplify"}]}], ";"}]], "Input",
 CellChangeTimes->{3.8677834512556143`*^9},
 CellLabel->"In[54]:=",ExpressionUUID->"d4b29e47-d46e-4000-b9c4-608f82239fe5"],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{
  "Get", " ", "the", " ", "numerator", " ", "of", " ", "the", " ", "above", 
   " ", "equation"}], "*)"}]], "Input",
 CellChangeTimes->{{3.866128308028946*^9, 
  3.866128331866126*^9}},ExpressionUUID->"065f1eb8-dc7c-4463-9137-\
ff5d54e8dbd3"],

Cell[BoxData[
 RowBox[{
  RowBox[{"num2", "=", 
   RowBox[{
    RowBox[{"Numerator", "[", "derObj", "]"}], "//", "FullSimplify"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{3.867783604710103*^9},
 CellLabel->"In[55]:=",ExpressionUUID->"21d21a93-c6b6-4b4e-94d8-1ec9c5e01152"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"Compute", " ", "coefficients", " ", "when", " ", "psi1"}], " ", 
    "=", " ", "1"}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"CoefficientList", "[", 
        RowBox[{"num2", ",", "chi"}], "]"}], "/.", 
       RowBox[{"{", 
        RowBox[{
         SuperscriptBox["F1", "2"], "\[Rule]", 
         RowBox[{"\[Rho]", "*", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["Fs", "2"], "+", 
            SuperscriptBox["tau", "2"]}], ")"}]}]}], "}"}]}], ")"}], "/", 
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["Fs", "2"], "+", 
       SuperscriptBox["tau", "2"]}], ")"}]}], ")"}], "//", 
   "FullSimplify"}]}]], "Input",
 CellChangeTimes->{{3.8677836307658052`*^9, 3.867783632809165*^9}},
 CellLabel->"In[56]:=",ExpressionUUID->"da562287-e4d7-485f-a844-81a7486fcd7a"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", "4"}], " ", "psi2", " ", "\[Rho]"}], "+", 
    RowBox[{"2", " ", "\[Alpha]", " ", 
     RowBox[{"(", 
      RowBox[{"2", "+", 
       RowBox[{"5", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "psi2"}], ")"}], " ", "\[Rho]"}]}], 
      ")"}]}]}], ",", 
   RowBox[{"4", " ", 
    RowBox[{"(", 
     RowBox[{"\[Alpha]", "-", 
      RowBox[{"psi2", " ", "\[Rho]"}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "5"}], "+", 
         RowBox[{"3", " ", "psi2"}]}], ")"}], " ", "\[Alpha]", " ", 
       "\[Rho]"}]}], ")"}]}], ",", 
   RowBox[{"\[Alpha]", "-", 
    RowBox[{"psi2", " ", "\[Rho]"}], "+", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "11"}], "+", 
       RowBox[{"3", " ", "psi2"}]}], ")"}], " ", "\[Alpha]", " ", 
     "\[Rho]"}]}], ",", 
   RowBox[{
    RowBox[{"-", "2"}], " ", "\[Alpha]", " ", "\[Rho]"}]}], "}"}]], "Output",
 CellChangeTimes->{3.866128398172509*^9, 3.867783633620232*^9, 
  3.868217242324143*^9},
 CellLabel->"Out[56]=",ExpressionUUID->"c615c8d1-0289-45e9-8042-51a80fd8e1b1"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{"Compute", " ", "expression", " ", "for", " ", "denominator"}], 
   "*)"}], "\[IndentingNewLine]", 
  RowBox[{"den2", "=", 
   RowBox[{
    RowBox[{"Denominator", "[", "derObj", "]"}], "//", 
    "FullSimplify"}]}]}]], "Input",
 CellChangeTimes->{{3.867783714308104*^9, 3.8677837222093*^9}},
 CellLabel->"In[57]:=",ExpressionUUID->"89607b5e-ec49-4853-95b1-320b93d1e7ec"],

Cell[BoxData[
 RowBox[{
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{"2", "+", "chi"}], ")"}], "2"], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"-", "1"}], "+", "psi2"}], ")"}]}]], "Output",
 CellChangeTimes->{3.8661283572265673`*^9, 3.867783728876552*^9, 
  3.868217246804533*^9},
 CellLabel->"Out[57]=",ExpressionUUID->"9ea23a79-97f0-44c1-9043-d1fe4fc01a71"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
   "check", " ", "that", " ", "the", " ", "roots", " ", "of", " ", "the", " ",
     "denominator", " ", "do", " ", "not", " ", "make", " ", "the", " ", 
    "numerator", " ", "be", " ", "zero"}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{"Solve", "[", 
   RowBox[{
    RowBox[{"den2", "\[Equal]", "0"}], ",", "chi"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.86778370956126*^9, 3.867783710110259*^9}},
 CellLabel->"In[58]:=",ExpressionUUID->"a73001a3-4193-435c-83ef-5692efc3feca"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"chi", "\[Rule]", 
     RowBox[{"-", "2"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"chi", "\[Rule]", 
     RowBox[{"-", "2"}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.86612837385006*^9, 3.868217250343033*^9},
 CellLabel->"Out[58]=",ExpressionUUID->"9cdb2859-1895-417b-9f0e-69a0d83529fa"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
   "Now", " ", "check", " ", "that", " ", "these", " ", "roots", " ", "do", 
    " ", "not", " ", "make", " ", "the", " ", "numerator", " ", "be", " ", 
    RowBox[{"zero", "."}]}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
     RowBox[{
     "Observe", " ", "that", " ", "the", " ", "numerator", " ", "will", " ", 
      "not", " ", "be", " ", "zero", " ", "since", " ", "F1"}], " ", ">", 
     "0"}], ",", " ", 
    RowBox[{"alpha", " ", ">", " ", "0"}], ",", " ", 
    RowBox[{"1", " ", "=", " ", 
     RowBox[{"psi1", " ", ">", " ", "psi2"}]}]}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"num2", "/.", 
    RowBox[{"{", 
     RowBox[{"chi", "\[Rule]", 
      RowBox[{"-", "2"}]}], "}"}]}], "//", "FullSimplify"}]}]], "Input",
 CellChangeTimes->{{3.867783742962775*^9, 3.867783782569261*^9}},
 CellLabel->"In[59]:=",ExpressionUUID->"80ac9b22-3075-474f-a73b-bedfe09090dc"],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "2"}], " ", 
  SuperscriptBox["F1", "2"], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"-", "1"}], "+", "psi2"}], ")"}], " ", "\[Alpha]"}]], "Output",
 CellChangeTimes->{3.866128385979632*^9, 3.8682172537226057`*^9},
 CellLabel->"Out[59]=",ExpressionUUID->"da6ef327-4654-46b6-be4f-65da01281d58"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{"Check", " ", "formulas", " ", "in", " ", "Lemma", " ", "D", 
   RowBox[{".13", "."}]}], "*)"}]], "Input",
 CellChangeTimes->{{3.8677838458195753`*^9, 
  3.867783857217985*^9}},ExpressionUUID->"02e289ec-838f-4c86-a200-\
0d92e22df513"],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{
  "Compute", " ", "formulas", " ", "for", " ", "the", " ", "sign", " ", "of", 
   " ", "the", " ", "derivatives", " ", "at", " ", "left", " ", "value", " ", 
   "x_L"}], "*)"}]], "Input",
 CellChangeTimes->{{3.866128769316647*^9, 3.866128769513452*^9}, {
  3.866128972019266*^9, 3.8661289811533623`*^9}, {3.866129028241643*^9, 
  3.866129052750249*^9}, {3.867783843619216*^9, 3.8677838443191338`*^9}, {
  3.867783899821848*^9, 
  3.867783901276084*^9}},ExpressionUUID->"ee81a2e4-51d1-426c-b14e-\
c45259749171"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"D", "[", 
    RowBox[{"objective", ",", "chi"}], "]"}], "/.", 
   RowBox[{"{", 
    RowBox[{"chi", "\[Rule]", 
     RowBox[{"-", "psi1"}]}], "}"}]}], "//", "FullSimplify"}]], "Input",
 CellLabel->"In[60]:=",ExpressionUUID->"440c4878-7079-481e-abf2-a38ab838cea7"],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox[
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["Fs", "2"], "+", 
       SuperscriptBox["tau", "2"]}], ")"}], " ", "\[Alpha]"}], "+", 
    RowBox[{
     SuperscriptBox["F1", "2"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"psi2", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "\[Alpha]"}], ")"}]}], "+", "\[Alpha]"}], 
      ")"}]}]}], 
   RowBox[{"psi1", "-", "psi2"}]]}]], "Output",
 CellChangeTimes->{3.866129058944274*^9, 3.867783916028988*^9, 
  3.868217258019207*^9},
 CellLabel->"Out[60]=",ExpressionUUID->"f8b8973c-3073-4de4-8591-75c3ff8359cc"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{
  "Compute", " ", "formulas", " ", "for", " ", "the", " ", "sign", " ", "of", 
   " ", "the", " ", "derivatives", " ", "at", " ", "right", " ", "value", " ",
    "x_R"}], "*)"}]], "Input",
 CellChangeTimes->{{3.866129068461193*^9, 3.866129069957387*^9}, {
  3.86778391192526*^9, 
  3.8677839137723713`*^9}},ExpressionUUID->"9c9fa923-17c1-416a-9322-\
a7b2774c80d6"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"D", "[", 
     RowBox[{"objective", ",", "chi"}], "]"}], "/.", 
    RowBox[{"{", 
     RowBox[{"chi", "\[Rule]", "0"}], "}"}]}], "//", "FullSimplify"}], " ", 
  RowBox[{"(*", 
   RowBox[{"psi1", " ", "<", " ", "1"}], "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"D", "[", 
    RowBox[{"objective", ",", "chi"}], "]"}], "/.", 
   RowBox[{"{", 
    RowBox[{"chi", "\[Rule]", 
     RowBox[{"1", "-", "psi1"}]}], "}"}]}], "//", "FullSimplify", " ", 
  RowBox[{"(*", 
   RowBox[{"psi1", " ", ">", " ", "1"}], "*)"}]}]}], "Input",
 CellChangeTimes->{{3.867783927422903*^9, 3.867783935821265*^9}},
 CellLabel->"In[61]:=",ExpressionUUID->"8f440147-0899-4d72-a4ef-900512dcf39a"],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{
    SuperscriptBox["F1", "2"], " ", "psi2"}], "-", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["Fs", "2"], "+", 
      RowBox[{
       SuperscriptBox["F1", "2"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "-", 
         RowBox[{"4", " ", "psi1"}], "+", 
         RowBox[{"3", " ", "psi2"}]}], ")"}]}], "+", 
      SuperscriptBox["tau", "2"]}], ")"}], " ", "\[Alpha]"}]}], 
  RowBox[{"psi1", "-", "psi2"}]]], "Output",
 CellChangeTimes->{
  3.8661290866873503`*^9, {3.867783919841751*^9, 3.867783936236895*^9}, 
   3.868217264429491*^9},
 CellLabel->"Out[61]=",ExpressionUUID->"d76c0003-2801-45e7-9b97-7a8b1c6f3ffc"],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{
    RowBox[{"-", 
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["Fs", "2"], "+", 
       SuperscriptBox["tau", "2"]}], ")"}]}], " ", "\[Alpha]"}], "+", 
   RowBox[{
    SuperscriptBox["F1", "2"], " ", 
    RowBox[{"(", 
     RowBox[{"psi2", "+", "\[Alpha]", "+", 
      RowBox[{"2", " ", "psi1", " ", "\[Alpha]"}], "-", 
      RowBox[{"3", " ", "psi2", " ", "\[Alpha]"}]}], ")"}]}]}], 
  RowBox[{"psi1", "-", "psi2"}]]], "Output",
 CellChangeTimes->{
  3.8661290866873503`*^9, {3.867783919841751*^9, 3.867783936236895*^9}, 
   3.868217264477921*^9},
 CellLabel->"Out[62]=",ExpressionUUID->"58f94d4d-73fc-4d73-bb21-4b7c8eb4996a"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{
  "Compute", " ", "formulas", " ", "for", " ", "the", " ", "sign", " ", "of", 
   " ", "differences", " ", "between", " ", "left", " ", "value", " ", "and", 
   " ", "right", " ", "value", " ", "in", " ", "objective", " ", "function"}],
   "*)"}]], "Input",
 CellChangeTimes->{{3.866129099516841*^9, 
  3.8661291297367477`*^9}},ExpressionUUID->"4fa5379a-6cad-41e0-b76f-\
a51bf6950715"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"(", 
    RowBox[{"objective", "/.", 
     RowBox[{"{", 
      RowBox[{"chi", "\[Rule]", 
       RowBox[{"-", "psi1"}]}], "}"}]}], ")"}], "-", 
   RowBox[{"(", 
    RowBox[{"objective", "/.", 
     RowBox[{"{", 
      RowBox[{"chi", "\[Rule]", "0"}], "}"}]}], ")"}]}], "//", 
  "FullSimplify"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"(", 
    RowBox[{"objective", "/.", 
     RowBox[{"{", 
      RowBox[{"chi", "\[Rule]", 
       RowBox[{"-", "psi1"}]}], "}"}]}], ")"}], "-", 
   RowBox[{"(", 
    RowBox[{"objective", "/.", 
     RowBox[{"{", 
      RowBox[{"chi", "\[Rule]", 
       RowBox[{"1", "-", "psi1"}]}], "}"}]}], ")"}]}], "//", 
  "FullSimplify"}]}], "Input",
 CellLabel->"In[63]:=",ExpressionUUID->"a069aa91-69a4-42b2-9069-48016604b4c5"],

Cell[BoxData[
 FractionBox[
  RowBox[{"psi1", " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["Fs", "2"], "+", 
        SuperscriptBox["tau", "2"]}], ")"}], " ", "\[Alpha]"}], "+", 
     RowBox[{
      SuperscriptBox["F1", "2"], " ", 
      RowBox[{"(", 
       RowBox[{"\[Alpha]", "-", 
        RowBox[{"2", " ", "psi1", " ", "\[Alpha]"}], "+", 
        RowBox[{"psi2", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "+", 
           RowBox[{"2", " ", "\[Alpha]"}]}], ")"}]}]}], ")"}]}]}], ")"}]}], 
  RowBox[{"psi1", "-", "psi2"}]]], "Output",
 CellChangeTimes->{3.8661291507067213`*^9, 3.868217268431354*^9},
 CellLabel->"Out[63]=",ExpressionUUID->"fbbb4150-ea38-4fa8-bf15-3a031696020c"],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["Fs", "2"], "+", 
      SuperscriptBox["tau", "2"]}], ")"}], " ", "\[Alpha]"}], "-", 
   RowBox[{
    SuperscriptBox["F1", "2"], " ", 
    RowBox[{"(", 
     RowBox[{"psi2", "+", 
      RowBox[{"psi1", " ", "\[Alpha]"}], "-", 
      RowBox[{"2", " ", "psi2", " ", "\[Alpha]"}]}], ")"}]}]}], 
  RowBox[{"psi1", "-", "psi2"}]]], "Output",
 CellChangeTimes->{3.8661291507067213`*^9, 3.868217268493617*^9},
 CellLabel->"Out[64]=",ExpressionUUID->"8a8a39b9-77de-4fb3-a144-eafe712230d7"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{
   RowBox[{
   "Calculation", " ", "of", " ", "alpha_L", " ", "when", " ", "psi1"}], " ", 
   "<", " ", "1"}], " ", "*)"}]], "Input",
 CellChangeTimes->{{3.8661294859697943`*^9, 3.8661294916684113`*^9}, {
  3.8661296915186253`*^9, 3.866129734446257*^9}, {3.867784253979722*^9, 
  3.8677842630800037`*^9}},ExpressionUUID->"5dbdb82a-f524-488f-950c-\
a8814ef9cc6b"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Solve", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"D", "[", 
        RowBox[{"objective", ",", "chi"}], "]"}], "/.", 
       RowBox[{"{", 
        RowBox[{"chi", "\[Rule]", 
         RowBox[{"-", "psi1"}]}], "}"}]}], ")"}], "\[Equal]", "0"}], ",", 
    "\[Alpha]"}], "]"}], "//", "FullSimplify"}]], "Input",
 CellLabel->"In[65]:=",ExpressionUUID->"b859e630-078d-4328-b564-ff8200bca61b"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"\[Alpha]", "\[Rule]", 
    FractionBox[
     RowBox[{
      SuperscriptBox["F1", "2"], " ", "psi2"}], 
     RowBox[{
      SuperscriptBox["Fs", "2"], "+", 
      RowBox[{
       SuperscriptBox["F1", "2"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "psi2"}], ")"}]}], "+", 
      SuperscriptBox["tau", "2"]}]]}], "}"}], "}"}]], "Output",
 CellChangeTimes->{3.8661297238312597`*^9, 3.867784266358432*^9, 
  3.868217273592731*^9},
 CellLabel->"Out[65]=",ExpressionUUID->"3d626123-81d7-45de-838d-c77d7c1e2936"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{
   RowBox[{
    RowBox[{
    "The", " ", "derivative", " ", "of", " ", "O", " ", "at", " ", "x_L", " ",
      "when", " ", "alpha"}], " ", "=", " ", 
    RowBox[{"0", " ", "<", " ", 
     RowBox[{"alpha_L", " ", "is", " ", "negative"}]}]}], ",", " ", 
   RowBox[{
   "so", " ", "when", " ", "alpha", " ", "goes", " ", "from", " ", "smaller", 
    " ", "than", " ", "alpha_L", " ", "to", " ", "greater", " ", "than", " ", 
    "alpha_L", " ", "the", " ", "derivative", " ", "goes", " ", "from", " ", 
    "negative", " ", "to", " ", "positive"}]}], "*)"}]], "Input",
 CellChangeTimes->{{3.866129792739901*^9, 3.866129825489337*^9}, {
  3.86778427448102*^9, 3.8677843754910593`*^9}, {3.867784431190774*^9, 
  3.867784478697392*^9}, {3.867789290536644*^9, 
  3.867789294189452*^9}},ExpressionUUID->"b2207ab8-88c3-4a98-ad31-\
884ee7b13b19"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{"D", "[", 
     RowBox[{"objective", ",", "chi"}], "]"}], "/.", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"chi", "\[Rule]", 
       RowBox[{"-", "psi1"}]}], ",", 
      RowBox[{"\[Alpha]", "\[Rule]", "0"}]}], "}"}]}], ")"}], "//", 
  "FullSimplify"}]], "Input",
 CellLabel->"In[66]:=",ExpressionUUID->"64ea4316-4206-4643-8156-08c014f03f92"],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SuperscriptBox["F1", "2"], " ", "psi2"}], 
  RowBox[{"psi1", "-", "psi2"}]]], "Output",
 CellChangeTimes->{3.8661298460759087`*^9, 3.868217277745466*^9},
 CellLabel->"Out[66]=",ExpressionUUID->"b7bf5155-0263-40d3-ba3a-7996281bf0c7"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{
   RowBox[{
   "Calculation", " ", "of", " ", "alpha_R", " ", "when", " ", "psi1"}], " ", 
   "<", " ", "1"}], " ", "*)"}]], "Input",
 CellChangeTimes->{{3.8661298587605743`*^9, 3.866129859064128*^9}, {
  3.867788837423464*^9, 3.867788871157741*^9}, {3.869338407204248*^9, 
  3.869338407932638*^9}},ExpressionUUID->"238acc35-7c68-4caa-8d85-\
e1fb8bd84717"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Solve", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"D", "[", 
        RowBox[{"objective", ",", "chi"}], "]"}], "/.", 
       RowBox[{"{", 
        RowBox[{"chi", "\[Rule]", "0"}], "}"}]}], ")"}], "\[Equal]", "0"}], 
    ",", "\[Alpha]"}], "]"}], "//", "FullSimplify"}]], "Input",
 CellLabel->"In[67]:=",ExpressionUUID->"d53e8397-80a4-4c2e-92e5-82aaf31b7f7c"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"\[Alpha]", "\[Rule]", 
    FractionBox[
     RowBox[{
      SuperscriptBox["F1", "2"], " ", "psi2"}], 
     RowBox[{
      SuperscriptBox["Fs", "2"], "+", 
      RowBox[{
       SuperscriptBox["F1", "2"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "-", 
         RowBox[{"4", " ", "psi1"}], "+", 
         RowBox[{"3", " ", "psi2"}]}], ")"}]}], "+", 
      SuperscriptBox["tau", "2"]}]]}], "}"}], "}"}]], "Output",
 CellChangeTimes->{3.866129867074988*^9, 3.8682172817188997`*^9},
 CellLabel->"Out[67]=",ExpressionUUID->"98e92a7a-4df8-4ec2-902b-c5123064e36b"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
     RowBox[{
     "The", " ", "derivative", " ", "of", " ", "O", " ", "at", " ", "x_R", 
      " ", "when", " ", "alpha"}], " ", "=", " ", 
     RowBox[{"0", " ", "<", " ", 
      RowBox[{"alpha_R", " ", "is", " ", "negative"}]}]}], ",", " ", 
    RowBox[{
    "so", " ", "when", " ", "alpha", " ", "goes", " ", "from", " ", "smaller",
      " ", "than", " ", "alpha_R", " ", "to", " ", "greater", " ", "than", 
     " ", "alpha_R", " ", "the", " ", "derivative", " ", "goes", " ", "from", 
     " ", "negative", " ", "to", " ", "positive"}]}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"D", "[", 
      RowBox[{"objective", ",", "chi"}], "]"}], "/.", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"chi", "\[Rule]", "0"}], ",", 
       RowBox[{"\[Alpha]", "\[Rule]", "0"}]}], "}"}]}], ")"}], "//", 
   "FullSimplify"}]}]], "Input",
 CellChangeTimes->{{3.86612988107788*^9, 3.8661298944523373`*^9}, {
  3.867789139874938*^9, 3.867789160776176*^9}, {3.867789296457446*^9, 
  3.867789296939138*^9}},
 CellLabel->"In[68]:=",ExpressionUUID->"7d109c43-0d72-4057-9bcd-0634d8bb7bc1"],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SuperscriptBox["F1", "2"], " ", "psi2"}], 
  RowBox[{"psi1", "-", "psi2"}]]], "Output",
 CellChangeTimes->{3.8661298966686363`*^9, 3.86821728478825*^9},
 CellLabel->"Out[68]=",ExpressionUUID->"48ca190d-8015-458f-9432-d6206a91dd97"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
    "Calculation", " ", "of", " ", "alpha_C", " ", "when", " ", "psi1"}], " ",
     "<", " ", "1"}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"Solve", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"objective", "/.", 
        RowBox[{"{", 
         RowBox[{"chi", "\[Rule]", 
          RowBox[{"-", "psi1"}]}], "}"}]}], ")"}], "==", 
      "\[IndentingNewLine]", 
      RowBox[{"(", 
       RowBox[{"objective", "/.", 
        RowBox[{"{", 
         RowBox[{"chi", "\[Rule]", "0"}], "}"}]}], ")"}]}], ",", "\[Alpha]"}],
     "]"}], "//", "FullSimplify"}]}]], "Input",
 CellChangeTimes->{{3.866129983784257*^9, 3.866129996193472*^9}, 
   3.866130054022498*^9, {3.867789182319181*^9, 3.867789188288418*^9}},
 CellLabel->"In[69]:=",ExpressionUUID->"20f1357f-79cf-47ce-a2bb-2716bf8d1b1b"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"\[Alpha]", "\[Rule]", 
    FractionBox[
     RowBox[{
      SuperscriptBox["F1", "2"], " ", "psi2"}], 
     RowBox[{
      SuperscriptBox["Fs", "2"], "+", 
      RowBox[{
       SuperscriptBox["F1", "2"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "-", 
         RowBox[{"2", " ", "psi1"}], "+", 
         RowBox[{"2", " ", "psi2"}]}], ")"}]}], "+", 
      SuperscriptBox["tau", "2"]}]]}], "}"}], "}"}]], "Output",
 CellChangeTimes->{3.866130006920499*^9, 3.868217288634616*^9},
 CellLabel->"Out[69]=",ExpressionUUID->"5a8fcb9f-1d38-4e0e-90cb-270850aed397"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{
   RowBox[{
    RowBox[{
    "The", " ", "difference", " ", "of", " ", "O", " ", "at", " ", "x_L", "  ",
      "and", " ", "O", " ", "at", " ", "x_R", " ", "when", " ", "alpha"}], 
    " ", "=", " ", 
    RowBox[{"0", " ", "<", " ", 
     RowBox[{"alpha_R", " ", "is", " ", "positive"}]}]}], ",", " ", 
   RowBox[{
   "so", " ", "when", " ", "alpha", " ", "goes", " ", "from", " ", "smaller", 
    " ", "than", " ", "alpha_C", " ", "to", " ", "greater", " ", "than", " ", 
    "alpha_C", " ", "the", " ", "difference", " ", "goes", " ", "from", " ", 
    "positive", " ", "to", " ", "negative"}]}], "*)"}]], "Input",
 CellChangeTimes->{{3.8661300645621634`*^9, 3.866130076490336*^9}, {
  3.8661301089761257`*^9, 3.866130121153516*^9}, {3.867789206832449*^9, 
  3.867789221030662*^9}, {3.867789272880848*^9, 
  3.867789348820335*^9}},ExpressionUUID->"0a17741d-93ea-4d74-a0bd-\
034de473341e"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"(", 
    RowBox[{"objective", "/.", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"chi", "\[Rule]", 
        RowBox[{"-", "psi1"}]}], ",", 
       RowBox[{"\[Alpha]", "\[Rule]", "0"}]}], "}"}]}], ")"}], "-", 
   RowBox[{"(", 
    RowBox[{"objective", "/.", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"chi", "\[Rule]", "0"}], ",", 
       RowBox[{"\[Alpha]", "\[Rule]", "0"}]}], "}"}]}], ")"}]}], "//", 
  "FullSimplify"}]], "Input",
 CellChangeTimes->{3.866130099234562*^9},
 CellLabel->"In[70]:=",ExpressionUUID->"5c3f99ad-1213-4fb1-adc8-7066fa8c0aa1"],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox[
   RowBox[{
    SuperscriptBox["F1", "2"], " ", "psi1", " ", "psi2"}], 
   RowBox[{"psi1", "-", "psi2"}]]}]], "Output",
 CellChangeTimes->{3.866130101638337*^9, 3.868218956734908*^9},
 CellLabel->"Out[70]=",ExpressionUUID->"61aa10fa-144e-49bc-af0c-28583d7c0c24"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{
   RowBox[{
   "Calculation", " ", "of", " ", "alpha_L", " ", "when", " ", "psi1"}], " ", 
   ">=", " ", "1"}], " ", "*)"}]], "Input",
 CellChangeTimes->{{3.866130139908216*^9, 3.86613014472928*^9}, {
  3.867789381287882*^9, 
  3.8677893888104773`*^9}},ExpressionUUID->"4eef40b2-ed87-4b5e-8d03-\
5d5451cab698"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Solve", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"D", "[", 
        RowBox[{"objective", ",", "chi"}], "]"}], "/.", 
       RowBox[{"{", 
        RowBox[{"chi", "\[Rule]", 
         RowBox[{"-", "psi1"}]}], "}"}]}], ")"}], "\[Equal]", "0"}], ",", 
    "\[Alpha]"}], "]"}], "//", "FullSimplify"}]], "Input",
 CellLabel->"In[71]:=",ExpressionUUID->"8afba731-7f19-41bc-826c-dcb11eb9b7ab"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"\[Alpha]", "\[Rule]", 
    FractionBox[
     RowBox[{
      SuperscriptBox["F1", "2"], " ", "psi2"}], 
     RowBox[{
      SuperscriptBox["Fs", "2"], "+", 
      RowBox[{
       SuperscriptBox["F1", "2"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "psi2"}], ")"}]}], "+", 
      SuperscriptBox["tau", "2"]}]]}], "}"}], "}"}]], "Output",
 CellChangeTimes->{3.866130162710685*^9, 3.86821896048374*^9},
 CellLabel->"Out[71]=",ExpressionUUID->"a6fa9fe0-ee2b-4e69-8bbd-4475bcf39135"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{
   RowBox[{
    RowBox[{
    "The", " ", "derivative", " ", "of", " ", "O", " ", "at", " ", "x_L", " ",
      "when", " ", "alpha"}], " ", "=", " ", 
    RowBox[{"0", " ", "<", " ", 
     RowBox[{"alpha_L", " ", "is", " ", "negative"}]}]}], ",", " ", 
   RowBox[{
   "so", " ", "when", " ", "alpha", " ", "goes", " ", "from", " ", "smaller", 
    " ", "than", " ", "alpha_L", " ", "to", " ", "greater", " ", "than", " ", 
    "alpha_L", " ", "the", " ", "derivative", " ", "goes", " ", "from", " ", 
    "negative", " ", "to", " ", "positive"}]}], "*)"}]], "Input",
 CellChangeTimes->{
  3.867789449432939*^9},ExpressionUUID->"b881403c-97b7-499f-98aa-\
c120c21b8f61"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{"D", "[", 
     RowBox[{"objective", ",", "chi"}], "]"}], "/.", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"chi", "\[Rule]", 
       RowBox[{"-", "psi1"}]}], ",", 
      RowBox[{"\[Alpha]", "\[Rule]", "0"}]}], "}"}]}], ")"}], "//", 
  "FullSimplify"}]], "Input",
 CellLabel->"In[70]:=",ExpressionUUID->"ce7c229a-c595-4cea-b638-ba5ae1c2fc70"],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SuperscriptBox["F1", "2"], " ", "psi2"}], 
  RowBox[{"psi1", "-", "psi2"}]]], "Output",
 CellChangeTimes->{3.866130185243478*^9},
 CellLabel->"Out[70]=",ExpressionUUID->"f9d977d3-eee6-411a-a4d8-6b9ddc7aa307"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
    "Calculation", " ", "of", " ", "alpha", " ", "R", " ", "when", " ", 
     "psi1"}], " ", ">=", " ", "1"}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"Solve", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"D", "[", 
         RowBox[{"objective", ",", "chi"}], "]"}], "/.", 
        RowBox[{"{", 
         RowBox[{"chi", "\[Rule]", 
          RowBox[{"1", "-", "psi1"}]}], "}"}]}], ")"}], "\[Equal]", "0"}], 
     ",", "\[Alpha]"}], "]"}], "//", "FullSimplify"}]}]], "Input",
 CellChangeTimes->{{3.866130196621367*^9, 3.866130202355854*^9}, {
  3.867789466798993*^9, 
  3.86778947292686*^9}},ExpressionUUID->"787a627d-06ca-49a4-9f17-\
c7680b280641"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"\[Alpha]", "\[Rule]", 
    FractionBox[
     RowBox[{
      SuperscriptBox["F1", "2"], " ", "psi2"}], 
     RowBox[{
      SuperscriptBox["Fs", "2"], "+", 
      RowBox[{
       SuperscriptBox["F1", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "-", 
         RowBox[{"2", " ", "psi1"}], "+", 
         RowBox[{"3", " ", "psi2"}]}], ")"}]}], "+", 
      SuperscriptBox["tau", "2"]}]]}], "}"}], "}"}]], "Output",
 CellChangeTimes->{3.866130204472707*^9},
 CellLabel->"Out[71]=",ExpressionUUID->"17dcd4dd-6e73-41c5-96a0-ca6e1855a367"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{
   RowBox[{
    RowBox[{
    "The", " ", "derivative", " ", "of", " ", "O", " ", "at", " ", "x_R", " ",
      "when", " ", "alpha"}], " ", "=", " ", 
    RowBox[{"0", " ", "<", " ", 
     RowBox[{"alpha_R", " ", "is", " ", "negative"}]}]}], ",", " ", 
   RowBox[{
   "so", " ", "when", " ", "alpha", " ", "goes", " ", "from", " ", "smaller", 
    " ", "than", " ", "alpha_R", " ", "to", " ", "greater", " ", "than", " ", 
    "alpha_R", " ", "the", " ", "derivative", " ", "goes", " ", "from", " ", 
    "negative", " ", "to", " ", "positive"}]}], "*)"}]], "Input",
 CellChangeTimes->{{3.866130212400043*^9, 3.866130213689598*^9}, {
  3.867789480354621*^9, 
  3.867789499345291*^9}},ExpressionUUID->"c0e8b5f5-3961-4999-8b15-\
fb163bb22c5d"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{"D", "[", 
     RowBox[{"objective", ",", "chi"}], "]"}], "/.", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"chi", "\[Rule]", 
       RowBox[{"1", "-", "psi1"}]}], ",", 
      RowBox[{"\[Alpha]", "\[Rule]", "0"}]}], "}"}]}], ")"}], "//", 
  "FullSimplify"}]], "Input",
 CellLabel->"In[79]:=",ExpressionUUID->"e6824f86-c376-4be4-8594-d6aa9be7a5f9"],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SuperscriptBox["F1", "2"], " ", "psi2"}], 
  RowBox[{"psi1", "-", "psi2"}]]], "Output",
 CellChangeTimes->{3.867789537500784*^9},
 CellLabel->"Out[79]=",ExpressionUUID->"a00fc81f-46bd-496d-a520-f468cdbdd10a"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
    "Calculation", " ", "of", " ", "alpha_C", " ", "when", " ", "psi1"}], " ",
     ">=", " ", "1"}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"Solve", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"objective", "/.", 
        RowBox[{"{", 
         RowBox[{"chi", "\[Rule]", 
          RowBox[{"-", "psi1"}]}], "}"}]}], ")"}], "==", 
      "\[IndentingNewLine]", 
      RowBox[{"(", 
       RowBox[{"objective", "/.", 
        RowBox[{"{", 
         RowBox[{"chi", "\[Rule]", 
          RowBox[{"1", "-", "psi1"}]}], "}"}]}], ")"}]}], ",", "\[Alpha]"}], 
    "]"}], "//", "FullSimplify"}]}]], "Input",
 CellChangeTimes->{{3.867789533846006*^9, 
  3.867789577315508*^9}},ExpressionUUID->"843d8962-b036-4b13-9a92-\
9497bf22180e"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"\[Alpha]", "\[Rule]", 
    FractionBox[
     RowBox[{
      SuperscriptBox["F1", "2"], " ", "psi2"}], 
     RowBox[{
      SuperscriptBox["Fs", "2"], "-", 
      RowBox[{
       SuperscriptBox["F1", "2"], " ", 
       RowBox[{"(", 
        RowBox[{"psi1", "-", 
         RowBox[{"2", " ", "psi2"}]}], ")"}]}], "+", 
      SuperscriptBox["tau", "2"]}]]}], "}"}], "}"}]], "Output",
 CellChangeTimes->{3.867789555332861*^9},
 CellLabel->"Out[80]=",ExpressionUUID->"63ad53b2-68d7-47df-a759-f2d96e74aecf"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
     RowBox[{
     "The", " ", "difference", " ", "of", " ", "O", " ", "at", " ", "x_L", "  ",
       "and", " ", "O", " ", "at", " ", "x_R", " ", "when", " ", "alpha"}], 
     " ", "=", " ", 
     RowBox[{"0", " ", "<", " ", 
      RowBox[{"alpha_R", " ", "is", " ", "positive"}]}]}], ",", " ", 
    RowBox[{
    "so", " ", "when", " ", "alpha", " ", "goes", " ", "from", " ", "smaller",
      " ", "than", " ", "alpha_C", " ", "to", " ", "greater", " ", "than", 
     " ", "alpha_C", " ", "the", " ", "difference", " ", "goes", " ", "from", 
     " ", "positive", " ", "to", " ", "negative"}]}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{"objective", "/.", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"chi", "\[Rule]", 
         RowBox[{"-", "psi1"}]}], ",", 
        RowBox[{"\[Alpha]", "\[Rule]", "0"}]}], "}"}]}], ")"}], "-", 
    RowBox[{"(", 
     RowBox[{"objective", "/.", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"chi", "\[Rule]", 
         RowBox[{"1", "-", "psi1"}]}], ",", 
        RowBox[{"\[Alpha]", "\[Rule]", "0"}]}], "}"}]}], ")"}]}], "//", 
   "FullSimplify"}]}]], "Input",
 CellChangeTimes->{{3.867789581642929*^9, 3.867789616365233*^9}},
 CellLabel->"In[81]:=",ExpressionUUID->"d65b89e3-bbd4-460e-979b-d9ae268aef9a"],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox[
   RowBox[{
    SuperscriptBox["F1", "2"], " ", "psi2"}], 
   RowBox[{"psi1", "-", "psi2"}]]}]], "Output",
 CellChangeTimes->{3.867789619370618*^9},
 CellLabel->"Out[81]=",ExpressionUUID->"88bcf52b-f148-4225-b27e-89a9a01e133c"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
    "Plot", " ", "to", " ", "Show", " ", "the", " ", "relationship", " ", 
     "among", " ", "alpha_L"}], ",", " ", "alpha_R", ",", " ", 
    RowBox[{"and", " ", "alpha_C"}]}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
     RowBox[{"when", " ", "psi1"}], " ", "<", " ", "1"}], ",", " ", 
    RowBox[{
     RowBox[{
      RowBox[{"Show", " ", "that", " ", 
       RowBox[{"1", "/", "alpha_L"}]}], " ", "<", " ", 
      RowBox[{"1", "/", "alpha_R"}]}], " ", "\[Rule]", " ", 
     RowBox[{"alpha_L", " ", ">", " ", 
      RowBox[{"alpha_R", " ", "when", " ", "psi2"}], " ", ">", " ", 
      RowBox[{"2", "psi1", " ", "and", " ", "vice", " ", "versa"}]}]}]}], " ",
    "*)"}], "\[IndentingNewLine]", 
  RowBox[{"Solve", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "+", "psi2"}], ")"}], " ", "-", " ", 
      RowBox[{"(", 
       RowBox[{"1", "-", 
        RowBox[{"4", " ", "psi1"}], "+", 
        RowBox[{"3", " ", "psi2"}]}], ")"}]}], "\[Equal]", "0"}], ",", " ", 
    "psi2"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.8661302794554996`*^9, 3.866130321584098*^9}, {
  3.866130370784151*^9, 3.866130403474102*^9}, {3.866130509267297*^9, 
  3.8661305133310347`*^9}, {3.8693177646456547`*^9, 3.86931786784671*^9}, {
  3.869319765304824*^9, 3.8693198526622763`*^9}, {3.869319899723675*^9, 
  3.869319959302322*^9}, {3.8693387865171432`*^9, 
  3.869338787286515*^9}},ExpressionUUID->"e683acda-9a1e-40d4-bf10-\
af1cf02a5218"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"psi2", "\[Rule]", 
    RowBox[{"2", " ", "psi1"}]}], "}"}], "}"}]], "Output",
 CellChangeTimes->{3.8693178709999104`*^9},
 CellLabel->"Out[5]=",ExpressionUUID->"d5619d0e-ec80-4659-9ff8-af76cc955e85"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"D", "[", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "+", "psi2"}], ")"}], " ", "-", " ", 
      RowBox[{"(", 
       RowBox[{"1", "-", 
        RowBox[{"4", " ", "psi1"}], "+", 
        RowBox[{"3", " ", "psi2"}]}], ")"}]}], ")"}], ",", " ", "psi2"}], 
   "]"}], "//", "FullSimplify"}]], "Input",
 CellChangeTimes->{{3.869318039823286*^9, 3.869318058611442*^9}},
 CellLabel->"In[7]:=",ExpressionUUID->"7189e4bd-8c6e-4599-a414-a65b96152216"],

Cell[BoxData[
 RowBox[{"-", "2"}]], "Output",
 CellChangeTimes->{3.869318060845152*^9},
 CellLabel->"Out[7]=",ExpressionUUID->"7db76eca-c302-4a63-8765-24671b09e6d6"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{
   RowBox[{
    RowBox[{"when", " ", "psi1"}], " ", "<", " ", "1"}], ",", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"Show", " ", "that", " ", 
      RowBox[{"1", "/", "alpha_C"}]}], " ", ">", " ", 
     RowBox[{"1", "/", "alpha_L"}]}], " ", "\[Rule]", " ", 
    RowBox[{"alpha_L", " ", ">", " ", 
     RowBox[{"alpha_C", " ", "when", " ", "psi2"}], " ", ">", " ", 
     RowBox[{"2", "psi1", " ", "and", " ", "vice", " ", "versa"}]}]}]}], " ", 
  "*)"}]], "Input",
 CellChangeTimes->{{3.869320956302122*^9, 3.869320964885353*^9}, {
  3.869321134652431*^9, 3.8693211550624237`*^9}, {3.8693387908145723`*^9, 
  3.869338791339478*^9}},ExpressionUUID->"99c3bc22-3121-4a9b-b847-\
b0af9b662383"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{"1", "-", 
    RowBox[{"2", " ", "psi1"}], "+", 
    RowBox[{"2", " ", "psi2"}]}], ")"}], "-", 
  RowBox[{"(", 
   RowBox[{"1", "+", "psi2"}], ")"}]}]], "Input",
 CellChangeTimes->{{3.8693199961674747`*^9, 3.8693200005142403`*^9}, {
  3.869320219664742*^9, 3.869320219798727*^9}, {3.869320250668021*^9, 
  3.869320305885543*^9}},
 CellLabel->"In[9]:=",ExpressionUUID->"2a9c36c4-9d0a-4517-b5fe-67c4182c1b92"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"-", "2"}], " ", "psi1"}], "+", "psi2"}]], "Output",
 CellChangeTimes->{3.869320311321289*^9},
 CellLabel->"Out[9]=",ExpressionUUID->"861dfd95-750f-43b9-af6b-4f6e8a1924a0"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{
   RowBox[{
    RowBox[{"when", " ", "psi1"}], " ", "<", " ", "1"}], ",", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"Show", " ", "that", " ", 
      RowBox[{"1", "/", "alpha_R"}]}], " ", ">", " ", 
     RowBox[{"1", "/", "alpha_C"}]}], " ", "\[Rule]", " ", 
    RowBox[{"alpha_C", " ", ">", " ", 
     RowBox[{"alpha_R", " ", "when", " ", "psi2"}], " ", ">", " ", 
     RowBox[{"2", "psi1", " ", "and", " ", "vice", " ", "versa"}]}]}]}], " ", 
  "*)"}]], "Input",
 CellChangeTimes->{{3.869320982437799*^9, 3.869321002929048*^9}, {
  3.869321172395743*^9, 3.8693211740641127`*^9}, {3.869321846957386*^9, 
  3.8693218566027937`*^9}, {3.869338794106399*^9, 
  3.869338794567363*^9}},ExpressionUUID->"6d170436-9d64-459a-8878-\
ed5524720b66"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{"1", "-", 
    RowBox[{"4", " ", "psi1"}], "+", 
    RowBox[{"3", " ", "psi2"}]}], ")"}], "-", 
  RowBox[{"(", 
   RowBox[{"1", "-", 
    RowBox[{"2", " ", "psi1"}], "+", 
    RowBox[{"2", " ", "psi2"}]}], ")"}]}]], "Input",
 CellChangeTimes->{{3.8693203463588247`*^9, 3.86932035723503*^9}},
 CellLabel->"In[10]:=",ExpressionUUID->"f00fb579-60df-4005-ab92-ffb82f548783"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"-", "2"}], " ", "psi1"}], "+", "psi2"}]], "Output",
 CellChangeTimes->{3.869320359426906*^9},
 CellLabel->"Out[10]=",ExpressionUUID->"f5258800-c036-4254-a4a5-5c09cc4180e3"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{
   RowBox[{
    RowBox[{"when", " ", "psi1"}], " ", "\[GreaterEqual]", " ", "1"}], ",", 
   " ", 
   RowBox[{
    RowBox[{
     RowBox[{"Show", " ", "that", " ", 
      RowBox[{"1", "/", "alpha_L"}]}], " ", "<", " ", 
     RowBox[{"1", "/", "alpha_R"}]}], " ", "\[Rule]", " ", 
    RowBox[{"alpha_L", " ", ">", " ", 
     RowBox[{"alpha_R", " ", "when", " ", "psi2"}], " ", ">", " ", 
     RowBox[{"1", "+", 
      RowBox[{"psi1", " ", "and", " ", "vice", " ", "versa"}]}]}]}]}], " ", 
  "*)"}]], "Input",
 CellChangeTimes->{{3.869319966031062*^9, 3.869319981538651*^9}, {
  3.869320966639308*^9, 3.869320968319623*^9}, {3.869338796357658*^9, 
  3.869338796806376*^9}},ExpressionUUID->"759e6576-eee7-465f-863d-\
1256d86b429f"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"1", "+", "psi2"}], ")"}], " ", "-", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "-", 
       RowBox[{"2", " ", "psi1"}], "+", 
       RowBox[{"3", " ", "psi2"}]}], ")"}]}], "\[Equal]", "0"}], ",", " ", 
   "psi2"}], "]"}]], "Input",
 CellChangeTimes->{{3.869317918373987*^9, 3.8693179189641438`*^9}},
 CellLabel->"In[6]:=",ExpressionUUID->"5b0022f3-cdb3-4de7-9ef1-8ab6685f3cb1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"psi2", "\[Rule]", 
    RowBox[{"1", "+", "psi1"}]}], "}"}], "}"}]], "Output",
 CellChangeTimes->{3.8693179223508043`*^9},
 CellLabel->"Out[6]=",ExpressionUUID->"acc59d6f-e9ac-40cc-a39d-cd620debf6a1"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"D", "[", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "+", "psi2"}], ")"}], " ", "-", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "-", 
        RowBox[{"2", " ", "psi1"}], "+", 
        RowBox[{"3", " ", "psi2"}]}], ")"}]}], ")"}], ",", " ", "psi2"}], 
   "]"}], "//", "FullSimplify"}]], "Input",
 CellChangeTimes->{{3.869318082009815*^9, 3.869318082549679*^9}},
 CellLabel->"In[8]:=",ExpressionUUID->"44dbdfb7-adcf-4e74-a5e6-30edf4740057"],

Cell[BoxData[
 RowBox[{"-", "2"}]], "Output",
 CellChangeTimes->{3.8693180855047207`*^9},
 CellLabel->"Out[8]=",ExpressionUUID->"8f8fe75b-5daf-4941-914a-34ec2bfd9929"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{
   RowBox[{
    RowBox[{"when", " ", "psi1"}], " ", "<", " ", "1"}], ",", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"Show", " ", "that", " ", 
      RowBox[{"1", "/", "alpha_C"}]}], " ", ">", " ", 
     RowBox[{"1", "/", "alpha_L"}]}], " ", "\[Rule]", " ", 
    RowBox[{"alpha_L", " ", ">", " ", 
     RowBox[{"alpha_C", " ", "when", " ", "psi2"}], " ", ">", " ", 
     RowBox[{"1", "+", 
      RowBox[{"psi1", " ", "and", " ", "vice", " ", "versa"}]}]}]}]}], " ", 
  "*)"}]], "Input",
 CellChangeTimes->{{3.869321535435902*^9, 3.8693215364794893`*^9}, {
  3.869338798851795*^9, 
  3.869338799362937*^9}},ExpressionUUID->"e6487472-c95c-46fb-bf96-\
5d5aa4d8d7d0"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{"-", " ", "psi1"}], "+", 
    RowBox[{"2", " ", "psi2"}]}], ")"}], "-", 
  RowBox[{"(", 
   RowBox[{"1", "+", "psi2"}], ")"}]}]], "Input",
 CellChangeTimes->{{3.869321468129401*^9, 3.8693214931161747`*^9}},
 CellLabel->"In[11]:=",ExpressionUUID->"2a963476-056e-4aaf-b14b-6c1c37f1f21d"],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "1"}], "-", "psi1", "+", "psi2"}]], "Output",
 CellChangeTimes->{3.869321508718279*^9},
 CellLabel->"Out[11]=",ExpressionUUID->"935c676b-87f9-4080-bda9-d2fb59e0a363"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{
   RowBox[{
    RowBox[{"when", " ", "psi1"}], " ", "\[GreaterEqual]", " ", "1"}], ",", 
   " ", 
   RowBox[{
    RowBox[{
     RowBox[{"Show", " ", "that", " ", 
      RowBox[{"1", "/", "alpha_R"}]}], " ", ">", " ", 
     RowBox[{"1", "/", "alpha_C"}]}], " ", "\[Rule]", " ", 
    RowBox[{"alpha_R", " ", "<", " ", 
     RowBox[{"alpha_C", " ", "when", " ", "psi2"}], " ", ">", " ", 
     RowBox[{"1", "+", 
      RowBox[{"psi1", " ", "and", " ", "vice", " ", "versa"}]}]}]}]}], " ", 
  "*)"}]], "Input",
 CellChangeTimes->{{3.869321579144565*^9, 3.8693216237088757`*^9}, {
  3.869321832122505*^9, 3.869321835922278*^9}, {3.869338801330905*^9, 
  3.869338801746256*^9}},ExpressionUUID->"82242bb5-d357-4703-ab17-\
5ca2150778b9"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{"-", "1"}], "-", 
    RowBox[{"2", " ", "psi1"}], "+", 
    RowBox[{"3", " ", "psi2"}]}], ")"}], " ", "-", " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"-", " ", "psi1"}], "+", 
    RowBox[{"2", " ", "psi2"}]}], ")"}]}]], "Input",
 CellChangeTimes->{{3.869321656834877*^9, 3.869321672705559*^9}},
 CellLabel->"In[12]:=",ExpressionUUID->"9ebf9ea7-7a89-483a-a191-afac2c09ee83"],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "1"}], "-", "psi1", "+", "psi2"}]], "Output",
 CellChangeTimes->{3.869321675946179*^9},
 CellLabel->"Out[12]=",ExpressionUUID->"e2dce1a7-afe6-4180-844e-1202d84271dd"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{
   RowBox[{
    RowBox[{"when", " ", "psi1"}], " ", "<", " ", "1"}], ",", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"Show", " ", "that", " ", 
      RowBox[{"1", "/", "alpha_C"}]}], " ", "\[LessEqual]", " ", 
     RowBox[{"1", "/", "alpha_R"}]}], " ", "\[Rule]", " ", 
    RowBox[{"alpha_C", " ", "\[GreaterEqual]", " ", 
     RowBox[{"alpha_R", " ", "when", " ", "psi2"}], " ", "\[GreaterEqual]", 
     " ", 
     RowBox[{"beta_", "1"}]}]}]}], " ", "*)"}]], "Input",
 CellChangeTimes->{{3.869338065672917*^9, 3.86933806916921*^9}, {
  3.869338387990793*^9, 3.869338401017631*^9}, {3.86933849199763*^9, 
  3.869338532144856*^9}, {3.869338804963649*^9, 3.869338817875453*^9}, {
  3.869341083318946*^9, 
  3.869341083585084*^9}},ExpressionUUID->"75029fca-9c12-4ac9-ba7a-\
680593ad2f40"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Maximize", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "-", 
        RowBox[{"2", " ", "psi1"}], "+", 
        RowBox[{"2", " ", "psi2"}]}], ")"}], "-", 
      RowBox[{"(", 
       RowBox[{"1", "-", 
        RowBox[{"4", " ", "psi1"}], "+", 
        RowBox[{"3", " ", "psi2"}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"psi2", ">=", 
       FractionBox[
        RowBox[{"8", "-", 
         RowBox[{"8", " ", 
          SqrtBox[
           RowBox[{"1", "-", "psi1"}]]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "4"}], "+", "psi1"}], ")"}], " ", "psi1"}]}], 
        "psi1"]}], "&&", 
      RowBox[{"psi1", "\[LessEqual]", "1"}], "&&", 
      RowBox[{"psi1", "\[GreaterEqual]", "0"}], "&&", 
      RowBox[{"psi2", "\[GreaterEqual]", "psi1"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"psi1", ",", "psi2"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.869339536137341*^9, 3.869339537020378*^9}},
 CellLabel->"In[18]:=",ExpressionUUID->"83e6f954-df32-4300-b418-51f3c359163c"],

Cell[BoxData[
 TemplateBox[{
  "Maximize", "wksol", 
   "\"Warning: there is no maximum in the region in which the objective \
function is defined and the constraints are satisfied; a result on the \
boundary will be returned.\"", 2, 18, 6, 16469725684033471525, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.8693380429555063`*^9, 3.869339605075001*^9},
 CellLabel->
  "During evaluation of \
In[18]:=",ExpressionUUID->"3c7ac794-1679-44c0-8cf0-c350fe925bdc"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"psi1", "\[Rule]", "0"}], ",", 
     RowBox[{"psi2", "\[Rule]", "0"}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.869338042968417*^9, 3.869339605080688*^9},
 CellLabel->"Out[18]=",ExpressionUUID->"0f055e25-2fbb-403c-bcaa-ef2cf4694cad"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{
   RowBox[{
    RowBox[{"when", " ", "psi1"}], " ", "<", " ", "1"}], ",", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"Show", " ", "that", " ", 
      RowBox[{"1", "/", "alpha_C"}]}], " ", "\[GreaterEqual]", " ", 
     RowBox[{"1", "/", "alpha_L"}]}], " ", "\[Rule]", " ", 
    RowBox[{"alpha_C", " ", "\[LessEqual]", " ", 
     RowBox[{"alpha", " ", "L", " ", "when", " ", "psi2"}], " ", 
     "\[GreaterEqual]", " ", 
     RowBox[{"beta_", "1"}]}]}]}], " ", "*)"}]], "Input",
 CellChangeTimes->{{3.8693385720379887`*^9, 3.8693385728492947`*^9}, {
  3.869338762661236*^9, 3.869338777063054*^9}, {3.869338819749411*^9, 
  3.869338820528408*^9}, {3.869341086215567*^9, 
  3.869341086385666*^9}},ExpressionUUID->"78a26b7a-98f9-4192-98f2-\
74a47d0e0864"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Minimize", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "-", 
        RowBox[{"2", " ", "psi1"}], "+", 
        RowBox[{"2", " ", "psi2"}]}], ")"}], "-", 
      RowBox[{"(", 
       RowBox[{"1", "+", "psi2"}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"psi2", ">=", 
       FractionBox[
        RowBox[{"8", "-", 
         RowBox[{"8", " ", 
          SqrtBox[
           RowBox[{"1", "-", "psi1"}]]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "4"}], "+", "psi1"}], ")"}], " ", "psi1"}]}], 
        "psi1"]}], "&&", 
      RowBox[{"psi1", "\[LessEqual]", "1"}], "&&", 
      RowBox[{"psi1", "\[GreaterEqual]", "0"}], "&&", 
      RowBox[{"psi2", "\[GreaterEqual]", "psi1"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"psi1", ",", "psi2"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.869338717486199*^9, 3.869338744710984*^9}, {
  3.869339598625827*^9, 3.869339600939352*^9}},
 CellLabel->"In[19]:=",ExpressionUUID->"6db7c3e6-2314-4155-aae4-c1d025eba59c"],

Cell[BoxData[
 TemplateBox[{
  "Minimize", "wksol", 
   "\"Warning: there is no minimum in the region in which the objective \
function is defined and the constraints are satisfied; returning a result on \
the boundary.\"", 2, 19, 7, 16469725684033471525, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{{3.8693387382376966`*^9, 3.869338747503141*^9}, 
   3.8693396081103888`*^9},
 CellLabel->
  "During evaluation of \
In[19]:=",ExpressionUUID->"e664497f-1284-4d40-b534-5e768f0f29e2"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"psi1", "\[Rule]", "0"}], ",", 
     RowBox[{"psi2", "\[Rule]", "0"}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.869338738248146*^9, 3.869338747508954*^9}, 
   3.869339608117289*^9},
 CellLabel->"Out[19]=",ExpressionUUID->"e3609bb4-021f-4152-a2d7-1edc10c3ea3e"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{
   RowBox[{
    RowBox[{"when", " ", "psi1"}], " ", "\[GreaterEqual]", " ", "1"}], ",", 
   " ", 
   RowBox[{
    RowBox[{
     RowBox[{"Show", " ", "that", " ", 
      RowBox[{"1", "/", "alpha_C"}]}], " ", "\[LessEqual]", " ", 
     RowBox[{"1", "/", "alpha_R"}]}], " ", "\[Rule]", " ", 
    RowBox[{"alpha_C", " ", "\[GreaterEqual]", " ", 
     RowBox[{"alpha_R", " ", "when", " ", "psi2"}], " ", "\[GreaterEqual]", 
     " ", 
     RowBox[{"beta_", "1"}]}]}]}], " ", "*)"}]], "Input",
 CellChangeTimes->{{3.869338924839402*^9, 3.869338926876574*^9}, {
  3.869341088901581*^9, 
  3.8693410890675087`*^9}},ExpressionUUID->"024ff94d-c674-4fc0-ac83-\
9eb0040f948b"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Maximize", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", " ", "psi1"}], "+", 
        RowBox[{"2", " ", "psi2"}]}], ")"}], "-", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "-", 
        RowBox[{"2", " ", "psi1"}], "+", 
        RowBox[{"3", " ", "psi2"}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"psi2", ">=", 
       RowBox[{"psi1", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "3"}], "-", 
          RowBox[{"8", " ", 
           SqrtBox[
            RowBox[{
             RowBox[{"-", "1"}], "+", "psi1"}]], " ", 
           SqrtBox["psi1"]}], "+", 
          RowBox[{"8", " ", "psi1"}]}], ")"}]}]}], "&&", 
      RowBox[{"psi1", ">=", "1"}], "&&", 
      RowBox[{"psi2", "\[GreaterEqual]", "psi1"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"psi1", ",", "psi2"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.8693389673910513`*^9, 3.869338977770996*^9}, {
   3.8693390131971617`*^9, 3.869339043111992*^9}, 3.869339613726988*^9},
 CellLabel->"In[20]:=",ExpressionUUID->"654bdb5a-7911-4207-be21-696c2a5b61d2"],

Cell[BoxData[
 TemplateBox[{
  "Maximize", "natt", 
   "\"The maximum is not attained at any point satisfying the given \
constraints. \"", 2, 20, 8, 16469725684033471525, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.869339052237936*^9, 3.869339617363151*^9},
 CellLabel->
  "During evaluation of \
In[20]:=",ExpressionUUID->"5d8eee3f-2a00-4426-8f7d-13e9c347fca2"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"psi1", "\[Rule]", "Indeterminate"}], ",", 
     RowBox[{"psi2", "\[Rule]", "Indeterminate"}]}], "}"}]}], "}"}]], "Output",\

 CellChangeTimes->{3.869339052246089*^9, 3.869339617368423*^9},
 CellLabel->"Out[20]=",ExpressionUUID->"15bff46a-64e3-4c77-86f4-16c44c507d49"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{
   RowBox[{
    RowBox[{"when", " ", "psi1"}], " ", "\[GreaterEqual]", "  ", "1"}], ",", 
   " ", 
   RowBox[{
    RowBox[{
     RowBox[{"Show", " ", "that", " ", 
      RowBox[{"1", "/", "alpha_C"}]}], " ", "\[GreaterEqual]", " ", 
     RowBox[{"1", "/", "alpha_L"}]}], " ", "\[Rule]", " ", 
    RowBox[{"alpha_C", " ", "\[LessEqual]", " ", 
     RowBox[{"alpha", " ", "L", " ", "when", " ", "psi2"}], " ", 
     "\[GreaterEqual]", " ", 
     RowBox[{"beta_", "1"}]}]}]}], " ", "*)"}]], "Input",
 CellChangeTimes->{{3.869339077019273*^9, 3.869339081038013*^9}, {
  3.8693410920126467`*^9, 
  3.8693410922556057`*^9}},ExpressionUUID->"7923be57-8a86-4a5f-9ad6-\
4346c097f58f"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Minimize", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", " ", "psi1"}], "+", 
        RowBox[{"2", " ", "psi2"}]}], ")"}], "-", 
      RowBox[{"(", 
       RowBox[{"1", "+", "psi2"}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"psi2", ">=", 
       RowBox[{"psi1", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "3"}], "-", 
          RowBox[{"8", " ", 
           SqrtBox[
            RowBox[{
             RowBox[{"-", "1"}], "+", "psi1"}]], " ", 
           SqrtBox["psi1"]}], "+", 
          RowBox[{"8", " ", "psi1"}]}], ")"}]}]}], "&&", 
      RowBox[{"psi1", ">=", "1"}], "&&", 
      RowBox[{"psi2", "\[GreaterEqual]", "psi1"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"psi1", ",", "psi2"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.869339096668911*^9, 3.8693391167608433`*^9}, 
   3.869339622055318*^9},
 CellLabel->"In[21]:=",ExpressionUUID->"3f6d601c-2594-447c-b231-2b51791e2b36"],

Cell[BoxData[
 TemplateBox[{
  "Minimize", "natt", 
   "\"The minimum is not attained at any point satisfying the given \
constraints.\"", 2, 21, 9, 16469725684033471525, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.869339124818241*^9, 3.8693396245711107`*^9},
 CellLabel->
  "During evaluation of \
In[21]:=",ExpressionUUID->"5ffa0520-f4b1-4a15-8017-7f511ca3895c"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"psi1", "\[Rule]", "Indeterminate"}], ",", 
     RowBox[{"psi2", "\[Rule]", "Indeterminate"}]}], "}"}]}], "}"}]], "Output",\

 CellChangeTimes->{3.869339124825972*^9, 3.869339624575886*^9},
 CellLabel->"Out[21]=",ExpressionUUID->"9fcceb56-255f-4bef-ad0d-a09166d185ab"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{
   RowBox[{
    RowBox[{"when", " ", "psi1"}], " ", "<", " ", "1"}], ",", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"Show", " ", "that", " ", 
      RowBox[{"1", "/", "alpha_C"}]}], " ", "\[GreaterEqual]", " ", 
     RowBox[{"1", "/", "alpha_R"}]}], " ", "\[Rule]", " ", 
    RowBox[{"alpha_C", " ", "\[LessEqual]", "  ", 
     RowBox[{"alpha_R", " ", "when", " ", "beta_", "2"}], " ", 
     "\[GreaterEqual]", " ", "psi2", " ", "\[GreaterEqual]", " ", 
     RowBox[{"beta_", "3"}]}]}]}], "  ", "*)"}]], "Input",
 CellChangeTimes->{{3.869338065672917*^9, 3.86933806916921*^9}, {
  3.869338387990793*^9, 3.869338401017631*^9}, {3.86933849199763*^9, 
  3.869338532144856*^9}, {3.869338804963649*^9, 3.869338817875453*^9}, {
  3.869341073058743*^9, 3.869341109407817*^9}, {3.869342639962832*^9, 
  3.869342643170868*^9}, {3.869343024875881*^9, 
  3.8693430309965897`*^9}},ExpressionUUID->"64cd3b0b-e73d-4a02-a637-\
16690203c3f3"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Minimize", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "-", 
        RowBox[{"2", " ", "psi1"}], "+", 
        RowBox[{"2", " ", "psi2"}]}], ")"}], "-", 
      RowBox[{"(", 
       RowBox[{"1", "-", 
        RowBox[{"4", " ", "psi1"}], "+", 
        RowBox[{"3", " ", "psi2"}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"-", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "2"}], "+", "psi1"}], ")"}]}], " ", "psi1"}], 
       "\[LessEqual]", " ", "psi2", "\[LessEqual]", " ", 
       FractionBox[
        RowBox[{"psi1", " ", 
         RowBox[{"(", 
          RowBox[{"2", "+", "psi1"}], ")"}]}], 
        RowBox[{"1", "+", "psi1"}]]}], "&&", 
      RowBox[{"psi1", "\[LessEqual]", "1"}], "&&", 
      RowBox[{"psi1", "\[GreaterEqual]", "0"}], "&&", 
      RowBox[{"psi2", "\[GreaterEqual]", "psi1"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"psi1", ",", "psi2"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.869339536137341*^9, 3.869339537020378*^9}, {
  3.86934114753758*^9, 3.869341149798815*^9}, {3.869341516404428*^9, 
  3.869341542798565*^9}, {3.869341586847829*^9, 3.8693416024919157`*^9}, {
  3.869342659738112*^9, 3.869342683707329*^9}, {3.869343133310656*^9, 
  3.869343164054289*^9}},
 CellLabel->"In[31]:=",ExpressionUUID->"6d9b57ce-c92f-4f42-98f5-bd083db53aba"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"psi1", "\[Rule]", "0"}], ",", 
     RowBox[{"psi2", "\[Rule]", "0"}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.869338042968417*^9, 3.869339605080688*^9, 3.8693414586851807`*^9, 
   3.8693415219984617`*^9, {3.869341593669079*^9, 3.869341604837596*^9}, 
   3.8693426887152853`*^9, {3.869343138288622*^9, 3.8693431667777653`*^9}},
 CellLabel->"Out[31]=",ExpressionUUID->"7c5f9ce3-2fd8-46a7-a5e1-f45b409996ba"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{
   RowBox[{
    RowBox[{"when", " ", "psi1"}], " ", "<", " ", "1"}], ",", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"Show", " ", "that", " ", 
      RowBox[{"1", "/", "alpha_C"}]}], " ", "\[LessEqual]", " ", 
     RowBox[{"1", "/", "alpha_L"}]}], " ", "\[Rule]", " ", 
    RowBox[{"alpha_C", " ", "\[GreaterEqual]", " ", 
     RowBox[{"alpha", " ", "L", " ", "when", " ", "beta_", "2"}], " ", 
     "\[GreaterEqual]", " ", "psi2", " ", "\[GreaterEqual]", " ", 
     RowBox[{"beta_", "3"}]}]}]}], " ", "*)"}]], "Input",
 CellChangeTimes->{{3.8693385720379887`*^9, 3.8693385728492947`*^9}, {
  3.869338762661236*^9, 3.869338777063054*^9}, {3.869338819749411*^9, 
  3.869338820528408*^9}, {3.869341116456341*^9, 3.8693411298578777`*^9}, {
  3.869342779039583*^9, 3.869342780875321*^9}, {3.8693430448092737`*^9, 
  3.869343054573244*^9}, {3.869343389319001*^9, 
  3.869343389504903*^9}},ExpressionUUID->"a5151fb7-bb23-4f37-91be-\
47fbc3c1359e"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Maximize", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "-", 
        RowBox[{"2", " ", "psi1"}], "+", 
        RowBox[{"2", " ", "psi2"}]}], ")"}], "-", 
      RowBox[{"(", 
       RowBox[{"1", "+", "psi2"}], ")"}]}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"-", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "2"}], "+", "psi1"}], ")"}]}], " ", "psi1"}], 
       "\[LessEqual]", " ", "psi2", "\[LessEqual]", " ", 
       FractionBox[
        RowBox[{"psi1", " ", 
         RowBox[{"(", 
          RowBox[{"2", "+", "psi1"}], ")"}]}], 
        RowBox[{"1", "+", "psi1"}]]}], "&&", 
      RowBox[{"psi1", "\[LessEqual]", "1"}], "&&", 
      RowBox[{"psi1", "\[GreaterEqual]", "0"}], "&&", 
      RowBox[{"psi2", "\[GreaterEqual]", "psi1"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"psi1", ",", "psi2"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.869338717486199*^9, 3.869338744710984*^9}, {
  3.869339598625827*^9, 3.869339600939352*^9}, {3.8693411567674217`*^9, 
  3.869341160335251*^9}, {3.869342754740163*^9, 3.8693427666255703`*^9}, {
  3.869343174164968*^9, 3.86934318605205*^9}},
 CellLabel->"In[33]:=",ExpressionUUID->"b29301f8-39a8-42e9-9c15-ddcd1632df2c"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"psi1", "\[Rule]", "0"}], ",", 
     RowBox[{"psi2", "\[Rule]", "0"}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.869338738248146*^9, 3.869338747508954*^9}, 
   3.869339608117289*^9, {3.86934276108926*^9, 3.8693427701346273`*^9}, {
   3.869343179459545*^9, 3.869343189336047*^9}},
 CellLabel->"Out[33]=",ExpressionUUID->"518f1e99-5571-4bea-af3c-284a460f8763"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{
   RowBox[{
    RowBox[{"when", " ", "psi1"}], " ", "\[GreaterEqual]", " ", "1"}], ",", 
   " ", 
   RowBox[{
    RowBox[{
     RowBox[{"Show", " ", "that", " ", 
      RowBox[{"1", "/", "alpha_C"}]}], " ", "\[LessEqual]", " ", 
     RowBox[{"1", "/", "alpha_R"}]}], " ", "\[Rule]", " ", 
    RowBox[{"alpha_C", " ", "\[GreaterEqual]", " ", 
     RowBox[{"alpha_R", " ", "when", " ", "beta_", "2"}], " ", 
     "\[GreaterEqual]", " ", "psi2", " ", "\[GreaterEqual]", " ", 
     RowBox[{"beta_", "3"}]}]}]}], " ", " ", "*)"}]], "Input",
 CellChangeTimes->{
  3.869343385175705*^9},ExpressionUUID->"e63ae26b-e228-4eeb-ba96-\
e66307975300"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Minimize", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", " ", "psi1"}], "+", 
        RowBox[{"2", " ", "psi2"}]}], ")"}], "-", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "-", 
        RowBox[{"2", " ", "psi1"}], "+", 
        RowBox[{"3", " ", "psi2"}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"1", "-", 
        FractionBox["1", "psi1"], "+", "psi1"}], "\[LessEqual]", " ", "psi2", 
       "\[LessEqual]", " ", 
       FractionBox[
        RowBox[{"psi1", " ", 
         RowBox[{"(", 
          RowBox[{"2", "+", "psi1"}], ")"}]}], 
        RowBox[{"1", "+", "psi1"}]]}], "&&", 
      RowBox[{"psi1", ">=", "1"}], "&&", 
      RowBox[{"psi2", "\[GreaterEqual]", "psi1"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"psi1", ",", "psi2"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.8693389673910513`*^9, 3.869338977770996*^9}, {
   3.8693390131971617`*^9, 3.869339043111992*^9}, 3.869339613726988*^9, {
   3.869343267594077*^9, 3.869343278442527*^9}, 3.86934336754275*^9, {
   3.869343426110551*^9, 3.869343445051504*^9}},
 CellLabel->"In[37]:=",ExpressionUUID->"82f54792-d511-497a-847b-3647aa4d4996"],

Cell[BoxData[
 TemplateBox[{
  "Minimize", "natt", 
   "\"The minimum is not attained at any point satisfying the given \
constraints.\"", 2, 37, 10, 16469725684033471525, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.869343447779728*^9},
 CellLabel->
  "During evaluation of \
In[37]:=",ExpressionUUID->"5f943e29-8d7c-4da5-9916-7a217592f501"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"psi1", "\[Rule]", "Indeterminate"}], ",", 
     RowBox[{"psi2", "\[Rule]", "Indeterminate"}]}], "}"}]}], "}"}]], "Output",\

 CellChangeTimes->{
  3.869339052246089*^9, 3.869339617368423*^9, {3.869343439419119*^9, 
   3.869343447787929*^9}},
 CellLabel->"Out[37]=",ExpressionUUID->"2b239ee1-d19d-4943-b566-6df0f231438d"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{
   RowBox[{
    RowBox[{"when", " ", "psi1"}], " ", "\[GreaterEqual]", "  ", "1"}], ",", 
   " ", 
   RowBox[{
    RowBox[{
     RowBox[{"Show", " ", "that", " ", 
      RowBox[{"1", "/", "alpha_C"}]}], " ", "\[GreaterEqual]", " ", 
     RowBox[{"1", "/", "alpha_L"}]}], " ", "\[Rule]", " ", 
    RowBox[{"alpha_C", " ", "\[LessEqual]", " ", 
     RowBox[{"alpha", " ", "L", " ", "when", " ", "beta_", "2"}], " ", 
     "\[GreaterEqual]", " ", "psi2", " ", "\[GreaterEqual]", " ", 
     RowBox[{"beta_", "3"}]}]}]}], " ", "*)"}]], "Input",
 CellChangeTimes->{{3.869339077019273*^9, 3.869339081038013*^9}, {
   3.8693410920126467`*^9, 3.8693410922556057`*^9}, 
   3.8693433924996357`*^9},ExpressionUUID->"16b693b2-ee3f-4570-ab86-\
10ca1de8aabe"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Maximize", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", " ", "psi1"}], "+", 
        RowBox[{"2", " ", "psi2"}]}], ")"}], "-", 
      RowBox[{"(", 
       RowBox[{"1", "+", "psi2"}], ")"}]}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"1", "-", 
        FractionBox["1", "psi1"], "+", "psi1"}], "\[LessEqual]", " ", "psi2", 
       "\[LessEqual]", " ", 
       FractionBox[
        RowBox[{"psi1", " ", 
         RowBox[{"(", 
          RowBox[{"2", "+", "psi1"}], ")"}]}], 
        RowBox[{"1", "+", "psi1"}]]}], "&&", 
      RowBox[{"psi1", ">=", "1"}], "&&", 
      RowBox[{"psi2", "\[GreaterEqual]", "psi1"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"psi1", ",", "psi2"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.869339096668911*^9, 3.8693391167608433`*^9}, 
   3.869339622055318*^9, {3.8693434631848*^9, 3.8693434716859503`*^9}},
 CellLabel->"In[39]:=",ExpressionUUID->"ed2f6988-1a55-40d4-910b-42c4a327c31d"],

Cell[BoxData[
 TemplateBox[{
  "Maximize", "natt", 
   "\"The maximum is not attained at any point satisfying the given \
constraints. \"", 2, 39, 11, 16469725684033471525, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.869343474319408*^9},
 CellLabel->
  "During evaluation of \
In[39]:=",ExpressionUUID->"85f808d6-a839-4acd-8124-5b1058916033"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"psi1", "\[Rule]", "Indeterminate"}], ",", 
     RowBox[{"psi2", "\[Rule]", "Indeterminate"}]}], "}"}]}], "}"}]], "Output",\

 CellChangeTimes->{
  3.869339124825972*^9, 3.869339624575886*^9, {3.86934346730269*^9, 
   3.869343474327684*^9}},
 CellLabel->"Out[39]=",ExpressionUUID->"6b0cd029-d03d-47f2-9643-438af6c90ca1"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{
   RowBox[{
    RowBox[{"when", " ", "psi1"}], " ", "<", " ", "1"}], ",", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"Show", " ", "that", " ", 
      RowBox[{"1", "/", "alpha_C"}]}], " ", "\[GreaterEqual]", " ", 
     RowBox[{"1", "/", "alpha_R"}]}], " ", "\[Rule]", " ", 
    RowBox[{"alpha_C", " ", "\[LessEqual]", "  ", 
     RowBox[{"alpha_R", " ", "when", " ", "psi2"}], " ", "\[LessEqual]", " ", 
     
     RowBox[{"beta_", "3"}]}]}]}], "  ", "*)"}]], "Input",
 CellChangeTimes->{{3.869338065672917*^9, 3.86933806916921*^9}, {
  3.869338387990793*^9, 3.869338401017631*^9}, {3.86933849199763*^9, 
  3.869338532144856*^9}, {3.869338804963649*^9, 3.869338817875453*^9}, {
  3.869341073058743*^9, 3.869341109407817*^9}, {3.869342639962832*^9, 
  3.869342643170868*^9}, {3.869343024875881*^9, 3.8693430309965897`*^9}, {
  3.869343539635356*^9, 
  3.869343542809999*^9}},ExpressionUUID->"46263673-75df-4ed7-86a9-\
c1d466849076"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Minimize", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "-", 
        RowBox[{"2", " ", "psi1"}], "+", 
        RowBox[{"2", " ", "psi2"}]}], ")"}], "-", 
      RowBox[{"(", 
       RowBox[{"1", "-", 
        RowBox[{"4", " ", "psi1"}], "+", 
        RowBox[{"3", " ", "psi2"}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"psi2", "\[LessEqual]", " ", 
       RowBox[{
        RowBox[{"-", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "2"}], "+", "psi1"}], ")"}]}], " ", "psi1"}]}], "&&", 
      
      RowBox[{"psi1", "\[LessEqual]", "1"}], "&&", 
      RowBox[{"psi1", "\[GreaterEqual]", "0"}], "&&", 
      RowBox[{"psi2", "\[GreaterEqual]", "psi1"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"psi1", ",", "psi2"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.869339536137341*^9, 3.869339537020378*^9}, {
  3.86934114753758*^9, 3.869341149798815*^9}, {3.869341516404428*^9, 
  3.869341542798565*^9}, {3.869341586847829*^9, 3.8693416024919157`*^9}, {
  3.869342659738112*^9, 3.869342683707329*^9}, {3.869343133310656*^9, 
  3.869343164054289*^9}, {3.8693435561779013`*^9, 3.869343562919626*^9}},
 CellLabel->"In[40]:=",ExpressionUUID->"7797bf27-f64c-4ceb-bf49-9f6633da8079"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"psi1", "\[Rule]", "0"}], ",", 
     RowBox[{"psi2", "\[Rule]", "0"}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.869338042968417*^9, 3.869339605080688*^9, 3.8693414586851807`*^9, 
   3.8693415219984617`*^9, {3.869341593669079*^9, 3.869341604837596*^9}, 
   3.8693426887152853`*^9, {3.869343138288622*^9, 3.8693431667777653`*^9}, 
   3.86934356837465*^9},
 CellLabel->"Out[40]=",ExpressionUUID->"1e867e8d-a55c-40c3-a6c2-b31029338cca"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{
   RowBox[{
    RowBox[{"when", " ", "psi1"}], " ", "<", " ", "1"}], ",", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"Show", " ", "that", " ", 
      RowBox[{"1", "/", "alpha_C"}]}], " ", "\[LessEqual]", " ", 
     RowBox[{"1", "/", "alpha_L"}]}], " ", "\[Rule]", " ", 
    RowBox[{"alpha_C", " ", "\[GreaterEqual]", " ", 
     RowBox[{"alpha", " ", "L", " ", "when", "  ", "psi2"}], " ", 
     "\[LessEqual]", " ", 
     RowBox[{"beta_", "3"}]}]}]}], " ", "*)"}]], "Input",
 CellChangeTimes->{{3.8693385720379887`*^9, 3.8693385728492947`*^9}, {
  3.869338762661236*^9, 3.869338777063054*^9}, {3.869338819749411*^9, 
  3.869338820528408*^9}, {3.869341116456341*^9, 3.8693411298578777`*^9}, {
  3.869342779039583*^9, 3.869342780875321*^9}, {3.8693430448092737`*^9, 
  3.869343054573244*^9}, {3.869343389319001*^9, 3.869343389504903*^9}, {
  3.869343579145088*^9, 
  3.869343584624894*^9}},ExpressionUUID->"034b7b9b-1f6e-4ea6-9b24-\
5afd07b33905"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Maximize", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "-", 
        RowBox[{"2", " ", "psi1"}], "+", 
        RowBox[{"2", " ", "psi2"}]}], ")"}], "-", 
      RowBox[{"(", 
       RowBox[{"1", "+", "psi2"}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"psi2", "\[LessEqual]", " ", 
       RowBox[{
        RowBox[{"-", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "2"}], "+", "psi1"}], ")"}]}], " ", "psi1"}]}], "&&", 
      
      RowBox[{"psi1", "\[LessEqual]", "1"}], "&&", 
      RowBox[{"psi1", "\[GreaterEqual]", "0"}], "&&", 
      RowBox[{"psi2", "\[GreaterEqual]", "psi1"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"psi1", ",", "psi2"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.869338717486199*^9, 3.869338744710984*^9}, {
   3.869339598625827*^9, 3.869339600939352*^9}, {3.8693411567674217`*^9, 
   3.869341160335251*^9}, {3.869342754740163*^9, 3.8693427666255703`*^9}, {
   3.869343174164968*^9, 3.86934318605205*^9}, 3.869343654575027*^9},
 CellLabel->"In[41]:=",ExpressionUUID->"9ccb4e91-6b8a-47c2-b7d1-a89cc56d9849"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"psi1", "\[Rule]", "0"}], ",", 
     RowBox[{"psi2", "\[Rule]", "0"}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.869338738248146*^9, 3.869338747508954*^9}, 
   3.869339608117289*^9, {3.86934276108926*^9, 3.8693427701346273`*^9}, {
   3.869343179459545*^9, 3.869343189336047*^9}, 3.869343665063505*^9},
 CellLabel->"Out[41]=",ExpressionUUID->"6561266b-2538-446d-8939-ab7e69f359de"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{
   RowBox[{
    RowBox[{"when", " ", "psi1"}], " ", "\[GreaterEqual]", " ", "1"}], ",", 
   " ", 
   RowBox[{
    RowBox[{
     RowBox[{"Show", " ", "that", " ", 
      RowBox[{"1", "/", "alpha_C"}]}], " ", "\[LessEqual]", " ", 
     RowBox[{"1", "/", "alpha_R"}]}], " ", "\[Rule]", " ", 
    RowBox[{"alpha_C", " ", "\[GreaterEqual]", " ", 
     RowBox[{"alpha_R", " ", "when", "  ", "psi2"}], " ", "\[LessEqual]", " ", 
     RowBox[{"beta_", "3"}]}]}]}], "  ", "*)"}]], "Input",
 CellChangeTimes->{
  3.869343385175705*^9, {3.8693438460648127`*^9, 
   3.869343848825786*^9}},ExpressionUUID->"7bf24455-68d4-4abc-be7a-\
2c2f08af8758"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Minimize", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", " ", "psi1"}], "+", 
        RowBox[{"2", " ", "psi2"}]}], ")"}], "-", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "-", 
        RowBox[{"2", " ", "psi1"}], "+", 
        RowBox[{"3", " ", "psi2"}]}], ")"}]}], ",", " ", 
     RowBox[{
      RowBox[{"psi2", "\[LessEqual]", 
       RowBox[{"1", "-", 
        FractionBox["1", "psi1"], "+", "psi1"}]}], " ", "&&", 
      RowBox[{"psi1", ">=", "1"}], "&&", 
      RowBox[{"psi2", "\[GreaterEqual]", "psi1"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"psi1", ",", "psi2"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.8693389673910513`*^9, 3.869338977770996*^9}, {
   3.8693390131971617`*^9, 3.869339043111992*^9}, 3.869339613726988*^9, {
   3.869343267594077*^9, 3.869343278442527*^9}, 3.86934336754275*^9, {
   3.869343426110551*^9, 3.869343445051504*^9}, {3.869343820019066*^9, 
   3.86934382615314*^9}},
 CellLabel->"In[42]:=",ExpressionUUID->"c31a2af2-97b3-43e9-b2e4-49cbc9a324b2"],

Cell[BoxData[
 TemplateBox[{
  "Minimize", "natt", 
   "\"The minimum is not attained at any point satisfying the given \
constraints.\"", 2, 42, 12, 16469725684033471525, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.869343447779728*^9, 3.869343829176223*^9},
 CellLabel->
  "During evaluation of \
In[42]:=",ExpressionUUID->"1aaa0f64-fed0-4a30-81cc-31e8bb4a6193"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"psi1", "\[Rule]", "Indeterminate"}], ",", 
     RowBox[{"psi2", "\[Rule]", "Indeterminate"}]}], "}"}]}], "}"}]], "Output",\

 CellChangeTimes->{
  3.869339052246089*^9, 3.869339617368423*^9, {3.869343439419119*^9, 
   3.869343447787929*^9}, 3.8693438291843233`*^9},
 CellLabel->"Out[42]=",ExpressionUUID->"6b664dfc-fb86-4f95-93e7-c8139d73a866"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{
   RowBox[{
    RowBox[{"when", " ", "psi1"}], " ", "\[GreaterEqual]", "  ", "1"}], ",", 
   " ", 
   RowBox[{
    RowBox[{
     RowBox[{"Show", " ", "that", " ", 
      RowBox[{"1", "/", "alpha_C"}]}], " ", "\[GreaterEqual]", " ", 
     RowBox[{"1", "/", "alpha_L"}]}], " ", "\[Rule]", " ", 
    RowBox[{"alpha_C", " ", "\[LessEqual]", " ", 
     RowBox[{"alpha", " ", "L", " ", "when", " ", "psi2"}], " ", 
     "\[LessEqual]", " ", 
     RowBox[{"beta_", "3"}]}]}]}], " ", "*)"}]], "Input",
 CellChangeTimes->{{3.869339077019273*^9, 3.869339081038013*^9}, {
   3.8693410920126467`*^9, 3.8693410922556057`*^9}, 3.8693433924996357`*^9, {
   3.8693438540807333`*^9, 
   3.869343856826069*^9}},ExpressionUUID->"4b249480-6c1f-4fdb-a145-\
74428e222416"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Maximize", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", " ", "psi1"}], "+", 
        RowBox[{"2", " ", "psi2"}]}], ")"}], "-", 
      RowBox[{"(", 
       RowBox[{"1", "+", "psi2"}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"psi2", "\[LessEqual]", 
       RowBox[{"1", "-", 
        FractionBox["1", "psi1"], "+", "psi1"}]}], " ", "&&", 
      RowBox[{"psi1", ">=", "1"}], "&&", 
      RowBox[{"psi2", "\[GreaterEqual]", "psi1"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"psi1", ",", "psi2"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.869339096668911*^9, 3.8693391167608433`*^9}, 
   3.869339622055318*^9, {3.8693434631848*^9, 3.8693434716859503`*^9}, 
   3.8693438372774763`*^9},
 CellLabel->"In[43]:=",ExpressionUUID->"214d9124-f7be-454f-968a-3d4550ed30b3"],

Cell[BoxData[
 TemplateBox[{
  "Maximize", "natt", 
   "\"The maximum is not attained at any point satisfying the given \
constraints. \"", 2, 43, 13, 16469725684033471525, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.869343474319408*^9, 3.869343839931761*^9},
 CellLabel->
  "During evaluation of \
In[43]:=",ExpressionUUID->"3be7db27-21c4-4f82-b78e-fc097971255e"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"psi1", "\[Rule]", "Indeterminate"}], ",", 
     RowBox[{"psi2", "\[Rule]", "Indeterminate"}]}], "}"}]}], "}"}]], "Output",\

 CellChangeTimes->{
  3.869339124825972*^9, 3.869339624575886*^9, {3.86934346730269*^9, 
   3.869343474327684*^9}, 3.8693438399402113`*^9},
 CellLabel->"Out[43]=",ExpressionUUID->"984859f6-6cea-4470-a1f9-8971c1ee18ad"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{
   RowBox[{"CASE", " ", "2", " ", "WHEN", " ", "psi1"}], " ", ">", " ", 
   "psi2"}], "*)"}]], "Input",
 CellChangeTimes->{{3.8684392356726*^9, 
  3.868439238193049*^9}},ExpressionUUID->"6c9e59ab-d8ba-4952-ab03-\
6e39ec98a811"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"objective2", "=", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"(", "\[Alpha]", ")"}], 
       RowBox[{"SSpecialmod", "[", 
        RowBox[{
        "F1", ",", "Fs", ",", "tau", ",", " ", "psi1", ",", "psi2", ",", 
         "zetasq", ",", "chi"}], "]"}]}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "-", "\[Alpha]"}], ")"}], "*", 
       RowBox[{"Rmod", "[", 
        RowBox[{
        "F1", ",", "Fs", ",", "tau", ",", "psi1", ",", " ", "psi2", ",", 
         "zetasq", ",", "chi"}], "]"}]}]}], "/.", 
     RowBox[{"{", 
      RowBox[{"zetasq", "->", 
       FractionBox[
        RowBox[{"chi", "+", "psi2"}], 
        RowBox[{"chi", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "+", "chi", "+", "psi2"}], ")"}]}]]}], "}"}]}],
     ")"}], "//", "FullSimplify"}]}]], "Input",
 CellLabel->"In[26]:=",ExpressionUUID->"b6f64742-9395-49a8-be1b-d36e197fe7e1"],

Cell[BoxData[
 RowBox[{
  FractionBox["1", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"psi1", "-", "psi2"}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "psi2"}], "+", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"chi", "+", "psi2"}], ")"}], "2"]}], ")"}]}]], 
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      SuperscriptBox["chi", "4"]}], " ", 
     SuperscriptBox["F1", "2"], " ", "\[Alpha]"}], "-", 
    RowBox[{"psi2", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "+", "psi1", "-", 
          RowBox[{"2", " ", "psi2"}]}], ")"}], " ", "psi2", " ", 
        SuperscriptBox["tau", "2"]}], "+", 
       RowBox[{
        SuperscriptBox["Fs", "2"], " ", 
        RowBox[{"(", 
         RowBox[{"psi1", "-", 
          SuperscriptBox["psi2", "2"], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"psi1", "-", "psi2"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", "psi2"}], ")"}], " ", "\[Alpha]"}]}], 
         ")"}]}], "+", 
       RowBox[{
        SuperscriptBox["F1", "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "psi2"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"psi1", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", "psi2"}], ")"}]}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "psi1"}], "+", "psi2"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", 
             RowBox[{"2", " ", "psi2"}]}], ")"}], " ", "\[Alpha]"}]}], 
         ")"}]}]}], ")"}]}], "+", 
    RowBox[{
     SuperscriptBox["chi", "2"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        SuperscriptBox["Fs", "2"], " ", 
        RowBox[{"(", 
         RowBox[{"psi2", "-", 
          RowBox[{"psi1", " ", "\[Alpha]"}], "+", 
          RowBox[{"3", " ", "psi2", " ", "\[Alpha]"}]}], ")"}]}], "+", 
       RowBox[{
        SuperscriptBox["F1", "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "psi2"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", "psi1", "+", 
             RowBox[{"2", " ", "psi2"}]}], ")"}]}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"4", "-", 
             RowBox[{"9", " ", "psi2"}]}], ")"}], " ", "psi2", " ", 
           "\[Alpha]"}], "+", 
          RowBox[{"psi1", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", 
             RowBox[{"6", " ", "psi2"}]}], ")"}], " ", "\[Alpha]"}]}], 
         ")"}]}], "+", 
       RowBox[{
        SuperscriptBox["tau", "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "psi1"}], "+", 
          RowBox[{"2", " ", "psi2", " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", "\[Alpha]"}], ")"}]}]}], ")"}]}]}], ")"}]}], 
    "-", 
    RowBox[{"chi", " ", "psi2", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        SuperscriptBox["Fs", "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "2"}], " ", "psi2"}], "+", "\[Alpha]", "+", 
          RowBox[{"2", " ", "psi1", " ", "\[Alpha]"}], "-", 
          RowBox[{"3", " ", "psi2", " ", "\[Alpha]"}]}], ")"}]}], "+", 
       RowBox[{
        SuperscriptBox["F1", "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", "psi2"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"2", " ", "psi1"}], "+", "psi2"}], ")"}]}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "+", 
             RowBox[{"4", " ", "psi1"}], "-", 
             RowBox[{"6", " ", 
              RowBox[{"(", 
               RowBox[{"1", "+", "psi1"}], ")"}], " ", "psi2"}], "+", 
             RowBox[{"7", " ", 
              SuperscriptBox["psi2", "2"]}]}], ")"}], " ", "\[Alpha]"}]}], 
         ")"}]}], "+", 
       RowBox[{
        SuperscriptBox["tau", "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", " ", "psi1"}], "+", "\[Alpha]", "-", 
          RowBox[{"psi2", " ", 
           RowBox[{"(", 
            RowBox[{"4", "+", "\[Alpha]"}], ")"}]}]}], ")"}]}]}], ")"}]}], 
    "+", 
    RowBox[{
     SuperscriptBox["chi", "3"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["Fs", "2"], "+", 
          SuperscriptBox["tau", "2"]}], ")"}], " ", "\[Alpha]"}], "+", 
       RowBox[{
        SuperscriptBox["F1", "2"], " ", 
        RowBox[{"(", 
         RowBox[{"\[Alpha]", "+", 
          RowBox[{"2", " ", "psi1", " ", "\[Alpha]"}], "-", 
          RowBox[{"psi2", " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", 
             RowBox[{"5", " ", "\[Alpha]"}]}], ")"}]}]}], ")"}]}]}], 
      ")"}]}]}], ")"}]}]], "Output",
 CellChangeTimes->{3.868439410544383*^9, 3.86899689756004*^9, 
  3.869048823917701*^9, 3.8691503358190203`*^9},
 CellLabel->"Out[26]=",ExpressionUUID->"3371fc24-ec5f-4608-afaa-f34204978586"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
    "Compute", " ", "second", " ", "derivative", " ", "with", " ", "respect", 
     " ", "to", " ", "chi", " ", "MINUS", " ", "basedline", " ", 
     RowBox[{"function", ".", " ", "Since"}], " ", "Fs", " ", "and", " ", 
     "tau", " ", "are", " ", "together"}], ",", " ", 
    RowBox[{
    "we", " ", "can", " ", "without", " ", "loss", " ", "of", " ", 
     "generality", " ", "assume", " ", "tau", " ", "equal", " ", "0.", "  ", 
     "This", " ", "is", " ", "Otilde", " ", "in", " ", "the", " ", 
     "paper"}]}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{"secondDer2", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"D", "[", 
      RowBox[{
       RowBox[{"objective2", "/.", 
        RowBox[{"{", 
         RowBox[{"tau", "\[Rule]", "0"}], "}"}]}], ",", 
       RowBox[{"{", 
        RowBox[{"chi", ",", "2"}], "}"}]}], "]"}], "-", 
     RowBox[{"(", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{"2", " ", 
         SuperscriptBox["F1", "2"], " ", "\[Alpha]"}], 
        RowBox[{"psi1", "-", "psi2"}]]}], ")"}]}], "//", 
    "FullSimplify"}]}]}]], "Input",
 CellChangeTimes->{{3.8684399115649023`*^9, 3.868439919267939*^9}, {
  3.8684403090934057`*^9, 3.868440329452496*^9}, {3.869350801596051*^9, 
  3.869350817259848*^9}, {3.8693511405842733`*^9, 
  3.869351161013669*^9}},ExpressionUUID->"d73e61bb-a263-43e8-8560-\
b1a779c63b4b"],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox[
   RowBox[{"2", " ", "psi2", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "2"}], " ", 
       SuperscriptBox["chi", "3"], " ", 
       SuperscriptBox["F1", "2"]}], "+", 
      RowBox[{"3", " ", 
       SuperscriptBox["chi", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["Fs", "2"], "-", 
         RowBox[{
          SuperscriptBox["F1", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", "psi2"}], ")"}]}]}], ")"}]}], "+", 
      RowBox[{"6", " ", "chi", " ", 
       SuperscriptBox["Fs", "2"], " ", "psi2"}], "+", 
      RowBox[{"psi2", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SuperscriptBox["F1", "2"], " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", "psi2"}], ")"}], "2"]}], "+", 
         RowBox[{
          SuperscriptBox["Fs", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{"3", " ", "psi2"}]}], ")"}]}]}], ")"}]}]}], ")"}]}], 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "psi2"}], "+", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"chi", "+", "psi2"}], ")"}], "2"]}], ")"}], "3"]]}]], "Output",\

 CellChangeTimes->{3.8684402596463737`*^9, 3.868440332914008*^9, 
  3.868996902359004*^9, 3.869048830830309*^9, 3.869150342341968*^9},
 CellLabel->"Out[27]=",ExpressionUUID->"9e6c633d-4c1b-474b-b6c9-7953b9873a1d"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{
   RowBox[{
   "Show", " ", "that", " ", "secondDerMinusBaseline", " ", "is", " ", 
    "always", " ", "convex"}], ",", " ", 
   RowBox[{
    RowBox[{
    "we", " ", "will", " ", "seperate", " ", "it", " ", "into", " ", "F1", 
     " ", "and", " ", 
     RowBox[{"Fs", "^", "2"}]}], " ", "+", " ", 
    RowBox[{
     RowBox[{"tau", "^", "2"}], " ", "component"}]}]}], "*)"}]], "Input",
 CellChangeTimes->{{3.8684403789820766`*^9, 3.868440418490138*^9}, {
  3.869270655619307*^9, 
  3.8692706679177322`*^9}},ExpressionUUID->"80a3e68b-b83d-4d9b-afd3-\
2e4601a97d7d"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"F1componet", " ", "=", " ", 
   RowBox[{
    RowBox[{"D", "[", 
     RowBox[{
      RowBox[{"secondDer2", "/.", 
       RowBox[{"{", 
        RowBox[{
         SuperscriptBox["F1", "2"], "\[Rule]", "F1sq"}], "}"}]}], ",", 
      "F1sq"}], "]"}], "//", "FullSimplify"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Fscomponet", "=", " ", 
   RowBox[{
    RowBox[{"D", "[", 
     RowBox[{
      RowBox[{"secondDer2", "/.", 
       RowBox[{"{", 
        RowBox[{
         SuperscriptBox["Fs", "2"], "\[Rule]", "Fssq"}], "}"}]}], ",", 
      "Fssq"}], "]"}], "//", "FullSimplify"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.8684404484972687`*^9, 3.86844047540895*^9}, {
  3.868440814184956*^9, 3.868440815933003*^9}},
 CellLabel->"In[26]:=",ExpressionUUID->"ecf84a49-d0ed-46a9-94a7-564c281f19a8"],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{
  "Show", " ", "that", " ", "F1", " ", "component", " ", "is", " ", "always", 
   " ", "convex", " ", "by", " ", "checking", " ", "its", " ", "numerator", 
   " ", "and", " ", "denominator", " ", "are", " ", "both", " ", "negative"}],
   " ", "*)"}]], "Input",
 CellChangeTimes->{{3.868440498431471*^9, 3.868440537461257*^9}, {
  3.869270312859674*^9, 
  3.869270341386106*^9}},ExpressionUUID->"3914f899-8902-478b-a67a-\
b85954c939e8"],

Cell[BoxData[
 RowBox[{
  RowBox[{"secondderF1component", " ", "=", " ", 
   RowBox[{
    RowBox[{"D", "[", 
     RowBox[{"F1componet", ",", " ", 
      RowBox[{"{", 
       RowBox[{"chi", ",", "2"}], "}"}]}], "]"}], "//", "FullSimplify"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.868440824765463*^9, 3.8684408254284143`*^9}, {
  3.868440882374032*^9, 3.868440896624489*^9}},
 CellLabel->"In[28]:=",ExpressionUUID->"2e209128-501d-4141-a82c-eaf29bb5aed8"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
   "check", " ", "the", " ", "numerator", " ", "of", " ", "F1", " ", 
    "component", " ", "is", " ", "always", " ", "negative"}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"F1numerator", " ", "=", " ", 
   RowBox[{
    RowBox[{"Numerator", "[", "secondderF1component", "]"}], "//", 
    "FullSimplify"}]}]}]], "Input",
 CellChangeTimes->{{3.8684408044958763`*^9, 3.868440851817831*^9}, {
  3.868440987991843*^9, 3.868441013786611*^9}, {3.868445642466242*^9, 
  3.868445697542919*^9}, {3.868445763407037*^9, 3.868445764000321*^9}, {
  3.868446712612817*^9, 3.868446714278803*^9}, {3.868446765255698*^9, 
  3.868446770216548*^9}, {3.868996938551819*^9, 3.868996955264243*^9}},
 CellLabel->"In[29]:=",ExpressionUUID->"3b90e184-a329-4103-b3f5-da4e03291a5e"],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "24"}], " ", "psi2", " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "2"}], " ", 
     SuperscriptBox["chi", "5"]}], "-", 
    RowBox[{"5", " ", 
     SuperscriptBox["chi", "4"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", "psi2"}], ")"}]}], "+", 
    RowBox[{"10", " ", 
     SuperscriptBox["chi", "2"], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", "psi2"}], ")"}], "2"], " ", "psi2"}], "+", 
    RowBox[{"10", " ", "chi", " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", "psi2"}], ")"}], "2"], " ", 
     SuperscriptBox["psi2", "2"]}], "+", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", "psi2"}], ")"}], "2"], " ", 
     SuperscriptBox["psi2", "2"], " ", 
     RowBox[{"(", 
      RowBox[{"1", "+", 
       RowBox[{"3", " ", "psi2"}]}], ")"}]}]}], ")"}]}]], "Output",
 CellChangeTimes->{3.86899695698092*^9, 3.8690488468295403`*^9},
 CellLabel->"Out[29]=",ExpressionUUID->"a19f6db9-9c91-44f0-ba03-04d136249b42"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Minimize", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "2"}], " ", 
         SuperscriptBox["chi", "5"]}], "-", 
        RowBox[{"5", " ", 
         SuperscriptBox["chi", "4"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "+", "psi2"}], ")"}]}], "+", 
        RowBox[{"10", " ", 
         SuperscriptBox["chi", "2"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", "psi2"}], ")"}], "2"], " ", "psi2"}], 
        "+", 
        RowBox[{"10", " ", "chi", " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", "psi2"}], ")"}], "2"], " ", 
         SuperscriptBox["psi2", "2"]}], "+", 
        RowBox[{
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", "psi2"}], ")"}], "2"], " ", 
         SuperscriptBox["psi2", "2"], " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", 
           RowBox[{"3", " ", "psi2"}]}], ")"}]}]}], ")"}], ",", 
      RowBox[{
       RowBox[{"chi", "\[LessEqual]", "0"}], "&&", 
       RowBox[{"chi", "\[LessEqual]", 
        RowBox[{"1", "-", "psi2"}]}], "&&", 
       RowBox[{"chi", "\[GreaterEqual]", 
        RowBox[{"-", "psi2"}]}]}]}], "}"}], ",", "chi"}], "]"}], "//", 
  "FullSimplify"}]], "Input",
 CellChangeTimes->{{3.8684457756036043`*^9, 3.868445809909099*^9}, {
  3.86844584533121*^9, 3.868445846042285*^9}},
 CellLabel->"In[30]:=",ExpressionUUID->"cb8930fb-9e01-4482-95ab-513ef427e863"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[GridBox[{
      {"\[Piecewise]", GridBox[{
         {
          RowBox[{
           RowBox[{"-", "4"}], " ", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", "psi2"}], ")"}], "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "2"}], "+", 
             RowBox[{"2", " ", 
              SqrtBox[
               RowBox[{"1", "-", "psi2"}]]}], "+", "psi2"}], ")"}]}], 
          RowBox[{"0", "<", "psi2", "<", "1"}]},
         {
          RowBox[{
           RowBox[{"-", "4"}], " ", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", "psi2"}], ")"}], "2"], " ", 
           SuperscriptBox["psi2", "2"], " ", 
           RowBox[{"(", 
            RowBox[{"1", "-", 
             RowBox[{"2", " ", "psi2"}], "+", 
             RowBox[{"2", " ", 
              SqrtBox[
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "1"}], "+", "psi2"}], ")"}], " ", 
                "psi2"}]]}]}], ")"}]}], 
          RowBox[{"psi2", ">", "1"}]},
         {"\[Infinity]", 
          RowBox[{"psi2", "<", "0"}]},
         {"0", 
          TagBox["True",
           "PiecewiseDefault",
           AutoDelete->True]}
        },
        AllowedDimensions->{2, Automatic},
        Editable->True,
        GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Baseline}}},
        GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{1.}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.84]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}},
        Selectable->True]}
     },
     GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Baseline}}},
     GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{1.}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.35]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    "Piecewise",
    DeleteWithContents->True,
    Editable->False,
    SelectWithContents->True,
    Selectable->False,
    StripWrapperBoxes->True], ",", 
   RowBox[{"{", 
    RowBox[{"chi", "\[Rule]", 
     TagBox[GridBox[{
        {"\[Piecewise]", GridBox[{
           {
            RowBox[{"Root", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"8", "-", 
                RowBox[{"8", " ", 
                 SqrtBox[
                  RowBox[{"-", 
                   SuperscriptBox[
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "1"}], "+", "psi2"}], ")"}], "5"]}]]}], "-", 
                
                RowBox[{"20", " ", "psi2"}], "+", 
                RowBox[{"15", " ", 
                 SuperscriptBox["psi2", "2"]}], "-", 
                RowBox[{"5", " ", 
                 SuperscriptBox["psi2", "3"]}], "+", 
                RowBox[{"5", " ", 
                 SuperscriptBox["psi2", "4"]}], "-", 
                RowBox[{"3", " ", 
                 SuperscriptBox["psi2", "5"]}], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"-", "10"}], " ", 
                    SuperscriptBox["psi2", "2"]}], "+", 
                   RowBox[{"20", " ", 
                    SuperscriptBox["psi2", "3"]}], "-", 
                   RowBox[{"10", " ", 
                    SuperscriptBox["psi2", "4"]}]}], ")"}], " ", "#1"}], "+", 
                
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"-", "10"}], " ", "psi2"}], "+", 
                   RowBox[{"20", " ", 
                    SuperscriptBox["psi2", "2"]}], "-", 
                   RowBox[{"10", " ", 
                    SuperscriptBox["psi2", "3"]}]}], ")"}], " ", 
                 SuperscriptBox["#1", "2"]}], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "5"}], "+", 
                   RowBox[{"5", " ", "psi2"}]}], ")"}], " ", 
                 SuperscriptBox["#1", "4"]}], "+", 
                RowBox[{"2", " ", 
                 SuperscriptBox["#1", "5"]}]}], "&"}], ",", "1"}], "]"}], 
            RowBox[{"0", "<", "psi2", "<", "1"}]},
           {
            RowBox[{"Root", "[", 
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{"-", "5"}], " ", 
                 SuperscriptBox["psi2", "2"]}], "+", 
                RowBox[{"15", " ", 
                 SuperscriptBox["psi2", "3"]}], "-", 
                RowBox[{"15", " ", 
                 SuperscriptBox["psi2", "4"]}], "+", 
                RowBox[{"5", " ", 
                 SuperscriptBox["psi2", "5"]}], "-", 
                RowBox[{"8", " ", 
                 SqrtBox[
                  RowBox[{
                   SuperscriptBox[
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "1"}], "+", "psi2"}], ")"}], "5"], " ", 
                   SuperscriptBox["psi2", "5"]}]]}], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"-", "10"}], " ", 
                    SuperscriptBox["psi2", "2"]}], "+", 
                   RowBox[{"20", " ", 
                    SuperscriptBox["psi2", "3"]}], "-", 
                   RowBox[{"10", " ", 
                    SuperscriptBox["psi2", "4"]}]}], ")"}], " ", "#1"}], "+", 
                
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"-", "10"}], " ", "psi2"}], "+", 
                   RowBox[{"20", " ", 
                    SuperscriptBox["psi2", "2"]}], "-", 
                   RowBox[{"10", " ", 
                    SuperscriptBox["psi2", "3"]}]}], ")"}], " ", 
                 SuperscriptBox["#1", "2"]}], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "5"}], "+", 
                   RowBox[{"5", " ", "psi2"}]}], ")"}], " ", 
                 SuperscriptBox["#1", "4"]}], "+", 
                RowBox[{"2", " ", 
                 SuperscriptBox["#1", "5"]}]}], "&"}], ",", "1"}], "]"}], 
            RowBox[{"psi2", ">", "1"}]},
           {"0", 
            RowBox[{
             RowBox[{"psi2", "\[Equal]", "0"}], "||", 
             RowBox[{"psi2", "\[Equal]", "1"}]}]},
           {"Indeterminate", 
            TagBox["True",
             "PiecewiseDefault",
             AutoDelete->True]}
          },
          AllowedDimensions->{2, Automatic},
          Editable->True,
          GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Baseline}}},
          GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{1.}}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.84]}, 
              Offset[0.27999999999999997`]}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}},
          Selectable->True]}
       },
       GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Baseline}}},
       GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{1.}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.35]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      "Piecewise",
      DeleteWithContents->True,
      Editable->False,
      SelectWithContents->True,
      Selectable->False,
      StripWrapperBoxes->True]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.8684457821194773`*^9, 3.86844581379285*^9, 
  3.868445849856514*^9, 3.868997179039988*^9, 3.8690488511599483`*^9},
 CellLabel->"Out[30]=",ExpressionUUID->"21772aa2-b2bc-4f1d-9744-142b3304c9d5"]
}, Open  ]],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.868445870378093*^9, 
  3.86844589696548*^9}},ExpressionUUID->"ba1c9fbb-bcef-4a34-b727-\
f6f3eca8e413"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Maximize", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "2"}], "+", 
      RowBox[{"2", " ", 
       SqrtBox[
        RowBox[{"1", "-", "psi2"}]]}], "+", "psi2"}], ",", " ", 
     RowBox[{
      RowBox[{"psi2", " ", "<", " ", "1"}], " ", "&&", " ", 
      RowBox[{"psi2", ">", "0"}]}]}], "}"}], ",", " ", "psi2"}], 
  "]"}]], "Input",
 CellLabel->"In[31]:=",ExpressionUUID->"1dd0fc5e-5552-4799-a121-75795c3f0472"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", 
   RowBox[{"{", 
    RowBox[{"psi2", "\[Rule]", "0"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.868445900002058*^9, 3.868997183146784*^9, 
  3.8690488539267483`*^9},
 CellLabel->"Out[31]=",ExpressionUUID->"32c595e9-ff8f-455e-8bc7-36bbb605b7dc"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Maximize", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "-", 
      RowBox[{"2", " ", "psi2"}], "+", 
      RowBox[{"2", " ", 
       SqrtBox[
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "+", "psi2"}], ")"}], " ", "psi2"}]]}]}], ",", 
     " ", 
     RowBox[{"psi2", ">", "1"}]}], "}"}], ",", " ", "psi2"}], "]"}]], "Input",\

 CellLabel->"In[32]:=",ExpressionUUID->"efb9ba4e-177c-4170-af91-3c3543842dc0"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", 
   RowBox[{"{", 
    RowBox[{"psi2", "\[Rule]", "\[Infinity]"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.8684468602219143`*^9, 3.8689971867504597`*^9, 
  3.869048856408373*^9},
 CellLabel->"Out[32]=",ExpressionUUID->"01173ec4-6620-4716-8886-d7ba7d54423f"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
   "check", " ", "the", " ", "denominator", " ", "of", " ", "F1", " ", 
    "component", " ", "is", " ", "always", " ", "negative"}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"F1denominator", " ", "=", " ", 
   RowBox[{
    RowBox[{"Denominator", "[", "secondderF1component", "]"}], "//", 
    "FullSimplify"}]}]}]], "Input",
 CellChangeTimes->{{3.868446856189005*^9, 3.868446919327441*^9}, {
  3.8689977633953733`*^9, 3.868997765682395*^9}},
 CellLabel->"In[33]:=",ExpressionUUID->"4f83f3eb-9d9f-4220-89d9-3c05a187d298"],

Cell[BoxData[
 SuperscriptBox[
  RowBox[{"(", 
   RowBox[{
    RowBox[{"-", "psi2"}], "+", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"chi", "+", "psi2"}], ")"}], "2"]}], ")"}], "5"]], "Output",
 CellChangeTimes->{3.8684469218385353`*^9, 3.8689972342348413`*^9, 
  3.868997768723082*^9, 3.869048859533526*^9},
 CellLabel->"Out[33]=",ExpressionUUID->"897d8415-1d6f-4b81-9040-9536af5a55b3"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Maximize", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "psi2"}], "+", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"chi", "+", "psi2"}], ")"}], "2"]}], ",", 
      RowBox[{
       RowBox[{"chi", "\[LessEqual]", "0"}], "&&", 
       RowBox[{"chi", "\[LessEqual]", 
        RowBox[{"1", "-", "psi2"}]}], "&&", 
       RowBox[{"chi", "\[GreaterEqual]", 
        RowBox[{"-", "psi2"}]}]}]}], "}"}], ",", "chi"}], "]"}], "//", 
  "FullSimplify"}]], "Input",
 CellLabel->"In[34]:=",ExpressionUUID->"0d5adff5-cede-48de-beac-dc7de78036e0"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[GridBox[{
      {"\[Piecewise]", GridBox[{
         {
          RowBox[{"1", "-", "psi2"}], 
          RowBox[{"psi2", ">", "1"}]},
         {
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", "psi2"}], ")"}], " ", "psi2"}], 
          RowBox[{"0", "\[LessEqual]", "psi2", "\[LessEqual]", "1"}]},
         {
          RowBox[{"-", "\[Infinity]"}], 
          TagBox["True",
           "PiecewiseDefault",
           AutoDelete->True]}
        },
        AllowedDimensions->{2, Automatic},
        Editable->True,
        GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Baseline}}},
        GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{1.}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.84]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}},
        Selectable->True]}
     },
     GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Baseline}}},
     GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{1.}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.35]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    "Piecewise",
    DeleteWithContents->True,
    Editable->False,
    SelectWithContents->True,
    Selectable->False,
    StripWrapperBoxes->True], ",", 
   RowBox[{"{", 
    RowBox[{"chi", "\[Rule]", 
     TagBox[GridBox[{
        {"\[Piecewise]", GridBox[{
           {
            RowBox[{"1", "-", "psi2"}], 
            RowBox[{"psi2", ">", "1"}]},
           {"0", 
            RowBox[{"0", "\[LessEqual]", "psi2", "\[LessEqual]", "1"}]},
           {"Indeterminate", 
            TagBox["True",
             "PiecewiseDefault",
             AutoDelete->True]}
          },
          AllowedDimensions->{2, Automatic},
          Editable->True,
          GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Baseline}}},
          GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{1.}}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.84]}, 
              Offset[0.27999999999999997`]}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}},
          Selectable->True]}
       },
       GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Baseline}}},
       GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{1.}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.35]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      "Piecewise",
      DeleteWithContents->True,
      Editable->False,
      SelectWithContents->True,
      Selectable->False,
      StripWrapperBoxes->True]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.868446971621562*^9, 3.868997242554969*^9, 
  3.8689977719323072`*^9, 3.869048862887443*^9},
 CellLabel->"Out[34]=",ExpressionUUID->"810c673e-c432-45cc-8c39-54de16c3ddeb"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{
   RowBox[{"show", " ", "that", " ", 
    RowBox[{"Fs", "^", "2"}]}], " ", "+", " ", 
   RowBox[{
    RowBox[{"tau", "^", "2"}], " ", "component", " ", "is", " ", "also", " ", 
    "convex", " ", "by", " ", "checking", " ", "its", " ", "numerator", " ", 
    "and", " ", "denominator", " ", "are", " ", "both", " ", "negative"}]}], 
  "*)"}]], "Input",
 CellChangeTimes->{{3.8692704572218857`*^9, 
  3.8692704578320007`*^9}},ExpressionUUID->"f80dd342-3be3-47d4-9da7-\
72795fbe7355"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"secondderFscomponent", " ", "=", " ", 
  RowBox[{
   RowBox[{"D", "[", 
    RowBox[{"Fscomponet", ",", " ", 
     RowBox[{"{", 
      RowBox[{"chi", ",", "2"}], "}"}]}], "]"}], "//", 
   "FullSimplify"}]}]], "Input",
 CellChangeTimes->{{3.8689976231907043`*^9, 3.868997623873149*^9}, {
  3.868997656968503*^9, 3.868997663984132*^9}},
 CellLabel->"In[35]:=",ExpressionUUID->"cc44443d-0a0d-46e8-b281-54c52e5aacce"],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox[
   RowBox[{"24", " ", "psi2", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"5", " ", 
       SuperscriptBox["chi", "4"]}], "+", 
      RowBox[{"20", " ", 
       SuperscriptBox["chi", "3"], " ", "psi2"}], "+", 
      SuperscriptBox["psi2", "2"], "+", 
      RowBox[{"20", " ", "chi", " ", 
       SuperscriptBox["psi2", "2"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "psi2"}], ")"}]}], "+", 
      RowBox[{"5", " ", 
       SuperscriptBox["psi2", "3"], " ", 
       RowBox[{"(", 
        RowBox[{"2", "+", "psi2"}], ")"}]}], "+", 
      RowBox[{"10", " ", 
       SuperscriptBox["chi", "2"], " ", "psi2", " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", 
         RowBox[{"3", " ", "psi2"}]}], ")"}]}]}], ")"}]}], 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "psi2"}], "+", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"chi", "+", "psi2"}], ")"}], "2"]}], ")"}], "5"]]}]], "Output",\

 CellChangeTimes->{3.868447030982499*^9, 3.868997438877692*^9, 
  3.868997626795032*^9, 3.868997667524837*^9, 3.868997775002095*^9, 
  3.869048866155056*^9},
 CellLabel->"Out[35]=",ExpressionUUID->"ba12b273-e22a-4216-a1a0-123dff443942"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{
   RowBox[{"check", " ", "the", " ", "numerator", " ", "of", " ", 
    RowBox[{"Fs", "^", "2"}]}], " ", "+", " ", 
   RowBox[{
    RowBox[{"tau", "^", "2"}], " ", "component", " ", "is", " ", "always", 
    " ", "negative"}]}], " ", "*)"}]], "Input",
 CellChangeTimes->{{3.868998001521069*^9, 3.868998008074218*^9}, {
  3.869270436122621*^9, 
  3.869270454679031*^9}},ExpressionUUID->"6c0c5a7d-9fad-4cbe-a487-\
d65baf1f403a"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Fsnumerator", " ", "=", "  ", 
  RowBox[{"Numerator", "[", "secondderFscomponent", "]"}]}]], "Input",
 CellChangeTimes->{{3.868997648474831*^9, 3.8689976525596857`*^9}, {
  3.868997718840317*^9, 3.8689977401504374`*^9}, {3.86899787104541*^9, 
  3.868997886150395*^9}},
 CellLabel->"In[36]:=",ExpressionUUID->"2e00be6e-d1c8-43a8-90e5-0b3c1702a03a"],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "24"}], " ", "psi2", " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"5", " ", 
     SuperscriptBox["chi", "4"]}], "+", 
    RowBox[{"20", " ", 
     SuperscriptBox["chi", "3"], " ", "psi2"}], "+", 
    SuperscriptBox["psi2", "2"], "+", 
    RowBox[{"20", " ", "chi", " ", 
     SuperscriptBox["psi2", "2"], " ", 
     RowBox[{"(", 
      RowBox[{"1", "+", "psi2"}], ")"}]}], "+", 
    RowBox[{"5", " ", 
     SuperscriptBox["psi2", "3"], " ", 
     RowBox[{"(", 
      RowBox[{"2", "+", "psi2"}], ")"}]}], "+", 
    RowBox[{"10", " ", 
     SuperscriptBox["chi", "2"], " ", "psi2", " ", 
     RowBox[{"(", 
      RowBox[{"1", "+", 
       RowBox[{"3", " ", "psi2"}]}], ")"}]}]}], ")"}]}]], "Output",
 CellChangeTimes->{3.868997742018166*^9, 3.86899789762971*^9, 
  3.8690488693475943`*^9},
 CellLabel->"Out[36]=",ExpressionUUID->"1eaf6142-5175-4c37-9b1d-a1c65c3b9524"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Minimize", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"5", " ", 
        SuperscriptBox["chi", "4"]}], "+", 
       RowBox[{"20", " ", 
        SuperscriptBox["chi", "3"], " ", "psi2"}], "+", 
       SuperscriptBox["psi2", "2"], "+", 
       RowBox[{"20", " ", "chi", " ", 
        SuperscriptBox["psi2", "2"], " ", 
        RowBox[{"(", 
         RowBox[{"1", "+", "psi2"}], ")"}]}], "+", 
       RowBox[{"5", " ", 
        SuperscriptBox["psi2", "3"], " ", 
        RowBox[{"(", 
         RowBox[{"2", "+", "psi2"}], ")"}]}], "+", 
       RowBox[{"10", " ", 
        SuperscriptBox["chi", "2"], " ", "psi2", " ", 
        RowBox[{"(", 
         RowBox[{"1", "+", 
          RowBox[{"3", " ", "psi2"}]}], ")"}]}]}], ",", 
      RowBox[{
       RowBox[{"chi", "\[LessEqual]", "0"}], "&&", 
       RowBox[{"chi", "\[LessEqual]", 
        RowBox[{"1", "-", "psi2"}]}], "&&", 
       RowBox[{"chi", "\[GreaterEqual]", 
        RowBox[{"-", "psi2"}]}]}]}], "}"}], ",", "chi"}], "]"}], "//", 
  "FullSimplify"}]], "Input",
 CellLabel->"In[37]:=",ExpressionUUID->"9e6195e5-f7c5-4787-95dd-0b41f4ceb6f6"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[GridBox[{
      {"\[Piecewise]", GridBox[{
         {
          SuperscriptBox["psi2", "2"], 
          RowBox[{"psi2", "\[GreaterEqual]", "0"}]},
         {"\[Infinity]", 
          TagBox["True",
           "PiecewiseDefault",
           AutoDelete->True]}
        },
        AllowedDimensions->{2, Automatic},
        Editable->True,
        GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Baseline}}},
        GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{1.}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.84]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}},
        Selectable->True]}
     },
     GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Baseline}}},
     GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{1.}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.35]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    "Piecewise",
    DeleteWithContents->True,
    Editable->False,
    SelectWithContents->True,
    Selectable->False,
    StripWrapperBoxes->True], ",", 
   RowBox[{"{", 
    RowBox[{"chi", "\[Rule]", 
     TagBox[GridBox[{
        {"\[Piecewise]", GridBox[{
           {
            RowBox[{"-", "psi2"}], 
            RowBox[{"psi2", "\[GreaterEqual]", "0"}]},
           {"Indeterminate", 
            TagBox["True",
             "PiecewiseDefault",
             AutoDelete->True]}
          },
          AllowedDimensions->{2, Automatic},
          Editable->True,
          GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Baseline}}},
          GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{1.}}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.84]}, 
              Offset[0.27999999999999997`]}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}},
          Selectable->True]}
       },
       GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Baseline}}},
       GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{1.}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.35]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      "Piecewise",
      DeleteWithContents->True,
      Editable->False,
      SelectWithContents->True,
      Selectable->False,
      StripWrapperBoxes->True]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.8689979769949923`*^9, 3.869048872382077*^9},
 CellLabel->"Out[37]=",ExpressionUUID->"86ab3891-6d93-43b5-8b7d-d4f056129d58"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"check", " ", "the", " ", "denominator", " ", "of", " ", 
     RowBox[{"Fs", "^", "2"}]}], " ", "+", " ", 
    RowBox[{
     RowBox[{"tau", "^", "2"}], " ", "component", " ", "is", " ", "always", 
     " ", "negative"}]}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{"F1denominator", " ", "=", " ", 
   RowBox[{
    RowBox[{"Denominator", "[", "secondderF1component", "]"}], "//", 
    "FullSimplify"}]}]}]], "Input",
 CellChangeTimes->{{3.868998011671983*^9, 3.86899801395814*^9}},
 CellLabel->"In[38]:=",ExpressionUUID->"5f1d95ad-e817-4062-a8da-d41f9eef8099"],

Cell[BoxData[
 SuperscriptBox[
  RowBox[{"(", 
   RowBox[{
    RowBox[{"-", "psi2"}], "+", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"chi", "+", "psi2"}], ")"}], "2"]}], ")"}], "5"]], "Output",
 CellChangeTimes->{3.868998016962121*^9, 3.8690488755000143`*^9},
 CellLabel->"Out[38]=",ExpressionUUID->"e038cb84-d39e-401d-be58-7e08f51cccf1"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Maximize", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "psi2"}], "+", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"chi", "+", "psi2"}], ")"}], "2"]}], ",", 
      RowBox[{
       RowBox[{"chi", "\[LessEqual]", "0"}], "&&", 
       RowBox[{"chi", "\[LessEqual]", 
        RowBox[{"1", "-", "psi2"}]}], "&&", 
       RowBox[{"chi", "\[GreaterEqual]", 
        RowBox[{"-", "psi2"}]}]}]}], "}"}], ",", "chi"}], "]"}], "//", 
  "FullSimplify"}]], "Input",
 CellLabel->"In[39]:=",ExpressionUUID->"f129a4b7-909a-49d1-a26a-1efa83c1725c"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[GridBox[{
      {"\[Piecewise]", GridBox[{
         {
          RowBox[{"1", "-", "psi2"}], 
          RowBox[{"psi2", ">", "1"}]},
         {
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", "psi2"}], ")"}], " ", "psi2"}], 
          RowBox[{"0", "\[LessEqual]", "psi2", "\[LessEqual]", "1"}]},
         {
          RowBox[{"-", "\[Infinity]"}], 
          TagBox["True",
           "PiecewiseDefault",
           AutoDelete->True]}
        },
        AllowedDimensions->{2, Automatic},
        Editable->True,
        GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Baseline}}},
        GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{1.}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.84]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}},
        Selectable->True]}
     },
     GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Baseline}}},
     GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{1.}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.35]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    "Piecewise",
    DeleteWithContents->True,
    Editable->False,
    SelectWithContents->True,
    Selectable->False,
    StripWrapperBoxes->True], ",", 
   RowBox[{"{", 
    RowBox[{"chi", "\[Rule]", 
     TagBox[GridBox[{
        {"\[Piecewise]", GridBox[{
           {
            RowBox[{"1", "-", "psi2"}], 
            RowBox[{"psi2", ">", "1"}]},
           {"0", 
            RowBox[{"0", "\[LessEqual]", "psi2", "\[LessEqual]", "1"}]},
           {"Indeterminate", 
            TagBox["True",
             "PiecewiseDefault",
             AutoDelete->True]}
          },
          AllowedDimensions->{2, Automatic},
          Editable->True,
          GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Baseline}}},
          GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{1.}}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.84]}, 
              Offset[0.27999999999999997`]}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}},
          Selectable->True]}
       },
       GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Baseline}}},
       GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{1.}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.35]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      "Piecewise",
      DeleteWithContents->True,
      Editable->False,
      SelectWithContents->True,
      Selectable->False,
      StripWrapperBoxes->True]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.8689980268454857`*^9, 3.869048878178001*^9},
 CellLabel->"Out[39]=",ExpressionUUID->"08a5c10c-0f35-4bec-869f-99f2ac530d3e"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{
  "show", " ", "that", " ", "F1", " ", "component", " ", "left", " ", "side", 
   " ", "is", " ", "smaller", " ", "than", " ", "right", " ", "side"}], " ", 
  "*)"}]], "Input",
 CellChangeTimes->{{3.8689985127291718`*^9, 3.8689985258241587`*^9}, {
  3.8689986613252993`*^9, 
  3.8689986630036583`*^9}},ExpressionUUID->"6be2443b-5c3a-4d13-a190-\
f81ca6e6c11a"],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{"F1", " ", "component", " ", "at", " ", "left"}], "*)"}]], "Input",
 CellChangeTimes->{{3.8689980884282923`*^9, 
  3.86899810325211*^9}},ExpressionUUID->"461d3389-9f66-4c36-a981-\
2c3019f58d01"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"F1componet", " ", "/.", 
   RowBox[{"{", 
    RowBox[{"chi", "\[Rule]", 
     RowBox[{"-", "psi2"}]}], "}"}]}], "//", "FullSimplify"}]], "Input",
 CellChangeTimes->{3.868998080214971*^9},
 CellLabel->"In[40]:=",ExpressionUUID->"f7c184f0-6bff-47ba-bea8-4ee0ccf8a84e"],

Cell[BoxData[
 RowBox[{"2", "+", 
  FractionBox["2", "psi2"]}]], "Output",
 CellChangeTimes->{3.868998082618108*^9, 3.869048880684452*^9},
 CellLabel->"Out[40]=",ExpressionUUID->"db415a9f-c4b5-4a12-bb6e-e6a63604faf2"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{"F1", " ", "component", " ", "at", " ", "right"}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"F1componet", " ", "/.", 
    RowBox[{"{", 
     RowBox[{"chi", "\[Rule]", "0"}], "}"}]}], "//", 
   "FullSimplify"}]}]], "Input",
 CellChangeTimes->{{3.86899810592234*^9, 3.8689981348848257`*^9}},
 CellLabel->"In[41]:=",ExpressionUUID->"692b8a13-6e0b-4dc6-a3ee-5c693d23fe8c"],

Cell[BoxData[
 FractionBox["2", 
  RowBox[{"psi2", "-", 
   SuperscriptBox["psi2", "2"]}]]], "Output",
 CellChangeTimes->{3.8689981376841307`*^9, 3.8690488836181498`*^9},
 CellLabel->"Out[41]=",ExpressionUUID->"c239b0a1-8b09-4b78-8515-34bb746c39fc"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"F1componet", " ", "/.", 
   RowBox[{"{", 
    RowBox[{"chi", "\[Rule]", 
     RowBox[{"1", "-", "psi2"}]}], "}"}]}], "//", "FullSimplify"}]], "Input",
 CellChangeTimes->{{3.868998157759007*^9, 3.868998167163417*^9}},
 CellLabel->"In[50]:=",ExpressionUUID->"aba20d63-bf2f-49e6-ab51-4a75e08b0c8b"],

Cell[BoxData[
 FractionBox[
  RowBox[{"2", " ", "psi2"}], 
  RowBox[{
   RowBox[{"-", "1"}], "+", "psi2"}]]], "Output",
 CellChangeTimes->{3.8689981707521667`*^9},
 CellLabel->"Out[50]=",ExpressionUUID->"db947cf0-fd5d-414f-a60a-061bd3ea006c"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
    "comparison", " ", "between", " ", "left", " ", "and", " ", "right", " ", 
     "and", " ", "left", " ", "is", " ", "smaller", " ", "than", " ", 
     "right"}], ",", " ", 
    RowBox[{"cause", " ", "psi2", " ", 
     RowBox[{"can", "'"}], "t", " ", "be", " ", "zero"}]}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"Minimize", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"Max", "[", 
        RowBox[{
         FractionBox["2", 
          RowBox[{"psi2", "-", 
           SuperscriptBox["psi2", "2"]}]], ",", 
         FractionBox[
          RowBox[{"2", " ", "psi2"}], 
          RowBox[{
           RowBox[{"-", "1"}], "+", "psi2"}]]}], "]"}], "-", 
       RowBox[{"(", 
        RowBox[{"2", "+", 
         FractionBox["2", "psi2"]}], ")"}]}], ",", 
      RowBox[{"psi2", "\[GreaterEqual]", "0"}]}], "}"}], ",", "psi2"}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.868998177514657*^9, 3.868998204767098*^9}, {
  3.868998489071169*^9, 3.8689985191964483`*^9}, {3.8689986664903173`*^9, 
  3.868998670232959*^9}, {3.86935179185885*^9, 
  3.869351798478001*^9}},ExpressionUUID->"b8bc7e16-2879-457d-b616-\
b61e7d2f4d4e"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", 
   RowBox[{"{", 
    RowBox[{"psi2", "\[Rule]", "0"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.8689982070649023`*^9},
 CellLabel->"Out[51]=",ExpressionUUID->"e3549416-e6ca-4b42-9d01-dbdf2b4657b2"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{"show", " ", "that", " ", 
   RowBox[{"Fs", "^", " ", 
    RowBox[{"+", " ", 
     RowBox[{"tau", "^", "2"}]}]}], " ", "component", " ", "left", " ", 
   "side", " ", "is", " ", "smaller", " ", "than", " ", "right", " ", 
   "side"}], " ", "*)"}]], "Input",
 CellChangeTimes->{
  3.868998570973496*^9, {3.869270558591936*^9, 
   3.869270565507042*^9}},ExpressionUUID->"ba4aa40c-dcef-4bd7-b10e-\
9a40d69f1442"],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{
   RowBox[{"Fs", "^", " ", 
    RowBox[{"+", " ", 
     RowBox[{"tau", "^", "2"}]}]}], " ", "component", " ", "at", " ", 
   "left"}], "*)"}]], "Input",
 CellChangeTimes->{{3.86899861754701*^9, 3.868998617749704*^9}, {
  3.8692707074693403`*^9, 
  3.86927071059359*^9}},ExpressionUUID->"b4fc0262-7e6e-4575-bafd-\
aede05163500"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Fscomponet", " ", "/.", 
   RowBox[{"{", 
    RowBox[{"chi", "\[Rule]", 
     RowBox[{"-", "psi2"}]}], "}"}]}], "//", "FullSimplify"}]], "Input",
 CellChangeTimes->{{3.868998592643395*^9, 3.868998592738253*^9}},
 CellLabel->"In[52]:=",ExpressionUUID->"1d2facf4-1087-4612-b801-a4eff86ea644"],

Cell[BoxData[
 FractionBox["2", "psi2"]], "Output",
 CellChangeTimes->{3.8689985955977716`*^9},
 CellLabel->"Out[52]=",ExpressionUUID->"362144a4-8187-4d20-ad8b-e55875bbc770"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{
   RowBox[{"Fs", "^", " ", 
    RowBox[{"+", " ", 
     RowBox[{"tau", "^", "2"}]}]}], " ", "component", " ", "at", " ", 
   "right"}], "*)"}]], "Input",
 CellChangeTimes->{{3.868998606150996*^9, 3.868998619311809*^9}, {
  3.86927071263918*^9, 
  3.869270713435573*^9}},ExpressionUUID->"b6abc117-0c18-4892-8877-\
147ce3c0313a"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Fscomponet", " ", "/.", 
   RowBox[{"{", 
    RowBox[{"chi", "\[Rule]", "0"}], "}"}]}], "//", "FullSimplify"}]], "Input",\

 CellChangeTimes->{3.8689986332313223`*^9},
 CellLabel->"In[53]:=",ExpressionUUID->"10a11e13-2584-49ed-a48d-76511a90e23e"],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox[
   RowBox[{"2", " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", 
      RowBox[{"3", " ", "psi2"}]}], ")"}]}], 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", "psi2"}], ")"}], "3"], " ", 
    "psi2"}]]}]], "Output",
 CellChangeTimes->{3.868998636023406*^9},
 CellLabel->"Out[53]=",ExpressionUUID->"b601bb85-a955-4399-b64a-6117daeb7c4b"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Fscomponet", " ", "/.", 
   RowBox[{"{", 
    RowBox[{"chi", "\[Rule]", 
     RowBox[{"1", "-", "psi2"}]}], "}"}]}], "//", "FullSimplify"}]], "Input",
 CellChangeTimes->{3.868998686219945*^9},
 CellLabel->"In[54]:=",ExpressionUUID->"3f34ac81-c7d9-40a5-9060-130ac0c6ab3f"],

Cell[BoxData[
 FractionBox[
  RowBox[{"2", " ", "psi2", " ", 
   RowBox[{"(", 
    RowBox[{"3", "+", "psi2"}], ")"}]}], 
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "1"}], "+", "psi2"}], ")"}], "3"]]], "Output",
 CellChangeTimes->{3.868998689739202*^9},
 CellLabel->"Out[54]=",ExpressionUUID->"51b584c1-1d4d-4ed8-88a3-8d21711fd7a9"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{
  "comparison", " ", "between", " ", "left", " ", "and", " ", "right", " ", 
   "and", " ", "left", " ", "is", " ", "smaller", " ", "or", " ", "equal", 
   " ", "than", " ", "right"}], "*)"}]], "Input",
 CellChangeTimes->{{3.868998716799739*^9, 
  3.868998719157659*^9}},ExpressionUUID->"aeba70c6-018f-49a7-bbf9-\
425fa07cf686"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Minimize", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"Max", "[", 
       RowBox[{
        RowBox[{"-", 
         FractionBox[
          RowBox[{"2", " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", 
             RowBox[{"3", " ", "psi2"}]}], ")"}]}], 
          RowBox[{
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", "psi2"}], ")"}], "3"], " ", 
           "psi2"}]]}], ",", 
        FractionBox[
         RowBox[{"2", " ", "psi2", " ", 
          RowBox[{"(", 
           RowBox[{"3", "+", "psi2"}], ")"}]}], 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", "psi2"}], ")"}], "3"]]}], "]"}], "-", 
      RowBox[{"(", 
       FractionBox["2", "psi2"], ")"}]}], ",", 
     RowBox[{"psi2", "\[GreaterEqual]", "0"}]}], "}"}], ",", "psi2"}], 
  "]"}]], "Input",
 CellLabel->"In[55]:=",ExpressionUUID->"735831fd-485b-4fe6-9924-4626f61bd583"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", 
   RowBox[{"{", 
    RowBox[{"psi2", "\[Rule]", "\[Infinity]"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.868998722203272*^9},
 CellLabel->"Out[55]=",ExpressionUUID->"0606c296-161e-4e63-b5cd-7783d2663599"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{
  "show", " ", "that", " ", "derivative", " ", "of", " ", "F1", " ", 
   "component", " ", "the", " ", "left", " ", "is", " ", "always", " ", 
   "negative", " ", "and", " ", "right", " ", "is", " ", "always", " ", 
   "positive"}], "*)"}]], "Input",
 CellChangeTimes->{
  3.868999074771264*^9, {3.868999110559352*^9, 
   3.868999112479505*^9}},ExpressionUUID->"c63a6cf0-5611-4ce9-b678-\
d81195eb6e2a"],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{"derivative", " ", "F1", " ", "component", " ", "at", " ", "left"}],
   "*)"}]], "Input",
 CellChangeTimes->{{3.868999088455535*^9, 
  3.868999106425385*^9}},ExpressionUUID->"3d6069cb-cb8a-482d-a913-\
f15310107314"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"D", "[", 
    RowBox[{"F1componet", " ", ",", "chi"}], "]"}], "/.", 
   RowBox[{"{", 
    RowBox[{"chi", "\[Rule]", 
     RowBox[{"-", "psi2"}]}], "}"}]}], "//", "FullSimplify"}]], "Input",
 CellChangeTimes->{{3.868999133937997*^9, 3.8689991348652782`*^9}},
 CellLabel->"In[57]:=",ExpressionUUID->"b4220134-b5d5-4462-b038-09217a69e726"],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox["12", "psi2"]}]], "Output",
 CellChangeTimes->{{3.868999122468875*^9, 3.868999137707106*^9}},
 CellLabel->"Out[57]=",ExpressionUUID->"7673e567-fa02-4a78-b334-cc3326efc5e0"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{
  "derivative", " ", "F1", " ", "component", " ", "at", " ", "right"}], 
  "*)"}]], "Input",
 CellChangeTimes->{{3.868999146697603*^9, 
  3.8689991481874104`*^9}},ExpressionUUID->"3d99020b-92d2-4394-865a-\
21bc9c9c6fec"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"D", "[", 
    RowBox[{"F1componet", " ", ",", "chi"}], "]"}], "/.", 
   RowBox[{"{", 
    RowBox[{"chi", "\[Rule]", "0"}], "}"}]}], "//", "FullSimplify"}]], "Input",\

 CellChangeTimes->{3.8689991628475723`*^9},
 CellLabel->"In[58]:=",ExpressionUUID->"7ad9bea7-75bf-4cd4-a13e-892b10e70da4"],

Cell[BoxData[
 FractionBox["12", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", "psi2"}], ")"}], "2"], " ", 
   "psi2"}]]], "Output",
 CellChangeTimes->{3.868999165312673*^9},
 CellLabel->"Out[58]=",ExpressionUUID->"ee6807f5-b0e0-4ee1-8c4a-7a5102981120"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"D", "[", 
    RowBox[{"F1componet", " ", ",", "chi"}], "]"}], "/.", 
   RowBox[{"{", 
    RowBox[{"chi", "\[Rule]", 
     RowBox[{"1", "-", "psi2"}]}], "}"}]}], "//", "FullSimplify"}]], "Input",
 CellChangeTimes->{{3.868999181081646*^9, 3.868999181656455*^9}},
 CellLabel->"In[59]:=",ExpressionUUID->"ea3d9533-d53d-4db1-884e-af1ebc6a3085"],

Cell[BoxData[
 FractionBox[
  RowBox[{"12", " ", "psi2"}], 
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "1"}], "+", "psi2"}], ")"}], "2"]]], "Output",
 CellChangeTimes->{3.8689991847129583`*^9},
 CellLabel->"Out[59]=",ExpressionUUID->"52154477-5c88-493c-aa52-14c2ed95a22c"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{
   RowBox[{"show", " ", "that", " ", "dervative", " ", "of", " ", 
    RowBox[{"Fs", "^", "2"}]}], " ", "+", " ", 
   RowBox[{
    RowBox[{"tau", "^", "2"}], " ", "component", " ", "the", " ", "left", " ",
     "is", " ", "always", " ", "zero", " ", "and", " ", "right", " ", "is", 
    " ", "always", " ", "positive"}]}], "*)"}]], "Input",
 CellChangeTimes->{{3.869270763454726*^9, 
  3.8692707801264887`*^9}},ExpressionUUID->"b2b33848-af38-426a-a380-\
27f52fa58159"],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{
   RowBox[{"derivative", " ", 
    RowBox[{"Fs", "^", "2"}]}], " ", "+", " ", 
   RowBox[{
    RowBox[{"tau", "^", "2"}], " ", "component", " ", "at", " ", "left"}]}], 
  "*)"}]], "Input",
 CellChangeTimes->{{3.868999207049487*^9, 3.868999207160206*^9}, {
  3.86927078749104*^9, 
  3.8692707881497307`*^9}},ExpressionUUID->"22ed68d0-c7a4-4106-80ad-\
86355af87002"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"D", "[", 
    RowBox[{"Fscomponet", ",", "chi"}], "]"}], "/.", 
   RowBox[{"{", 
    RowBox[{"chi", "\[Rule]", 
     RowBox[{"-", "psi2"}]}], "}"}]}], "//", "FullSimplify"}]], "Input",
 CellChangeTimes->{{3.8689992165523787`*^9, 3.8689992198269653`*^9}},
 CellLabel->"In[60]:=",ExpressionUUID->"15634a69-7c57-4945-8ff8-aa3164f73081"],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{3.8689992225619097`*^9},
 CellLabel->"Out[60]=",ExpressionUUID->"de6c6e55-14bb-4110-9648-701995c1af0b"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{
   RowBox[{"derivative", " ", 
    RowBox[{"Fs", "^", "2"}]}], " ", "+", " ", 
   RowBox[{
    RowBox[{"tau", "^", "2"}], " ", "component", " ", "at", " ", "right"}]}], 
  "*)"}]], "Input",
 CellChangeTimes->{{3.8689992324372673`*^9, 3.8689992347808733`*^9}, {
  3.8692707897800407`*^9, 
  3.869270790525858*^9}},ExpressionUUID->"b6bfd6be-bf0f-4f06-ac55-\
a321196a07e6"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"D", "[", 
    RowBox[{"Fscomponet", ",", "chi"}], "]"}], "/.", 
   RowBox[{"{", 
    RowBox[{"chi", "\[Rule]", "0"}], "}"}]}], "//", "FullSimplify"}]], "Input",\

 CellChangeTimes->{{3.868999245038409*^9, 3.8689992455358686`*^9}},
 CellLabel->"In[61]:=",ExpressionUUID->"347ffe5e-e905-45a0-a848-633b9eeeb53d"],

Cell[BoxData[
 FractionBox[
  RowBox[{"24", " ", 
   RowBox[{"(", 
    RowBox[{"1", "+", "psi2"}], ")"}]}], 
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", "psi2"}], ")"}], "4"], " ", 
   "psi2"}]]], "Output",
 CellChangeTimes->{3.8689992484202967`*^9},
 CellLabel->"Out[61]=",ExpressionUUID->"ddc6c6df-b6db-493d-9d37-716c0d8079d5"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"D", "[", 
    RowBox[{"Fscomponet", ",", "chi"}], "]"}], "/.", 
   RowBox[{"{", 
    RowBox[{"chi", "\[Rule]", 
     RowBox[{"1", "-", "psi2"}]}], "}"}]}], "//", "FullSimplify"}]], "Input",
 CellChangeTimes->{3.8689992646137342`*^9},
 CellLabel->"In[62]:=",ExpressionUUID->"5e060cac-213e-4365-9ecc-4492a99cbe53"],

Cell[BoxData[
 FractionBox[
  RowBox[{"24", " ", "psi2", " ", 
   RowBox[{"(", 
    RowBox[{"1", "+", "psi2"}], ")"}]}], 
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "1"}], "+", "psi2"}], ")"}], "4"]]], "Output",
 CellChangeTimes->{3.8689992672073593`*^9},
 CellLabel->"Out[62]=",ExpressionUUID->"d5b5e011-5cd5-48eb-b857-d90313de8e94"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{"define", " ", "A1"}], "*)"}]], "Input",
 CellChangeTimes->{{3.869000158511853*^9, 
  3.869000180516431*^9}},ExpressionUUID->"49b753de-6de6-45c7-bfe0-\
e26d13537a92"],

Cell[BoxData[
 RowBox[{
  RowBox[{"secondDerMinusBase2", "=", "secondDer2"}], ";"}]], "Input",
 CellChangeTimes->{{3.8690002579044123`*^9, 3.869000263759451*^9}},
 CellLabel->"In[63]:=",ExpressionUUID->"4af486ab-ea52-45eb-baeb-5d6ea4e94db6"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"secondDerMinusBase2", "/.", 
   RowBox[{"{", 
    RowBox[{"chi", "\[Rule]", 
     RowBox[{"-", "psi2"}]}], "}"}]}], "//", "FullSimplify"}]], "Input",
 CellLabel->"In[64]:=",ExpressionUUID->"cc2cf346-af3f-473d-a957-15e090518bfd"],

Cell[BoxData[
 FractionBox[
  RowBox[{"2", " ", 
   RowBox[{"(", 
    RowBox[{
     SuperscriptBox["Fs", "2"], "+", 
     RowBox[{
      SuperscriptBox["F1", "2"], " ", 
      RowBox[{"(", 
       RowBox[{"1", "+", "psi2"}], ")"}]}]}], ")"}]}], "psi2"]], "Output",
 CellChangeTimes->{3.8690002747557983`*^9},
 CellLabel->"Out[64]=",ExpressionUUID->"91523b5a-bd52-4120-8df9-027f13ab2f69"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{"define", " ", "A3"}], "*)"}]], "Input",
 CellChangeTimes->{{3.8690002893083353`*^9, 
  3.869000299338284*^9}},ExpressionUUID->"7446cdb4-517e-476d-918d-\
dfd04fbde5e3"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"secondDerMinusBase2", "/.", 
   RowBox[{"{", 
    RowBox[{"chi", "\[Rule]", "0"}], "}"}]}], "//", 
  "FullSimplify"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"secondDerMinusBase2", "/.", 
   RowBox[{"{", 
    RowBox[{"chi", "\[Rule]", 
     RowBox[{"1", "-", "psi2"}]}], "}"}]}], "//", "FullSimplify"}]}], "Input",\

 CellLabel->"In[65]:=",ExpressionUUID->"73b13a4f-bcf9-43be-862f-d9c67b2ec913"],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox[
   RowBox[{"2", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       SuperscriptBox["F1", "2"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "psi2"}], ")"}], "2"]}], "+", 
      RowBox[{
       SuperscriptBox["Fs", "2"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", 
         RowBox[{"3", " ", "psi2"}]}], ")"}]}]}], ")"}]}], 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", "psi2"}], ")"}], "3"], " ", 
    "psi2"}]]}]], "Output",
 CellChangeTimes->{3.869000312574095*^9},
 CellLabel->"Out[65]=",ExpressionUUID->"b8ddb720-029d-4c87-964c-13aa55f7860d"],

Cell[BoxData[
 FractionBox[
  RowBox[{"2", " ", "psi2", " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      SuperscriptBox["F1", "2"], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "psi2"}], ")"}], "2"]}], "+", 
     RowBox[{
      SuperscriptBox["Fs", "2"], " ", 
      RowBox[{"(", 
       RowBox[{"3", "+", "psi2"}], ")"}]}]}], ")"}]}], 
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "1"}], "+", "psi2"}], ")"}], "3"]]], "Output",
 CellChangeTimes->{3.869000312595469*^9},
 CellLabel->"Out[66]=",ExpressionUUID->"d9a8428b-ea6b-485f-b299-d9d9654ea7f1"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{
   RowBox[{"Calculate", " ", "the", " ", "poly", " ", "for", " ", "A2"}], ",",
    " ", 
   RowBox[{
    RowBox[{"/", "rho"}], " ", "is", " ", "for", " ", "signal", " ", 
    "ratio"}]}], "*)"}]], "Input",
 CellChangeTimes->{{3.869000895205618*^9, 3.869000902049346*^9}, {
  3.869270810367931*^9, 
  3.86927082060493*^9}},ExpressionUUID->"ed2dd5e4-d32a-4a33-952b-\
0698b16dacaa"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Minimize", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"secondDerMinusBase2", "/.", 
         RowBox[{"{", 
          RowBox[{"F1", "\[Rule]", 
           RowBox[{
            SqrtBox["\[Rho]"], "*", "Fs"}]}], "}"}]}], ")"}], "/", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["Fs", "2"], "psi2"}], ")"}]}], "//", "FullSimplify"}],
      ",", 
     RowBox[{
      RowBox[{"chi", "\[GreaterEqual]", 
       RowBox[{"-", "psi2"}]}], "&&", 
      RowBox[{"chi", "\[LessEqual]", "0"}], "&&", 
      RowBox[{"chi", "\[LessEqual]", 
       RowBox[{"1", "-", "psi2"}]}], "&&", 
      RowBox[{"\[Rho]", ">=", "0"}], "&&", 
      RowBox[{"F1", ">=", "0"}], "&&", 
      RowBox[{"Fs", ">=", "0"}], "&&", 
      RowBox[{"psi2", ">=", "0"}]}]}], "}"}], ",", "chi"}], "]"}]], "Input",
 CellChangeTimes->{{3.869000815844202*^9, 3.869000844605608*^9}},
 CellLabel->"In[69]:=",ExpressionUUID->"5bdc4615-3682-498e-ad9e-4250cf652594"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[GridBox[{
      {"\[Piecewise]", GridBox[{
         {
          FractionBox["2", 
           SuperscriptBox["psi2", "2"]], 
          RowBox[{
           RowBox[{"psi2", ">", "0"}], "&&", 
           RowBox[{"\[Rho]", "\[Equal]", "0"}], "&&", 
           RowBox[{"Fs", "\[GreaterEqual]", "0"}], "&&", 
           RowBox[{"F1", "\[GreaterEqual]", "0"}]}]},
         {"\[Infinity]", 
          RowBox[{"!", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"psi2", ">", "0"}], "&&", 
               RowBox[{"\[Rho]", "\[Equal]", "0"}], "&&", 
               RowBox[{"Fs", "\[GreaterEqual]", "0"}], "&&", 
               RowBox[{"F1", "\[GreaterEqual]", "0"}]}], ")"}], "||", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"psi2", ">", "0"}], "&&", 
               RowBox[{"\[Rho]", ">", "0"}], "&&", 
               RowBox[{"Fs", "\[GreaterEqual]", "0"}], "&&", 
               RowBox[{"F1", "\[GreaterEqual]", "0"}]}], ")"}]}], ")"}]}]},
         {
          RowBox[{"Root", "[", 
           RowBox[{
            RowBox[{
             RowBox[{
              SuperscriptBox["\[Rho]", "4"], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "8"}], "-", 
                 RowBox[{"24", " ", "\[Rho]"}], "-", 
                 RowBox[{"24", " ", "psi2", " ", "\[Rho]"}], "-", 
                 RowBox[{"24", " ", 
                  SuperscriptBox["\[Rho]", "2"]}], "-", 
                 RowBox[{"20", " ", "psi2", " ", 
                  SuperscriptBox["\[Rho]", "2"]}], "-", 
                 RowBox[{"24", " ", 
                  SuperscriptBox["psi2", "2"], " ", 
                  SuperscriptBox["\[Rho]", "2"]}], "-", 
                 RowBox[{"8", " ", 
                  SuperscriptBox["\[Rho]", "3"]}], "+", 
                 RowBox[{"4", " ", "psi2", " ", 
                  SuperscriptBox["\[Rho]", "3"]}], "+", 
                 RowBox[{"4", " ", 
                  SuperscriptBox["psi2", "2"], " ", 
                  SuperscriptBox["\[Rho]", "3"]}], "-", 
                 RowBox[{"8", " ", 
                  SuperscriptBox["psi2", "3"], " ", 
                  SuperscriptBox["\[Rho]", "3"]}]}], ")"}], " ", "#1"}], "+", 
              
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{
                  RowBox[{"-", "28"}], " ", 
                  SuperscriptBox["psi2", "2"]}], "-", 
                 RowBox[{"56", " ", 
                  SuperscriptBox["psi2", "2"], " ", "\[Rho]"}], "-", 
                 RowBox[{"56", " ", 
                  SuperscriptBox["psi2", "3"], " ", "\[Rho]"}], "-", 
                 RowBox[{"28", " ", 
                  SuperscriptBox["psi2", "2"], " ", 
                  SuperscriptBox["\[Rho]", "2"]}], "+", 
                 RowBox[{"80", " ", 
                  SuperscriptBox["psi2", "3"], " ", 
                  SuperscriptBox["\[Rho]", "2"]}], "-", 
                 RowBox[{"28", " ", 
                  SuperscriptBox["psi2", "4"], " ", 
                  SuperscriptBox["\[Rho]", "2"]}]}], ")"}], " ", 
               SuperscriptBox["#1", "2"]}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{
                  RowBox[{"-", "16"}], " ", 
                  SuperscriptBox["psi2", "4"]}], "-", 
                 RowBox[{"16", " ", 
                  SuperscriptBox["psi2", "4"], " ", "\[Rho]"}], "-", 
                 RowBox[{"16", " ", 
                  SuperscriptBox["psi2", "5"], " ", "\[Rho]"}]}], ")"}], " ", 
               
               SuperscriptBox["#1", "3"]}], "+", 
              RowBox[{"16", " ", 
               SuperscriptBox["psi2", "6"], " ", 
               SuperscriptBox["#1", "4"]}]}], "&"}], ",", "2"}], "]"}], 
          TagBox["True",
           "PiecewiseDefault",
           AutoDelete->True]}
        },
        AllowedDimensions->{2, Automatic},
        Editable->True,
        GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Baseline}}},
        GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{1.}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.84]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}},
        Selectable->True]}
     },
     GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Baseline}}},
     GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{1.}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.35]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    "Piecewise",
    DeleteWithContents->True,
    Editable->False,
    SelectWithContents->True,
    Selectable->False,
    StripWrapperBoxes->True], ",", 
   RowBox[{"{", 
    RowBox[{"chi", "\[Rule]", 
     TagBox[GridBox[{
        {"\[Piecewise]", GridBox[{
           {
            RowBox[{"-", "psi2"}], 
            RowBox[{
             RowBox[{"psi2", ">", "0"}], "&&", 
             RowBox[{"\[Rho]", "\[Equal]", "0"}], "&&", 
             RowBox[{"Fs", "\[GreaterEqual]", "0"}], "&&", 
             RowBox[{"F1", "\[GreaterEqual]", "0"}]}]},
           {
            RowBox[{"Root", "[", 
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{"2", " ", "psi2"}], "+", 
                RowBox[{"6", " ", 
                 SuperscriptBox["psi2", "2"]}], "+", 
                RowBox[{"2", " ", "psi2", " ", "\[Rho]"}], "-", 
                RowBox[{"4", " ", 
                 SuperscriptBox["psi2", "2"], " ", "\[Rho]"}], "+", 
                RowBox[{"2", " ", 
                 SuperscriptBox["psi2", "3"], " ", "\[Rho]"}], "-", 
                RowBox[{
                 SuperscriptBox["psi2", "3"], " ", 
                 RowBox[{"Root", "[", 
                  RowBox[{
                   RowBox[{
                    RowBox[{
                    SuperscriptBox["\[Rho]", "4"], "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "8"}], "-", 
                    RowBox[{"24", " ", "\[Rho]"}], "-", 
                    RowBox[{"24", " ", "psi2", " ", "\[Rho]"}], "-", 
                    RowBox[{"24", " ", 
                    SuperscriptBox["\[Rho]", "2"]}], "-", 
                    RowBox[{"20", " ", "psi2", " ", 
                    SuperscriptBox["\[Rho]", "2"]}], "-", 
                    RowBox[{"24", " ", 
                    SuperscriptBox["psi2", "2"], " ", 
                    SuperscriptBox["\[Rho]", "2"]}], "-", 
                    RowBox[{"8", " ", 
                    SuperscriptBox["\[Rho]", "3"]}], "+", 
                    RowBox[{"4", " ", "psi2", " ", 
                    SuperscriptBox["\[Rho]", "3"]}], "+", 
                    RowBox[{"4", " ", 
                    SuperscriptBox["psi2", "2"], " ", 
                    SuperscriptBox["\[Rho]", "3"]}], "-", 
                    RowBox[{"8", " ", 
                    SuperscriptBox["psi2", "3"], " ", 
                    SuperscriptBox["\[Rho]", "3"]}]}], ")"}], " ", "#1"}], 
                    "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", "28"}], " ", 
                    SuperscriptBox["psi2", "2"]}], "-", 
                    RowBox[{"56", " ", 
                    SuperscriptBox["psi2", "2"], " ", "\[Rho]"}], "-", 
                    RowBox[{"56", " ", 
                    SuperscriptBox["psi2", "3"], " ", "\[Rho]"}], "-", 
                    RowBox[{"28", " ", 
                    SuperscriptBox["psi2", "2"], " ", 
                    SuperscriptBox["\[Rho]", "2"]}], "+", 
                    RowBox[{"80", " ", 
                    SuperscriptBox["psi2", "3"], " ", 
                    SuperscriptBox["\[Rho]", "2"]}], "-", 
                    RowBox[{"28", " ", 
                    SuperscriptBox["psi2", "4"], " ", 
                    SuperscriptBox["\[Rho]", "2"]}]}], ")"}], " ", 
                    SuperscriptBox["#1", "2"]}], "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", "16"}], " ", 
                    SuperscriptBox["psi2", "4"]}], "-", 
                    RowBox[{"16", " ", 
                    SuperscriptBox["psi2", "4"], " ", "\[Rho]"}], "-", 
                    RowBox[{"16", " ", 
                    SuperscriptBox["psi2", "5"], " ", "\[Rho]"}]}], ")"}], 
                    " ", 
                    SuperscriptBox["#1", "3"]}], "+", 
                    RowBox[{"16", " ", 
                    SuperscriptBox["psi2", "6"], " ", 
                    SuperscriptBox["#1", "4"]}]}], "&"}], ",", "2"}], "]"}]}],
                 "+", 
                RowBox[{"3", " ", 
                 SuperscriptBox["psi2", "4"], " ", 
                 RowBox[{"Root", "[", 
                  RowBox[{
                   RowBox[{
                    RowBox[{
                    SuperscriptBox["\[Rho]", "4"], "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "8"}], "-", 
                    RowBox[{"24", " ", "\[Rho]"}], "-", 
                    RowBox[{"24", " ", "psi2", " ", "\[Rho]"}], "-", 
                    RowBox[{"24", " ", 
                    SuperscriptBox["\[Rho]", "2"]}], "-", 
                    RowBox[{"20", " ", "psi2", " ", 
                    SuperscriptBox["\[Rho]", "2"]}], "-", 
                    RowBox[{"24", " ", 
                    SuperscriptBox["psi2", "2"], " ", 
                    SuperscriptBox["\[Rho]", "2"]}], "-", 
                    RowBox[{"8", " ", 
                    SuperscriptBox["\[Rho]", "3"]}], "+", 
                    RowBox[{"4", " ", "psi2", " ", 
                    SuperscriptBox["\[Rho]", "3"]}], "+", 
                    RowBox[{"4", " ", 
                    SuperscriptBox["psi2", "2"], " ", 
                    SuperscriptBox["\[Rho]", "3"]}], "-", 
                    RowBox[{"8", " ", 
                    SuperscriptBox["psi2", "3"], " ", 
                    SuperscriptBox["\[Rho]", "3"]}]}], ")"}], " ", "#1"}], 
                    "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", "28"}], " ", 
                    SuperscriptBox["psi2", "2"]}], "-", 
                    RowBox[{"56", " ", 
                    SuperscriptBox["psi2", "2"], " ", "\[Rho]"}], "-", 
                    RowBox[{"56", " ", 
                    SuperscriptBox["psi2", "3"], " ", "\[Rho]"}], "-", 
                    RowBox[{"28", " ", 
                    SuperscriptBox["psi2", "2"], " ", 
                    SuperscriptBox["\[Rho]", "2"]}], "+", 
                    RowBox[{"80", " ", 
                    SuperscriptBox["psi2", "3"], " ", 
                    SuperscriptBox["\[Rho]", "2"]}], "-", 
                    RowBox[{"28", " ", 
                    SuperscriptBox["psi2", "4"], " ", 
                    SuperscriptBox["\[Rho]", "2"]}]}], ")"}], " ", 
                    SuperscriptBox["#1", "2"]}], "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", "16"}], " ", 
                    SuperscriptBox["psi2", "4"]}], "-", 
                    RowBox[{"16", " ", 
                    SuperscriptBox["psi2", "4"], " ", "\[Rho]"}], "-", 
                    RowBox[{"16", " ", 
                    SuperscriptBox["psi2", "5"], " ", "\[Rho]"}]}], ")"}], 
                    " ", 
                    SuperscriptBox["#1", "3"]}], "+", 
                    RowBox[{"16", " ", 
                    SuperscriptBox["psi2", "6"], " ", 
                    SuperscriptBox["#1", "4"]}]}], "&"}], ",", "2"}], "]"}]}],
                 "-", 
                RowBox[{"3", " ", 
                 SuperscriptBox["psi2", "5"], " ", 
                 RowBox[{"Root", "[", 
                  RowBox[{
                   RowBox[{
                    RowBox[{
                    SuperscriptBox["\[Rho]", "4"], "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "8"}], "-", 
                    RowBox[{"24", " ", "\[Rho]"}], "-", 
                    RowBox[{"24", " ", "psi2", " ", "\[Rho]"}], "-", 
                    RowBox[{"24", " ", 
                    SuperscriptBox["\[Rho]", "2"]}], "-", 
                    RowBox[{"20", " ", "psi2", " ", 
                    SuperscriptBox["\[Rho]", "2"]}], "-", 
                    RowBox[{"24", " ", 
                    SuperscriptBox["psi2", "2"], " ", 
                    SuperscriptBox["\[Rho]", "2"]}], "-", 
                    RowBox[{"8", " ", 
                    SuperscriptBox["\[Rho]", "3"]}], "+", 
                    RowBox[{"4", " ", "psi2", " ", 
                    SuperscriptBox["\[Rho]", "3"]}], "+", 
                    RowBox[{"4", " ", 
                    SuperscriptBox["psi2", "2"], " ", 
                    SuperscriptBox["\[Rho]", "3"]}], "-", 
                    RowBox[{"8", " ", 
                    SuperscriptBox["psi2", "3"], " ", 
                    SuperscriptBox["\[Rho]", "3"]}]}], ")"}], " ", "#1"}], 
                    "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", "28"}], " ", 
                    SuperscriptBox["psi2", "2"]}], "-", 
                    RowBox[{"56", " ", 
                    SuperscriptBox["psi2", "2"], " ", "\[Rho]"}], "-", 
                    RowBox[{"56", " ", 
                    SuperscriptBox["psi2", "3"], " ", "\[Rho]"}], "-", 
                    RowBox[{"28", " ", 
                    SuperscriptBox["psi2", "2"], " ", 
                    SuperscriptBox["\[Rho]", "2"]}], "+", 
                    RowBox[{"80", " ", 
                    SuperscriptBox["psi2", "3"], " ", 
                    SuperscriptBox["\[Rho]", "2"]}], "-", 
                    RowBox[{"28", " ", 
                    SuperscriptBox["psi2", "4"], " ", 
                    SuperscriptBox["\[Rho]", "2"]}]}], ")"}], " ", 
                    SuperscriptBox["#1", "2"]}], "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", "16"}], " ", 
                    SuperscriptBox["psi2", "4"]}], "-", 
                    RowBox[{"16", " ", 
                    SuperscriptBox["psi2", "4"], " ", "\[Rho]"}], "-", 
                    RowBox[{"16", " ", 
                    SuperscriptBox["psi2", "5"], " ", "\[Rho]"}]}], ")"}], 
                    " ", 
                    SuperscriptBox["#1", "3"]}], "+", 
                    RowBox[{"16", " ", 
                    SuperscriptBox["psi2", "6"], " ", 
                    SuperscriptBox["#1", "4"]}]}], "&"}], ",", "2"}], "]"}]}],
                 "+", 
                RowBox[{
                 SuperscriptBox["psi2", "6"], " ", 
                 RowBox[{"Root", "[", 
                  RowBox[{
                   RowBox[{
                    RowBox[{
                    SuperscriptBox["\[Rho]", "4"], "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "8"}], "-", 
                    RowBox[{"24", " ", "\[Rho]"}], "-", 
                    RowBox[{"24", " ", "psi2", " ", "\[Rho]"}], "-", 
                    RowBox[{"24", " ", 
                    SuperscriptBox["\[Rho]", "2"]}], "-", 
                    RowBox[{"20", " ", "psi2", " ", 
                    SuperscriptBox["\[Rho]", "2"]}], "-", 
                    RowBox[{"24", " ", 
                    SuperscriptBox["psi2", "2"], " ", 
                    SuperscriptBox["\[Rho]", "2"]}], "-", 
                    RowBox[{"8", " ", 
                    SuperscriptBox["\[Rho]", "3"]}], "+", 
                    RowBox[{"4", " ", "psi2", " ", 
                    SuperscriptBox["\[Rho]", "3"]}], "+", 
                    RowBox[{"4", " ", 
                    SuperscriptBox["psi2", "2"], " ", 
                    SuperscriptBox["\[Rho]", "3"]}], "-", 
                    RowBox[{"8", " ", 
                    SuperscriptBox["psi2", "3"], " ", 
                    SuperscriptBox["\[Rho]", "3"]}]}], ")"}], " ", "#1"}], 
                    "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", "28"}], " ", 
                    SuperscriptBox["psi2", "2"]}], "-", 
                    RowBox[{"56", " ", 
                    SuperscriptBox["psi2", "2"], " ", "\[Rho]"}], "-", 
                    RowBox[{"56", " ", 
                    SuperscriptBox["psi2", "3"], " ", "\[Rho]"}], "-", 
                    RowBox[{"28", " ", 
                    SuperscriptBox["psi2", "2"], " ", 
                    SuperscriptBox["\[Rho]", "2"]}], "+", 
                    RowBox[{"80", " ", 
                    SuperscriptBox["psi2", "3"], " ", 
                    SuperscriptBox["\[Rho]", "2"]}], "-", 
                    RowBox[{"28", " ", 
                    SuperscriptBox["psi2", "4"], " ", 
                    SuperscriptBox["\[Rho]", "2"]}]}], ")"}], " ", 
                    SuperscriptBox["#1", "2"]}], "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", "16"}], " ", 
                    SuperscriptBox["psi2", "4"]}], "-", 
                    RowBox[{"16", " ", 
                    SuperscriptBox["psi2", "4"], " ", "\[Rho]"}], "-", 
                    RowBox[{"16", " ", 
                    SuperscriptBox["psi2", "5"], " ", "\[Rho]"}]}], ")"}], 
                    " ", 
                    SuperscriptBox["#1", "3"]}], "+", 
                    RowBox[{"16", " ", 
                    SuperscriptBox["psi2", "6"], " ", 
                    SuperscriptBox["#1", "4"]}]}], "&"}], ",", "2"}], "]"}]}],
                 "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"12", " ", "psi2"}], "+", 
                   RowBox[{"6", " ", 
                    SuperscriptBox["psi2", "3"], " ", 
                    RowBox[{"Root", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    SuperscriptBox["\[Rho]", "4"], "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "8"}], "-", 
                    RowBox[{"24", " ", "\[Rho]"}], "-", 
                    RowBox[{"24", " ", "psi2", " ", "\[Rho]"}], "-", 
                    RowBox[{"24", " ", 
                    SuperscriptBox["\[Rho]", "2"]}], "-", 
                    RowBox[{"20", " ", "psi2", " ", 
                    SuperscriptBox["\[Rho]", "2"]}], "-", 
                    RowBox[{"24", " ", 
                    SuperscriptBox["psi2", "2"], " ", 
                    SuperscriptBox["\[Rho]", "2"]}], "-", 
                    RowBox[{"8", " ", 
                    SuperscriptBox["\[Rho]", "3"]}], "+", 
                    RowBox[{"4", " ", "psi2", " ", 
                    SuperscriptBox["\[Rho]", "3"]}], "+", 
                    RowBox[{"4", " ", 
                    SuperscriptBox["psi2", "2"], " ", 
                    SuperscriptBox["\[Rho]", "3"]}], "-", 
                    RowBox[{"8", " ", 
                    SuperscriptBox["psi2", "3"], " ", 
                    SuperscriptBox["\[Rho]", "3"]}]}], ")"}], " ", "#1"}], 
                    "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", "28"}], " ", 
                    SuperscriptBox["psi2", "2"]}], "-", 
                    RowBox[{"56", " ", 
                    SuperscriptBox["psi2", "2"], " ", "\[Rho]"}], "-", 
                    RowBox[{"56", " ", 
                    SuperscriptBox["psi2", "3"], " ", "\[Rho]"}], "-", 
                    RowBox[{"28", " ", 
                    SuperscriptBox["psi2", "2"], " ", 
                    SuperscriptBox["\[Rho]", "2"]}], "+", 
                    RowBox[{"80", " ", 
                    SuperscriptBox["psi2", "3"], " ", 
                    SuperscriptBox["\[Rho]", "2"]}], "-", 
                    RowBox[{"28", " ", 
                    SuperscriptBox["psi2", "4"], " ", 
                    SuperscriptBox["\[Rho]", "2"]}]}], ")"}], " ", 
                    SuperscriptBox["#1", "2"]}], "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", "16"}], " ", 
                    SuperscriptBox["psi2", "4"]}], "-", 
                    RowBox[{"16", " ", 
                    SuperscriptBox["psi2", "4"], " ", "\[Rho]"}], "-", 
                    RowBox[{"16", " ", 
                    SuperscriptBox["psi2", "5"], " ", "\[Rho]"}]}], ")"}], 
                    " ", 
                    SuperscriptBox["#1", "3"]}], "+", 
                    RowBox[{"16", " ", 
                    SuperscriptBox["psi2", "6"], " ", 
                    SuperscriptBox["#1", "4"]}]}], "&"}], ",", "2"}], "]"}]}],
                    "-", 
                   RowBox[{"12", " ", 
                    SuperscriptBox["psi2", "4"], " ", 
                    RowBox[{"Root", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    SuperscriptBox["\[Rho]", "4"], "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "8"}], "-", 
                    RowBox[{"24", " ", "\[Rho]"}], "-", 
                    RowBox[{"24", " ", "psi2", " ", "\[Rho]"}], "-", 
                    RowBox[{"24", " ", 
                    SuperscriptBox["\[Rho]", "2"]}], "-", 
                    RowBox[{"20", " ", "psi2", " ", 
                    SuperscriptBox["\[Rho]", "2"]}], "-", 
                    RowBox[{"24", " ", 
                    SuperscriptBox["psi2", "2"], " ", 
                    SuperscriptBox["\[Rho]", "2"]}], "-", 
                    RowBox[{"8", " ", 
                    SuperscriptBox["\[Rho]", "3"]}], "+", 
                    RowBox[{"4", " ", "psi2", " ", 
                    SuperscriptBox["\[Rho]", "3"]}], "+", 
                    RowBox[{"4", " ", 
                    SuperscriptBox["psi2", "2"], " ", 
                    SuperscriptBox["\[Rho]", "3"]}], "-", 
                    RowBox[{"8", " ", 
                    SuperscriptBox["psi2", "3"], " ", 
                    SuperscriptBox["\[Rho]", "3"]}]}], ")"}], " ", "#1"}], 
                    "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", "28"}], " ", 
                    SuperscriptBox["psi2", "2"]}], "-", 
                    RowBox[{"56", " ", 
                    SuperscriptBox["psi2", "2"], " ", "\[Rho]"}], "-", 
                    RowBox[{"56", " ", 
                    SuperscriptBox["psi2", "3"], " ", "\[Rho]"}], "-", 
                    RowBox[{"28", " ", 
                    SuperscriptBox["psi2", "2"], " ", 
                    SuperscriptBox["\[Rho]", "2"]}], "+", 
                    RowBox[{"80", " ", 
                    SuperscriptBox["psi2", "3"], " ", 
                    SuperscriptBox["\[Rho]", "2"]}], "-", 
                    RowBox[{"28", " ", 
                    SuperscriptBox["psi2", "4"], " ", 
                    SuperscriptBox["\[Rho]", "2"]}]}], ")"}], " ", 
                    SuperscriptBox["#1", "2"]}], "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", "16"}], " ", 
                    SuperscriptBox["psi2", "4"]}], "-", 
                    RowBox[{"16", " ", 
                    SuperscriptBox["psi2", "4"], " ", "\[Rho]"}], "-", 
                    RowBox[{"16", " ", 
                    SuperscriptBox["psi2", "5"], " ", "\[Rho]"}]}], ")"}], 
                    " ", 
                    SuperscriptBox["#1", "3"]}], "+", 
                    RowBox[{"16", " ", 
                    SuperscriptBox["psi2", "6"], " ", 
                    SuperscriptBox["#1", "4"]}]}], "&"}], ",", "2"}], "]"}]}],
                    "+", 
                   RowBox[{"6", " ", 
                    SuperscriptBox["psi2", "5"], " ", 
                    RowBox[{"Root", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    SuperscriptBox["\[Rho]", "4"], "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "8"}], "-", 
                    RowBox[{"24", " ", "\[Rho]"}], "-", 
                    RowBox[{"24", " ", "psi2", " ", "\[Rho]"}], "-", 
                    RowBox[{"24", " ", 
                    SuperscriptBox["\[Rho]", "2"]}], "-", 
                    RowBox[{"20", " ", "psi2", " ", 
                    SuperscriptBox["\[Rho]", "2"]}], "-", 
                    RowBox[{"24", " ", 
                    SuperscriptBox["psi2", "2"], " ", 
                    SuperscriptBox["\[Rho]", "2"]}], "-", 
                    RowBox[{"8", " ", 
                    SuperscriptBox["\[Rho]", "3"]}], "+", 
                    RowBox[{"4", " ", "psi2", " ", 
                    SuperscriptBox["\[Rho]", "3"]}], "+", 
                    RowBox[{"4", " ", 
                    SuperscriptBox["psi2", "2"], " ", 
                    SuperscriptBox["\[Rho]", "3"]}], "-", 
                    RowBox[{"8", " ", 
                    SuperscriptBox["psi2", "3"], " ", 
                    SuperscriptBox["\[Rho]", "3"]}]}], ")"}], " ", "#1"}], 
                    "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", "28"}], " ", 
                    SuperscriptBox["psi2", "2"]}], "-", 
                    RowBox[{"56", " ", 
                    SuperscriptBox["psi2", "2"], " ", "\[Rho]"}], "-", 
                    RowBox[{"56", " ", 
                    SuperscriptBox["psi2", "3"], " ", "\[Rho]"}], "-", 
                    RowBox[{"28", " ", 
                    SuperscriptBox["psi2", "2"], " ", 
                    SuperscriptBox["\[Rho]", "2"]}], "+", 
                    RowBox[{"80", " ", 
                    SuperscriptBox["psi2", "3"], " ", 
                    SuperscriptBox["\[Rho]", "2"]}], "-", 
                    RowBox[{"28", " ", 
                    SuperscriptBox["psi2", "4"], " ", 
                    SuperscriptBox["\[Rho]", "2"]}]}], ")"}], " ", 
                    SuperscriptBox["#1", "2"]}], "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", "16"}], " ", 
                    SuperscriptBox["psi2", "4"]}], "-", 
                    RowBox[{"16", " ", 
                    SuperscriptBox["psi2", "4"], " ", "\[Rho]"}], "-", 
                    RowBox[{"16", " ", 
                    SuperscriptBox["psi2", "5"], " ", "\[Rho]"}]}], ")"}], 
                    " ", 
                    SuperscriptBox["#1", "3"]}], "+", 
                    RowBox[{"16", " ", 
                    SuperscriptBox["psi2", "6"], " ", 
                    SuperscriptBox["#1", "4"]}]}], "&"}], ",", "2"}], 
                    "]"}]}]}], ")"}], " ", "#1"}], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"6", "+", 
                   RowBox[{"6", " ", "\[Rho]"}], "-", 
                   RowBox[{"6", " ", "psi2", " ", "\[Rho]"}], "+", 
                   RowBox[{"3", " ", 
                    SuperscriptBox["psi2", "2"], " ", 
                    RowBox[{"Root", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    SuperscriptBox["\[Rho]", "4"], "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "8"}], "-", 
                    RowBox[{"24", " ", "\[Rho]"}], "-", 
                    RowBox[{"24", " ", "psi2", " ", "\[Rho]"}], "-", 
                    RowBox[{"24", " ", 
                    SuperscriptBox["\[Rho]", "2"]}], "-", 
                    RowBox[{"20", " ", "psi2", " ", 
                    SuperscriptBox["\[Rho]", "2"]}], "-", 
                    RowBox[{"24", " ", 
                    SuperscriptBox["psi2", "2"], " ", 
                    SuperscriptBox["\[Rho]", "2"]}], "-", 
                    RowBox[{"8", " ", 
                    SuperscriptBox["\[Rho]", "3"]}], "+", 
                    RowBox[{"4", " ", "psi2", " ", 
                    SuperscriptBox["\[Rho]", "3"]}], "+", 
                    RowBox[{"4", " ", 
                    SuperscriptBox["psi2", "2"], " ", 
                    SuperscriptBox["\[Rho]", "3"]}], "-", 
                    RowBox[{"8", " ", 
                    SuperscriptBox["psi2", "3"], " ", 
                    SuperscriptBox["\[Rho]", "3"]}]}], ")"}], " ", "#1"}], 
                    "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", "28"}], " ", 
                    SuperscriptBox["psi2", "2"]}], "-", 
                    RowBox[{"56", " ", 
                    SuperscriptBox["psi2", "2"], " ", "\[Rho]"}], "-", 
                    RowBox[{"56", " ", 
                    SuperscriptBox["psi2", "3"], " ", "\[Rho]"}], "-", 
                    RowBox[{"28", " ", 
                    SuperscriptBox["psi2", "2"], " ", 
                    SuperscriptBox["\[Rho]", "2"]}], "+", 
                    RowBox[{"80", " ", 
                    SuperscriptBox["psi2", "3"], " ", 
                    SuperscriptBox["\[Rho]", "2"]}], "-", 
                    RowBox[{"28", " ", 
                    SuperscriptBox["psi2", "4"], " ", 
                    SuperscriptBox["\[Rho]", "2"]}]}], ")"}], " ", 
                    SuperscriptBox["#1", "2"]}], "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", "16"}], " ", 
                    SuperscriptBox["psi2", "4"]}], "-", 
                    RowBox[{"16", " ", 
                    SuperscriptBox["psi2", "4"], " ", "\[Rho]"}], "-", 
                    RowBox[{"16", " ", 
                    SuperscriptBox["psi2", "5"], " ", "\[Rho]"}]}], ")"}], 
                    " ", 
                    SuperscriptBox["#1", "3"]}], "+", 
                    RowBox[{"16", " ", 
                    SuperscriptBox["psi2", "6"], " ", 
                    SuperscriptBox["#1", "4"]}]}], "&"}], ",", "2"}], "]"}]}],
                    "-", 
                   RowBox[{"18", " ", 
                    SuperscriptBox["psi2", "3"], " ", 
                    RowBox[{"Root", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    SuperscriptBox["\[Rho]", "4"], "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "8"}], "-", 
                    RowBox[{"24", " ", "\[Rho]"}], "-", 
                    RowBox[{"24", " ", "psi2", " ", "\[Rho]"}], "-", 
                    RowBox[{"24", " ", 
                    SuperscriptBox["\[Rho]", "2"]}], "-", 
                    RowBox[{"20", " ", "psi2", " ", 
                    SuperscriptBox["\[Rho]", "2"]}], "-", 
                    RowBox[{"24", " ", 
                    SuperscriptBox["psi2", "2"], " ", 
                    SuperscriptBox["\[Rho]", "2"]}], "-", 
                    RowBox[{"8", " ", 
                    SuperscriptBox["\[Rho]", "3"]}], "+", 
                    RowBox[{"4", " ", "psi2", " ", 
                    SuperscriptBox["\[Rho]", "3"]}], "+", 
                    RowBox[{"4", " ", 
                    SuperscriptBox["psi2", "2"], " ", 
                    SuperscriptBox["\[Rho]", "3"]}], "-", 
                    RowBox[{"8", " ", 
                    SuperscriptBox["psi2", "3"], " ", 
                    SuperscriptBox["\[Rho]", "3"]}]}], ")"}], " ", "#1"}], 
                    "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", "28"}], " ", 
                    SuperscriptBox["psi2", "2"]}], "-", 
                    RowBox[{"56", " ", 
                    SuperscriptBox["psi2", "2"], " ", "\[Rho]"}], "-", 
                    RowBox[{"56", " ", 
                    SuperscriptBox["psi2", "3"], " ", "\[Rho]"}], "-", 
                    RowBox[{"28", " ", 
                    SuperscriptBox["psi2", "2"], " ", 
                    SuperscriptBox["\[Rho]", "2"]}], "+", 
                    RowBox[{"80", " ", 
                    SuperscriptBox["psi2", "3"], " ", 
                    SuperscriptBox["\[Rho]", "2"]}], "-", 
                    RowBox[{"28", " ", 
                    SuperscriptBox["psi2", "4"], " ", 
                    SuperscriptBox["\[Rho]", "2"]}]}], ")"}], " ", 
                    SuperscriptBox["#1", "2"]}], "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", "16"}], " ", 
                    SuperscriptBox["psi2", "4"]}], "-", 
                    RowBox[{"16", " ", 
                    SuperscriptBox["psi2", "4"], " ", "\[Rho]"}], "-", 
                    RowBox[{"16", " ", 
                    SuperscriptBox["psi2", "5"], " ", "\[Rho]"}]}], ")"}], 
                    " ", 
                    SuperscriptBox["#1", "3"]}], "+", 
                    RowBox[{"16", " ", 
                    SuperscriptBox["psi2", "6"], " ", 
                    SuperscriptBox["#1", "4"]}]}], "&"}], ",", "2"}], "]"}]}],
                    "+", 
                   RowBox[{"15", " ", 
                    SuperscriptBox["psi2", "4"], " ", 
                    RowBox[{"Root", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    SuperscriptBox["\[Rho]", "4"], "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "8"}], "-", 
                    RowBox[{"24", " ", "\[Rho]"}], "-", 
                    RowBox[{"24", " ", "psi2", " ", "\[Rho]"}], "-", 
                    RowBox[{"24", " ", 
                    SuperscriptBox["\[Rho]", "2"]}], "-", 
                    RowBox[{"20", " ", "psi2", " ", 
                    SuperscriptBox["\[Rho]", "2"]}], "-", 
                    RowBox[{"24", " ", 
                    SuperscriptBox["psi2", "2"], " ", 
                    SuperscriptBox["\[Rho]", "2"]}], "-", 
                    RowBox[{"8", " ", 
                    SuperscriptBox["\[Rho]", "3"]}], "+", 
                    RowBox[{"4", " ", "psi2", " ", 
                    SuperscriptBox["\[Rho]", "3"]}], "+", 
                    RowBox[{"4", " ", 
                    SuperscriptBox["psi2", "2"], " ", 
                    SuperscriptBox["\[Rho]", "3"]}], "-", 
                    RowBox[{"8", " ", 
                    SuperscriptBox["psi2", "3"], " ", 
                    SuperscriptBox["\[Rho]", "3"]}]}], ")"}], " ", "#1"}], 
                    "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", "28"}], " ", 
                    SuperscriptBox["psi2", "2"]}], "-", 
                    RowBox[{"56", " ", 
                    SuperscriptBox["psi2", "2"], " ", "\[Rho]"}], "-", 
                    RowBox[{"56", " ", 
                    SuperscriptBox["psi2", "3"], " ", "\[Rho]"}], "-", 
                    RowBox[{"28", " ", 
                    SuperscriptBox["psi2", "2"], " ", 
                    SuperscriptBox["\[Rho]", "2"]}], "+", 
                    RowBox[{"80", " ", 
                    SuperscriptBox["psi2", "3"], " ", 
                    SuperscriptBox["\[Rho]", "2"]}], "-", 
                    RowBox[{"28", " ", 
                    SuperscriptBox["psi2", "4"], " ", 
                    SuperscriptBox["\[Rho]", "2"]}]}], ")"}], " ", 
                    SuperscriptBox["#1", "2"]}], "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", "16"}], " ", 
                    SuperscriptBox["psi2", "4"]}], "-", 
                    RowBox[{"16", " ", 
                    SuperscriptBox["psi2", "4"], " ", "\[Rho]"}], "-", 
                    RowBox[{"16", " ", 
                    SuperscriptBox["psi2", "5"], " ", "\[Rho]"}]}], ")"}], 
                    " ", 
                    SuperscriptBox["#1", "3"]}], "+", 
                    RowBox[{"16", " ", 
                    SuperscriptBox["psi2", "6"], " ", 
                    SuperscriptBox["#1", "4"]}]}], "&"}], ",", "2"}], 
                    "]"}]}]}], ")"}], " ", 
                 SuperscriptBox["#1", "2"]}], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"-", "4"}], " ", "\[Rho]"}], "-", 
                   RowBox[{"12", " ", 
                    SuperscriptBox["psi2", "2"], " ", 
                    RowBox[{"Root", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    SuperscriptBox["\[Rho]", "4"], "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "8"}], "-", 
                    RowBox[{"24", " ", "\[Rho]"}], "-", 
                    RowBox[{"24", " ", "psi2", " ", "\[Rho]"}], "-", 
                    RowBox[{"24", " ", 
                    SuperscriptBox["\[Rho]", "2"]}], "-", 
                    RowBox[{"20", " ", "psi2", " ", 
                    SuperscriptBox["\[Rho]", "2"]}], "-", 
                    RowBox[{"24", " ", 
                    SuperscriptBox["psi2", "2"], " ", 
                    SuperscriptBox["\[Rho]", "2"]}], "-", 
                    RowBox[{"8", " ", 
                    SuperscriptBox["\[Rho]", "3"]}], "+", 
                    RowBox[{"4", " ", "psi2", " ", 
                    SuperscriptBox["\[Rho]", "3"]}], "+", 
                    RowBox[{"4", " ", 
                    SuperscriptBox["psi2", "2"], " ", 
                    SuperscriptBox["\[Rho]", "3"]}], "-", 
                    RowBox[{"8", " ", 
                    SuperscriptBox["psi2", "3"], " ", 
                    SuperscriptBox["\[Rho]", "3"]}]}], ")"}], " ", "#1"}], 
                    "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", "28"}], " ", 
                    SuperscriptBox["psi2", "2"]}], "-", 
                    RowBox[{"56", " ", 
                    SuperscriptBox["psi2", "2"], " ", "\[Rho]"}], "-", 
                    RowBox[{"56", " ", 
                    SuperscriptBox["psi2", "3"], " ", "\[Rho]"}], "-", 
                    RowBox[{"28", " ", 
                    SuperscriptBox["psi2", "2"], " ", 
                    SuperscriptBox["\[Rho]", "2"]}], "+", 
                    RowBox[{"80", " ", 
                    SuperscriptBox["psi2", "3"], " ", 
                    SuperscriptBox["\[Rho]", "2"]}], "-", 
                    RowBox[{"28", " ", 
                    SuperscriptBox["psi2", "4"], " ", 
                    SuperscriptBox["\[Rho]", "2"]}]}], ")"}], " ", 
                    SuperscriptBox["#1", "2"]}], "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", "16"}], " ", 
                    SuperscriptBox["psi2", "4"]}], "-", 
                    RowBox[{"16", " ", 
                    SuperscriptBox["psi2", "4"], " ", "\[Rho]"}], "-", 
                    RowBox[{"16", " ", 
                    SuperscriptBox["psi2", "5"], " ", "\[Rho]"}]}], ")"}], 
                    " ", 
                    SuperscriptBox["#1", "3"]}], "+", 
                    RowBox[{"16", " ", 
                    SuperscriptBox["psi2", "6"], " ", 
                    SuperscriptBox["#1", "4"]}]}], "&"}], ",", "2"}], "]"}]}],
                    "+", 
                   RowBox[{"20", " ", 
                    SuperscriptBox["psi2", "3"], " ", 
                    RowBox[{"Root", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    SuperscriptBox["\[Rho]", "4"], "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "8"}], "-", 
                    RowBox[{"24", " ", "\[Rho]"}], "-", 
                    RowBox[{"24", " ", "psi2", " ", "\[Rho]"}], "-", 
                    RowBox[{"24", " ", 
                    SuperscriptBox["\[Rho]", "2"]}], "-", 
                    RowBox[{"20", " ", "psi2", " ", 
                    SuperscriptBox["\[Rho]", "2"]}], "-", 
                    RowBox[{"24", " ", 
                    SuperscriptBox["psi2", "2"], " ", 
                    SuperscriptBox["\[Rho]", "2"]}], "-", 
                    RowBox[{"8", " ", 
                    SuperscriptBox["\[Rho]", "3"]}], "+", 
                    RowBox[{"4", " ", "psi2", " ", 
                    SuperscriptBox["\[Rho]", "3"]}], "+", 
                    RowBox[{"4", " ", 
                    SuperscriptBox["psi2", "2"], " ", 
                    SuperscriptBox["\[Rho]", "3"]}], "-", 
                    RowBox[{"8", " ", 
                    SuperscriptBox["psi2", "3"], " ", 
                    SuperscriptBox["\[Rho]", "3"]}]}], ")"}], " ", "#1"}], 
                    "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", "28"}], " ", 
                    SuperscriptBox["psi2", "2"]}], "-", 
                    RowBox[{"56", " ", 
                    SuperscriptBox["psi2", "2"], " ", "\[Rho]"}], "-", 
                    RowBox[{"56", " ", 
                    SuperscriptBox["psi2", "3"], " ", "\[Rho]"}], "-", 
                    RowBox[{"28", " ", 
                    SuperscriptBox["psi2", "2"], " ", 
                    SuperscriptBox["\[Rho]", "2"]}], "+", 
                    RowBox[{"80", " ", 
                    SuperscriptBox["psi2", "3"], " ", 
                    SuperscriptBox["\[Rho]", "2"]}], "-", 
                    RowBox[{"28", " ", 
                    SuperscriptBox["psi2", "4"], " ", 
                    SuperscriptBox["\[Rho]", "2"]}]}], ")"}], " ", 
                    SuperscriptBox["#1", "2"]}], "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", "16"}], " ", 
                    SuperscriptBox["psi2", "4"]}], "-", 
                    RowBox[{"16", " ", 
                    SuperscriptBox["psi2", "4"], " ", "\[Rho]"}], "-", 
                    RowBox[{"16", " ", 
                    SuperscriptBox["psi2", "5"], " ", "\[Rho]"}]}], ")"}], 
                    " ", 
                    SuperscriptBox["#1", "3"]}], "+", 
                    RowBox[{"16", " ", 
                    SuperscriptBox["psi2", "6"], " ", 
                    SuperscriptBox["#1", "4"]}]}], "&"}], ",", "2"}], 
                    "]"}]}]}], ")"}], " ", 
                 SuperscriptBox["#1", "3"]}], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"-", "3"}], " ", "psi2", " ", 
                    RowBox[{"Root", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    SuperscriptBox["\[Rho]", "4"], "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "8"}], "-", 
                    RowBox[{"24", " ", "\[Rho]"}], "-", 
                    RowBox[{"24", " ", "psi2", " ", "\[Rho]"}], "-", 
                    RowBox[{"24", " ", 
                    SuperscriptBox["\[Rho]", "2"]}], "-", 
                    RowBox[{"20", " ", "psi2", " ", 
                    SuperscriptBox["\[Rho]", "2"]}], "-", 
                    RowBox[{"24", " ", 
                    SuperscriptBox["psi2", "2"], " ", 
                    SuperscriptBox["\[Rho]", "2"]}], "-", 
                    RowBox[{"8", " ", 
                    SuperscriptBox["\[Rho]", "3"]}], "+", 
                    RowBox[{"4", " ", "psi2", " ", 
                    SuperscriptBox["\[Rho]", "3"]}], "+", 
                    RowBox[{"4", " ", 
                    SuperscriptBox["psi2", "2"], " ", 
                    SuperscriptBox["\[Rho]", "3"]}], "-", 
                    RowBox[{"8", " ", 
                    SuperscriptBox["psi2", "3"], " ", 
                    SuperscriptBox["\[Rho]", "3"]}]}], ")"}], " ", "#1"}], 
                    "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", "28"}], " ", 
                    SuperscriptBox["psi2", "2"]}], "-", 
                    RowBox[{"56", " ", 
                    SuperscriptBox["psi2", "2"], " ", "\[Rho]"}], "-", 
                    RowBox[{"56", " ", 
                    SuperscriptBox["psi2", "3"], " ", "\[Rho]"}], "-", 
                    RowBox[{"28", " ", 
                    SuperscriptBox["psi2", "2"], " ", 
                    SuperscriptBox["\[Rho]", "2"]}], "+", 
                    RowBox[{"80", " ", 
                    SuperscriptBox["psi2", "3"], " ", 
                    SuperscriptBox["\[Rho]", "2"]}], "-", 
                    RowBox[{"28", " ", 
                    SuperscriptBox["psi2", "4"], " ", 
                    SuperscriptBox["\[Rho]", "2"]}]}], ")"}], " ", 
                    SuperscriptBox["#1", "2"]}], "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", "16"}], " ", 
                    SuperscriptBox["psi2", "4"]}], "-", 
                    RowBox[{"16", " ", 
                    SuperscriptBox["psi2", "4"], " ", "\[Rho]"}], "-", 
                    RowBox[{"16", " ", 
                    SuperscriptBox["psi2", "5"], " ", "\[Rho]"}]}], ")"}], 
                    " ", 
                    SuperscriptBox["#1", "3"]}], "+", 
                    RowBox[{"16", " ", 
                    SuperscriptBox["psi2", "6"], " ", 
                    SuperscriptBox["#1", "4"]}]}], "&"}], ",", "2"}], "]"}]}],
                    "+", 
                   RowBox[{"15", " ", 
                    SuperscriptBox["psi2", "2"], " ", 
                    RowBox[{"Root", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    SuperscriptBox["\[Rho]", "4"], "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "8"}], "-", 
                    RowBox[{"24", " ", "\[Rho]"}], "-", 
                    RowBox[{"24", " ", "psi2", " ", "\[Rho]"}], "-", 
                    RowBox[{"24", " ", 
                    SuperscriptBox["\[Rho]", "2"]}], "-", 
                    RowBox[{"20", " ", "psi2", " ", 
                    SuperscriptBox["\[Rho]", "2"]}], "-", 
                    RowBox[{"24", " ", 
                    SuperscriptBox["psi2", "2"], " ", 
                    SuperscriptBox["\[Rho]", "2"]}], "-", 
                    RowBox[{"8", " ", 
                    SuperscriptBox["\[Rho]", "3"]}], "+", 
                    RowBox[{"4", " ", "psi2", " ", 
                    SuperscriptBox["\[Rho]", "3"]}], "+", 
                    RowBox[{"4", " ", 
                    SuperscriptBox["psi2", "2"], " ", 
                    SuperscriptBox["\[Rho]", "3"]}], "-", 
                    RowBox[{"8", " ", 
                    SuperscriptBox["psi2", "3"], " ", 
                    SuperscriptBox["\[Rho]", "3"]}]}], ")"}], " ", "#1"}], 
                    "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", "28"}], " ", 
                    SuperscriptBox["psi2", "2"]}], "-", 
                    RowBox[{"56", " ", 
                    SuperscriptBox["psi2", "2"], " ", "\[Rho]"}], "-", 
                    RowBox[{"56", " ", 
                    SuperscriptBox["psi2", "3"], " ", "\[Rho]"}], "-", 
                    RowBox[{"28", " ", 
                    SuperscriptBox["psi2", "2"], " ", 
                    SuperscriptBox["\[Rho]", "2"]}], "+", 
                    RowBox[{"80", " ", 
                    SuperscriptBox["psi2", "3"], " ", 
                    SuperscriptBox["\[Rho]", "2"]}], "-", 
                    RowBox[{"28", " ", 
                    SuperscriptBox["psi2", "4"], " ", 
                    SuperscriptBox["\[Rho]", "2"]}]}], ")"}], " ", 
                    SuperscriptBox["#1", "2"]}], "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", "16"}], " ", 
                    SuperscriptBox["psi2", "4"]}], "-", 
                    RowBox[{"16", " ", 
                    SuperscriptBox["psi2", "4"], " ", "\[Rho]"}], "-", 
                    RowBox[{"16", " ", 
                    SuperscriptBox["psi2", "5"], " ", "\[Rho]"}]}], ")"}], 
                    " ", 
                    SuperscriptBox["#1", "3"]}], "+", 
                    RowBox[{"16", " ", 
                    SuperscriptBox["psi2", "6"], " ", 
                    SuperscriptBox["#1", "4"]}]}], "&"}], ",", "2"}], 
                    "]"}]}]}], ")"}], " ", 
                 SuperscriptBox["#1", "4"]}], "+", 
                RowBox[{"6", " ", "psi2", " ", 
                 RowBox[{"Root", "[", 
                  RowBox[{
                   RowBox[{
                    RowBox[{
                    SuperscriptBox["\[Rho]", "4"], "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "8"}], "-", 
                    RowBox[{"24", " ", "\[Rho]"}], "-", 
                    RowBox[{"24", " ", "psi2", " ", "\[Rho]"}], "-", 
                    RowBox[{"24", " ", 
                    SuperscriptBox["\[Rho]", "2"]}], "-", 
                    RowBox[{"20", " ", "psi2", " ", 
                    SuperscriptBox["\[Rho]", "2"]}], "-", 
                    RowBox[{"24", " ", 
                    SuperscriptBox["psi2", "2"], " ", 
                    SuperscriptBox["\[Rho]", "2"]}], "-", 
                    RowBox[{"8", " ", 
                    SuperscriptBox["\[Rho]", "3"]}], "+", 
                    RowBox[{"4", " ", "psi2", " ", 
                    SuperscriptBox["\[Rho]", "3"]}], "+", 
                    RowBox[{"4", " ", 
                    SuperscriptBox["psi2", "2"], " ", 
                    SuperscriptBox["\[Rho]", "3"]}], "-", 
                    RowBox[{"8", " ", 
                    SuperscriptBox["psi2", "3"], " ", 
                    SuperscriptBox["\[Rho]", "3"]}]}], ")"}], " ", "#1"}], 
                    "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", "28"}], " ", 
                    SuperscriptBox["psi2", "2"]}], "-", 
                    RowBox[{"56", " ", 
                    SuperscriptBox["psi2", "2"], " ", "\[Rho]"}], "-", 
                    RowBox[{"56", " ", 
                    SuperscriptBox["psi2", "3"], " ", "\[Rho]"}], "-", 
                    RowBox[{"28", " ", 
                    SuperscriptBox["psi2", "2"], " ", 
                    SuperscriptBox["\[Rho]", "2"]}], "+", 
                    RowBox[{"80", " ", 
                    SuperscriptBox["psi2", "3"], " ", 
                    SuperscriptBox["\[Rho]", "2"]}], "-", 
                    RowBox[{"28", " ", 
                    SuperscriptBox["psi2", "4"], " ", 
                    SuperscriptBox["\[Rho]", "2"]}]}], ")"}], " ", 
                    SuperscriptBox["#1", "2"]}], "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", "16"}], " ", 
                    SuperscriptBox["psi2", "4"]}], "-", 
                    RowBox[{"16", " ", 
                    SuperscriptBox["psi2", "4"], " ", "\[Rho]"}], "-", 
                    RowBox[{"16", " ", 
                    SuperscriptBox["psi2", "5"], " ", "\[Rho]"}]}], ")"}], 
                    " ", 
                    SuperscriptBox["#1", "3"]}], "+", 
                    RowBox[{"16", " ", 
                    SuperscriptBox["psi2", "6"], " ", 
                    SuperscriptBox["#1", "4"]}]}], "&"}], ",", "2"}], "]"}], 
                 " ", 
                 SuperscriptBox["#1", "5"]}], "+", 
                RowBox[{
                 RowBox[{"Root", "[", 
                  RowBox[{
                   RowBox[{
                    RowBox[{
                    SuperscriptBox["\[Rho]", "4"], "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "8"}], "-", 
                    RowBox[{"24", " ", "\[Rho]"}], "-", 
                    RowBox[{"24", " ", "psi2", " ", "\[Rho]"}], "-", 
                    RowBox[{"24", " ", 
                    SuperscriptBox["\[Rho]", "2"]}], "-", 
                    RowBox[{"20", " ", "psi2", " ", 
                    SuperscriptBox["\[Rho]", "2"]}], "-", 
                    RowBox[{"24", " ", 
                    SuperscriptBox["psi2", "2"], " ", 
                    SuperscriptBox["\[Rho]", "2"]}], "-", 
                    RowBox[{"8", " ", 
                    SuperscriptBox["\[Rho]", "3"]}], "+", 
                    RowBox[{"4", " ", "psi2", " ", 
                    SuperscriptBox["\[Rho]", "3"]}], "+", 
                    RowBox[{"4", " ", 
                    SuperscriptBox["psi2", "2"], " ", 
                    SuperscriptBox["\[Rho]", "3"]}], "-", 
                    RowBox[{"8", " ", 
                    SuperscriptBox["psi2", "3"], " ", 
                    SuperscriptBox["\[Rho]", "3"]}]}], ")"}], " ", "#1"}], 
                    "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", "28"}], " ", 
                    SuperscriptBox["psi2", "2"]}], "-", 
                    RowBox[{"56", " ", 
                    SuperscriptBox["psi2", "2"], " ", "\[Rho]"}], "-", 
                    RowBox[{"56", " ", 
                    SuperscriptBox["psi2", "3"], " ", "\[Rho]"}], "-", 
                    RowBox[{"28", " ", 
                    SuperscriptBox["psi2", "2"], " ", 
                    SuperscriptBox["\[Rho]", "2"]}], "+", 
                    RowBox[{"80", " ", 
                    SuperscriptBox["psi2", "3"], " ", 
                    SuperscriptBox["\[Rho]", "2"]}], "-", 
                    RowBox[{"28", " ", 
                    SuperscriptBox["psi2", "4"], " ", 
                    SuperscriptBox["\[Rho]", "2"]}]}], ")"}], " ", 
                    SuperscriptBox["#1", "2"]}], "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", "16"}], " ", 
                    SuperscriptBox["psi2", "4"]}], "-", 
                    RowBox[{"16", " ", 
                    SuperscriptBox["psi2", "4"], " ", "\[Rho]"}], "-", 
                    RowBox[{"16", " ", 
                    SuperscriptBox["psi2", "5"], " ", "\[Rho]"}]}], ")"}], 
                    " ", 
                    SuperscriptBox["#1", "3"]}], "+", 
                    RowBox[{"16", " ", 
                    SuperscriptBox["psi2", "6"], " ", 
                    SuperscriptBox["#1", "4"]}]}], "&"}], ",", "2"}], "]"}], 
                 " ", 
                 SuperscriptBox["#1", "6"]}]}], "&"}], ",", "1"}], "]"}], 
            RowBox[{
             RowBox[{"psi2", ">", "0"}], "&&", 
             RowBox[{"\[Rho]", ">", "0"}], "&&", 
             RowBox[{"Fs", "\[GreaterEqual]", "0"}], "&&", 
             RowBox[{"F1", "\[GreaterEqual]", "0"}]}]},
           {"Indeterminate", 
            TagBox["True",
             "PiecewiseDefault",
             AutoDelete->True]}
          },
          AllowedDimensions->{2, Automatic},
          Editable->True,
          GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Baseline}}},
          GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{1.}}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.84]}, 
              Offset[0.27999999999999997`]}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}},
          Selectable->True]}
       },
       GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Baseline}}},
       GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{1.}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.35]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      "Piecewise",
      DeleteWithContents->True,
      Editable->False,
      SelectWithContents->True,
      Selectable->False,
      StripWrapperBoxes->True]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.8690008499617853`*^9},
 CellLabel->"Out[69]=",ExpressionUUID->"7ecdb9c5-97e1-46d1-86ee-1db273e005bc"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"polu2Fspsi2", "=", 
   RowBox[{
    RowBox[{
     SuperscriptBox["\[Rho]", "4"], "+", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "8"}], "-", 
        RowBox[{"24", " ", "\[Rho]"}], "-", 
        RowBox[{"24", " ", "psi2", " ", "\[Rho]"}], "-", 
        RowBox[{"24", " ", 
         SuperscriptBox["\[Rho]", "2"]}], "-", 
        RowBox[{"20", " ", "psi2", " ", 
         SuperscriptBox["\[Rho]", "2"]}], "-", 
        RowBox[{"24", " ", 
         SuperscriptBox["psi2", "2"], " ", 
         SuperscriptBox["\[Rho]", "2"]}], "-", 
        RowBox[{"8", " ", 
         SuperscriptBox["\[Rho]", "3"]}], "+", 
        RowBox[{"4", " ", "psi2", " ", 
         SuperscriptBox["\[Rho]", "3"]}], "+", 
        RowBox[{"4", " ", 
         SuperscriptBox["psi2", "2"], " ", 
         SuperscriptBox["\[Rho]", "3"]}], "-", 
        RowBox[{"8", " ", 
         SuperscriptBox["psi2", "3"], " ", 
         SuperscriptBox["\[Rho]", "3"]}]}], ")"}], " ", "#1"}], "+", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "28"}], " ", 
         SuperscriptBox["psi2", "2"]}], "-", 
        RowBox[{"56", " ", 
         SuperscriptBox["psi2", "2"], " ", "\[Rho]"}], "-", 
        RowBox[{"56", " ", 
         SuperscriptBox["psi2", "3"], " ", "\[Rho]"}], "-", 
        RowBox[{"28", " ", 
         SuperscriptBox["psi2", "2"], " ", 
         SuperscriptBox["\[Rho]", "2"]}], "+", 
        RowBox[{"80", " ", 
         SuperscriptBox["psi2", "3"], " ", 
         SuperscriptBox["\[Rho]", "2"]}], "-", 
        RowBox[{"28", " ", 
         SuperscriptBox["psi2", "4"], " ", 
         SuperscriptBox["\[Rho]", "2"]}]}], ")"}], " ", 
      SuperscriptBox["#1", "2"]}], "+", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "16"}], " ", 
         SuperscriptBox["psi2", "4"]}], "-", 
        RowBox[{"16", " ", 
         SuperscriptBox["psi2", "4"], " ", "\[Rho]"}], "-", 
        RowBox[{"16", " ", 
         SuperscriptBox["psi2", "5"], " ", "\[Rho]"}]}], ")"}], " ", 
      SuperscriptBox["#1", "3"]}], "+", 
     RowBox[{"16", " ", 
      SuperscriptBox["psi2", "6"], " ", 
      SuperscriptBox["#1", "4"]}]}], "&"}]}], ";"}]], "Input",
 CellLabel->"In[70]:=",ExpressionUUID->"a507afaa-17e9-42a5-9e23-ee1f289b6979"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"CoefficientList", "[", 
    RowBox[{
     RowBox[{"polu2Fspsi2", "[", "x", "]"}], ",", "x"}], "]"}], "/.", 
   RowBox[{"{", 
    RowBox[{"psi2", "\[Rule]", 
     SubscriptBox["\[Psi]", "2"]}], "}"}]}], "//", "FullSimplify"}]], "Input",\

 CellLabel->"In[71]:=",ExpressionUUID->"4d874e25-c487-4cbc-bad4-7782a9e14ede"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   SuperscriptBox["\[Rho]", "4"], ",", 
   RowBox[{
    RowBox[{"-", "4"}], " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", "\[Rho]", "+", 
      RowBox[{"\[Rho]", " ", 
       SubscriptBox["\[Psi]", "2"]}]}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"2", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "+", "\[Rho]"}], ")"}], "2"]}], "+", 
      RowBox[{"\[Rho]", " ", 
       SubscriptBox["\[Psi]", "2"], " ", 
       RowBox[{"(", 
        RowBox[{"4", "-", 
         RowBox[{"3", " ", "\[Rho]"}], "+", 
         RowBox[{"2", " ", "\[Rho]", " ", 
          SubscriptBox["\[Psi]", "2"]}]}], ")"}]}]}], ")"}]}], ",", 
   RowBox[{
    RowBox[{"-", "4"}], " ", 
    SubsuperscriptBox["\[Psi]", "2", "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"7", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "+", "\[Rho]"}], ")"}], "2"]}], "+", 
      RowBox[{"\[Rho]", " ", 
       SubscriptBox["\[Psi]", "2"], " ", 
       RowBox[{"(", 
        RowBox[{"14", "-", 
         RowBox[{"20", " ", "\[Rho]"}], "+", 
         RowBox[{"7", " ", "\[Rho]", " ", 
          SubscriptBox["\[Psi]", "2"]}]}], ")"}]}]}], ")"}]}], ",", 
   RowBox[{
    RowBox[{"-", "16"}], " ", 
    SubsuperscriptBox["\[Psi]", "2", "4"], " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", "\[Rho]", "+", 
      RowBox[{"\[Rho]", " ", 
       SubscriptBox["\[Psi]", "2"]}]}], ")"}]}], ",", 
   RowBox[{"16", " ", 
    SubsuperscriptBox["\[Psi]", "2", "6"]}]}], "}"}]], "Output",
 CellChangeTimes->{3.869000921435473*^9},
 CellLabel->"Out[71]=",ExpressionUUID->"66ecd957-5f20-42a7-a19c-943c121747d2"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{"Calculation", " ", "for", " ", "beta_", "2"}], "*)"}]], "Input",
 CellChangeTimes->{{3.869001024732991*^9, 3.869001027001926*^9}, {
  3.8690012093202953`*^9, 3.8690012382369137`*^9}, {3.869001674923245*^9, 
  3.869001675023905*^9}, {3.869351835516719*^9, 
  3.8693518361136837`*^9}},ExpressionUUID->"b0e7f97b-6aa9-4a32-bef8-\
651e87a7868c"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Solve", "[", 
   RowBox[{
    RowBox[{
     FractionBox[
      RowBox[{"2", " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["Fs", "2"], "+", 
         RowBox[{
          SuperscriptBox["F1", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"1", "+", "psi2"}], ")"}]}]}], ")"}]}], "psi2"], "==", 
     FractionBox[
      RowBox[{"2", " ", 
       SuperscriptBox["F1", "2"], " ", "\[Alpha]"}], 
      RowBox[{"psi1", "-", "psi2"}]]}], ",", "psi1"}], "]"}], "//", 
  "FullSimplify"}]], "Input",
 CellLabel->"In[72]:=",ExpressionUUID->"d48dc483-3ac5-4693-8b4d-811504cd1fcb"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"psi1", "\[Rule]", 
    RowBox[{"psi2", "+", 
     FractionBox[
      RowBox[{
       SuperscriptBox["F1", "2"], " ", "psi2", " ", "\[Alpha]"}], 
      RowBox[{
       SuperscriptBox["Fs", "2"], "+", 
       RowBox[{
        SuperscriptBox["F1", "2"], " ", 
        RowBox[{"(", 
         RowBox[{"1", "+", "psi2"}], ")"}]}]}]]}]}], "}"}], "}"}]], "Output",
 CellChangeTimes->{3.869001592353341*^9},
 CellLabel->"Out[72]=",ExpressionUUID->"1315a790-15ae-4222-91da-f935e4094645"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{"Calculation", " ", "for", " ", "beta_", "3"}], "*)"}]], "Input",
 CellChangeTimes->{{3.8690016019546824`*^9, 3.869001602084511*^9}, {
  3.869351837567844*^9, 
  3.8693518380366907`*^9}},ExpressionUUID->"12b65ea3-b756-4073-b1de-\
3b28d066e22b"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"Solve", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      FractionBox[
       RowBox[{"2", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           SuperscriptBox["F1", "2"], " ", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", "psi2"}], ")"}], "2"]}], "+", 
          RowBox[{
           SuperscriptBox["Fs", "2"], " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", 
             RowBox[{"3", " ", "psi2"}]}], ")"}]}]}], ")"}]}], 
       RowBox[{
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "+", "psi2"}], ")"}], "3"], " ", "psi2"}]]}], "==", 
     FractionBox[
      RowBox[{"2", " ", 
       SuperscriptBox["F1", "2"], " ", "\[Alpha]"}], 
      RowBox[{"psi1", "-", "psi2"}]]}], ",", "psi1"}], "]"}], "//", 
  "FullSimplify"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Solve", "[", 
   RowBox[{
    RowBox[{
     FractionBox[
      RowBox[{"2", " ", "psi2", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SuperscriptBox["F1", "2"], " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", "psi2"}], ")"}], "2"]}], "+", 
         RowBox[{
          SuperscriptBox["Fs", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"3", "+", "psi2"}], ")"}]}]}], ")"}]}], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "psi2"}], ")"}], "3"]], "==", 
     FractionBox[
      RowBox[{"2", " ", 
       SuperscriptBox["F1", "2"], " ", "\[Alpha]"}], 
      RowBox[{"psi1", "-", "psi2"}]]}], ",", "psi1"}], "]"}], "//", 
  "FullSimplify"}]}], "Input",
 CellChangeTimes->{{3.869001641109598*^9, 3.869001641694344*^9}},
 CellLabel->"In[73]:=",ExpressionUUID->"c5433707-b2ad-488a-8518-dc3002e1fe32"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"psi1", "\[Rule]", 
    RowBox[{"psi2", "-", 
     FractionBox[
      RowBox[{
       SuperscriptBox["F1", "2"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "psi2"}], ")"}], "3"], " ", "psi2", " ", 
       "\[Alpha]"}], 
      RowBox[{
       RowBox[{
        SuperscriptBox["F1", "2"], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "+", "psi2"}], ")"}], "2"]}], "+", 
       RowBox[{
        SuperscriptBox["Fs", "2"], " ", 
        RowBox[{"(", 
         RowBox[{"1", "+", 
          RowBox[{"3", " ", "psi2"}]}], ")"}]}]}]]}]}], "}"}], 
  "}"}]], "Output",
 CellChangeTimes->{3.869001643922089*^9},
 CellLabel->"Out[73]=",ExpressionUUID->"1d1948e9-653f-4663-abe0-90f74dc6562e"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"psi1", "\[Rule]", 
    RowBox[{"psi2", "+", 
     FractionBox[
      RowBox[{
       SuperscriptBox["F1", "2"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "psi2"}], ")"}], "3"], " ", "\[Alpha]"}], 
      RowBox[{"psi2", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SuperscriptBox["F1", "2"], " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", "psi2"}], ")"}], "2"]}], "+", 
         RowBox[{
          SuperscriptBox["Fs", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"3", "+", "psi2"}], ")"}]}]}], ")"}]}]]}]}], "}"}], 
  "}"}]], "Output",
 CellChangeTimes->{3.869001644144149*^9},
 CellLabel->"Out[74]=",ExpressionUUID->"15e112cc-6789-464d-9f3f-d482733f8aff"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{"Calculation", " ", "for", " ", "beta_", "1"}], "*)"}]], "Input",
 CellChangeTimes->{{3.869002769129381*^9, 3.869002769281926*^9}, {
  3.869351843108659*^9, 
  3.869351843747233*^9}},ExpressionUUID->"8f542ba5-effc-4d7e-93c0-\
d7822944b445"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"(", 
    RowBox[{"(", 
     RowBox[{"CoefficientList", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"polu2Fspsi2", "[", 
           FractionBox[
            RowBox[{"2", " ", "\[Rho]", " ", "\[Alpha]"}], 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"psi1", "-", "psi2"}], ")"}], "psi2"}]], "]"}], "//", 
          "Together"}], "//", "Numerator"}], "//", "FullSimplify"}], ",", 
       "psi1"}], "]"}], ")"}], ")"}], "/.", 
   RowBox[{"{", 
    RowBox[{"psi2", "\[Rule]", 
     SubscriptBox["\[Psi]", "2"]}], "}"}]}], "//", "FullSimplify"}]], "Input",\

 CellLabel->"In[75]:=",ExpressionUUID->"5b40a2ac-32ee-4ae7-b677-44ea2230cdde"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"\[Rho]", " ", 
    SubsuperscriptBox["\[Psi]", "2", "3"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"16", " ", "\[Alpha]", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "+", "\[Rho]", "-", 
          RowBox[{"4", " ", "\[Alpha]", " ", "\[Rho]"}]}], ")"}], "2"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "\[Rho]", "+", 
         RowBox[{"\[Alpha]", " ", "\[Rho]"}]}], ")"}]}], "+", 
      RowBox[{"\[Rho]", " ", 
       SubscriptBox["\[Psi]", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"8", " ", "\[Alpha]", " ", 
          RowBox[{"(", 
           RowBox[{"6", "+", 
            RowBox[{"\[Rho]", " ", 
             RowBox[{"(", 
              RowBox[{"5", "-", 
               RowBox[{"28", " ", "\[Alpha]"}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "1"}], "+", 
                  RowBox[{"8", " ", "\[Alpha]", " ", 
                   RowBox[{"(", 
                    RowBox[{"5", "+", 
                    RowBox[{"2", " ", "\[Alpha]"}]}], ")"}]}]}], ")"}], " ", 
                "\[Rho]"}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{"\[Rho]", " ", 
          SubscriptBox["\[Psi]", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"\[Rho]", "-", 
            RowBox[{"8", " ", "\[Alpha]", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "6"}], "+", "\[Rho]", "+", 
               RowBox[{"14", " ", "\[Alpha]", " ", "\[Rho]"}]}], ")"}]}], "+", 
            RowBox[{"16", " ", "\[Alpha]", " ", "\[Rho]", " ", 
             SubscriptBox["\[Psi]", "2"]}]}], ")"}]}]}], ")"}]}]}], ")"}]}], 
   ",", 
   RowBox[{"4", " ", "\[Rho]", " ", 
    SubsuperscriptBox["\[Psi]", "2", "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "4"}], " ", "\[Alpha]", " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "\[Rho]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "3"}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "3"}], "+", 
            RowBox[{"2", " ", "\[Alpha]"}]}], ")"}], " ", "\[Rho]"}]}], ")"}],
        " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", 
            RowBox[{"4", " ", "\[Alpha]"}]}], ")"}], " ", "\[Rho]"}]}], 
        ")"}]}], "+", 
      RowBox[{"\[Rho]", " ", 
       SubscriptBox["\[Psi]", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", "\[Alpha]", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "18"}], "+", 
            RowBox[{"3", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "5"}], "+", "\[Rho]"}], ")"}], " ", "\[Rho]"}], 
            "+", 
            RowBox[{"8", " ", "\[Alpha]", " ", "\[Rho]", " ", 
             RowBox[{"(", 
              RowBox[{"7", "-", 
               RowBox[{"2", " ", 
                RowBox[{"(", 
                 RowBox[{"5", "+", "\[Alpha]"}], ")"}], " ", "\[Rho]"}]}], 
              ")"}]}]}], ")"}]}], "-", 
         RowBox[{"\[Rho]", " ", 
          SubscriptBox["\[Psi]", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "6"}], " ", "\[Alpha]", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "6"}], "+", "\[Rho]"}], ")"}]}], "+", "\[Rho]", 
            "-", 
            RowBox[{"56", " ", 
             SuperscriptBox["\[Alpha]", "2"], " ", "\[Rho]"}], "+", 
            RowBox[{"12", " ", "\[Alpha]", " ", "\[Rho]", " ", 
             SubscriptBox["\[Psi]", "2"]}]}], ")"}]}]}], ")"}]}]}], ")"}]}], 
   ",", 
   RowBox[{"2", " ", "\[Rho]", " ", 
    SubscriptBox["\[Psi]", "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"3", " ", 
       SuperscriptBox["\[Rho]", "3"], " ", 
       SubsuperscriptBox["\[Psi]", "2", "2"]}], "+", 
      RowBox[{"12", " ", "\[Alpha]", " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "\[Rho]", "+", 
         RowBox[{"\[Rho]", " ", 
          SubscriptBox["\[Psi]", "2"]}]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"1", "+", "\[Rho]"}], ")"}], "2"]}], "+", 
         RowBox[{"\[Rho]", " ", 
          SubscriptBox["\[Psi]", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"4", "-", 
            RowBox[{"3", " ", "\[Rho]"}], "+", 
            RowBox[{"2", " ", "\[Rho]", " ", 
             SubscriptBox["\[Psi]", "2"]}]}], ")"}]}]}], ")"}]}], "-", 
      RowBox[{"8", " ", 
       SuperscriptBox["\[Alpha]", "2"], " ", "\[Rho]", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"7", " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"1", "+", "\[Rho]"}], ")"}], "2"]}], "+", 
         RowBox[{"\[Rho]", " ", 
          SubscriptBox["\[Psi]", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"14", "-", 
            RowBox[{"20", " ", "\[Rho]"}], "+", 
            RowBox[{"7", " ", "\[Rho]", " ", 
             SubscriptBox["\[Psi]", "2"]}]}], ")"}]}]}], ")"}]}]}], ")"}]}], 
   ",", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "4"}], " ", 
     SuperscriptBox["\[Rho]", "4"], " ", 
     SubsuperscriptBox["\[Psi]", "2", "2"]}], "-", 
    RowBox[{"8", " ", "\[Alpha]", " ", "\[Rho]", " ", 
     RowBox[{"(", 
      RowBox[{"1", "+", "\[Rho]", "+", 
       RowBox[{"\[Rho]", " ", 
        SubscriptBox["\[Psi]", "2"]}]}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"2", " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"1", "+", "\[Rho]"}], ")"}], "2"]}], "+", 
       RowBox[{"\[Rho]", " ", 
        SubscriptBox["\[Psi]", "2"], " ", 
        RowBox[{"(", 
         RowBox[{"4", "-", 
          RowBox[{"3", " ", "\[Rho]"}], "+", 
          RowBox[{"2", " ", "\[Rho]", " ", 
           SubscriptBox["\[Psi]", "2"]}]}], ")"}]}]}], ")"}]}]}], ",", 
   RowBox[{
    SuperscriptBox["\[Rho]", "4"], " ", 
    SubscriptBox["\[Psi]", "2"]}]}], "}"}]], "Output",
 CellChangeTimes->{3.869002779053421*^9},
 CellLabel->"Out[75]=",ExpressionUUID->"08ee339c-f577-46bd-8e4d-bf357da8e0fe"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{
  "Obtain", " ", "the", " ", "poly", " ", "from", " ", "the", " ", "first", 
   " ", "derivative", " ", "that", " ", "can", " ", "obtain", " ", "the", " ",
    "crticial", " ", "points", " ", "for", " ", "minimum"}], "*)"}]], "Input",\

 CellChangeTimes->{{3.8690029233635387`*^9, 3.869002928037353*^9}, {
  3.8690046258261967`*^9, 3.869004639521647*^9}, {3.869352027251627*^9, 
  3.869352041975566*^9}},ExpressionUUID->"83bfbb2f-5b05-40c4-8375-\
98b9eee84463"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Deriva2", "=", " ", 
  RowBox[{
   RowBox[{"D", "[", 
    RowBox[{"objective2", ",", " ", "chi"}], "]"}], "//", 
   "FullSimplify"}]}]], "Input",
 CellLabel->"In[76]:=",ExpressionUUID->"2eeb9615-f388-4e01-a7cc-156539e3684e"],

Cell[BoxData[
 RowBox[{
  FractionBox["1", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"psi1", "-", "psi2"}], ")"}], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"psi2", "-", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"chi", "+", "psi2"}], ")"}], "2"]}], ")"}], "2"]}]], 
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "2"}], " ", 
     SuperscriptBox["chi", "5"], " ", 
     SuperscriptBox["F1", "2"], " ", "\[Alpha]"}], "+", 
    RowBox[{"4", " ", 
     SuperscriptBox["chi", "3"], " ", "psi2", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["Fs", "2"], "+", 
          SuperscriptBox["tau", "2"]}], ")"}], " ", "\[Alpha]"}], "-", 
       RowBox[{
        SuperscriptBox["F1", "2"], " ", 
        RowBox[{"(", 
         RowBox[{"psi2", "-", 
          RowBox[{"2", " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", "psi1"}], ")"}], " ", "\[Alpha]"}], "+", 
          RowBox[{"6", " ", "psi2", " ", "\[Alpha]"}]}], ")"}]}]}], ")"}]}], 
    "+", 
    RowBox[{
     SuperscriptBox["psi2", "2"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        SuperscriptBox["Fs", "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", " ", "psi1"}], "-", 
          RowBox[{"2", " ", "psi2"}], "+", 
          RowBox[{
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", "psi2"}], ")"}], "2"], " ", 
           "\[Alpha]"}]}], ")"}]}], "+", 
       RowBox[{
        SuperscriptBox["tau", "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", " ", "psi1"}], "-", 
          RowBox[{"2", " ", "psi2"}], "+", 
          RowBox[{
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", "psi2"}], ")"}], "2"], " ", 
           "\[Alpha]"}]}], ")"}]}], "-", 
       RowBox[{
        SuperscriptBox["F1", "2"], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "+", "psi2"}], ")"}], "2"], " ", 
        RowBox[{"(", 
         RowBox[{"psi2", "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "-", 
             RowBox[{"2", " ", "psi1"}], "+", 
             RowBox[{"3", " ", "psi2"}]}], ")"}], " ", "\[Alpha]"}]}], 
         ")"}]}]}], ")"}]}], "+", 
    RowBox[{
     SuperscriptBox["chi", "4"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["Fs", "2"], "+", 
          SuperscriptBox["tau", "2"]}], ")"}], " ", "\[Alpha]"}], "+", 
       RowBox[{
        SuperscriptBox["F1", "2"], " ", 
        RowBox[{"(", 
         RowBox[{"\[Alpha]", "+", 
          RowBox[{"2", " ", "psi1", " ", "\[Alpha]"}], "-", 
          RowBox[{"psi2", " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", 
             RowBox[{"11", " ", "\[Alpha]"}]}], ")"}]}]}], ")"}]}]}], ")"}]}],
     "+", 
    RowBox[{"2", " ", "chi", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"psi2", " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["Fs", "2"], "+", 
          SuperscriptBox["tau", "2"]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"psi1", "+", 
          RowBox[{"psi2", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", 
             RowBox[{"2", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "1"}], "+", "psi2"}], ")"}], " ", "\[Alpha]"}]}],
             ")"}]}]}], ")"}]}], "-", 
       RowBox[{
        SuperscriptBox["F1", "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "psi2"}], ")"}], " ", "psi2", " ", 
        RowBox[{"(", 
         RowBox[{"psi1", "-", 
          RowBox[{"4", " ", "psi1", " ", "psi2", " ", "\[Alpha]"}], "+", 
          RowBox[{"psi2", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", 
             RowBox[{"2", " ", "psi2"}], "-", 
             RowBox[{"3", " ", "\[Alpha]"}], "+", 
             RowBox[{"7", " ", "psi2", " ", "\[Alpha]"}]}], ")"}]}]}], 
         ")"}]}]}], ")"}]}], "+", 
    RowBox[{"2", " ", 
     SuperscriptBox["chi", "2"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"psi2", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          RowBox[{"3", " ", "psi2"}]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["Fs", "2"], "+", 
          SuperscriptBox["tau", "2"]}], ")"}], " ", "\[Alpha]"}], "-", 
       RowBox[{
        SuperscriptBox["F1", "2"], " ", "psi2", " ", 
        RowBox[{"(", 
         RowBox[{"psi1", "+", "\[Alpha]", "+", 
          RowBox[{"psi1", " ", 
           RowBox[{"(", 
            RowBox[{"2", "-", 
             RowBox[{"6", " ", "psi2"}]}], ")"}], " ", "\[Alpha]"}], "+", 
          RowBox[{"psi2", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "2"}], "+", 
             RowBox[{"3", " ", "psi2"}], "-", 
             RowBox[{"10", " ", "\[Alpha]"}], "+", 
             RowBox[{"13", " ", "psi2", " ", "\[Alpha]"}]}], ")"}]}]}], 
         ")"}]}]}], ")"}]}]}], ")"}]}]], "Output",
 CellChangeTimes->{3.8690047798915377`*^9},
 CellLabel->"Out[76]=",ExpressionUUID->"8b1f280e-f9e8-4180-9606-a631d9ffb0be"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{
  "get", " ", "the", " ", "numerator", " ", "and", " ", "denominator", " ", 
   "from", " ", "the", " ", "above", " ", "result", " ", "for", " ", 
   "checking", " ", "if", " ", "solution", " ", "of", " ", "numerator", " ", 
   "will", " ", "make", " ", "denominator", " ", "zero"}], "*)"}]], "Input",
 CellChangeTimes->{{3.86900510294625*^9, 3.869005138794334*^9}, {
  3.869352062090639*^9, 
  3.869352080285262*^9}},ExpressionUUID->"345da9cb-91e5-428f-945b-\
f35297c908ad"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"num", "=", 
  RowBox[{
   RowBox[{"Numerator", "[", "Deriva2", "]"}], "//", 
   "FullSimplify"}]}], "\[IndentingNewLine]", 
 RowBox[{"den", "=", 
  RowBox[{
   RowBox[{"Denominator", "[", "Deriva2", "]"}], "//", 
   "FullSimplify"}]}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.869005162581201*^9, 3.8690051709634867`*^9}},
 CellLabel->"In[80]:=",ExpressionUUID->"35625a4f-6967-4263-ad05-49b2c788e4ea"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"-", "2"}], " ", 
   SuperscriptBox["chi", "5"], " ", 
   SuperscriptBox["F1", "2"], " ", "\[Alpha]"}], "+", 
  RowBox[{"4", " ", 
   SuperscriptBox["chi", "3"], " ", "psi2", " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["Fs", "2"], "+", 
        SuperscriptBox["tau", "2"]}], ")"}], " ", "\[Alpha]"}], "-", 
     RowBox[{
      SuperscriptBox["F1", "2"], " ", 
      RowBox[{"(", 
       RowBox[{"psi2", "-", 
        RowBox[{"2", " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", "psi1"}], ")"}], " ", "\[Alpha]"}], "+", 
        RowBox[{"6", " ", "psi2", " ", "\[Alpha]"}]}], ")"}]}]}], ")"}]}], 
  "+", 
  RowBox[{
   SuperscriptBox["psi2", "2"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      SuperscriptBox["Fs", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", " ", "psi1"}], "-", 
        RowBox[{"2", " ", "psi2"}], "+", 
        RowBox[{
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", "psi2"}], ")"}], "2"], " ", 
         "\[Alpha]"}]}], ")"}]}], "+", 
     RowBox[{
      SuperscriptBox["tau", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", " ", "psi1"}], "-", 
        RowBox[{"2", " ", "psi2"}], "+", 
        RowBox[{
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", "psi2"}], ")"}], "2"], " ", 
         "\[Alpha]"}]}], ")"}]}], "-", 
     RowBox[{
      SuperscriptBox["F1", "2"], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "psi2"}], ")"}], "2"], " ", 
      RowBox[{"(", 
       RowBox[{"psi2", "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "-", 
           RowBox[{"2", " ", "psi1"}], "+", 
           RowBox[{"3", " ", "psi2"}]}], ")"}], " ", "\[Alpha]"}]}], 
       ")"}]}]}], ")"}]}], "+", 
  RowBox[{
   SuperscriptBox["chi", "4"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["Fs", "2"], "+", 
        SuperscriptBox["tau", "2"]}], ")"}], " ", "\[Alpha]"}], "+", 
     RowBox[{
      SuperscriptBox["F1", "2"], " ", 
      RowBox[{"(", 
       RowBox[{"\[Alpha]", "+", 
        RowBox[{"2", " ", "psi1", " ", "\[Alpha]"}], "-", 
        RowBox[{"psi2", " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", 
           RowBox[{"11", " ", "\[Alpha]"}]}], ")"}]}]}], ")"}]}]}], ")"}]}], 
  "+", 
  RowBox[{"2", " ", "chi", " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"psi2", " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["Fs", "2"], "+", 
        SuperscriptBox["tau", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"psi1", "+", 
        RowBox[{"psi2", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "+", 
           RowBox[{"2", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", "psi2"}], ")"}], " ", "\[Alpha]"}]}], 
          ")"}]}]}], ")"}]}], "-", 
     RowBox[{
      SuperscriptBox["F1", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", "psi2"}], ")"}], " ", "psi2", " ", 
      RowBox[{"(", 
       RowBox[{"psi1", "-", 
        RowBox[{"4", " ", "psi1", " ", "psi2", " ", "\[Alpha]"}], "+", 
        RowBox[{"psi2", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "+", 
           RowBox[{"2", " ", "psi2"}], "-", 
           RowBox[{"3", " ", "\[Alpha]"}], "+", 
           RowBox[{"7", " ", "psi2", " ", "\[Alpha]"}]}], ")"}]}]}], 
       ")"}]}]}], ")"}]}], "+", 
  RowBox[{"2", " ", 
   SuperscriptBox["chi", "2"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"psi2", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        RowBox[{"3", " ", "psi2"}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["Fs", "2"], "+", 
        SuperscriptBox["tau", "2"]}], ")"}], " ", "\[Alpha]"}], "-", 
     RowBox[{
      SuperscriptBox["F1", "2"], " ", "psi2", " ", 
      RowBox[{"(", 
       RowBox[{"psi1", "+", "\[Alpha]", "+", 
        RowBox[{"psi1", " ", 
         RowBox[{"(", 
          RowBox[{"2", "-", 
           RowBox[{"6", " ", "psi2"}]}], ")"}], " ", "\[Alpha]"}], "+", 
        RowBox[{"psi2", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "2"}], "+", 
           RowBox[{"3", " ", "psi2"}], "-", 
           RowBox[{"10", " ", "\[Alpha]"}], "+", 
           RowBox[{"13", " ", "psi2", " ", "\[Alpha]"}]}], ")"}]}]}], 
       ")"}]}]}], ")"}]}]}]], "Output",
 CellChangeTimes->{3.869005174037056*^9},
 CellLabel->"Out[80]=",ExpressionUUID->"fc3d2403-7d37-4894-8d2c-79831adeed25"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{"psi1", "-", "psi2"}], ")"}], " ", 
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{"psi2", "-", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"chi", "+", "psi2"}], ")"}], "2"]}], ")"}], "2"]}]], "Output",
 CellChangeTimes->{3.869005174039763*^9},
 CellLabel->"Out[81]=",ExpressionUUID->"eb9c14ae-f7c4-4469-a025-0bb2f80e7354"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{"get", " ", "the", " ", "coefficent", " ", "from", " ", "num"}], 
  "*)"}]], "Input",
 CellChangeTimes->{{3.8690051924801073`*^9, 
  3.869005208717146*^9}},ExpressionUUID->"678eff54-4fb3-4874-96b4-\
16c15af03522"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"CoefficientList", "[", 
    RowBox[{"num", ",", "chi"}], "]"}], "/.", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"chi", "\[Rule]", "x"}], ",", 
     RowBox[{"F1", "\[Rule]", 
      SubscriptBox["F", "1"]}], ",", 
     RowBox[{"Fs", "\[Rule]", 
      SubscriptBox["F", "*"]}], ",", 
     RowBox[{"psi2", "\[Rule]", 
      SubscriptBox["\[Psi]", "2"]}], ",", 
     RowBox[{"tau", "\[Rule]", "\[Tau]"}], ",", 
     RowBox[{"psi1", "\[Rule]", 
      SubscriptBox["\[Psi]", "1"]}]}], "}"}]}], "//", 
  "FullSimplify"}]], "Input",
 CellChangeTimes->{{3.869005162581201*^9, 3.8690051709634867`*^9}},
 CellLabel->"In[83]:=",ExpressionUUID->"5908d8f7-b0d1-444c-9d64-a418e08eaf59"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    SubsuperscriptBox["\[Psi]", "2", "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       SubsuperscriptBox["F", "1", "2"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          SubscriptBox["\[Psi]", "2"]}], ")"}], "2"], " ", 
       RowBox[{"(", 
        RowBox[{"\[Alpha]", "+", 
         RowBox[{"2", " ", "\[Alpha]", " ", 
          SubscriptBox["\[Psi]", "1"]}], "-", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{"3", " ", "\[Alpha]"}]}], ")"}], " ", 
          SubscriptBox["\[Psi]", "2"]}]}], ")"}]}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"\[Alpha]", "+", 
         RowBox[{"2", " ", 
          SubscriptBox["\[Psi]", "1"]}], "-", 
         RowBox[{"2", " ", 
          RowBox[{"(", 
           RowBox[{"1", "+", "\[Alpha]"}], ")"}], " ", 
          SubscriptBox["\[Psi]", "2"]}], "+", 
         RowBox[{"\[Alpha]", " ", 
          SubsuperscriptBox["\[Psi]", "2", "2"]}]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["\[Tau]", "2"], "+", 
         SubsuperscriptBox["F", "*", "2"]}], ")"}]}]}], ")"}]}], ",", 
   RowBox[{"2", " ", 
    SubscriptBox["\[Psi]", "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"-", 
        SubsuperscriptBox["F", "1", "2"]}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         SubscriptBox["\[Psi]", "2"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         SubscriptBox["\[Psi]", "1"], "-", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{"3", " ", "\[Alpha]"}], "+", 
            RowBox[{"4", " ", "\[Alpha]", " ", 
             SubscriptBox["\[Psi]", "1"]}]}], ")"}], " ", 
          SubscriptBox["\[Psi]", "2"]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"2", "+", 
            RowBox[{"7", " ", "\[Alpha]"}]}], ")"}], " ", 
          SubsuperscriptBox["\[Psi]", "2", "2"]}]}], ")"}]}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         SubscriptBox["\[Psi]", "1"], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", 
            RowBox[{"2", " ", "\[Alpha]", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1"}], "+", 
               SubscriptBox["\[Psi]", "2"]}], ")"}]}]}], ")"}], " ", 
          SubscriptBox["\[Psi]", "2"]}]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["\[Tau]", "2"], "+", 
         SubsuperscriptBox["F", "*", "2"]}], ")"}]}]}], ")"}]}], ",", 
   RowBox[{"2", " ", 
    SubscriptBox["\[Psi]", "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"-", 
        SubsuperscriptBox["F", "1", "2"]}], " ", 
       RowBox[{"(", 
        RowBox[{"\[Alpha]", "+", 
         SubscriptBox["\[Psi]", "1"], "+", 
         RowBox[{"2", " ", "\[Alpha]", " ", 
          SubscriptBox["\[Psi]", "1"]}], "-", 
         RowBox[{"2", " ", 
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{"5", " ", "\[Alpha]"}], "+", 
            RowBox[{"3", " ", "\[Alpha]", " ", 
             SubscriptBox["\[Psi]", "1"]}]}], ")"}], " ", 
          SubscriptBox["\[Psi]", "2"]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"3", "+", 
            RowBox[{"13", " ", "\[Alpha]"}]}], ")"}], " ", 
          SubsuperscriptBox["\[Psi]", "2", "2"]}]}], ")"}]}], "+", 
      RowBox[{"\[Alpha]", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         RowBox[{"3", " ", 
          SubscriptBox["\[Psi]", "2"]}]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["\[Tau]", "2"], "+", 
         SubsuperscriptBox["F", "*", "2"]}], ")"}]}]}], ")"}]}], ",", 
   RowBox[{"4", " ", 
    SubscriptBox["\[Psi]", "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       SubsuperscriptBox["F", "1", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", "\[Alpha]", " ", 
          RowBox[{"(", 
           RowBox[{"1", "+", 
            SubscriptBox["\[Psi]", "1"]}], ")"}]}], "-", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{"6", " ", "\[Alpha]"}]}], ")"}], " ", 
          SubscriptBox["\[Psi]", "2"]}]}], ")"}]}], "+", 
      RowBox[{"\[Alpha]", " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["\[Tau]", "2"], "+", 
         SubsuperscriptBox["F", "*", "2"]}], ")"}]}]}], ")"}]}], ",", 
   RowBox[{
    RowBox[{
     SubsuperscriptBox["F", "1", "2"], " ", 
     RowBox[{"(", 
      RowBox[{"\[Alpha]", "+", 
       RowBox[{"2", " ", "\[Alpha]", " ", 
        SubscriptBox["\[Psi]", "1"]}], "-", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "+", 
          RowBox[{"11", " ", "\[Alpha]"}]}], ")"}], " ", 
        SubscriptBox["\[Psi]", "2"]}]}], ")"}]}], "+", 
    RowBox[{"\[Alpha]", " ", 
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["\[Tau]", "2"], "+", 
       SubsuperscriptBox["F", "*", "2"]}], ")"}]}]}], ",", 
   RowBox[{
    RowBox[{"-", "2"}], " ", "\[Alpha]", " ", 
    SubsuperscriptBox["F", "1", "2"]}]}], "}"}]], "Output",
 CellChangeTimes->{3.869005231652195*^9},
 CellLabel->"Out[83]=",ExpressionUUID->"1906e864-867f-40da-82a9-142bd81d6c5f"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{
   RowBox[{
    RowBox[{
    "Change", " ", "to", " ", "the", " ", "format", " ", "with", " ", "rho"}],
     "\[Rule]", " ", 
    RowBox[{"signal", " ", "ratio", " ", "rho"}]}], " ", "=", 
   RowBox[{
    RowBox[{"F1", "^", "2"}], " ", "/", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"Fs", "^", "2"}], " ", "+", " ", 
      RowBox[{"tau", "^", "2"}]}], ")"}]}]}], "*)"}]], "Input",
 CellChangeTimes->{{3.8690052330654917`*^9, 3.869005259132897*^9}, {
  3.869352049821082*^9, 3.869352054625985*^9}, {3.869352487757951*^9, 
  3.8693524910209627`*^9}},ExpressionUUID->"cb39bc01-bff5-4a2f-8956-\
52c1c5986be1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    SubsuperscriptBox["\[Psi]", "2", "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"\[Rho]", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          SubscriptBox["\[Psi]", "2"]}], ")"}], "2"], " ", 
       RowBox[{"(", 
        RowBox[{"\[Alpha]", "+", 
         RowBox[{"2", " ", "\[Alpha]", " ", 
          SubscriptBox["\[Psi]", "1"]}], "-", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{"3", " ", "\[Alpha]"}]}], ")"}], " ", 
          SubscriptBox["\[Psi]", "2"]}]}], ")"}]}], "+", 
      RowBox[{"(", 
       RowBox[{"\[Alpha]", "+", 
        RowBox[{"2", " ", 
         SubscriptBox["\[Psi]", "1"]}], "-", 
        RowBox[{"2", " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", "\[Alpha]"}], ")"}], " ", 
         SubscriptBox["\[Psi]", "2"]}], "+", 
        RowBox[{"\[Alpha]", " ", 
         SubsuperscriptBox["\[Psi]", "2", "2"]}]}], ")"}]}], ")"}]}], ",", 
   RowBox[{"2", " ", 
    SubscriptBox["\[Psi]", "2"], 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "\[Rho]"}], 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         SubscriptBox["\[Psi]", "2"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         SubscriptBox["\[Psi]", "1"], "-", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{"3", " ", "\[Alpha]"}], "+", 
            RowBox[{"4", " ", "\[Alpha]", " ", 
             SubscriptBox["\[Psi]", "1"]}]}], ")"}], " ", 
          SubscriptBox["\[Psi]", "2"]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"2", "+", 
            RowBox[{"7", " ", "\[Alpha]"}]}], ")"}], " ", 
          SubsuperscriptBox["\[Psi]", "2", "2"]}]}], ")"}]}], "+", 
      RowBox[{"(", 
       RowBox[{
        SubscriptBox["\[Psi]", "1"], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "+", 
           RowBox[{"2", " ", "\[Alpha]", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", 
              SubscriptBox["\[Psi]", "2"]}], ")"}]}]}], ")"}], " ", 
         SubscriptBox["\[Psi]", "2"]}]}], ")"}]}], " ", ")"}]}], ",", 
   RowBox[{"2", " ", 
    SubscriptBox["\[Psi]", "2"], 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "\[Rho]"}], " ", 
       RowBox[{"(", 
        RowBox[{"\[Alpha]", "+", 
         SubscriptBox["\[Psi]", "1"], "+", 
         RowBox[{"2", " ", "\[Alpha]", " ", 
          SubscriptBox["\[Psi]", "1"]}], "-", 
         RowBox[{"2", " ", 
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{"5", " ", "\[Alpha]"}], "+", 
            RowBox[{"3", " ", "\[Alpha]", " ", 
             SubscriptBox["\[Psi]", "1"]}]}], ")"}], " ", 
          SubscriptBox["\[Psi]", "2"]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"3", "+", 
            RowBox[{"13", " ", "\[Alpha]"}]}], ")"}], " ", 
          SubsuperscriptBox["\[Psi]", "2", "2"]}]}], ")"}]}], "+", 
      RowBox[{"\[Alpha]", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         RowBox[{"3", " ", 
          SubscriptBox["\[Psi]", "2"]}]}], ")"}]}]}], ")"}]}], ",", 
   RowBox[{"4", " ", 
    SubscriptBox["\[Psi]", "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"\[Rho]", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", "\[Alpha]", " ", 
          RowBox[{"(", 
           RowBox[{"1", "+", 
            SubscriptBox["\[Psi]", "1"]}], ")"}]}], "-", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{"6", " ", "\[Alpha]"}]}], ")"}], " ", 
          SubscriptBox["\[Psi]", "2"]}]}], ")"}]}], "+", "\[Alpha]"}], " ", 
     ")"}]}], ",", 
   RowBox[{
    RowBox[{"\[Rho]", " ", 
     RowBox[{"(", 
      RowBox[{"\[Alpha]", "+", 
       RowBox[{"2", " ", "\[Alpha]", " ", 
        SubscriptBox["\[Psi]", "1"]}], "-", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "+", 
          RowBox[{"11", " ", "\[Alpha]"}]}], ")"}], " ", 
        SubscriptBox["\[Psi]", "2"]}]}], ")"}]}], "+", "\[Alpha]"}], " ", ",", 
   RowBox[{
    RowBox[{"-", "2"}], " ", "\[Alpha]", " ", "\[Rho]"}]}], "}"}]], "Input",Ex\
pressionUUID->"80bb3c11-917b-4cab-9891-2d99fa9b98b8"],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.869005177315989*^9, 
  3.869005177317155*^9}},ExpressionUUID->"3a9c3419-db96-4679-8a60-\
9c5eec21e6f0"],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{
  "Show", " ", "the", " ", "roots", " ", "of", " ", "denominator", " ", "of", 
   " ", "above", " ", "result", " ", "never", " ", "make", " ", "the", " ", 
   "numerator", " ", "zero"}], "*)"}]], "Input",
 CellChangeTimes->{{3.86900527581536*^9, 3.8690053184789267`*^9}, {
  3.8690053509184027`*^9, 
  3.869005359232983*^9}},ExpressionUUID->"e25b10ff-f610-45cd-a4eb-\
c8611fc1e059"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"Solve", "[", 
   RowBox[{
    RowBox[{"den", " ", "\[Equal]", " ", "0"}], ",", " ", "chi"}], "]"}], "//",
   "FullSimplify"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"num", "/.", 
   RowBox[{"{", 
    RowBox[{"chi", "\[Rule]", 
     RowBox[{
      SqrtBox["psi2"], "-", "psi2"}]}], "}"}]}], "//", "FullSimplify", 
  " "}]}], "Input",
 CellChangeTimes->{{3.8690053346388617`*^9, 3.869005335045905*^9}, {
  3.8690053878815727`*^9, 
  3.8690053902892227`*^9}},ExpressionUUID->"35a709c1-1923-4274-add5-\
364592880eb2"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"chi", "\[Rule]", 
     RowBox[{
      RowBox[{"-", 
       SqrtBox["psi2"]}], "-", "psi2"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"chi", "\[Rule]", 
     RowBox[{
      RowBox[{"-", 
       SqrtBox["psi2"]}], "-", "psi2"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"chi", "\[Rule]", 
     RowBox[{
      SqrtBox["psi2"], "-", "psi2"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"chi", "\[Rule]", 
     RowBox[{
      SqrtBox["psi2"], "-", "psi2"}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.869005337008607*^9},
 CellLabel->"Out[84]=",ExpressionUUID->"9a742ec8-8d25-4493-8a3d-103c824a8cb6"],

Cell[BoxData[
 RowBox[{"2", " ", 
  RowBox[{"(", 
   RowBox[{"psi1", "-", "psi2"}], ")"}], " ", 
  SuperscriptBox["psi2", 
   RowBox[{"3", "/", "2"}]], " ", 
  RowBox[{"(", 
   RowBox[{
    SuperscriptBox["Fs", "2"], "+", 
    RowBox[{
     SuperscriptBox["F1", "2"], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SqrtBox["psi2"]}], ")"}], "2"]}], "+", 
    SuperscriptBox["tau", "2"]}], ")"}]}]], "Output",
 CellChangeTimes->{3.86900533704556*^9},
 CellLabel->"Out[85]=",ExpressionUUID->"ef253c3a-2989-496c-8b13-6b78df9ab47a"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{"Derivative", " ", "at", " ", "X_L"}], "*)"}]], "Input",
 CellChangeTimes->{{3.869006036359084*^9, 3.86900605558661*^9}, {
  3.869006115407778*^9, 3.869006119735652*^9}, {3.869270852682994*^9, 
  3.869270853475236*^9}},ExpressionUUID->"b2d159bc-c2e8-4a88-8023-\
ea879b86b21f"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"D", "[", 
     RowBox[{"objective2", ",", "chi"}], "]"}], "/.", 
    RowBox[{"{", 
     RowBox[{"chi", "\[Rule]", 
      RowBox[{"-", "psi2"}]}], "}"}]}], "/.", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"psi2", "\[Rule]", 
      SubscriptBox["\[Psi]", "2"]}], ",", 
     RowBox[{"F1", "\[Rule]", 
      SubscriptBox["F", "1"]}], ",", 
     RowBox[{"psi1", "\[Rule]", 
      SubscriptBox["\[Psi]", "1"]}], ",", 
     RowBox[{"tau", "\[Rule]", "\[Tau]"}], ",", 
     RowBox[{"Fs", "\[Rule]", 
      SubscriptBox["F", "*"]}]}], "}"}]}], "//", "FullSimplify"}]], "Input",
 CellLabel->"In[86]:=",ExpressionUUID->"b02aed33-8bfb-4c61-bf81-a3693e7202a2"],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{
    SubsuperscriptBox["F", "1", "2"], " ", 
    RowBox[{"(", 
     RowBox[{"\[Alpha]", "+", 
      RowBox[{"2", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "\[Alpha]"}], ")"}], " ", 
       SubscriptBox["\[Psi]", "1"]}], "+", 
      SubscriptBox["\[Psi]", "2"], "-", 
      RowBox[{"\[Alpha]", " ", 
       SubscriptBox["\[Psi]", "2"]}]}], ")"}]}], "+", 
   RowBox[{"\[Alpha]", " ", 
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["\[Tau]", "2"], "+", 
      SubsuperscriptBox["F", "*", "2"]}], ")"}]}]}], 
  RowBox[{
   SubscriptBox["\[Psi]", "1"], "-", 
   SubscriptBox["\[Psi]", "2"]}]]], "Output",
 CellChangeTimes->{3.869006128830669*^9},
 CellLabel->"Out[86]=",ExpressionUUID->"ed50934f-7032-4e70-8c64-8c328443c18e"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{
   RowBox[{"Derivative", " ", "at", " ", "X_R", " ", "when", " ", "psi2"}], 
   " ", ">", " ", "1"}], "*)"}]], "Input",
 CellChangeTimes->{{3.869006144535887*^9, 3.869006145861847*^9}, {
  3.869006274755212*^9, 3.86900629418857*^9}, {3.869270885774004*^9, 
  3.8692708869977903`*^9}},ExpressionUUID->"e941ee0e-6b47-4fb6-bf88-\
ad30a3bbc994"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"D", "[", 
     RowBox[{"objective2", ",", "chi"}], "]"}], "/.", 
    RowBox[{"{", 
     RowBox[{"chi", "\[Rule]", 
      RowBox[{"1", "-", "psi2"}]}], "}"}]}], "/.", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"psi2", "\[Rule]", 
      SubscriptBox["\[Psi]", "2"]}], ",", 
     RowBox[{"F1", "\[Rule]", 
      SubscriptBox["F", "1"]}], ",", 
     RowBox[{"psi1", "\[Rule]", 
      SubscriptBox["\[Psi]", "1"]}], ",", 
     RowBox[{"tau", "\[Rule]", "\[Tau]"}], ",", 
     RowBox[{"Fs", "\[Rule]", 
      SubscriptBox["F", "*"]}]}], "}"}]}], "//", "FullSimplify"}]], "Input",
 CellLabel->"In[87]:=",ExpressionUUID->"d4b346fa-9075-4b08-9b97-60516698f53f"],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{
    SubsuperscriptBox["F", "1", "2"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", 
       SubscriptBox["\[Psi]", "2"]}], ")"}], "2"], " ", 
    RowBox[{"(", 
     RowBox[{"\[Alpha]", "-", 
      RowBox[{"2", " ", "\[Alpha]", " ", 
       SubscriptBox["\[Psi]", "1"]}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "+", "\[Alpha]"}], ")"}], " ", 
       SubscriptBox["\[Psi]", "2"]}]}], ")"}]}], "-", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"\[Alpha]", "+", 
      RowBox[{
       SubscriptBox["\[Psi]", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "2"}], " ", "\[Alpha]"}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["\[Psi]", "1"]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "2"}], "+", "\[Alpha]"}], ")"}], " ", 
          SubscriptBox["\[Psi]", "2"]}]}], ")"}]}]}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["\[Tau]", "2"], "+", 
      SubsuperscriptBox["F", "*", "2"]}], ")"}]}]}], 
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      SubscriptBox["\[Psi]", "2"]}], ")"}], "2"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", 
      SubscriptBox["\[Psi]", "1"]}], "+", 
     SubscriptBox["\[Psi]", "2"]}], ")"}]}]]], "Output",
 CellChangeTimes->{3.869006182852985*^9},
 CellLabel->"Out[87]=",ExpressionUUID->"269a7bc2-e155-4f65-84cc-406450bfc37a"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{
   RowBox[{"Derivative", " ", "at", " ", "X_R", " ", "when", " ", "psi2"}], 
   " ", "<", " ", "1"}], "*)"}]], "Input",
 CellChangeTimes->{{3.869006299807479*^9, 3.869006300426754*^9}, {
  3.8692708892839327`*^9, 
  3.869270889975531*^9}},ExpressionUUID->"7337431d-1902-48d9-b55b-\
183f640cfeeb"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"D", "[", 
     RowBox[{"objective2", ",", "chi"}], "]"}], "/.", 
    RowBox[{"{", 
     RowBox[{"chi", "\[Rule]", "0"}], "}"}]}], "/.", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"psi2", "\[Rule]", 
      SubscriptBox["\[Psi]", "2"]}], ",", 
     RowBox[{"F1", "\[Rule]", 
      SubscriptBox["F", "1"]}], ",", 
     RowBox[{"psi1", "\[Rule]", 
      SubscriptBox["\[Psi]", "1"]}], ",", 
     RowBox[{"tau", "\[Rule]", "\[Tau]"}], ",", 
     RowBox[{"Fs", "\[Rule]", 
      SubscriptBox["F", "*"]}]}], "}"}]}], "//", "FullSimplify"}]], "Input",
 CellLabel->"In[88]:=",ExpressionUUID->"0bacbb8c-28a8-471c-82ac-828344113b3e"],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{
    SubsuperscriptBox["F", "1", "2"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", 
       SubscriptBox["\[Psi]", "2"]}], ")"}], "2"], " ", 
    RowBox[{"(", 
     RowBox[{"\[Alpha]", "+", 
      RowBox[{"2", " ", "\[Alpha]", " ", 
       SubscriptBox["\[Psi]", "1"]}], "-", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "+", 
         RowBox[{"3", " ", "\[Alpha]"}]}], ")"}], " ", 
       SubscriptBox["\[Psi]", "2"]}]}], ")"}]}], "+", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"\[Alpha]", "+", 
      RowBox[{"2", " ", 
       SubscriptBox["\[Psi]", "1"]}], "-", 
      RowBox[{"2", " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "\[Alpha]"}], ")"}], " ", 
       SubscriptBox["\[Psi]", "2"]}], "+", 
      RowBox[{"\[Alpha]", " ", 
       SubsuperscriptBox["\[Psi]", "2", "2"]}]}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["\[Tau]", "2"], "+", 
      SubsuperscriptBox["F", "*", "2"]}], ")"}]}]}], 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     SubscriptBox["\[Psi]", "1"], "-", 
     SubscriptBox["\[Psi]", "2"]}], ")"}], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      SubscriptBox["\[Psi]", "2"]}], ")"}], "2"]}]]], "Output",
 CellChangeTimes->{3.8690063916417313`*^9},
 CellLabel->"Out[88]=",ExpressionUUID->"24f5e771-0e1f-440e-afed-b8195d03315e"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{
   RowBox[{
    RowBox[{"Show", " ", "O", 
     RowBox[{"(", "X_L", ")"}]}], " ", "-", " ", 
    RowBox[{"O", 
     RowBox[{"(", "X_R", ")"}], " ", "psi2"}]}], " ", ">", " ", "1"}], 
  "*)"}]], "Input",
 CellChangeTimes->{{3.869270892671891*^9, 
  3.8692708976031513`*^9}},ExpressionUUID->"26d4ffe6-1f40-4d64-ac19-\
f71208255fa7"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"objective2", "/.", 
       RowBox[{"{", 
        RowBox[{"chi", "\[Rule]", 
         RowBox[{"-", "psi2"}]}], "}"}]}], ")"}], "-", "\[IndentingNewLine]", 
     
     RowBox[{"(", 
      RowBox[{"objective2", "/.", 
       RowBox[{"{", 
        RowBox[{"chi", "\[Rule]", 
         RowBox[{"1", "-", "psi2"}]}], "}"}]}], ")"}]}], ")"}], "/.", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"psi2", "\[Rule]", 
      SubscriptBox["\[Psi]", "2"]}], ",", 
     RowBox[{"F1", "\[Rule]", 
      SubscriptBox["F", "1"]}], ",", 
     RowBox[{"psi1", "\[Rule]", 
      SubscriptBox["\[Psi]", "1"]}], ",", 
     RowBox[{"tau", "\[Rule]", "\[Tau]"}], ",", 
     RowBox[{"Fs", "\[Rule]", 
      SubscriptBox["F", "*"]}]}], "}"}]}], "//", "FullSimplify"}]], "Input",
 CellLabel->"In[89]:=",ExpressionUUID->"7a1764b0-33f0-4227-bf5a-8ddd1026f859"],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{
    RowBox[{"-", "\[Alpha]"}], " ", 
    SubsuperscriptBox["F", "1", "2"], " ", 
    SubsuperscriptBox["\[Psi]", "2", "2"]}], "-", 
   RowBox[{"\[Alpha]", " ", 
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["\[Tau]", "2"], "+", 
      SubsuperscriptBox["F", "*", "2"]}], ")"}]}], "+", 
   RowBox[{
    SubscriptBox["\[Psi]", "1"], " ", 
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["\[Tau]", "2"], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         RowBox[{"2", " ", "\[Alpha]"}]}], ")"}], " ", 
       SubsuperscriptBox["F", "1", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         SubscriptBox["\[Psi]", "2"]}], ")"}]}], "+", 
      SubsuperscriptBox["F", "*", "2"]}], ")"}]}], "+", 
   RowBox[{
    SubscriptBox["\[Psi]", "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"\[Alpha]", " ", 
       SubsuperscriptBox["F", "1", "2"]}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "\[Alpha]"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["\[Tau]", "2"], "+", 
         SubsuperscriptBox["F", "*", "2"]}], ")"}]}]}], ")"}]}]}], 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "1"}], "+", 
     SubscriptBox["\[Psi]", "2"]}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", 
      SubscriptBox["\[Psi]", "1"]}], "+", 
     SubscriptBox["\[Psi]", "2"]}], ")"}]}]]], "Output",
 CellChangeTimes->{3.869006552077764*^9},
 CellLabel->"Out[89]=",ExpressionUUID->"2aa34aad-920b-4083-870f-b78db4e2b478"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{
   RowBox[{
    RowBox[{"Show", " ", "O", 
     RowBox[{"(", "X_L", ")"}]}], " ", "-", " ", 
    RowBox[{"O", 
     RowBox[{"(", "X_R", ")"}], " ", "psi2"}]}], " ", "<", " ", "1"}], 
  "*)"}]], "Input",
 CellChangeTimes->{{3.869270901172118*^9, 
  3.869270904719202*^9}},ExpressionUUID->"5d3eb0ac-a8f1-4c2a-998f-\
2e08c59f8558"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"objective2", "/.", 
       RowBox[{"{", 
        RowBox[{"chi", "\[Rule]", 
         RowBox[{"-", "psi2"}]}], "}"}]}], ")"}], "-", "\[IndentingNewLine]", 
     
     RowBox[{"(", 
      RowBox[{"objective2", "/.", 
       RowBox[{"{", 
        RowBox[{"chi", "\[Rule]", "0"}], "}"}]}], ")"}]}], ")"}], "/.", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"psi2", "\[Rule]", 
      SubscriptBox["\[Psi]", "2"]}], ",", 
     RowBox[{"F1", "\[Rule]", 
      SubscriptBox["F", "1"]}], ",", 
     RowBox[{"psi1", "\[Rule]", 
      SubscriptBox["\[Psi]", "1"]}], ",", 
     RowBox[{"tau", "\[Rule]", "\[Tau]"}], ",", 
     RowBox[{"Fs", "\[Rule]", 
      SubscriptBox["F", "*"]}]}], "}"}]}], "//", "FullSimplify"}]], "Input",
 CellChangeTimes->{3.869006588442822*^9},
 CellLabel->"In[90]:=",ExpressionUUID->"4a3df5ea-6b20-49c1-8a11-811f9fb6cc28"],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SubscriptBox["\[Psi]", "2"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      SubsuperscriptBox["F", "1", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SubscriptBox["\[Psi]", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"1", "-", 
           RowBox[{"2", " ", "\[Alpha]"}]}], ")"}], " ", 
         SubscriptBox["\[Psi]", "1"]}], "+", 
        RowBox[{"\[Alpha]", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "+", 
           RowBox[{"2", " ", 
            SubscriptBox["\[Psi]", "2"]}]}], ")"}]}]}], ")"}]}], "-", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "\[Alpha]"}], "-", 
        SubscriptBox["\[Psi]", "1"], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"1", "+", "\[Alpha]"}], ")"}], " ", 
         SubscriptBox["\[Psi]", "2"]}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["\[Tau]", "2"], "+", 
        SubsuperscriptBox["F", "*", "2"]}], ")"}]}]}], ")"}]}], 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     SubscriptBox["\[Psi]", "1"], "-", 
     SubscriptBox["\[Psi]", "2"]}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "1"}], "+", 
     SubscriptBox["\[Psi]", "2"]}], ")"}]}]]], "Output",
 CellChangeTimes->{3.869006592208075*^9},
 CellLabel->"Out[90]=",ExpressionUUID->"92d5dc34-4f88-418a-b6a8-4b518a3d98b9"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{"Solve", " ", "for", " ", "alpha_L"}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"Solve", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"D", "[", 
              RowBox[{"objective2", ",", "chi"}], "]"}], "/.", 
             RowBox[{"{", 
              RowBox[{"chi", "\[Rule]", 
               RowBox[{"-", "psi2"}]}], "}"}]}], ")"}], "\[Equal]", "0"}], 
          ",", "\[Alpha]"}], "]"}], "//", "FullSimplify"}], ")"}], "[", 
      RowBox[{"[", 
       RowBox[{"1", ",", "1", ",", "2"}], "]"}], "]"}], ")"}], "/.", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"psi2", "\[Rule]", 
       SubscriptBox["\[Psi]", "2"]}], ",", 
      RowBox[{"F1", "\[Rule]", 
       SubscriptBox["F", "1"]}], ",", 
      RowBox[{"psi1", "\[Rule]", 
       SubscriptBox["\[Psi]", "1"]}], ",", 
      RowBox[{"tau", "\[Rule]", "\[Tau]"}], ",", 
      RowBox[{"Fs", "\[Rule]", 
       SubscriptBox["F", "*"]}]}], "}"}]}], "//", "FullSimplify"}]}]], "Input",\

 CellChangeTimes->{{3.86927107716265*^9, 
  3.8692710778748207`*^9}},ExpressionUUID->"dcaa22ba-9874-4b8c-b22e-\
7f657dbb4166"],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SubsuperscriptBox["F", "1", "2"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"2", " ", 
      SubscriptBox["\[Psi]", "1"]}], "-", 
     SubscriptBox["\[Psi]", "2"]}], ")"}]}], 
  RowBox[{
   SuperscriptBox["\[Tau]", "2"], "+", 
   RowBox[{
    SubsuperscriptBox["F", "1", "2"], " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", 
      RowBox[{"2", " ", 
       SubscriptBox["\[Psi]", "1"]}], "-", 
      SubscriptBox["\[Psi]", "2"]}], ")"}]}], "+", 
   SubsuperscriptBox["F", "*", "2"]}]]], "Output",
 CellChangeTimes->{3.869007012227281*^9},
 CellLabel->"Out[91]=",ExpressionUUID->"d6086b5e-f51e-4b98-9403-a242f101bc19"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{
   RowBox[{
   "Justify", " ", "the", " ", "change", " ", "of", " ", "sign", " ", "when", 
    " ", "alpha", " ", "below", " ", "and", " ", "above", " ", "alpha_L"}], 
   ",", " ", 
   RowBox[{"when", " ", "below", " ", "alpha_L"}], ",", " ", 
   RowBox[{"it", " ", "is", " ", "negative"}]}], "*)"}]], "Input",
 CellChangeTimes->{{3.869007055051194*^9, 3.86900708356005*^9}, {
  3.869008559125683*^9, 3.869008575620481*^9}, {3.8690654849186907`*^9, 
  3.86906549277245*^9}, {3.869271080272811*^9, 
  3.86927108294208*^9}},ExpressionUUID->"bfd77eb0-b363-42d1-83e1-\
b4f0c9d5347e"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"D", "[", 
     RowBox[{"objective2", ",", "chi"}], "]"}], "/.", 
    RowBox[{"{", 
     RowBox[{"chi", "\[Rule]", 
      RowBox[{"-", "psi2"}]}], "}"}]}], "/.", 
   RowBox[{"{", 
    RowBox[{"\[Alpha]", "\[Rule]", "0"}], "}"}]}], "//", 
  "FullSimplify"}]], "Input",
 CellLabel->"In[92]:=",ExpressionUUID->"daed21c2-7308-4de4-a66f-28328da84015"],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SuperscriptBox["F1", "2"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "2"}], " ", "psi1"}], "+", "psi2"}], ")"}]}], 
  RowBox[{"psi1", "-", "psi2"}]]], "Output",
 CellChangeTimes->{3.869007087941737*^9},
 CellLabel->"Out[92]=",ExpressionUUID->"91b4b4a6-9efb-463b-9f47-cf1125c4556d"]
}, Open  ]],

Cell[BoxData["\[IndentingNewLine]"], "Input",
 CellChangeTimes->{{3.869009860541257*^9, 
  3.869009870384968*^9}},ExpressionUUID->"12e3f324-7972-4b59-8d60-\
310580945a3e"],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.869009867300757*^9, 
  3.869009867302009*^9}},ExpressionUUID->"fcc78fb8-449e-4b34-beb8-\
7c385037db00"],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{
   RowBox[{"find", " ", "the", " ", 
    RowBox[{"do", "/", "dx"}], " ", "at", " ", "X_R", " ", "for", " ", 
    "alpha_R", " ", "when", " ", "psi2"}], " ", ">", " ", "1"}], 
  "*)"}]], "Input",
 CellChangeTimes->{{3.8690084556856833`*^9, 
  3.86900846652608*^9}},ExpressionUUID->"8a1f5848-0aa2-4d6f-a754-\
0e25cc953aaa"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"D", "[", 
     RowBox[{"objective2", ",", "chi"}], "]"}], "/.", 
    RowBox[{"{", 
     RowBox[{"chi", "\[Rule]", 
      RowBox[{"1", "-", "psi2"}]}], "}"}]}], "/.", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"psi2", "\[Rule]", 
      SubscriptBox["\[Psi]", "2"]}], ",", 
     RowBox[{"F1", "\[Rule]", 
      SubscriptBox["F", "1"]}], ",", 
     RowBox[{"psi1", "\[Rule]", 
      SubscriptBox["\[Psi]", "1"]}], ",", 
     RowBox[{"tau", "\[Rule]", "\[Tau]"}], ",", 
     RowBox[{"Fs", "\[Rule]", 
      SubscriptBox["F", "*"]}]}], "}"}]}], "//", "FullSimplify"}]], "Input",
 CellLabel->"In[93]:=",ExpressionUUID->"88bf0afa-5fe0-4279-841e-c96d16977fa3"],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{
    SubsuperscriptBox["F", "1", "2"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", 
       SubscriptBox["\[Psi]", "2"]}], ")"}], "2"], " ", 
    RowBox[{"(", 
     RowBox[{"\[Alpha]", "-", 
      RowBox[{"2", " ", "\[Alpha]", " ", 
       SubscriptBox["\[Psi]", "1"]}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "+", "\[Alpha]"}], ")"}], " ", 
       SubscriptBox["\[Psi]", "2"]}]}], ")"}]}], "-", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"\[Alpha]", "+", 
      RowBox[{
       SubscriptBox["\[Psi]", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "2"}], " ", "\[Alpha]"}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["\[Psi]", "1"]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "2"}], "+", "\[Alpha]"}], ")"}], " ", 
          SubscriptBox["\[Psi]", "2"]}]}], ")"}]}]}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["\[Tau]", "2"], "+", 
      SubsuperscriptBox["F", "*", "2"]}], ")"}]}]}], 
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      SubscriptBox["\[Psi]", "2"]}], ")"}], "2"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", 
      SubscriptBox["\[Psi]", "1"]}], "+", 
     SubscriptBox["\[Psi]", "2"]}], ")"}]}]]], "Output",
 CellChangeTimes->{3.8690079835742826`*^9},
 CellLabel->"Out[93]=",ExpressionUUID->"2fa639c6-380e-4506-b793-43ca3f00d4e5"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{"Show", " ", "that", " ", 
   RowBox[{"do", "/", "dx"}], " ", "at", " ", "X_R", " ", "is", " ", "a", " ",
    "linear", " ", "increasing", " ", "function", " ", "of", " ", "alpha"}], 
  " ", "*)"}]], "Input",
 CellChangeTimes->{{3.869008403407263*^9, 3.8690084752828417`*^9}, {
  3.86900878783768*^9, 3.869008790366377*^9}, {3.8692711047780952`*^9, 
  3.869271110785795*^9}},ExpressionUUID->"0c0eeb80-0a63-4b83-a7f7-\
6b0b68535d64"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"D", "[", 
   RowBox[{
    FractionBox[
     RowBox[{
      RowBox[{
       SubsuperscriptBox["F", "1", "2"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          SubscriptBox["\[Psi]", "2"]}], ")"}], "2"], " ", 
       RowBox[{"(", 
        RowBox[{"\[Alpha]", "-", 
         RowBox[{"2", " ", "\[Alpha]", " ", 
          SubscriptBox["\[Psi]", "1"]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "+", "\[Alpha]"}], ")"}], " ", 
          SubscriptBox["\[Psi]", "2"]}]}], ")"}]}], "-", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"\[Alpha]", "+", 
         RowBox[{
          SubscriptBox["\[Psi]", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "2"}], " ", "\[Alpha]"}], "+", 
            RowBox[{"2", " ", 
             SubscriptBox["\[Psi]", "1"]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "2"}], "+", "\[Alpha]"}], ")"}], " ", 
             SubscriptBox["\[Psi]", "2"]}]}], ")"}]}]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["\[Tau]", "2"], "+", 
         SubsuperscriptBox["F", "*", "2"]}], ")"}]}]}], 
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         SubscriptBox["\[Psi]", "2"]}], ")"}], "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SubscriptBox["\[Psi]", "1"]}], "+", 
        SubscriptBox["\[Psi]", "2"]}], ")"}]}]], ",", "\[Alpha]"}], " ", 
   "]"}], "//", "FullSimplify"}]], "Input",
 CellChangeTimes->{{3.869008233413064*^9, 3.8690082561162233`*^9}},
 CellLabel->"In[94]:=",ExpressionUUID->"445efe22-d182-4efc-83b9-e1c25cb99694"],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SuperscriptBox["\[Tau]", "2"], "+", 
   RowBox[{
    SubsuperscriptBox["F", "1", "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      RowBox[{"2", " ", 
       SubscriptBox["\[Psi]", "1"]}], "-", 
      SubscriptBox["\[Psi]", "2"]}], ")"}]}], "+", 
   SubsuperscriptBox["F", "*", "2"]}], 
  RowBox[{
   SubscriptBox["\[Psi]", "1"], "-", 
   SubscriptBox["\[Psi]", "2"]}]]], "Output",
 CellChangeTimes->{3.869008258439754*^9},
 CellLabel->"Out[94]=",ExpressionUUID->"3e165d80-7c2d-4a83-bb05-5c248e5ed28d"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{
   RowBox[{
   "show", " ", "the", " ", "condition", " ", "for", " ", "the", " ", "first",
     " ", "implication", " ", "for", " ", 
    RowBox[{"do", "/", "dx"}], " ", "at", " ", "X_R", " ", "at", " ", 
    "alpha"}], " ", "=", " ", "1"}], " ", "*)"}]], "Input",
 CellChangeTimes->{{3.86900862401239*^9, 3.869008638955694*^9}, {
  3.869008675074793*^9, 3.869008692213546*^9}, {3.869008766435306*^9, 
  3.8690087978870153`*^9}, {3.86901029189051*^9, 
  3.869010297964608*^9}},ExpressionUUID->"27b590a9-b92f-45e3-bef8-\
db8e97de2e1e"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"D", "[", 
     RowBox[{"objective2", ",", "chi"}], "]"}], "/.", 
    RowBox[{"{", 
     RowBox[{"chi", "\[Rule]", 
      RowBox[{"1", "-", "psi2"}]}], "}"}]}], "/.", 
   RowBox[{"{", 
    RowBox[{"\[Alpha]", "\[Rule]", "1"}], "}"}]}], "//", 
  "FullSimplify"}]], "Input",
 CellLabel->"In[95]:=",ExpressionUUID->"fa677965-17ff-4557-a475-9492242028d2"],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{
    RowBox[{"-", 
     SuperscriptBox["F1", "2"]}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      RowBox[{"2", " ", "psi1"}], "-", 
      RowBox[{"2", " ", "psi2"}]}], ")"}], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", "psi2"}], ")"}], "2"]}], "+", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      RowBox[{"psi2", " ", 
       RowBox[{"(", 
        RowBox[{"2", "-", 
         RowBox[{"2", " ", "psi1"}], "+", "psi2"}], ")"}]}]}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["Fs", "2"], "+", 
      SuperscriptBox["tau", "2"]}], ")"}]}]}], 
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", "psi2"}], ")"}], "2"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "psi1"}], "+", "psi2"}], ")"}]}]]], "Output",
 CellChangeTimes->{3.869009220471451*^9},
 CellLabel->"Out[95]=",ExpressionUUID->"e7981528-bdbb-4be8-8633-aced4a0aaa3f"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{
  "the", " ", "threshold", " ", "B", " ", "is", " ", "calcuted", " ", "when", 
   " ", "the", " ", "above", " ", "condition", " ", "is", " ", "0"}], 
  "*)"}]], "Input",
 CellChangeTimes->{{3.8690092299894667`*^9, 3.869009253088284*^9}, {
  3.869009296902769*^9, 
  3.869009359502524*^9}},ExpressionUUID->"1b2a9323-8929-4e71-bb99-\
9bbd7f6b4151"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Solve", "[", 
   RowBox[{
    RowBox[{
     FractionBox[
      RowBox[{
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["F1", "2"]}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          RowBox[{"2", " ", "psi1"}], "-", 
          RowBox[{"2", " ", "psi2"}]}], ")"}], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "+", "psi2"}], ")"}], "2"]}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          RowBox[{"psi2", " ", 
           RowBox[{"(", 
            RowBox[{"2", "-", 
             RowBox[{"2", " ", "psi1"}], "+", "psi2"}], ")"}]}]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["Fs", "2"], "+", 
          SuperscriptBox["tau", "2"]}], ")"}]}]}], "1"], "\[Equal]", "0"}], 
    ",", " ", "psi1"}], "]"}], "//", "FullSimplify"}]], "Input",
 CellLabel->"In[96]:=",ExpressionUUID->"34d049bd-74cf-4338-bae9-9225f55c972b"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"psi1", "\[Rule]", 
    FractionBox[
     RowBox[{
      RowBox[{
       SuperscriptBox["F1", "2"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "psi2"}], ")"}], "2"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", 
         RowBox[{"2", " ", "psi2"}]}], ")"}]}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         RowBox[{"psi2", " ", 
          RowBox[{"(", 
           RowBox[{"2", "+", "psi2"}], ")"}]}]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["Fs", "2"], "+", 
         SuperscriptBox["tau", "2"]}], ")"}]}]}], 
     RowBox[{"2", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         SuperscriptBox["F1", "2"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", "psi2"}], ")"}], "2"]}], "+", 
        RowBox[{"psi2", " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["Fs", "2"], "+", 
           SuperscriptBox["tau", "2"]}], ")"}]}]}], ")"}]}]]}], "}"}], 
  "}"}]], "Output",
 CellChangeTimes->{3.869009320571529*^9},
 CellLabel->"Out[96]=",ExpressionUUID->"bfe82cdb-74b3-4966-a53a-d8bd141a04e2"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{
   RowBox[{
    RowBox[{"Show", " ", "that", " ", "when", " ", "psi1"}], " ", "<", " ", 
    "B"}], ",", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"do", "/", "dx"}], " ", "at", " ", "X_R", " ", "at", " ", 
     "alpha"}], " ", "=", " ", 
    RowBox[{"1", " ", "is", " ", "negative"}]}]}], "*)"}]], "Input",
 CellChangeTimes->{{3.8690101473627167`*^9, 3.869010184219673*^9}, {
  3.869010263933072*^9, 
  3.8690103261116533`*^9}},ExpressionUUID->"26da55ac-d01b-4647-81ef-\
194e56f43d56"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"D", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["F1", "2"]}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        RowBox[{"2", " ", "psi1"}], "-", 
        RowBox[{"2", " ", "psi2"}]}], ")"}], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "psi2"}], ")"}], "2"]}], "+", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        RowBox[{"psi2", " ", 
         RowBox[{"(", 
          RowBox[{"2", "-", 
           RowBox[{"2", " ", "psi1"}], "+", "psi2"}], ")"}]}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["Fs", "2"], "+", 
        SuperscriptBox["tau", "2"]}], ")"}]}]}], ",", " ", "psi1"}], "]"}], "//",
   "FullSimplify"}]], "Input",
 CellChangeTimes->{{3.869010090445888*^9, 3.869010104217588*^9}},
 CellLabel->"In[98]:=",ExpressionUUID->"5ad5bc52-218d-4298-a124-7a2241b4e44b"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"-", "2"}], " ", 
   SuperscriptBox["F1", "2"], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", "psi2"}], ")"}], "2"]}], "-", 
  RowBox[{"2", " ", "psi2", " ", 
   RowBox[{"(", 
    RowBox[{
     SuperscriptBox["Fs", "2"], "+", 
     SuperscriptBox["tau", "2"]}], ")"}]}]}]], "Output",
 CellChangeTimes->{3.8690101065423098`*^9},
 CellLabel->"Out[98]=",ExpressionUUID->"4e2e53f0-d389-4487-80b8-1714d8d31c06"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{
   RowBox[{"find", " ", "the", " ", 
    RowBox[{"do", "/", "dx"}], " ", "at", " ", "X_R", " ", "for", " ", 
    "alpha_R", " ", "when", " ", "psi2"}], " ", "<", " ", "1"}], 
  "*)"}]], "Input",
 CellChangeTimes->{{3.869010346562158*^9, 3.8690103502013807`*^9}, {
  3.869010498237664*^9, 
  3.869010507982951*^9}},ExpressionUUID->"edfbeba1-6a85-44c1-ba91-\
d26c95cfffc5"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"D", "[", 
     RowBox[{"objective2", ",", "chi"}], "]"}], "/.", 
    RowBox[{"{", 
     RowBox[{"chi", "\[Rule]", "0"}], "}"}]}], "/.", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"psi2", "\[Rule]", 
      SubscriptBox["\[Psi]", "2"]}], ",", 
     RowBox[{"F1", "\[Rule]", 
      SubscriptBox["F", "1"]}], ",", 
     RowBox[{"psi1", "\[Rule]", 
      SubscriptBox["\[Psi]", "1"]}], ",", 
     RowBox[{"tau", "\[Rule]", "\[Tau]"}], ",", 
     RowBox[{"Fs", "\[Rule]", 
      SubscriptBox["F", "*"]}]}], "}"}]}], "//", "FullSimplify"}]], "Input",
 CellLabel->"In[99]:=",ExpressionUUID->"dc4dfb41-bc59-476e-8b88-6100675dc97f"],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{
    SubsuperscriptBox["F", "1", "2"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", 
       SubscriptBox["\[Psi]", "2"]}], ")"}], "2"], " ", 
    RowBox[{"(", 
     RowBox[{"\[Alpha]", "+", 
      RowBox[{"2", " ", "\[Alpha]", " ", 
       SubscriptBox["\[Psi]", "1"]}], "-", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "+", 
         RowBox[{"3", " ", "\[Alpha]"}]}], ")"}], " ", 
       SubscriptBox["\[Psi]", "2"]}]}], ")"}]}], "+", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"\[Alpha]", "+", 
      RowBox[{"2", " ", 
       SubscriptBox["\[Psi]", "1"]}], "-", 
      RowBox[{"2", " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "\[Alpha]"}], ")"}], " ", 
       SubscriptBox["\[Psi]", "2"]}], "+", 
      RowBox[{"\[Alpha]", " ", 
       SubsuperscriptBox["\[Psi]", "2", "2"]}]}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["\[Tau]", "2"], "+", 
      SubsuperscriptBox["F", "*", "2"]}], ")"}]}]}], 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     SubscriptBox["\[Psi]", "1"], "-", 
     SubscriptBox["\[Psi]", "2"]}], ")"}], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      SubscriptBox["\[Psi]", "2"]}], ")"}], "2"]}]]], "Input",
 CellChangeTimes->{3.869010662098*^9},
 CellLabel->"Out[99]=",ExpressionUUID->"dd77379e-1e75-44b9-9caa-b9b87b05926f"],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{"Show", " ", "that", " ", 
   RowBox[{"do", "/", "dx"}], " ", "at", " ", "X_R", " ", "is", " ", "a", " ",
    "linear", " ", "increasing", " ", "function", " ", "of", " ", "alpha"}], 
  " ", "*)"}]], "Input",ExpressionUUID->"858d9dda-2cfa-43a0-b3e3-\
442ee957fc7c"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"D", "[", 
   RowBox[{
    FractionBox[
     RowBox[{
      RowBox[{
       SubsuperscriptBox["F", "1", "2"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          SubscriptBox["\[Psi]", "2"]}], ")"}], "2"], " ", 
       RowBox[{"(", 
        RowBox[{"\[Alpha]", "+", 
         RowBox[{"2", " ", "\[Alpha]", " ", 
          SubscriptBox["\[Psi]", "1"]}], "-", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{"3", " ", "\[Alpha]"}]}], ")"}], " ", 
          SubscriptBox["\[Psi]", "2"]}]}], ")"}]}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"\[Alpha]", "+", 
         RowBox[{"2", " ", 
          SubscriptBox["\[Psi]", "1"]}], "-", 
         RowBox[{"2", " ", 
          RowBox[{"(", 
           RowBox[{"1", "+", "\[Alpha]"}], ")"}], " ", 
          SubscriptBox["\[Psi]", "2"]}], "+", 
         RowBox[{"\[Alpha]", " ", 
          SubsuperscriptBox["\[Psi]", "2", "2"]}]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["\[Tau]", "2"], "+", 
         SubsuperscriptBox["F", "*", "2"]}], ")"}]}]}], 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        SubscriptBox["\[Psi]", "1"], "-", 
        SubscriptBox["\[Psi]", "2"]}], ")"}], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         SubscriptBox["\[Psi]", "2"]}], ")"}], "2"]}]], ",", "\[Alpha]"}], 
   " ", "]"}], "//", "FullSimplify"}]], "Input",
 CellChangeTimes->{3.869010667976767*^9},
 CellLabel->
  "In[100]:=",ExpressionUUID->"f12cf372-3afc-4a15-9ad6-072003b98e60"],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SuperscriptBox["\[Tau]", "2"], "+", 
   RowBox[{
    SubsuperscriptBox["F", "1", "2"], " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", 
      RowBox[{"2", " ", 
       SubscriptBox["\[Psi]", "1"]}], "-", 
      RowBox[{"3", " ", 
       SubscriptBox["\[Psi]", "2"]}]}], ")"}]}], "+", 
   SubsuperscriptBox["F", "*", "2"]}], 
  RowBox[{
   SubscriptBox["\[Psi]", "1"], "-", 
   SubscriptBox["\[Psi]", "2"]}]]], "Output",
 CellChangeTimes->{3.869010670647359*^9},
 CellLabel->
  "Out[100]=",ExpressionUUID->"85734363-5820-4851-9aca-3150b0a77c90"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{
   RowBox[{
   "show", " ", "the", " ", "condition", " ", "for", " ", "the", " ", "first",
     " ", "implication", " ", "for", " ", 
    RowBox[{"do", "/", "dx"}], " ", "at", " ", "X_R", " ", "at", " ", 
    "alpha"}], " ", "=", "1"}], "*)"}]], "Input",
 CellChangeTimes->{{3.869010725806995*^9, 3.869010726262128*^9}, {
  3.869010760467031*^9, 3.869010763028421*^9}, {3.869010842426488*^9, 
  3.869010842770564*^9}, {3.869048953898447*^9, 
  3.8690489636865664`*^9}},ExpressionUUID->"8b2381ee-2550-4c57-a87f-\
daf97a3bcdcf"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"D", "[", 
     RowBox[{"objective2", ",", "chi"}], "]"}], "/.", 
    RowBox[{"{", 
     RowBox[{"chi", "\[Rule]", "0"}], "}"}]}], "/.", 
   RowBox[{"{", 
    RowBox[{"\[Alpha]", "\[Rule]", "1"}], "}"}]}], "//", 
  "FullSimplify"}]], "Input",
 CellLabel->
  "In[101]:=",ExpressionUUID->"3d339f46-048a-4d01-9df4-48bb27c6d1ba"],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{
    SuperscriptBox["F1", "2"], " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", 
      RowBox[{"2", " ", "psi1"}], "-", 
      RowBox[{"4", " ", "psi2"}]}], ")"}], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", "psi2"}], ")"}], "2"]}], "+", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"1", "+", 
      RowBox[{"2", " ", "psi1"}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "4"}], "+", "psi2"}], ")"}], " ", "psi2"}]}], ")"}], 
    " ", 
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["Fs", "2"], "+", 
      SuperscriptBox["tau", "2"]}], ")"}]}]}], 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"psi1", "-", "psi2"}], ")"}], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", "psi2"}], ")"}], "2"]}]]], "Output",
 CellChangeTimes->{3.869010940698036*^9},
 CellLabel->
  "Out[101]=",ExpressionUUID->"8300efc3-030e-48a0-85ab-2747276e49dc"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{
  "the", " ", "threshold", " ", "B", " ", "is", " ", "calcuted", " ", "when", 
   " ", "the", " ", "above", " ", "condition", " ", "is", " ", "0"}], 
  "*)"}]], "Input",ExpressionUUID->"630bdadd-99e2-4265-9a7e-3625fbbf2815"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Solve", "[", 
   RowBox[{
    RowBox[{
     FractionBox[
      RowBox[{
       RowBox[{
        SuperscriptBox["F1", "2"], " ", 
        RowBox[{"(", 
         RowBox[{"1", "+", 
          RowBox[{"2", " ", "psi1"}], "-", 
          RowBox[{"4", " ", "psi2"}]}], ")"}], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "+", "psi2"}], ")"}], "2"]}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "+", 
          RowBox[{"2", " ", "psi1"}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "4"}], "+", "psi2"}], ")"}], " ", "psi2"}]}], ")"}],
         " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["Fs", "2"], "+", 
          SuperscriptBox["tau", "2"]}], ")"}]}]}], "1"], "\[Equal]", "0"}], 
    ",", "psi1"}], "]"}], "//", "FullSimplify"}]], "Input",
 CellLabel->
  "In[102]:=",ExpressionUUID->"8802c1b8-f638-4b76-96f4-ea6cd8612d53"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"psi1", "\[Rule]", 
    FractionBox[
     RowBox[{
      RowBox[{
       SuperscriptBox["F1", "2"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "psi2"}], ")"}], "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         RowBox[{"4", " ", "psi2"}]}], ")"}]}], "-", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "4"}], "+", "psi2"}], ")"}], " ", "psi2"}]}], ")"}], 
       " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["Fs", "2"], "+", 
         SuperscriptBox["tau", "2"]}], ")"}]}]}], 
     RowBox[{"2", " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["Fs", "2"], "+", 
        RowBox[{
         SuperscriptBox["F1", "2"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", "psi2"}], ")"}], "2"]}], "+", 
        SuperscriptBox["tau", "2"]}], ")"}]}]]}], "}"}], "}"}]], "Output",
 CellChangeTimes->{3.869010954672842*^9},
 CellLabel->
  "Out[102]=",ExpressionUUID->"c8575da2-9551-4f27-9b5f-17e9ff9000d6"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{
   RowBox[{
    RowBox[{"Show", " ", "that", " ", "when", " ", "psi1"}], " ", "<", " ", 
    "B"}], ",", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"do", "/", "dx"}], " ", "at", " ", "X_R", " ", "at", " ", 
     "alpha"}], " ", "=", " ", 
    RowBox[{"1", " ", "is", " ", "negative"}]}]}], "*)"}]], "Input",Expression\
UUID->"f8f35584-c9f7-4787-924d-a72631450d06"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"D", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      SuperscriptBox["F1", "2"], " ", 
      RowBox[{"(", 
       RowBox[{"1", "+", 
        RowBox[{"2", " ", "psi1"}], "-", 
        RowBox[{"4", " ", "psi2"}]}], ")"}], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "psi2"}], ")"}], "2"]}], "+", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "+", 
        RowBox[{"2", " ", "psi1"}], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "4"}], "+", "psi2"}], ")"}], " ", "psi2"}]}], ")"}], 
      " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["Fs", "2"], "+", 
        SuperscriptBox["tau", "2"]}], ")"}]}]}], ",", " ", "psi1"}], "]"}], "//",
   "FullSimplify"}]], "Input",
 CellChangeTimes->{{3.8690110486005163`*^9, 3.869011068769184*^9}},
 CellLabel->
  "In[103]:=",ExpressionUUID->"dcaf8508-e11b-4e54-b16f-0e89875b75d5"],

Cell[BoxData[
 RowBox[{"2", " ", 
  RowBox[{"(", 
   RowBox[{
    SuperscriptBox["Fs", "2"], "+", 
    RowBox[{
     SuperscriptBox["F1", "2"], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", "psi2"}], ")"}], "2"]}], "+", 
    SuperscriptBox["tau", "2"]}], ")"}]}]], "Output",
 CellChangeTimes->{3.869011072073779*^9},
 CellLabel->
  "Out[103]=",ExpressionUUID->"ceb19a24-05e7-4328-9ddc-b6c2791be0eb"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{
   RowBox[{
   "show", " ", "the", " ", "condition", " ", "for", " ", "the", " ", 
    "second", " ", "implication", " ", "for", " ", 
    RowBox[{"do", "/", "dx"}], " ", "at", " ", "X_R", " ", "at", " ", 
    "alpha"}], " ", "=", " ", 
   RowBox[{
    RowBox[{"0", " ", "when", " ", "psi2"}], " ", ">", " ", "1"}]}], " ", 
  "*)"}]], "Input",
 CellChangeTimes->{{3.869013726265332*^9, 3.869013732594242*^9}, {
  3.8690489789009132`*^9, 
  3.8690489916312237`*^9}},ExpressionUUID->"edc56c89-9cae-49bd-9d09-\
f5605111b236"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"D", "[", 
     RowBox[{"objective2", ",", "chi"}], "]"}], "/.", 
    RowBox[{"{", 
     RowBox[{"chi", "\[Rule]", 
      RowBox[{"1", "-", "psi2"}]}], "}"}]}], "/.", 
   RowBox[{"{", 
    RowBox[{"\[Alpha]", "\[Rule]", "0"}], "}"}]}], "//", 
  "FullSimplify"}]], "Input",
 CellChangeTimes->{{3.869013848947648*^9, 3.869013849184339*^9}},
 CellLabel->"In[42]:=",ExpressionUUID->"1eed43a3-117d-46c0-b030-7f18821f8e66"],

Cell[BoxData[
 FractionBox[
  RowBox[{"psi2", " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      SuperscriptBox["F1", "2"], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "psi2"}], ")"}], "2"]}], "-", 
     RowBox[{"2", " ", 
      RowBox[{"(", 
       RowBox[{"psi1", "-", "psi2"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["Fs", "2"], "+", 
        SuperscriptBox["tau", "2"]}], ")"}]}]}], ")"}]}], 
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", "psi2"}], ")"}], "2"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "psi1"}], "+", "psi2"}], ")"}]}]]], "Output",
 CellChangeTimes->{3.869013851737417*^9, 3.8690489960668497`*^9},
 CellLabel->"Out[42]=",ExpressionUUID->"212c786a-14d4-4b0c-ad33-64ea3222eacd"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{
  "the", " ", "threshold", " ", "A", " ", "is", " ", "calcuted", " ", "when", 
   " ", "the", " ", "above", " ", "condition", " ", "is", " ", "0"}], 
  "*)"}]], "Input",
 CellChangeTimes->{{3.869013888479813*^9, 
  3.8690138888425493`*^9}},ExpressionUUID->"0d964abf-ef78-43f0-8932-\
8d3996317cfa"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Solve", "[", 
   RowBox[{
    RowBox[{
     FractionBox[
      RowBox[{"psi2", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SuperscriptBox["F1", "2"], " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", "psi2"}], ")"}], "2"]}], "-", 
         RowBox[{"2", " ", 
          RowBox[{"(", 
           RowBox[{"psi1", "-", "psi2"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["Fs", "2"], "+", 
            SuperscriptBox["tau", "2"]}], ")"}]}]}], ")"}]}], "1"], 
     "\[Equal]", "0"}], ",", " ", "psi1"}], "]"}], "//", 
  "FullSimplify"}]], "Input",
 CellChangeTimes->{{3.869013910854727*^9, 3.8690139146083813`*^9}},
 CellLabel->"In[43]:=",ExpressionUUID->"1b41cf86-0023-47c8-a641-286be56c35dc"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"psi1", "\[Rule]", 
    RowBox[{"psi2", "+", 
     FractionBox[
      RowBox[{
       SuperscriptBox["F1", "2"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "psi2"}], ")"}], "2"]}], 
      RowBox[{"2", " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["Fs", "2"], "+", 
         SuperscriptBox["tau", "2"]}], ")"}]}]]}]}], "}"}], "}"}]], "Output",
 CellChangeTimes->{3.869013917288273*^9, 3.869048999317605*^9},
 CellLabel->"Out[43]=",ExpressionUUID->"c4b0cd55-30fb-452c-a141-f8c562d6cd13"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{
   RowBox[{
    RowBox[{"Show", " ", "that", " ", "when", " ", "psi1"}], " ", ">", " ", 
    "A"}], ",", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"do", "/", "dx"}], " ", "at", " ", "X_R", " ", "at", " ", 
     "alpha"}], " ", "=", " ", 
    RowBox[{"0", " ", "is", " ", "positive"}]}]}], "*)"}]], "Input",
 CellChangeTimes->{{3.8690496926572123`*^9, 3.869049700640072*^9}, {
  3.869049773030746*^9, 
  3.8690497733777313`*^9}},ExpressionUUID->"6ffe87f9-16bf-47d9-9f93-\
464cdd49e6a3"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"D", "[", 
   RowBox[{
    FractionBox[
     RowBox[{"psi2", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         SuperscriptBox["F1", "2"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", "psi2"}], ")"}], "2"]}], "-", 
        RowBox[{"2", " ", 
         RowBox[{"(", 
          RowBox[{"psi1", "-", "psi2"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["Fs", "2"], "+", 
           SuperscriptBox["tau", "2"]}], ")"}]}]}], ")"}]}], "1"], ",", " ", 
    "psi1"}], "]"}], "//", "FullSimplify"}]], "Input",
 CellChangeTimes->{{3.8690496183195257`*^9, 3.8690496360045643`*^9}},
 CellLabel->"In[44]:=",ExpressionUUID->"70bf5562-e6a4-4eca-8c6d-baad2ee4357f"],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "2"}], " ", "psi2", " ", 
  RowBox[{"(", 
   RowBox[{
    SuperscriptBox["Fs", "2"], "+", 
    SuperscriptBox["tau", "2"]}], ")"}]}]], "Output",
 CellChangeTimes->{3.869049638557845*^9},
 CellLabel->"Out[44]=",ExpressionUUID->"645531f6-ddf3-4e2f-9abd-765515458e7c"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{
   RowBox[{
   "show", " ", "the", " ", "condition", " ", "for", " ", "the", " ", 
    "second", " ", "implication", " ", "for", " ", 
    RowBox[{"do", "/", "dx"}], " ", "at", " ", "X_R", " ", "at", " ", 
    "alpha"}], " ", "=", " ", 
   RowBox[{
    RowBox[{"0", " ", "when", " ", "psi2"}], " ", "<", " ", "1"}]}], " ", 
  "*)"}]], "Input",
 CellChangeTimes->{{3.869049033369299*^9, 
  3.8690490339023237`*^9}},ExpressionUUID->"1cb33d63-3471-4bd1-9b8b-\
16237cd06059"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"D", "[", 
     RowBox[{"objective2", ",", "chi"}], "]"}], "/.", 
    RowBox[{"{", 
     RowBox[{"chi", "\[Rule]", "0"}], "}"}]}], "/.", 
   RowBox[{"{", 
    RowBox[{"\[Alpha]", "\[Rule]", "0"}], "}"}]}], "//", 
  "FullSimplify"}]], "Input",
 CellChangeTimes->{{3.86904904550609*^9, 3.8690490457094193`*^9}},
 CellLabel->"In[45]:=",ExpressionUUID->"82303478-46d4-4abb-aa48-bf065edefb81"],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   FractionBox[
    RowBox[{
     SuperscriptBox["F1", "2"], " ", "psi2"}], 
    RowBox[{"psi1", "-", "psi2"}]]}], "+", 
  FractionBox[
   RowBox[{"2", " ", 
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["Fs", "2"], "+", 
      SuperscriptBox["tau", "2"]}], ")"}]}], 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", "psi2"}], ")"}], "2"]]}]], "Output",
 CellChangeTimes->{3.8690497105721292`*^9},
 CellLabel->"Out[45]=",ExpressionUUID->"345ef6e8-1383-412d-9684-38b18922d14b"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{
  "the", " ", "threshold", " ", "A", " ", "is", " ", "calcuted", " ", "when", 
   " ", "the", " ", "above", " ", "condition", " ", "is", " ", "0"}], 
  "*)"}]], "Input",ExpressionUUID->"140d4113-39dd-49d1-9c46-80ef07ef044f"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Solve", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"-", 
       FractionBox[
        RowBox[{
         SuperscriptBox["F1", "2"], " ", "psi2"}], 
        RowBox[{"psi1", "-", "psi2"}]]}], "+", 
      FractionBox[
       RowBox[{"2", " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["Fs", "2"], "+", 
          SuperscriptBox["tau", "2"]}], ")"}]}], 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "psi2"}], ")"}], "2"]]}], "\[Equal]", 
     "0"}], ",", " ", "psi1"}], "]"}], "//", "FullSimplify"}]], "Input",
 CellChangeTimes->{3.869049737032589*^9},
 CellLabel->"In[47]:=",ExpressionUUID->"9bf4d270-e623-4216-9dbc-4d398b38e4f0"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"psi1", "\[Rule]", 
    RowBox[{"psi2", "+", 
     FractionBox[
      RowBox[{
       SuperscriptBox["F1", "2"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "psi2"}], ")"}], "2"], " ", "psi2"}], 
      RowBox[{"2", " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["Fs", "2"], "+", 
         SuperscriptBox["tau", "2"]}], ")"}]}]]}]}], "}"}], "}"}]], "Output",
 CellChangeTimes->{{3.8690497233722773`*^9, 3.869049740831032*^9}},
 CellLabel->"Out[47]=",ExpressionUUID->"02a544a1-c133-42e5-8879-c51d10acf2a0"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{
   RowBox[{
    RowBox[{"Show", " ", "that", " ", "when", " ", "psi1"}], " ", ">", " ", 
    "A"}], ",", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"do", "/", "dx"}], " ", "at", " ", "X_R", " ", "at", " ", 
     "alpha"}], " ", "=", " ", 
    RowBox[{"0", " ", "is", " ", "positive"}]}]}], "*)"}]], "Input",
 CellChangeTimes->{{3.869049775002256*^9, 
  3.8690497752668867`*^9}},ExpressionUUID->"4367196e-c584-4cdf-84bf-\
cd475cd596f5"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"D", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      FractionBox[
       RowBox[{
        SuperscriptBox["F1", "2"], " ", "psi2"}], 
       RowBox[{"psi1", "-", "psi2"}]]}], "+", 
     FractionBox[
      RowBox[{"2", " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["Fs", "2"], "+", 
         SuperscriptBox["tau", "2"]}], ")"}]}], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "psi2"}], ")"}], "2"]]}], ",", " ", 
    "psi1"}], "]"}], "//", "FullSimplify"}]], "Input",
 CellChangeTimes->{{3.869049795684884*^9, 3.869049796354267*^9}},
 CellLabel->"In[48]:=",ExpressionUUID->"02ffec23-4eba-4958-9374-d9f841217079"],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SuperscriptBox["F1", "2"], " ", "psi2"}], 
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{"psi1", "-", "psi2"}], ")"}], "2"]]], "Output",
 CellChangeTimes->{3.8690498000028563`*^9},
 CellLabel->"Out[48]=",ExpressionUUID->"bbe433ce-a19c-418d-8bb6-e0e4b75bfe7d"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{"Then", ",", " ", 
   RowBox[{
   "we", " ", "can", " ", "show", " ", "the", " ", "alpha", " ", "R", " ", 
    "when", " ", "psi1", " ", "is", " ", "between", " ", "A", " ", "and", " ",
     "B"}]}], "*)"}]], "Input",
 CellChangeTimes->{{3.869049829690456*^9, 3.869049835650754*^9}, {
  3.869049876570703*^9, 3.869049879095615*^9}, {3.869050284749042*^9, 
  3.86905030439157*^9}},ExpressionUUID->"79498c87-8fd8-4e5d-a24f-\
158c29f2b8f1"],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{
   RowBox[{"alpha", " ", "R", " ", "when", " ", "psi2"}], " ", ">", " ", 
   "1"}], "*)"}]], "Input",
 CellChangeTimes->{{3.869050345887073*^9, 3.869050356059864*^9}, {
  3.869050423257319*^9, 
  3.86905042400249*^9}},ExpressionUUID->"e5bbac27-547b-483f-9b4b-\
823521ec8de9"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Solve", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"D", "[", 
        RowBox[{"objective2", ",", "chi"}], "]"}], "/.", 
       RowBox[{"{", 
        RowBox[{"chi", "\[Rule]", 
         RowBox[{"1", "-", "psi2"}]}], "}"}]}], ")"}], "\[Equal]", "0"}], ",",
     "\[Alpha]"}], "]"}], "//", "FullSimplify"}]], "Input",
 CellLabel->"In[49]:=",ExpressionUUID->"12d7c91b-f3b1-4dec-8b0d-5ee51ac666a4"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"\[Alpha]", "\[Rule]", 
    RowBox[{"-", 
     FractionBox[
      RowBox[{
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["F1", "2"]}], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "+", "psi2"}], ")"}], "2"], " ", "psi2"}], "+", 
       RowBox[{"2", " ", 
        RowBox[{"(", 
         RowBox[{"psi1", "-", "psi2"}], ")"}], " ", "psi2", " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["Fs", "2"], "+", 
          SuperscriptBox["tau", "2"]}], ")"}]}]}], 
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "psi2"}], ")"}], "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["Fs", "2"], "-", 
         RowBox[{
          SuperscriptBox["F1", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"1", "-", 
            RowBox[{"2", " ", "psi1"}], "+", "psi2"}], ")"}]}], "+", 
         SuperscriptBox["tau", "2"]}], ")"}]}]]}]}], "}"}], "}"}]], "Output",
 CellChangeTimes->{3.869050434295642*^9},
 CellLabel->"Out[49]=",ExpressionUUID->"f5ae1eb6-c25d-42a0-88d6-937c2bac6f8b"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{
   RowBox[{"alpha", " ", "R", " ", "when", " ", "psi2"}], " ", "<", " ", 
   "1"}], "*)"}]], "Input",
 CellChangeTimes->{{3.869050494273267*^9, 
  3.869050495008635*^9}},ExpressionUUID->"604f9c4d-3575-4707-befd-\
354ae337d42b"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Solve", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"D", "[", 
        RowBox[{"objective2", ",", "chi"}], "]"}], "/.", 
       RowBox[{"{", 
        RowBox[{"chi", "\[Rule]", "0"}], "}"}]}], ")"}], "\[Equal]", "0"}], 
    ",", "\[Alpha]"}], "]"}], "//", "FullSimplify"}]], "Input",
 CellChangeTimes->{{3.869050497458899*^9, 3.869050497995632*^9}},
 CellLabel->"In[50]:=",ExpressionUUID->"6b3a23c1-5241-41a5-9764-7b8e78f3402e"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"\[Alpha]", "\[Rule]", 
    RowBox[{"-", 
     FractionBox[
      RowBox[{
       RowBox[{"2", " ", 
        SuperscriptBox["Fs", "2"], " ", 
        RowBox[{"(", 
         RowBox[{"psi1", "-", "psi2"}], ")"}]}], "-", 
       RowBox[{
        SuperscriptBox["F1", "2"], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "+", "psi2"}], ")"}], "2"], " ", "psi2"}], "+", 
       RowBox[{"2", " ", 
        RowBox[{"(", 
         RowBox[{"psi1", "-", "psi2"}], ")"}], " ", 
        SuperscriptBox["tau", "2"]}]}], 
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "psi2"}], ")"}], "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["Fs", "2"], "+", 
         RowBox[{
          SuperscriptBox["F1", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{"2", " ", "psi1"}], "-", 
            RowBox[{"3", " ", "psi2"}]}], ")"}]}], "+", 
         SuperscriptBox["tau", "2"]}], ")"}]}]]}]}], "}"}], "}"}]], "Output",
 CellChangeTimes->{3.869050500532452*^9},
 CellLabel->"Out[50]=",ExpressionUUID->"1d57ba06-4dfe-4b29-a7ff-9686d43b54cc"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{
   RowBox[{
    RowBox[{"when", " ", "psi2"}], " ", "<", " ", "1"}], ",", " ", 
   RowBox[{
    RowBox[{"show", " ", "A"}], "\[GreaterEqual]", "B"}]}], "*)"}]], "Input",
 CellChangeTimes->{{3.869050681424765*^9, 3.869050695707204*^9}, {
  3.869050862480876*^9, 3.869050889516705*^9}, {3.869050921549233*^9, 
  3.869050925240402*^9}, {3.869051010331726*^9, 3.869051015264781*^9}, {
  3.869051129687078*^9, 
  3.8690511303574753`*^9}},ExpressionUUID->"b3b0b842-b9e5-431e-ae25-\
5f7a90ebf5ae"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Minimize", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", 
       FractionBox[
        RowBox[{
         RowBox[{
          SuperscriptBox["F1", "2"], " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", "psi2"}], ")"}], "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", 
            RowBox[{"4", " ", "psi2"}]}], ")"}]}], "-", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "4"}], "+", "psi2"}], ")"}], " ", "psi2"}]}], 
           ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["Fs", "2"], "+", 
            SuperscriptBox["tau", "2"]}], ")"}]}]}], 
        RowBox[{"2", " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["Fs", "2"], "+", 
           RowBox[{
            SuperscriptBox["F1", "2"], " ", 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1"}], "+", "psi2"}], ")"}], "2"]}], "+", 
           SuperscriptBox["tau", "2"]}], ")"}]}]]}], "+", 
      RowBox[{"(", 
       RowBox[{"psi2", "+", 
        FractionBox[
         RowBox[{
          SuperscriptBox["F1", "2"], " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", "psi2"}], ")"}], "2"], " ", "psi2"}], 
         RowBox[{"2", " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["Fs", "2"], "+", 
            SuperscriptBox["tau", "2"]}], ")"}]}]]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"psi2", "\[LessEqual]", "1"}], "&&", 
      RowBox[{"psi2", "\[GreaterEqual]", "0"}], "&&", 
      RowBox[{"F1", "\[GreaterEqual]", "0"}], "&&", 
      RowBox[{"tau", "\[GreaterEqual]", "0"}], "&&", 
      RowBox[{"Fs", "\[GreaterEqual]", "0"}]}]}], "}"}], ",", "psi2"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.869051054092599*^9, 3.869051074021089*^9}},
 CellLabel->"In[53]:=",ExpressionUUID->"53e56f57-b8b3-4034-859a-2f58dd442d1b"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[GridBox[{
      {"\[Piecewise]", GridBox[{
         {"\[Infinity]", 
          RowBox[{"!", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"tau", "\[Equal]", "0"}], "&&", 
               RowBox[{"Fs", ">", "0"}], "&&", 
               RowBox[{"F1", "\[Equal]", "0"}]}], ")"}], "||", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"tau", "\[Equal]", "0"}], "&&", 
               RowBox[{"Fs", ">", "0"}], "&&", 
               RowBox[{"F1", ">", "0"}]}], ")"}], "||", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"tau", ">", "0"}], "&&", 
               RowBox[{"Fs", "\[GreaterEqual]", "0"}], "&&", 
               RowBox[{"F1", "\[Equal]", "0"}]}], ")"}], "||", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"tau", ">", "0"}], "&&", 
               RowBox[{"Fs", "\[GreaterEqual]", "0"}], "&&", 
               RowBox[{"F1", ">", "0"}]}], ")"}]}], ")"}]}]},
         {"0", 
          TagBox["True",
           "PiecewiseDefault",
           AutoDelete->True]}
        },
        AllowedDimensions->{2, Automatic},
        Editable->True,
        GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Baseline}}},
        GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{1.}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.84]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}},
        Selectable->True]}
     },
     GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Baseline}}},
     GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{1.}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.35]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    "Piecewise",
    DeleteWithContents->True,
    Editable->False,
    SelectWithContents->True,
    Selectable->False,
    StripWrapperBoxes->True], ",", 
   RowBox[{"{", 
    RowBox[{"psi2", "\[Rule]", 
     TagBox[GridBox[{
        {"\[Piecewise]", GridBox[{
           {"1", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"tau", "\[Equal]", "0"}], "&&", 
               RowBox[{"Fs", ">", "0"}], "&&", 
               RowBox[{"F1", "\[Equal]", "0"}]}], ")"}], "||", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"tau", ">", "0"}], "&&", 
               RowBox[{"Fs", "\[GreaterEqual]", "0"}], "&&", 
               RowBox[{"F1", "\[Equal]", "0"}]}], ")"}]}]},
           {
            RowBox[{"Root", "[", 
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{
                 SuperscriptBox["F1", "2"], " ", 
                 SuperscriptBox["Fs", "2"]}], "+", 
                SuperscriptBox["Fs", "4"], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   SuperscriptBox["F1", "4"], "-", 
                   RowBox[{"3", " ", 
                    SuperscriptBox["F1", "2"], " ", 
                    SuperscriptBox["Fs", "2"]}], "-", 
                   RowBox[{"2", " ", 
                    SuperscriptBox["Fs", "4"]}]}], ")"}], " ", "#1"}], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"-", "4"}], " ", 
                    SuperscriptBox["F1", "4"]}], "+", 
                   RowBox[{"3", " ", 
                    SuperscriptBox["F1", "2"], " ", 
                    SuperscriptBox["Fs", "2"]}], "+", 
                   SuperscriptBox["Fs", "4"]}], ")"}], " ", 
                 SuperscriptBox["#1", "2"]}], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"6", " ", 
                    SuperscriptBox["F1", "4"]}], "-", 
                   RowBox[{
                    SuperscriptBox["F1", "2"], " ", 
                    SuperscriptBox["Fs", "2"]}]}], ")"}], " ", 
                 SuperscriptBox["#1", "3"]}], "-", 
                RowBox[{"4", " ", 
                 SuperscriptBox["F1", "4"], " ", 
                 SuperscriptBox["#1", "4"]}], "+", 
                RowBox[{
                 SuperscriptBox["F1", "4"], " ", 
                 SuperscriptBox["#1", "5"]}]}], "&"}], ",", "2"}], "]"}], 
            RowBox[{
             RowBox[{"tau", "\[Equal]", "0"}], "&&", 
             RowBox[{"Fs", ">", "0"}], "&&", 
             RowBox[{"F1", ">", "0"}]}]},
           {
            RowBox[{"Root", "[", 
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{
                 SuperscriptBox["F1", "2"], " ", 
                 SuperscriptBox["Fs", "2"]}], "+", 
                SuperscriptBox["Fs", "4"], "+", 
                RowBox[{
                 SuperscriptBox["F1", "2"], " ", 
                 SuperscriptBox["tau", "2"]}], "+", 
                RowBox[{"2", " ", 
                 SuperscriptBox["Fs", "2"], " ", 
                 SuperscriptBox["tau", "2"]}], "+", 
                SuperscriptBox["tau", "4"], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   SuperscriptBox["F1", "4"], "-", 
                   RowBox[{"3", " ", 
                    SuperscriptBox["F1", "2"], " ", 
                    SuperscriptBox["Fs", "2"]}], "-", 
                   RowBox[{"2", " ", 
                    SuperscriptBox["Fs", "4"]}], "-", 
                   RowBox[{"3", " ", 
                    SuperscriptBox["F1", "2"], " ", 
                    SuperscriptBox["tau", "2"]}], "-", 
                   RowBox[{"4", " ", 
                    SuperscriptBox["Fs", "2"], " ", 
                    SuperscriptBox["tau", "2"]}], "-", 
                   RowBox[{"2", " ", 
                    SuperscriptBox["tau", "4"]}]}], ")"}], " ", "#1"}], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"-", "4"}], " ", 
                    SuperscriptBox["F1", "4"]}], "+", 
                   RowBox[{"3", " ", 
                    SuperscriptBox["F1", "2"], " ", 
                    SuperscriptBox["Fs", "2"]}], "+", 
                   SuperscriptBox["Fs", "4"], "+", 
                   RowBox[{"3", " ", 
                    SuperscriptBox["F1", "2"], " ", 
                    SuperscriptBox["tau", "2"]}], "+", 
                   RowBox[{"2", " ", 
                    SuperscriptBox["Fs", "2"], " ", 
                    SuperscriptBox["tau", "2"]}], "+", 
                   SuperscriptBox["tau", "4"]}], ")"}], " ", 
                 SuperscriptBox["#1", "2"]}], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"6", " ", 
                    SuperscriptBox["F1", "4"]}], "-", 
                   RowBox[{
                    SuperscriptBox["F1", "2"], " ", 
                    SuperscriptBox["Fs", "2"]}], "-", 
                   RowBox[{
                    SuperscriptBox["F1", "2"], " ", 
                    SuperscriptBox["tau", "2"]}]}], ")"}], " ", 
                 SuperscriptBox["#1", "3"]}], "-", 
                RowBox[{"4", " ", 
                 SuperscriptBox["F1", "4"], " ", 
                 SuperscriptBox["#1", "4"]}], "+", 
                RowBox[{
                 SuperscriptBox["F1", "4"], " ", 
                 SuperscriptBox["#1", "5"]}]}], "&"}], ",", "2"}], "]"}], 
            RowBox[{
             RowBox[{"tau", ">", "0"}], "&&", 
             RowBox[{"Fs", "\[GreaterEqual]", "0"}], "&&", 
             RowBox[{"F1", ">", "0"}]}]},
           {"Indeterminate", 
            TagBox["True",
             "PiecewiseDefault",
             AutoDelete->True]}
          },
          AllowedDimensions->{2, Automatic},
          Editable->True,
          GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Baseline}}},
          GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{1.}}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.84]}, 
              Offset[0.27999999999999997`]}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}},
          Selectable->True]}
       },
       GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Baseline}}},
       GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{1.}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.35]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      "Piecewise",
      DeleteWithContents->True,
      Editable->False,
      SelectWithContents->True,
      Selectable->False,
      StripWrapperBoxes->True]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.869051019325376*^9, {3.869051062864559*^9, 3.869051077190131*^9}},
 CellLabel->"Out[53]=",ExpressionUUID->"ff1aafec-15c8-4dc5-9c58-201ab6f77fc4"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{
   RowBox[{
    RowBox[{"when", " ", "psi2"}], " ", ">", " ", "1"}], ",", " ", 
   RowBox[{
    RowBox[{"show", " ", "A"}], "\[GreaterEqual]", "B"}]}], "*)"}]], "Input",
 CellChangeTimes->{{3.8690510925665817`*^9, 3.8690510951461983`*^9}, {
  3.869051132666151*^9, 
  3.869051133202138*^9}},ExpressionUUID->"c748eba9-0c04-4a39-a698-\
720649b37561"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Minimize", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", 
       FractionBox[
        RowBox[{
         RowBox[{
          SuperscriptBox["F1", "2"], " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", "psi2"}], ")"}], "2"], " ", 
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{"2", " ", "psi2"}]}], ")"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", 
            RowBox[{"psi2", " ", 
             RowBox[{"(", 
              RowBox[{"2", "+", "psi2"}], ")"}]}]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["Fs", "2"], "+", 
            SuperscriptBox["tau", "2"]}], ")"}]}]}], 
        RowBox[{"2", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["F1", "2"], " ", 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1"}], "+", "psi2"}], ")"}], "2"]}], "+", 
           RowBox[{"psi2", " ", 
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["Fs", "2"], "+", 
              SuperscriptBox["tau", "2"]}], ")"}]}]}], ")"}]}]]}], "+", 
      RowBox[{"(", 
       RowBox[{"psi2", "+", 
        FractionBox[
         RowBox[{
          SuperscriptBox["F1", "2"], " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", "psi2"}], ")"}], "2"]}], 
         RowBox[{"2", " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["Fs", "2"], "+", 
            SuperscriptBox["tau", "2"]}], ")"}]}]]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"psi2", "\[GreaterEqual]", "1"}], "&&", 
      RowBox[{"F1", "\[GreaterEqual]", "0"}], "&&", 
      RowBox[{"tau", "\[GreaterEqual]", "0"}], "&&", 
      RowBox[{"Fs", "\[GreaterEqual]", "0"}]}]}], "}"}], ",", "psi2"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.869051205845346*^9, 3.869051250472872*^9}},
 CellLabel->"In[54]:=",ExpressionUUID->"46f48a9f-3067-4649-9f4d-daa33f102abf"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[GridBox[{
      {"\[Piecewise]", GridBox[{
         {"\[Infinity]", 
          RowBox[{"!", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"tau", "\[Equal]", "0"}], "&&", 
               RowBox[{"Fs", ">", "0"}], "&&", 
               RowBox[{"F1", "\[GreaterEqual]", "0"}]}], ")"}], "||", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"tau", ">", "0"}], "&&", 
               RowBox[{"Fs", "\[GreaterEqual]", "0"}], "&&", 
               RowBox[{"F1", "\[GreaterEqual]", "0"}]}], ")"}]}], ")"}]}]},
         {"0", 
          TagBox["True",
           "PiecewiseDefault",
           AutoDelete->True]}
        },
        AllowedDimensions->{2, Automatic},
        Editable->True,
        GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Baseline}}},
        GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{1.}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.84]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}},
        Selectable->True]}
     },
     GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Baseline}}},
     GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{1.}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.35]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    "Piecewise",
    DeleteWithContents->True,
    Editable->False,
    SelectWithContents->True,
    Selectable->False,
    StripWrapperBoxes->True], ",", 
   RowBox[{"{", 
    RowBox[{"psi2", "\[Rule]", 
     TagBox[GridBox[{
        {"\[Piecewise]", GridBox[{
           {
            RowBox[{"Root", "[", 
             RowBox[{
              RowBox[{
               RowBox[{
                SuperscriptBox["F1", "4"], "-", 
                RowBox[{
                 SuperscriptBox["F1", "2"], " ", 
                 SuperscriptBox["Fs", "2"]}], "+", 
                SuperscriptBox["Fs", "4"], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"-", "4"}], " ", 
                    SuperscriptBox["F1", "4"]}], "+", 
                   RowBox[{"3", " ", 
                    SuperscriptBox["F1", "2"], " ", 
                    SuperscriptBox["Fs", "2"]}], "-", 
                   RowBox[{"2", " ", 
                    SuperscriptBox["Fs", "4"]}]}], ")"}], " ", "#1"}], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"6", " ", 
                    SuperscriptBox["F1", "4"]}], "-", 
                   RowBox[{"3", " ", 
                    SuperscriptBox["F1", "2"], " ", 
                    SuperscriptBox["Fs", "2"]}], "+", 
                   SuperscriptBox["Fs", "4"]}], ")"}], " ", 
                 SuperscriptBox["#1", "2"]}], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"-", "4"}], " ", 
                    SuperscriptBox["F1", "4"]}], "+", 
                   RowBox[{
                    SuperscriptBox["F1", "2"], " ", 
                    SuperscriptBox["Fs", "2"]}]}], ")"}], " ", 
                 SuperscriptBox["#1", "3"]}], "+", 
                RowBox[{
                 SuperscriptBox["F1", "4"], " ", 
                 SuperscriptBox["#1", "4"]}]}], "&"}], ",", "1"}], "]"}], 
            RowBox[{
             RowBox[{"tau", "\[Equal]", "0"}], "&&", 
             RowBox[{"Fs", ">", "0"}], "&&", 
             RowBox[{"F1", "\[GreaterEqual]", "0"}]}]},
           {
            RowBox[{"Root", "[", 
             RowBox[{
              RowBox[{
               RowBox[{
                SuperscriptBox["F1", "4"], "-", 
                RowBox[{
                 SuperscriptBox["F1", "2"], " ", 
                 SuperscriptBox["Fs", "2"]}], "+", 
                SuperscriptBox["Fs", "4"], "-", 
                RowBox[{
                 SuperscriptBox["F1", "2"], " ", 
                 SuperscriptBox["tau", "2"]}], "+", 
                RowBox[{"2", " ", 
                 SuperscriptBox["Fs", "2"], " ", 
                 SuperscriptBox["tau", "2"]}], "+", 
                SuperscriptBox["tau", "4"], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"-", "4"}], " ", 
                    SuperscriptBox["F1", "4"]}], "+", 
                   RowBox[{"3", " ", 
                    SuperscriptBox["F1", "2"], " ", 
                    SuperscriptBox["Fs", "2"]}], "-", 
                   RowBox[{"2", " ", 
                    SuperscriptBox["Fs", "4"]}], "+", 
                   RowBox[{"3", " ", 
                    SuperscriptBox["F1", "2"], " ", 
                    SuperscriptBox["tau", "2"]}], "-", 
                   RowBox[{"4", " ", 
                    SuperscriptBox["Fs", "2"], " ", 
                    SuperscriptBox["tau", "2"]}], "-", 
                   RowBox[{"2", " ", 
                    SuperscriptBox["tau", "4"]}]}], ")"}], " ", "#1"}], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"6", " ", 
                    SuperscriptBox["F1", "4"]}], "-", 
                   RowBox[{"3", " ", 
                    SuperscriptBox["F1", "2"], " ", 
                    SuperscriptBox["Fs", "2"]}], "+", 
                   SuperscriptBox["Fs", "4"], "-", 
                   RowBox[{"3", " ", 
                    SuperscriptBox["F1", "2"], " ", 
                    SuperscriptBox["tau", "2"]}], "+", 
                   RowBox[{"2", " ", 
                    SuperscriptBox["Fs", "2"], " ", 
                    SuperscriptBox["tau", "2"]}], "+", 
                   SuperscriptBox["tau", "4"]}], ")"}], " ", 
                 SuperscriptBox["#1", "2"]}], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"-", "4"}], " ", 
                    SuperscriptBox["F1", "4"]}], "+", 
                   RowBox[{
                    SuperscriptBox["F1", "2"], " ", 
                    SuperscriptBox["Fs", "2"]}], "+", 
                   RowBox[{
                    SuperscriptBox["F1", "2"], " ", 
                    SuperscriptBox["tau", "2"]}]}], ")"}], " ", 
                 SuperscriptBox["#1", "3"]}], "+", 
                RowBox[{
                 SuperscriptBox["F1", "4"], " ", 
                 SuperscriptBox["#1", "4"]}]}], "&"}], ",", "1"}], "]"}], 
            RowBox[{
             RowBox[{"tau", ">", "0"}], "&&", 
             RowBox[{"Fs", "\[GreaterEqual]", "0"}], "&&", 
             RowBox[{"F1", "\[GreaterEqual]", "0"}]}]},
           {"Indeterminate", 
            TagBox["True",
             "PiecewiseDefault",
             AutoDelete->True]}
          },
          AllowedDimensions->{2, Automatic},
          Editable->True,
          GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Baseline}}},
          GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{1.}}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.84]}, 
              Offset[0.27999999999999997`]}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}},
          Selectable->True]}
       },
       GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Baseline}}},
       GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{1.}}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.35]}, 
           Offset[0.27999999999999997`]}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}}],
      "Piecewise",
      DeleteWithContents->True,
      Editable->False,
      SelectWithContents->True,
      Selectable->False,
      StripWrapperBoxes->True]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.869051260514037*^9},
 CellLabel->"Out[54]=",ExpressionUUID->"d25d7ad3-fc9e-49a1-87b4-9da3af79c955"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{
   RowBox[{"Calculate", " ", "the", " ", "condition", " ", "for", " ", "B"}], 
   " ", "<", " ", "psi2"}], " ", "*)"}]], "Input",
 CellChangeTimes->{{3.869051312923773*^9, 3.869051318994553*^9}, {
  3.869051416658937*^9, 3.8690514195830183`*^9}, {3.869051970966051*^9, 
  3.869051977441527*^9}},ExpressionUUID->"10fa52e6-d0cf-4162-bd80-\
bd35ee476baa"],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{
   RowBox[{
    RowBox[{
    "Threshold", " ", "for", " ", "B", " ", "is", " ", "bigger", " ", "than", 
     " ", "psi2", " ", "when", " ", "psi2"}], " ", "<", " ", "1"}], ",", " ", 
   
   RowBox[{"s", " ", "is", " ", "for", " ", "signal", " ", "ratio"}], ",", 
   " ", 
   RowBox[{"s", " ", "=", 
    RowBox[{
     RowBox[{"F1", "^", "2"}], " ", "/", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"Fs", "^", "2"}], " ", "+", " ", 
       RowBox[{"tau", "^", "2"}]}], ")"}]}]}]}], "*)"}]], "Input",
 CellChangeTimes->{{3.869052013429914*^9, 3.869052018487116*^9}, {
  3.869352467503323*^9, 3.8693524680108967`*^9}, {3.869352620840989*^9, 
  3.8693526209436893`*^9}},ExpressionUUID->"a7a80709-437e-4fe8-8282-\
c03d546f5945"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Solve", "[", 
   RowBox[{
    RowBox[{
     FractionBox[
      RowBox[{
       RowBox[{"S", " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "+", "psi2"}], ")"}], "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          RowBox[{"4", " ", "psi2"}]}], ")"}]}], "-", 
       RowBox[{"(", 
        RowBox[{"1", "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "4"}], "+", "psi2"}], ")"}], " ", "psi2"}]}], ")"}], 
       " "}], 
      RowBox[{"2", " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", 
         RowBox[{"S", " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", "psi2"}], ")"}], "2"]}]}], ")"}]}]], "==",
      "psi2"}], ",", "S"}], "]"}], "//", "FullSimplify"}]], "Input",
 CellLabel->"In[55]:=",ExpressionUUID->"c6d51675-b17a-4370-a034-242251d1bc0d"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"S", "\[Rule]", 
    FractionBox["1", 
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      RowBox[{"2", " ", "psi2"}]}]]}], "}"}], "}"}]], "Output",
 CellChangeTimes->{3.869052007494505*^9},
 CellLabel->"Out[55]=",ExpressionUUID->"f40986e9-6e82-45b6-9615-38725ff65f81"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{
   RowBox[{
    RowBox[{
    "Threshold", " ", "for", " ", "B", " ", "is", " ", "bigger", " ", "than", 
     " ", "psi2", " ", "when", " ", "psi2"}], " ", ">", " ", "1"}], ",", " ", 
   
   RowBox[{"s", " ", "is", " ", "for", " ", "signal", " ", "ratio"}], ",", 
   " ", 
   RowBox[{"s", " ", "=", 
    RowBox[{
     RowBox[{"F1", "^", "2"}], " ", "/", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"Fs", "^", "2"}], " ", "+", " ", 
       RowBox[{"tau", "^", "2"}]}], ")"}]}]}]}], "*)"}]], "Input",
 CellChangeTimes->{{3.869052070088139*^9, 3.869052071416623*^9}, {
  3.869352470128478*^9, 3.869352470769682*^9}, {3.869352622551025*^9, 
  3.8693526226836557`*^9}},ExpressionUUID->"8d1ca338-c05d-474a-9818-\
7e65f7957b19"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Solve", "[", 
   RowBox[{
    RowBox[{
     FractionBox[
      RowBox[{
       RowBox[{"S", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "+", "psi2"}], ")"}], "2"], " ", 
        RowBox[{"(", 
         RowBox[{"1", "+", 
          RowBox[{"2", " ", "psi2"}]}], ")"}]}], "+", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         RowBox[{"psi2", " ", 
          RowBox[{"(", 
           RowBox[{"2", "+", "psi2"}], ")"}]}]}], ")"}], " "}], 
      RowBox[{"2", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"S", " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", "psi2"}], ")"}], "2"]}], "+", "psi2"}], 
        " ", ")"}]}]], "\[Equal]", "psi2"}], ",", " ", "S"}], "]"}], "//", 
  "FullSimplify"}]], "Input",
 CellLabel->"In[56]:=",ExpressionUUID->"2c3f5b22-f644-47e9-bc27-991fa5ab150a"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"S", "\[Rule]", "1"}], "}"}], "}"}]], "Output",
 CellChangeTimes->{3.869052074658469*^9},
 CellLabel->"Out[56]=",ExpressionUUID->"99f5ee60-2b2f-484c-844b-de87987d24f5"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{
  "Show", " ", "the", " ", "condition", " ", "for", " ", "alpha", " ", "R", 
   " ", "between", " ", "0", " ", "and", " ", "1"}], "*)"}]], "Input",
 CellChangeTimes->{{3.869052220458899*^9, 3.869052227928879*^9}, {
  3.869052263600357*^9, 
  3.869052293197727*^9}},ExpressionUUID->"a11fcecb-b000-4f54-90ed-\
3895b15669f4"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
     RowBox[{"When", " ", "psi2"}], " ", ">", " ", "1"}], ",", " ", 
    RowBox[{"s", " ", "for", " ", "signal", " ", "ratio"}], ",", " ", 
    RowBox[{"s", " ", "=", 
     RowBox[{
      RowBox[{"F1", "^", "2"}], " ", "/", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"Fs", "^", "2"}], " ", "+", " ", 
        RowBox[{"tau", "^", "2"}]}], ")"}]}]}]}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"alphaRLarge", "[", 
     RowBox[{"S_", ",", "psi1_", ",", "psi2_"}], "]"}], ":=", 
    RowBox[{"-", 
     FractionBox[
      RowBox[{
       RowBox[{
        RowBox[{"-", "S"}], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "+", "psi2"}], ")"}], "2"], " ", "psi2"}], "+", 
       RowBox[{"2", " ", 
        RowBox[{"(", 
         RowBox[{"psi1", "-", "psi2"}], ")"}], " ", "psi2", " "}]}], 
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "psi2"}], ")"}], "2"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "-", 
         RowBox[{"S", " ", 
          RowBox[{"(", 
           RowBox[{"1", "-", 
            RowBox[{"2", " ", "psi1"}], "+", "psi2"}], ")"}]}]}], 
        ")"}]}]]}]}], ";"}]}]], "Input",
 CellChangeTimes->{{3.869052328241152*^9, 3.86905233119069*^9}, {
  3.869052364593405*^9, 3.869052368967168*^9}, {3.869352451595294*^9, 
  3.869352454283469*^9}, {3.869352637783935*^9, 
  3.8693526379593782`*^9}},ExpressionUUID->"4dc9d249-c335-4d08-a90a-\
31bbf6c6d779"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"Solve", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"alphaRLarge", "[", 
      RowBox[{"S", ",", "psi1", ",", "psi2"}], "]"}], "\[Equal]", "0"}], ",", 
    "psi1"}], "]"}], "//", "FullSimplify"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Solve", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"alphaRLarge", "[", 
      RowBox[{"S", ",", "psi1", ",", "psi2"}], "]"}], "\[Equal]", "1"}], ",", 
    "psi1"}], "]"}], "//", "FullSimplify"}]}], "Input",
 CellLabel->"In[87]:=",ExpressionUUID->"8b346b62-d44f-40da-a0ed-bee7648b5bb3"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"psi1", "\[Rule]", 
    RowBox[{"psi2", "+", 
     RowBox[{
      FractionBox["1", "2"], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "psi2"}], ")"}], "2"], " ", "S"}]}]}], 
   "}"}], "}"}]], "Output",
 CellChangeTimes->{{3.869052349109642*^9, 3.8690523564921913`*^9}, 
   3.869065951051755*^9},
 CellLabel->"Out[87]=",ExpressionUUID->"6121ca7b-4a5d-4480-8ff3-fec1ae8a543b"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"psi1", "\[Rule]", 
    FractionBox[
     RowBox[{
      RowBox[{"-", "1"}], "+", "S", "+", 
      RowBox[{"psi2", " ", 
       RowBox[{"(", 
        RowBox[{"2", "+", "psi2", "+", 
         RowBox[{"psi2", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "3"}], "+", 
            RowBox[{"2", " ", "psi2"}]}], ")"}], " ", "S"}]}], ")"}]}]}], 
     RowBox[{"2", " ", 
      RowBox[{"(", 
       RowBox[{"psi2", "+", 
        RowBox[{
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", "psi2"}], ")"}], "2"], " ", "S"}]}], 
       ")"}]}]]}], "}"}], "}"}]], "Output",
 CellChangeTimes->{{3.869052349109642*^9, 3.8690523564921913`*^9}, 
   3.869065951098549*^9},
 CellLabel->"Out[88]=",ExpressionUUID->"ba5337e0-04c3-4623-9f70-172fdf6e80fe"]
}, Open  ]],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.869065927825363*^9, 
  3.8690659459848423`*^9}},ExpressionUUID->"0ca4a183-369b-4df2-8f9d-\
eb0777ca825e"],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{
   RowBox[{
   "proof", " ", "that", " ", "psi1", " ", "is", " ", "between", " ", "the", 
    " ", "two", " ", "bounds", " ", "above", " ", "by", " ", "showing", " ", 
    "that", " ", "it", " ", "is", " ", "decreasing", " ", "regarding", " ", 
    "psi1"}], ",", " ", 
   RowBox[{
    RowBox[{"psi1", " ", "is", " ", "bigger", " ", "than", " ", 
     FractionBox[
      RowBox[{
       RowBox[{"-", "1"}], "+", "S", "+", 
       RowBox[{"psi2", " ", 
        RowBox[{"(", 
         RowBox[{"2", "+", "psi2", "+", 
          RowBox[{"psi2", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "3"}], "+", 
             RowBox[{"2", " ", "psi2"}]}], ")"}], " ", "S"}]}], ")"}]}]}], 
      RowBox[{"2", " ", 
       RowBox[{"(", 
        RowBox[{"psi2", "+", 
         RowBox[{
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", "psi2"}], ")"}], "2"], " ", "S"}]}], 
        ")"}]}]], " ", "and", " ", "smaller", " ", "than", " ", "psi2"}], "+", 
    RowBox[{
     FractionBox["1", "2"], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", "psi2"}], ")"}], "2"], " ", "S"}]}]}], 
  "*)"}]], "Input",
 CellChangeTimes->{{3.8690526839407043`*^9, 3.869052688796164*^9}, {
   3.869052781417501*^9, 3.869052817400442*^9}, 3.869065884831959*^9, {
   3.869065916694124*^9, 3.869065942018951*^9}, {3.869352321986354*^9, 
   3.8693523396975803`*^9}},ExpressionUUID->"18402bbd-9f00-48b4-ab91-\
230ce34e37c1"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"D", "[", 
   RowBox[{
    RowBox[{"alphaRLarge", "[", 
     RowBox[{"S", ",", "psi1", ",", "psi2"}], "]"}], ",", " ", "psi1"}], 
   "]"}], "//", "FullSimplify"}]], "Input",
 CellChangeTimes->{{3.869052390648138*^9, 3.8690524056269627`*^9}},
 CellLabel->"In[62]:=",ExpressionUUID->"84c4d89d-2cbf-4bb5-9164-a42281a47e4f"],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox[
   RowBox[{"2", " ", "psi2", " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", 
      RowBox[{"S", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "psi2", "+", 
         RowBox[{
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", "psi2"}], ")"}], "2"], " ", "S"}]}], 
        ")"}]}]}], ")"}]}], 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", "psi2"}], ")"}], "2"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "-", 
          RowBox[{"2", " ", "psi1"}], "+", "psi2"}], ")"}], " ", "S"}]}], 
      ")"}], "2"]}]]}]], "Output",
 CellChangeTimes->{3.869052407898426*^9},
 CellLabel->"Out[62]=",ExpressionUUID->"bc93fe7c-c727-487b-b7b8-62678fc53ed8"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{
   RowBox[{
    RowBox[{"When", " ", "psi2"}], " ", "<", " ", "1"}], ",", " ", 
   RowBox[{
    RowBox[{"s", " ", "for", " ", "signal", " ", 
     RowBox[{"ratio", ".", " ", "s"}]}], " ", "=", 
    RowBox[{
     RowBox[{"F1", "^", "2"}], " ", "/", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"Fs", "^", "2"}], " ", "+", " ", 
       RowBox[{"tau", "^", "2"}]}], ")"}]}]}]}], "*)"}]], "Input",
 CellChangeTimes->{{3.869052844852809*^9, 3.86905284535251*^9}, {
  3.869352527444882*^9, 3.869352527843896*^9}, {3.869352641405273*^9, 
  3.869352641570004*^9}},ExpressionUUID->"f1f5ea75-ad1e-4478-b1e5-\
5a6cc87838a2"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"alphaR", "[", 
    RowBox[{"S_", ",", "psi1_", ",", "psi2_"}], "]"}], ":=", 
   RowBox[{"(", 
    RowBox[{"-", 
     FractionBox[
      RowBox[{
       RowBox[{"2", " ", 
        RowBox[{"(", 
         RowBox[{"psi1", "-", "psi2"}], ")"}]}], "-", 
       RowBox[{"S", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "+", "psi2"}], ")"}], "2"], " ", "psi2"}]}], 
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "psi2"}], ")"}], "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"S", 
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{"2", " ", "psi1"}], "-", 
            RowBox[{"3", " ", "psi2"}]}], ")"}]}], "+", "1"}], ")"}]}]]}], 
    ")"}]}], ";"}]], "Input",
 CellLabel->"In[65]:=",ExpressionUUID->"421ffd55-6648-4bba-af6d-3f57d29c473d"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"Solve", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"alphaR", "[", 
      RowBox[{"S", ",", "psi1", ",", "psi2"}], "]"}], "\[Equal]", "0"}], ",", 
    "psi1"}], "]"}], "//", "FullSimplify"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Solve", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"alphaR", "[", 
      RowBox[{"S", ",", "psi1", ",", "psi2"}], "]"}], "\[Equal]", "1"}], ",", 
    "psi1"}], "]"}], "//", "FullSimplify"}]}], "Input",
 CellLabel->"In[66]:=",ExpressionUUID->"a49d9050-b8c6-494f-b064-10e5191a2f73"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"psi1", "\[Rule]", 
    RowBox[{"psi2", "+", 
     RowBox[{
      FractionBox["1", "2"], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "psi2"}], ")"}], "2"], " ", "psi2", " ", 
      "S"}]}]}], "}"}], "}"}]], "Output",
 CellChangeTimes->{{3.8690528752862453`*^9, 3.869052881047388*^9}},
 CellLabel->"Out[66]=",ExpressionUUID->"fc62c688-99e6-43ca-9f56-8f67e41a3fbf"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"psi1", "\[Rule]", 
    RowBox[{
     RowBox[{"-", 
      FractionBox["1", "2"]}], "+", 
     RowBox[{"psi2", " ", 
      RowBox[{"(", 
       RowBox[{"2", "-", 
        FractionBox["psi2", 
         RowBox[{"2", "+", 
          RowBox[{"2", " ", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", "psi2"}], ")"}], "2"], " ", "S"}]}]]}],
        ")"}]}]}]}], "}"}], "}"}]], "Output",
 CellChangeTimes->{{3.8690528752862453`*^9, 3.869052881143693*^9}},
 CellLabel->"Out[67]=",ExpressionUUID->"16637e07-05c9-4f15-a658-2ef71c590b53"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{
   RowBox[{
   "proof", " ", "that", " ", "psi1", " ", "is", " ", "between", " ", "the", 
    " ", "two", " ", "bounds", " ", "above", " ", "by", " ", "showing", " ", 
    "that", " ", "it", " ", "is", " ", "decreasing", " ", "regarding", " ", 
    "psi1"}], ",", " ", 
   RowBox[{
    RowBox[{"psi1", " ", "is", " ", "bigger", " ", "than"}], " ", "-", 
    FractionBox["1", "2"], "+", 
    RowBox[{"psi2", " ", 
     RowBox[{"(", 
      RowBox[{"2", "-", 
       FractionBox["psi2", 
        RowBox[{"2", "+", 
         RowBox[{"2", " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", "psi2"}], ")"}], "2"], " ", "S"}]}]]}], 
      ")"}], " ", "and", " ", "smaller", " ", "than", " ", "psi2"}], "+", 
    RowBox[{
     FractionBox["1", "2"], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", "psi2"}], ")"}], "2"], " ", "psi2", " ", 
     "S"}]}]}], "*)"}]], "Input",
 CellChangeTimes->{
  3.869054286267508*^9, {3.869065965898141*^9, 3.869065981698735*^9}, {
   3.869352385087117*^9, 
   3.869352390997451*^9}},ExpressionUUID->"a07a4dae-3185-4916-bfb5-\
1839ad64d86c"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"D", "[", 
   RowBox[{
    RowBox[{"alphaR", "[", 
     RowBox[{"S", ",", "psi1", ",", "psi2"}], "]"}], ",", " ", "psi1"}], 
   "]"}], "//", "FullSimplify"}]], "Input",
 CellChangeTimes->{{3.8690528933592854`*^9, 3.8690528939167013`*^9}},
 CellLabel->"In[68]:=",ExpressionUUID->"956a9139-2ebf-4241-8897-074d8048534b"],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox[
   RowBox[{"2", " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "psi2"}], ")"}], " ", "S", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", "psi2"}], ")"}], " ", "psi2", " ", 
          "S"}]}], ")"}]}]}], ")"}]}], 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", "psi2"}], ")"}], "2"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"1", "+", "S", "+", 
       RowBox[{"2", " ", "psi1", " ", "S"}], "-", 
       RowBox[{"3", " ", "psi2", " ", "S"}]}], ")"}], "2"]}]]}]], "Output",
 CellChangeTimes->{3.869052896923356*^9},
 CellLabel->"Out[68]=",ExpressionUUID->"9bf05269-d6f9-43e1-a94b-7e3f53aba89e"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{
   RowBox[{"Show", " ", "O", 
    RowBox[{"(", "x_L", ")"}]}], " ", "-", " ", 
   RowBox[{"O", 
    RowBox[{"(", "x_R", ")"}], " ", "is", " ", "linear", " ", "decreasing", 
    " ", "function", " ", "of", " ", "alpha"}]}], "*)"}]], "Input",
 CellChangeTimes->{{3.8690560177033*^9, 3.869056067884581*^9}, {
  3.8693524088241253`*^9, 
  3.869352410735333*^9}},ExpressionUUID->"58dde0c7-60e4-47e6-835e-\
ffbb6be59ff5"],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{
   RowBox[{"When", " ", "psi2"}], " ", ">", " ", "1"}], "*)"}]], "Input",
 CellChangeTimes->{{3.869056128608692*^9, 
  3.869056142243318*^9}},ExpressionUUID->"0d476c03-1b94-4753-a826-\
01d068d9b7a8"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"D", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"objective2", "/.", 
       RowBox[{"{", 
        RowBox[{"chi", "\[Rule]", 
         RowBox[{"-", "psi2"}]}], "}"}]}], ")"}], "-", 
     RowBox[{"(", 
      RowBox[{"objective2", "/.", 
       RowBox[{"{", 
        RowBox[{"chi", "\[Rule]", 
         RowBox[{"1", "-", "psi2"}]}], "}"}]}], ")"}]}], ",", "\[Alpha]"}], 
   "]"}], "//", "FullSimplify"}]], "Input",
 CellLabel->"In[73]:=",ExpressionUUID->"22f7920c-568b-4326-9c7f-e14dfef45263"],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SuperscriptBox["Fs", "2"], "+", 
   RowBox[{
    SuperscriptBox["F1", "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"2", " ", "psi1"}], "-", "psi2"}], ")"}]}], "+", 
   SuperscriptBox["tau", "2"]}], 
  RowBox[{
   RowBox[{"-", "psi1"}], "+", "psi2"}]]], "Output",
 CellChangeTimes->{3.869056079154643*^9, 3.869056538717988*^9},
 CellLabel->"Out[73]=",ExpressionUUID->"603b5b96-90a2-49aa-8e6a-52d3138b8122"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{
   RowBox[{
    RowBox[{"Show", " ", "O", 
     RowBox[{"(", "x_L", ")"}]}], " ", "-", " ", 
    RowBox[{"O", 
     RowBox[{"(", "x_R", ")"}], " ", "is", " ", "negative", " ", "when", " ", 
     "alpha"}]}], " ", "=", " ", "1"}], "*)"}]], "Input",
 CellChangeTimes->{{3.869056672712105*^9, 3.869056681212967*^9}, {
  3.869352414718485*^9, 
  3.869352416502756*^9}},ExpressionUUID->"108f771f-2cbe-44e1-84f7-\
69a5f79c7ae0"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"objective2", "/.", 
       RowBox[{"{", 
        RowBox[{"chi", "\[Rule]", 
         RowBox[{"-", "psi2"}]}], "}"}]}], ")"}], "-", 
     RowBox[{"(", 
      RowBox[{"objective2", "/.", 
       RowBox[{"{", 
        RowBox[{"chi", "\[Rule]", 
         RowBox[{"1", "-", "psi2"}]}], "}"}]}], ")"}]}], ")"}], "/.", 
   RowBox[{"\[Alpha]", "\[Rule]", "1"}]}], "//", "FullSimplify"}]], "Input",
 CellChangeTimes->{{3.869056547609252*^9, 3.8690565789192*^9}},
 CellLabel->"In[75]:=",ExpressionUUID->"aa170cb6-aca9-465d-bcf0-20985460220b"],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{
    SuperscriptBox["Fs", "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", "psi1"}], ")"}]}], "+", 
   RowBox[{
    SuperscriptBox["F1", "2"], " ", 
    RowBox[{"(", 
     RowBox[{"psi1", "-", "psi2"}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", "psi2"}], ")"}]}], "+", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", "psi1"}], ")"}], " ", 
    SuperscriptBox["tau", "2"]}]}], 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "1"}], "+", "psi2"}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "psi1"}], "+", "psi2"}], ")"}]}]]], "Output",
 CellChangeTimes->{3.869056551532917*^9, 3.869056582206224*^9},
 CellLabel->"Out[75]=",ExpressionUUID->"12a39c84-325a-4b0f-a138-5774d1dab65d"]
}, Open  ]],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.86905642895011*^9, 3.8690564890006847`*^9}, {
  3.869056528099628*^9, 
  3.869056535583593*^9}},ExpressionUUID->"ea2f32d8-9dd8-410c-907a-\
186ecee5a3df"],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{
   RowBox[{"When", " ", "psi2"}], " ", "<", " ", "1"}], "*)"}]], "Input",
 CellChangeTimes->{{3.869056157139448*^9, 
  3.8690561576428223`*^9}},ExpressionUUID->"53780b7e-11c8-4c7b-b093-\
4e88537eee1f"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"D", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"objective2", "/.", 
       RowBox[{"{", 
        RowBox[{"chi", "\[Rule]", 
         RowBox[{"-", "psi2"}]}], "}"}]}], ")"}], "-", 
     RowBox[{"(", 
      RowBox[{"objective2", "/.", 
       RowBox[{"{", 
        RowBox[{"chi", "\[Rule]", "0"}], "}"}]}], ")"}]}], ",", "\[Alpha]"}], 
   "]"}], "//", "FullSimplify"}]], "Input",
 CellLabel->"In[70]:=",ExpressionUUID->"1adf74c5-ef79-477b-86b0-404bbfbe462c"],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox[
   RowBox[{"psi2", " ", 
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["Fs", "2"], "+", 
      RowBox[{
       SuperscriptBox["F1", "2"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", 
         RowBox[{"2", " ", "psi1"}], "-", 
         RowBox[{"2", " ", "psi2"}]}], ")"}]}], "+", 
      SuperscriptBox["tau", "2"]}], ")"}]}], 
   RowBox[{"psi1", "-", "psi2"}]]}]], "Output",
 CellChangeTimes->{3.869056377577915*^9},
 CellLabel->"Out[70]=",ExpressionUUID->"f91b22b1-e9b6-4d97-be13-48780833d4c5"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{
   RowBox[{
    RowBox[{"Show", " ", "O", 
     RowBox[{"(", "x_L", ")"}]}], " ", "-", " ", 
    RowBox[{"O", 
     RowBox[{"(", "x_R", ")"}], " ", "is", " ", "negative", " ", "when", " ", 
     "alpha"}]}], " ", "=", " ", "1"}], "*)"}]], "Input",
 CellChangeTimes->{{3.8693524241781693`*^9, 
  3.869352426007449*^9}},ExpressionUUID->"ebf67f0e-981b-44a2-a157-\
7cff3d6da31e"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"objective2", "/.", 
       RowBox[{"{", 
        RowBox[{"chi", "\[Rule]", 
         RowBox[{"-", "psi2"}]}], "}"}]}], ")"}], "-", 
     RowBox[{"(", 
      RowBox[{"objective2", "/.", 
       RowBox[{"{", 
        RowBox[{"chi", "\[Rule]", "0"}], "}"}]}], ")"}]}], ")"}], "/.", 
   RowBox[{"\[Alpha]", "\[Rule]", "1"}]}], "//", "FullSimplify"}]], "Input",
 CellChangeTimes->{{3.869056711950471*^9, 3.869056712493465*^9}},
 CellLabel->"In[76]:=",ExpressionUUID->"014c8525-db9a-4bef-89d4-7874af5520f4"],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox[
   RowBox[{
    RowBox[{"(", 
     RowBox[{"1", "+", "psi1", "-", 
      RowBox[{"2", " ", "psi2"}]}], ")"}], " ", "psi2", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["Fs", "2"]}], "+", 
      RowBox[{
       SuperscriptBox["F1", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "psi2"}], ")"}]}], "-", 
      SuperscriptBox["tau", "2"]}], ")"}]}], 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"psi1", "-", "psi2"}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", "psi2"}], ")"}]}]]}]], "Output",
 CellChangeTimes->{3.8690567154053297`*^9},
 CellLabel->"Out[76]=",ExpressionUUID->"c30637da-f38e-44cf-b662-eaef8a41bfad"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{"Calculation", " ", "of", " ", "alpha_c"}], "*)"}]], "Input",
 CellChangeTimes->{{3.8690568120153427`*^9, 3.869056835294643*^9}, {
  3.86914969083326*^9, 
  3.869149691302763*^9}},ExpressionUUID->"7ede65c3-6666-4646-8bce-\
b44647a467b4"],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{
   RowBox[{"When", " ", "psi2"}], " ", ">", " ", "1"}], "*)"}]], "Input",Expre\
ssionUUID->"3ab1953f-dbce-461e-9fb3-8ba1ea2ff19d"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Solve", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"objective2", "/.", 
       RowBox[{"{", 
        RowBox[{"chi", "\[Rule]", 
         RowBox[{"-", "psi2"}]}], "}"}]}], ")"}], "==", "\[IndentingNewLine]", 
     RowBox[{"(", 
      RowBox[{"objective2", "/.", 
       RowBox[{"{", 
        RowBox[{"chi", "\[Rule]", 
         RowBox[{"1", "-", "psi2"}]}], "}"}]}], ")"}]}], ",", "\[Alpha]"}], 
   "]"}], "//", "FullSimplify"}]], "Input",
 CellLabel->"In[28]:=",ExpressionUUID->"37f01f2d-32c5-4fd9-b697-2aacd795213f"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"\[Alpha]", "\[Rule]", 
    RowBox[{"-", 
     FractionBox[
      RowBox[{
       RowBox[{
        SuperscriptBox["F1", "2"], " ", 
        RowBox[{"(", 
         RowBox[{"psi1", "-", 
          RowBox[{"psi1", " ", "psi2"}]}], ")"}]}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"psi1", "-", "psi2"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["Fs", "2"], "+", 
          SuperscriptBox["tau", "2"]}], ")"}]}]}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "psi2"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["Fs", "2"], "+", 
         RowBox[{
          SuperscriptBox["F1", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "psi1"}], "-", "psi2"}], ")"}]}], "+", 
         SuperscriptBox["tau", "2"]}], ")"}]}]]}]}], "}"}], "}"}]], "Output",
 CellChangeTimes->{3.8691502899356937`*^9, 3.869150359487505*^9},
 CellLabel->"Out[28]=",ExpressionUUID->"244c6cc9-8910-4aee-99db-66699889a6e2"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"\[Alpha]", "\[Rule]", 
    FractionBox[
     RowBox[{
      RowBox[{
       SuperscriptBox["F1", "2"], " ", 
       RowBox[{"(", 
        RowBox[{"psi1", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "+", " ", "psi2"}], ")"}]}], ")"}]}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "psi1"}], "+", "psi2"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["Fs", "2"], "+", 
         SuperscriptBox["tau", "2"]}], ")"}]}]}], 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", "psi2"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["Fs", "2"], "+", 
        RowBox[{
         SuperscriptBox["F1", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", "psi1"}], "-", "psi2"}], ")"}]}], "+", 
        SuperscriptBox["tau", "2"]}], ")"}]}]]}], "}"}], "}"}]], "Input",
 CellChangeTimes->{{3.869149831755828*^9, 
  3.869149865108716*^9}},ExpressionUUID->"65e8cce5-ef07-4121-ad3e-\
2e7e08412522"],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{
   RowBox[{"the", " ", "condition", " ", "when", " ", "alpha_c"}], " ", 
   "\[GreaterEqual]", " ", "0"}], "*)"}]], "Input",
 CellChangeTimes->{{3.8690569232239656`*^9, 3.869056965367087*^9}, {
  3.869149701200927*^9, 
  3.869149701549322*^9}},ExpressionUUID->"a63a923c-4c6d-4d79-a0e8-\
8b35bca5c0c8"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Minimize", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"S", 
       RowBox[{"(", 
        RowBox[{"psi1", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "+", " ", "psi2"}], ")"}]}], ")"}]}], "+", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "psi1"}], "+", "psi2"}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"psi1", ">", "psi2"}], "&&", 
      RowBox[{"psi2", ">", "0"}], "&&", 
      RowBox[{"S", ">", "0"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"psi1", ",", "psi2", ",", "S"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.869149913461042*^9, 3.8691499994109297`*^9}},
 CellLabel->"In[2]:=",ExpressionUUID->"751cc04a-9dcd-4323-939d-430bebad369c"],

Cell[BoxData[
 TemplateBox[{
  "Minimize", "natt", 
   "\"The minimum is not attained at any point satisfying the given \
constraints.\"", 2, 2, 2, 16468597645547366084, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{{3.869149980928463*^9, 3.869150000629999*^9}},
 CellLabel->
  "During evaluation of \
In[2]:=",ExpressionUUID->"8feec346-31e3-4393-84cb-4017180e39c1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "\[Infinity]"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"psi1", "\[Rule]", 
      FractionBox["3", "2"]}], ",", 
     RowBox[{"psi2", "\[Rule]", 
      FractionBox["1", "2"]}], ",", 
     RowBox[{"S", "\[Rule]", "\[Infinity]"}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.869149980960187*^9, 3.86915000063666*^9}},
 CellLabel->"Out[2]=",ExpressionUUID->"7d6ca24f-aac1-49ea-93a3-115e5124aa81"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Solve", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"S", " ", 
       RowBox[{"(", 
        RowBox[{"psi1", "-", 
         RowBox[{"psi1", " ", "psi2"}]}], ")"}]}], "+", 
      RowBox[{"(", 
       RowBox[{"psi1", "-", "psi2"}], ")"}]}], " ", "\[Equal]", "0"}], ",", 
    "psi1"}], "]"}], "//", "FullSimplify"}]], "Input",
 CellChangeTimes->{{3.86905685691129*^9, 3.869056859699512*^9}, 
   3.869056973860153*^9, {3.8690573020746393`*^9, 3.869057306320249*^9}},
 CellLabel->"In[80]:=",ExpressionUUID->"7fe9583d-3c2a-4d85-8264-ed3742734176"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"psi1", "\[Rule]", 
    FractionBox["psi2", 
     RowBox[{"1", "+", "S", "-", 
      RowBox[{"psi2", " ", "S"}]}]]}], "}"}], "}"}]], "Output",
 CellChangeTimes->{3.8690569760400133`*^9, 3.8690573095452433`*^9},
 CellLabel->"Out[80]=",ExpressionUUID->"7d762697-2742-457d-8642-ed45ad4c394e"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
   "threshold", " ", "for", " ", "the", " ", "positivity", " ", "of", " ", 
    "the", " ", "above", " ", "slope"}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"below", " ", "s"}], " ", "=", 
    RowBox[{
     RowBox[{"F1", "^", "2"}], " ", "/", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"Fs", "^", "2"}], " ", "+", " ", 
       RowBox[{"tau", "^", "2"}]}], ")"}]}]}], "*)"}], "\[IndentingNewLine]", 
  
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"we", " ", "also", " ", "remove", " ", "a"}], " ", "-", " ", 
    RowBox[{"sign", " ", "from", " ", "the", " ", "numerator"}]}], 
   "*)"}]}]], "Input",
 CellChangeTimes->{{3.869065104769744*^9, 3.869065188335272*^9}, {
  3.869150371668704*^9, 3.8691504028249826`*^9}, {3.869352648998638*^9, 
  3.8693526491326303`*^9}},ExpressionUUID->"e2b477e0-3cd5-446c-b101-\
9c44a5d3fb07"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"D", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"S", " ", 
      RowBox[{"(", 
       RowBox[{"psi1", "-", 
        RowBox[{"psi1", " ", "psi2"}]}], ")"}]}], "+", 
     RowBox[{"(", 
      RowBox[{"psi1", "-", "psi2"}], ")"}]}], ",", " ", "psi1"}], "]"}], "//",
   "FullSimplify"}]], "Input",
 CellChangeTimes->{{3.869057026329754*^9, 3.869057038842361*^9}, 
   3.869057322256713*^9},
 CellLabel->"In[81]:=",ExpressionUUID->"5704ba44-3a99-4de7-b2ff-6e8a2a2be9bf"],

Cell[BoxData[
 RowBox[{"1", "+", "S", "-", 
  RowBox[{"psi2", " ", "S"}]}]], "Output",
 CellChangeTimes->{3.869057041316248*^9, 3.869057326533811*^9},
 CellLabel->"Out[81]=",ExpressionUUID->"8a7db85a-b93c-4897-a8cf-6089744d3285"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"1", "+", "S", "-", 
     RowBox[{"psi2", " ", "S"}]}], "\[Equal]", "0"}], ",", " ", "S"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.869065193105237*^9, 3.869065201690941*^9}},
 CellLabel->"In[85]:=",ExpressionUUID->"cb2ca5f6-1716-46d9-ae06-586fd4c08117"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"S", "\[Rule]", 
    FractionBox["1", 
     RowBox[{
      RowBox[{"-", "1"}], "+", "psi2"}]]}], "}"}], "}"}]], "Output",
 CellChangeTimes->{3.86906520465879*^9},
 CellLabel->"Out[85]=",ExpressionUUID->"0b8af8e5-f6ce-4382-87bf-be8a184d80f9"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{
   RowBox[{"When", " ", "psi2"}], " ", "<", " ", "1"}], "*)"}]], "Input",
 CellChangeTimes->{{3.86905747246345*^9, 
  3.869057473102363*^9}},ExpressionUUID->"2ed13cc7-ff1c-4104-bb4a-\
cec3cc341e77"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Solve", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"objective2", "/.", 
       RowBox[{"{", 
        RowBox[{"chi", "\[Rule]", 
         RowBox[{"-", "psi2"}]}], "}"}]}], ")"}], "==", "\[IndentingNewLine]", 
     RowBox[{"(", 
      RowBox[{"objective2", "/.", 
       RowBox[{"{", 
        RowBox[{"chi", "\[Rule]", "0"}], "}"}]}], ")"}]}], ",", "\[Alpha]"}], 
   "]"}], "//", "FullSimplify"}]], "Input",
 CellChangeTimes->{3.869057513873802*^9},
 CellLabel->"In[82]:=",ExpressionUUID->"df7e696a-f26a-46b8-96ba-be806d587d41"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"\[Alpha]", "\[Rule]", 
    RowBox[{"-", 
     FractionBox[
      RowBox[{
       RowBox[{
        SuperscriptBox["F1", "2"], " ", 
        RowBox[{"(", 
         RowBox[{"psi1", "-", 
          RowBox[{"psi1", " ", "psi2"}]}], ")"}]}], "-", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"psi1", "-", "psi2"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["Fs", "2"], "+", 
          SuperscriptBox["tau", "2"]}], ")"}]}]}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "psi2"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["Fs", "2"], "+", 
         RowBox[{
          SuperscriptBox["F1", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{"2", " ", "psi1"}], "-", 
            RowBox[{"2", " ", "psi2"}]}], ")"}]}], "+", 
         SuperscriptBox["tau", "2"]}], ")"}]}]]}]}], "}"}], "}"}]], "Output",
 CellChangeTimes->{3.869057516828493*^9},
 CellLabel->"Out[82]=",ExpressionUUID->"921128a3-49f3-4e2c-a470-dff2d3ee5f97"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{
   RowBox[{"the", " ", "condition", " ", "when", " ", "alpha", " ", "c"}], 
   " ", "\[GreaterEqual]", " ", "0"}], "*)"}]], "Input",ExpressionUUID->\
"9f38716f-257d-4f54-92dd-c57087b0921e"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Solve", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"S", " ", 
       RowBox[{"(", 
        RowBox[{"psi1", "-", 
         RowBox[{"psi1", " ", "psi2"}]}], ")"}]}], "-", 
      RowBox[{"(", 
       RowBox[{"psi1", "-", "psi2"}], ")"}]}], "\[Equal]", "0"}], ",", 
    "psi1"}], "]"}], "//", "FullSimplify"}]], "Input",
 CellLabel->"In[83]:=",ExpressionUUID->"8f70ed32-d6e3-4e57-8047-b7c1e922f575"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"psi1", "\[Rule]", 
    FractionBox["psi2", 
     RowBox[{"1", "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "psi2"}], ")"}], " ", "S"}]}]]}], "}"}], 
  "}"}]], "Output",
 CellChangeTimes->{3.86905761511721*^9},
 CellLabel->"Out[83]=",ExpressionUUID->"e8c63a6f-fe76-49db-910b-933e42e6c73c"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
   "threshold", " ", "for", " ", "the", " ", "positivity", " ", "of", " ", 
    "the", " ", "above", " ", "slope"}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"below", " ", "s"}], " ", "=", 
    RowBox[{
     RowBox[{"F1", "^", "2"}], " ", "/", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"Fs", "^", "2"}], " ", "+", " ", 
       RowBox[{"tau", "^", "2"}]}], ")"}]}]}], "*)"}]}]], "Input",
 CellChangeTimes->{{3.869180983988123*^9, 3.8691809847274427`*^9}, {
  3.8693526528511343`*^9, 
  3.869352652994837*^9}},ExpressionUUID->"e86ad77e-eb92-4077-8f9a-\
883c85939a5a"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"D", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"S", " ", 
      RowBox[{"(", 
       RowBox[{"psi1", "-", 
        RowBox[{"psi1", " ", "psi2"}]}], ")"}]}], "-", 
     RowBox[{"(", 
      RowBox[{"psi1", "-", "psi2"}], ")"}]}], ",", " ", "psi1"}], "]"}], "//",
   "FullSimplify"}]], "Input",
 CellChangeTimes->{3.86905763199664*^9},
 CellLabel->"In[84]:=",ExpressionUUID->"fcba76e1-05fe-43c4-8ec8-ed6711f38a35"],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "1"}], "+", "S", "-", 
  RowBox[{"psi2", " ", "S"}]}]], "Output",
 CellChangeTimes->{3.869057635928524*^9},
 CellLabel->"Out[84]=",ExpressionUUID->"6a14ad4b-34e6-4a6f-ac12-6ea461491a3c"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", "1"}], "+", "S", "-", 
     RowBox[{"psi2", " ", "S"}]}], "\[Equal]", "0"}], ",", " ", "S"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.869065287623466*^9, 3.869065288143647*^9}},
 CellLabel->"In[86]:=",ExpressionUUID->"124e6ce7-769e-4086-8e98-a58dbc5ed18e"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"S", "\[Rule]", 
    FractionBox["1", 
     RowBox[{"1", "-", "psi2"}]]}], "}"}], "}"}]], "Output",
 CellChangeTimes->{3.869065290594984*^9},
 CellLabel->"Out[86]=",ExpressionUUID->"ae617947-5ee1-4a4a-9207-7c7fce9d824d"]
}, Open  ]]
},
WindowSize->{1277, 772},
WindowMargins->{{22, Automatic}, {Automatic, 11}},
TaggingRules->{"TryRealOnly" -> False},
FrontEndVersion->"12.1 for Mac OS X x86 (64-bit) (June 19, 2020)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"e15b5f42-cf09-4160-96b5-925a518b56bf"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[558, 20, 26409, 706, 1249, "Input",ExpressionUUID->"25467969-791d-4b11-987b-7ede8f2285ce"],
Cell[26970, 728, 1303, 25, 136, "Input",ExpressionUUID->"bc488d36-3fda-4ed6-b61d-6ea2c7e3353b"],
Cell[CellGroupData[{
Cell[28298, 757, 472, 8, 30, "Input",ExpressionUUID->"7e01b3fa-0310-468b-9557-bfa27963979f"],
Cell[28773, 767, 406, 7, 34, "Output",ExpressionUUID->"fe8c57c1-34bd-433a-a6e3-5e5914bfc98e"]
}, Open  ]],
Cell[29194, 777, 1063, 23, 30, "Input",ExpressionUUID->"11605629-d5ac-4419-ad7a-beeb1d07c7ac"],
Cell[CellGroupData[{
Cell[30282, 804, 207, 3, 30, "Input",ExpressionUUID->"e94d3fbe-ca0d-4751-a1c1-8a9062b713bd"],
Cell[30492, 809, 9326, 173, 267, "Output",ExpressionUUID->"761bdddf-7917-4d86-be94-cfa7855c0ba3"]
}, Open  ]],
Cell[39833, 985, 755, 20, 30, "Input",ExpressionUUID->"4a1275f9-8e9b-4b00-bfcd-505a71c1b2f9"],
Cell[CellGroupData[{
Cell[40613, 1009, 207, 3, 30, "Input",ExpressionUUID->"0d36ca8a-46a9-4fc8-9a35-0cad04f91f6c"],
Cell[40823, 1014, 9210, 170, 239, "Output",ExpressionUUID->"5b7612cb-f6cb-479e-97f0-1db33f7548dc"]
}, Open  ]],
Cell[50048, 1187, 891, 20, 30, "Input",ExpressionUUID->"5c32e082-a504-4b43-87af-ccac94003db4"],
Cell[CellGroupData[{
Cell[50964, 1211, 203, 3, 30, "Input",ExpressionUUID->"5280010b-3199-4e15-bbb8-6f8e34dbcae7"],
Cell[51170, 1216, 5732, 113, 236, "Output",ExpressionUUID->"dd6cf566-1af5-4c2b-9acf-eb44ed982b03"]
}, Open  ]],
Cell[56917, 1332, 1285, 32, 52, "Input",ExpressionUUID->"2df0b080-8140-4eda-a59f-4e919995ff2e"],
Cell[CellGroupData[{
Cell[58227, 1368, 203, 3, 30, "Input",ExpressionUUID->"e58c3ee1-7e13-4fff-9d1d-0cab66ea1f88"],
Cell[58433, 1373, 8177, 155, 239, "Output",ExpressionUUID->"4c430579-f2ee-4aaf-b9db-1aaa0506bd5d"]
}, Open  ]],
Cell[CellGroupData[{
Cell[66647, 1533, 415, 9, 30, "Input",ExpressionUUID->"7ee87d80-8f7f-4bde-9994-4a7319e90e5d"],
Cell[67065, 1544, 167, 2, 34, "Output",ExpressionUUID->"446865fc-8234-4d84-82e8-ae57fc799a93"]
}, Open  ]],
Cell[CellGroupData[{
Cell[67269, 1551, 599, 15, 73, "Input",ExpressionUUID->"6eeba0a4-55d5-4e3c-9fe2-aa2d9ccf532d"],
Cell[67871, 1568, 504, 13, 54, "Output",ExpressionUUID->"0a4c5b9c-0c9c-4a59-bb00-932a4ef2c98d"]
}, Open  ]],
Cell[CellGroupData[{
Cell[68412, 1586, 1327, 35, 94, "Input",ExpressionUUID->"a53be0c8-dc6b-4ea0-9da6-ec791971f003"],
Cell[69742, 1623, 1638, 46, 51, "Output",ExpressionUUID->"f48cc5c1-9369-4621-8f66-04049e2cd465"],
Cell[71383, 1671, 383, 9, 34, "Output",ExpressionUUID->"8f4e8b03-97a7-40fa-9bb1-9e23c2f3a8bf"]
}, Open  ]],
Cell[CellGroupData[{
Cell[71803, 1685, 2211, 59, 180, "Input",ExpressionUUID->"210fa892-f26e-4ea3-b590-99acbaa52fca"],
Cell[74017, 1746, 371, 8, 56, "Output",ExpressionUUID->"79655aa8-7b94-4527-8226-1aa189f1a138"]
}, Open  ]],
Cell[CellGroupData[{
Cell[74425, 1759, 909, 22, 75, "Input",ExpressionUUID->"549ef418-3a5c-420b-a897-8c2fa5e10214"],
Cell[75337, 1783, 1012, 31, 62, "Output",ExpressionUUID->"26a326cd-a308-4ff9-88a5-61f1ebf43a13"]
}, Open  ]],
Cell[CellGroupData[{
Cell[76386, 1819, 5249, 132, 315, "Input",ExpressionUUID->"99d40d31-56e2-4109-9cf0-a8e2e0e6bfe7"],
Cell[81638, 1953, 507, 11, 24, "Message",ExpressionUUID->"42a6e36f-64fc-4bc6-a6e4-b835a3ed6eb3"],
Cell[82148, 1966, 948, 17, 34, "Output",ExpressionUUID->"cb7061fa-7a5e-4bb0-a976-da642badf5ae"],
Cell[83099, 1985, 418, 10, 24, "Message",ExpressionUUID->"174efe51-5aca-466d-99b3-381d458aed76"],
Cell[83520, 1997, 960, 17, 34, "Output",ExpressionUUID->"a3176815-66ec-42ff-b40c-bb582340b4e0"],
Cell[84483, 2016, 2073, 58, 62, "Output",ExpressionUUID->"9dee1f2b-5a37-488e-aed4-ddf5518b2e1d"],
Cell[86559, 2076, 886, 15, 34, "Output",ExpressionUUID->"912b0688-082e-4c99-a21a-20045cd62d18"]
}, Open  ]],
Cell[CellGroupData[{
Cell[87482, 2096, 1328, 30, 73, "Input",ExpressionUUID->"bda6e97a-445b-4071-a4bb-cb816f8dc88d"],
Cell[88813, 2128, 217, 4, 53, "Output",ExpressionUUID->"491d43dc-a581-4780-904a-2e0936eef6cb"]
}, Open  ]],
Cell[CellGroupData[{
Cell[89067, 2137, 2294, 56, 115, "Input",ExpressionUUID->"45b42e55-a8e3-4823-8fe3-8cff4ccc0450"],
Cell[91364, 2195, 270, 6, 54, "Output",ExpressionUUID->"46f21af2-df36-444b-8511-5443819f6d75"],
Cell[91637, 2203, 287, 7, 54, "Output",ExpressionUUID->"332af392-9814-454d-b13a-3e89721cbafe"]
}, Open  ]],
Cell[CellGroupData[{
Cell[91961, 2215, 801, 19, 52, "Input",ExpressionUUID->"27b5443c-b50d-4e2c-97ee-ce47da993881"],
Cell[92765, 2236, 477, 10, 24, "Message",ExpressionUUID->"2a27ec38-4173-406e-85d8-bc023356218f"],
Cell[93245, 2248, 320, 7, 34, "Output",ExpressionUUID->"1e57f65b-22d2-4165-9cf0-3072f7804356"]
}, Open  ]],
Cell[93580, 2258, 579, 15, 30, "Input",ExpressionUUID->"70b537a6-6084-4d55-820f-f1ca95a76c43"],
Cell[CellGroupData[{
Cell[94184, 2277, 327, 8, 30, "Input",ExpressionUUID->"5b337fda-25e9-4388-9518-413ebc193f4d"],
Cell[94514, 2287, 354, 7, 56, "Output",ExpressionUUID->"f8289e6c-0869-48d1-8cfa-bc0fdc778334"]
}, Open  ]],
Cell[94883, 2297, 375, 10, 52, "Input",ExpressionUUID->"4abc83ab-698a-4552-80e5-c54b7e68c8f8"],
Cell[CellGroupData[{
Cell[95283, 2311, 1323, 32, 73, "Input",ExpressionUUID->"e77235ec-7005-4968-98c8-bf8c77b6871c"],
Cell[96609, 2345, 15468, 383, 301, "Output",ExpressionUUID->"19b13fc6-33fe-49fe-9bbc-c2777cb7ddf8"]
}, Open  ]],
Cell[112092, 2731, 380, 10, 52, "Input",ExpressionUUID->"712352e9-3d60-4757-8260-e0973dd3bb6d"],
Cell[CellGroupData[{
Cell[112497, 2745, 1600, 49, 177, "Input",ExpressionUUID->"735b8073-07e6-4032-8f4b-3344d19e3cd6"],
Cell[114100, 2796, 535, 16, 57, "Output",ExpressionUUID->"a0392c4e-5b1a-45dc-85a9-7193d929e710"],
Cell[114638, 2814, 561, 16, 38, "Output",ExpressionUUID->"d54ccb34-af23-416c-868a-581147ca4bc9"]
}, Open  ]],
Cell[CellGroupData[{
Cell[115236, 2835, 685, 19, 72, "Input",ExpressionUUID->"0458fdda-0ac4-4eec-81c4-b556e91c97b7"],
Cell[115924, 2856, 437, 11, 54, "Output",ExpressionUUID->"7737fc63-c991-415a-9865-5373565ea007"]
}, Open  ]],
Cell[CellGroupData[{
Cell[116398, 2872, 1363, 41, 160, "Input",ExpressionUUID->"c2989c20-80c3-4e78-a806-136e56172813"],
Cell[117764, 2915, 387, 11, 34, "Output",ExpressionUUID->"16679a68-e8b1-448e-b4b8-744f2d7a0a5c"],
Cell[118154, 2928, 316, 7, 53, "Output",ExpressionUUID->"5073624b-2a4b-4f4d-91f9-c02e3e4338df"]
}, Open  ]],
Cell[118485, 2938, 651, 16, 52, "Input",ExpressionUUID->"2db69fb7-4ace-493a-b7e2-b9b2f8e305b5"],
Cell[119139, 2956, 589, 14, 52, "Input",ExpressionUUID->"a64b6d99-d360-4170-a4c0-96fbdf28c6ec"],
Cell[CellGroupData[{
Cell[119753, 2974, 960, 27, 54, "Input",ExpressionUUID->"7d9d1fa0-9af1-4b62-9f76-a6864cc5ae86"],
Cell[120716, 3003, 3084, 93, 81, "Output",ExpressionUUID->"826996c0-0c63-45c1-8ce1-857a59e2f54a"]
}, Open  ]],
Cell[CellGroupData[{
Cell[123837, 3101, 1102, 26, 115, "Input",ExpressionUUID->"ced51ac4-66b9-49ea-8d90-8f3c665eb9b9"],
Cell[124942, 3129, 540, 14, 38, "Output",ExpressionUUID->"abcde660-0d60-4f58-adec-9fafe3248693"],
Cell[125485, 3145, 833, 25, 38, "Output",ExpressionUUID->"504769d7-dd08-44e6-ae77-6d4e51e96ce8"]
}, Open  ]],
Cell[CellGroupData[{
Cell[126355, 3175, 1359, 37, 107, "Input",ExpressionUUID->"9c975f8a-67e6-4e55-9078-8a295d1e494c"],
Cell[127717, 3214, 503, 14, 38, "Output",ExpressionUUID->"82d67356-681f-4746-bf5e-734f42455ad1"],
Cell[128223, 3230, 506, 14, 38, "Output",ExpressionUUID->"8431f729-87e6-4e0e-b1d5-5698e57342fe"]
}, Open  ]],
Cell[128744, 3247, 405, 9, 30, "Input",ExpressionUUID->"3d872519-9c39-47f6-a7de-9204fc0a7cd9"],
Cell[129152, 3258, 435, 12, 30, "Input",ExpressionUUID->"d4b29e47-d46e-4000-b9c4-608f82239fe5"],
Cell[129590, 3272, 283, 7, 30, "Input",ExpressionUUID->"065f1eb8-dc7c-4463-9137-ff5d54e8dbd3"],
Cell[129876, 3281, 273, 7, 30, "Input",ExpressionUUID->"21d21a93-c6b6-4b4e-94d8-1ec9c5e01152"],
Cell[CellGroupData[{
Cell[130174, 3292, 947, 27, 54, "Input",ExpressionUUID->"da562287-e4d7-485f-a844-81a7486fcd7a"],
Cell[131124, 3321, 1182, 36, 34, "Output",ExpressionUUID->"c615c8d1-0289-45e9-8042-51a80fd8e1b1"]
}, Open  ]],
Cell[CellGroupData[{
Cell[132343, 3362, 422, 10, 52, "Input",ExpressionUUID->"89607b5e-ec49-4853-95b1-320b93d1e7ec"],
Cell[132768, 3374, 365, 10, 34, "Output",ExpressionUUID->"9ea23a79-97f0-44c1-9043-d1fe4fc01a71"]
}, Open  ]],
Cell[CellGroupData[{
Cell[133170, 3389, 533, 11, 52, "Input",ExpressionUUID->"a73001a3-4193-435c-83ef-5692efc3feca"],
Cell[133706, 3402, 371, 10, 34, "Output",ExpressionUUID->"9cdb2859-1895-417b-9f0e-69a0d83529fa"]
}, Open  ]],
Cell[CellGroupData[{
Cell[134114, 3417, 975, 24, 73, "Input",ExpressionUUID->"80ac9b22-3075-474f-a73b-bedfe09090dc"],
Cell[135092, 3443, 335, 8, 34, "Output",ExpressionUUID->"da6ef327-4654-46b6-be4f-65da01281d58"]
}, Open  ]],
Cell[135442, 3454, 274, 6, 30, "Input",ExpressionUUID->"02e289ec-838f-4c86-a200-0d92e22df513"],
Cell[135719, 3462, 551, 11, 30, "Input",ExpressionUUID->"ee81a2e4-51d1-426c-b14e-c45259749171"],
Cell[CellGroupData[{
Cell[136295, 3477, 309, 8, 30, "Input",ExpressionUUID->"440c4878-7079-481e-abf2-a38ab838cea7"],
Cell[136607, 3487, 677, 21, 58, "Output",ExpressionUUID->"f8b8973c-3073-4de4-8591-75c3ff8359cc"]
}, Open  ]],
Cell[137299, 3511, 405, 9, 30, "Input",ExpressionUUID->"9c9fa923-17c1-416a-9322-a7b2774c80d6"],
Cell[CellGroupData[{
Cell[137729, 3524, 751, 20, 52, "Input",ExpressionUUID->"8f440147-0899-4d72-a4ef-900512dcf39a"],
Cell[138483, 3546, 693, 20, 58, "Output",ExpressionUUID->"d76c0003-2801-45e7-9b97-7a8b1c6f3ffc"],
Cell[139179, 3568, 689, 19, 58, "Output",ExpressionUUID->"58f94d4d-73fc-4d73-bb21-4b7c8eb4996a"]
}, Open  ]],
Cell[139883, 3590, 426, 9, 30, "Input",ExpressionUUID->"4fa5379a-6cad-41e0-b76f-a51bf6950715"],
Cell[CellGroupData[{
Cell[140334, 3603, 815, 26, 52, "Input",ExpressionUUID->"a069aa91-69a4-42b2-9069-48016604b4c5"],
Cell[141152, 3631, 783, 22, 58, "Output",ExpressionUUID->"fbbb4150-ea38-4fa8-bf15-3a031696020c"],
Cell[141938, 3655, 585, 16, 58, "Output",ExpressionUUID->"8a8a39b9-77de-4fb3-a144-eafe712230d7"]
}, Open  ]],
Cell[142538, 3674, 403, 9, 30, "Input",ExpressionUUID->"5dbdb82a-f524-488f-950c-a8814ef9cc6b"],
Cell[CellGroupData[{
Cell[142966, 3687, 459, 13, 30, "Input",ExpressionUUID->"b859e630-078d-4328-b564-ff8200bca61b"],
Cell[143428, 3702, 573, 16, 57, "Output",ExpressionUUID->"3d626123-81d7-45de-838d-c77d7c1e2936"]
}, Open  ]],
Cell[144016, 3721, 877, 18, 52, "Input",ExpressionUUID->"b2207ab8-88c3-4a98-ad31-884ee7b13b19"],
Cell[CellGroupData[{
Cell[144918, 3743, 409, 12, 30, "Input",ExpressionUUID->"64ea4316-4206-4643-8156-08c014f03f92"],
Cell[145330, 3757, 274, 6, 56, "Output",ExpressionUUID->"b7bf5155-0263-40d3-ba3a-7996281bf0c7"]
}, Open  ]],
Cell[145619, 3766, 397, 9, 30, "Input",ExpressionUUID->"238acc35-7c68-4caa-8d85-e1fb8bd84717"],
Cell[CellGroupData[{
Cell[146041, 3779, 431, 12, 30, "Input",ExpressionUUID->"d53e8397-80a4-4c2e-92e5-82aaf31b7f7c"],
Cell[146475, 3793, 621, 17, 57, "Output",ExpressionUUID->"98e92a7a-4df8-4ec2-902b-c5123064e36b"]
}, Open  ]],
Cell[CellGroupData[{
Cell[147133, 3815, 1193, 29, 73, "Input",ExpressionUUID->"7d109c43-0d72-4057-9bcd-0634d8bb7bc1"],
Cell[148329, 3846, 273, 6, 56, "Output",ExpressionUUID->"48ca190d-8015-458f-9432-d6206a91dd97"]
}, Open  ]],
Cell[CellGroupData[{
Cell[148639, 3857, 889, 24, 73, "Input",ExpressionUUID->"20f1357f-79cf-47ce-a2bb-2716bf8d1b1b"],
Cell[149531, 3883, 619, 17, 57, "Output",ExpressionUUID->"5a8fcb9f-1d38-4e0e-90cb-270850aed397"]
}, Open  ]],
Cell[150165, 3903, 931, 19, 52, "Input",ExpressionUUID->"0a17741d-93ea-4d74-a0bd-034de473341e"],
Cell[CellGroupData[{
Cell[151121, 3926, 611, 18, 30, "Input",ExpressionUUID->"5c3f99ad-1213-4fb1-adc8-7066fa8c0aa1"],
Cell[151735, 3946, 306, 7, 56, "Output",ExpressionUUID->"61aa10fa-144e-49bc-af0c-28583d7c0c24"]
}, Open  ]],
Cell[152056, 3956, 351, 9, 30, "Input",ExpressionUUID->"4eef40b2-ed87-4b5e-8d03-5d5451cab698"],
Cell[CellGroupData[{
Cell[152432, 3969, 459, 13, 30, "Input",ExpressionUUID->"8afba731-7f19-41bc-826c-dcb11eb9b7ab"],
Cell[152894, 3984, 545, 15, 57, "Output",ExpressionUUID->"a6fa9fe0-ee2b-4e69-8bbd-4475bcf39135"]
}, Open  ]],
Cell[153454, 4002, 708, 16, 52, "Input",ExpressionUUID->"b881403c-97b7-499f-98aa-c120c21b8f61"],
Cell[CellGroupData[{
Cell[154187, 4022, 409, 12, 30, "Input",ExpressionUUID->"ce7c229a-c595-4cea-b638-ba5ae1c2fc70"],
Cell[154599, 4036, 250, 6, 56, "Output",ExpressionUUID->"f9d977d3-eee6-411a-a4d8-6b9ddc7aa307"]
}, Open  ]],
Cell[CellGroupData[{
Cell[154886, 4047, 773, 22, 52, "Input",ExpressionUUID->"787a627d-06ca-49a4-9f17-c7680b280641"],
Cell[155662, 4071, 622, 18, 57, "Output",ExpressionUUID->"17dcd4dd-6e73-41c5-96a0-ca6e1855a367"]
}, Open  ]],
Cell[156299, 4092, 781, 17, 52, "Input",ExpressionUUID->"c0e8b5f5-3961-4999-8b15-fb163bb22c5d"],
Cell[CellGroupData[{
Cell[157105, 4113, 414, 12, 30, "Input",ExpressionUUID->"e6824f86-c376-4be4-8594-d6aa9be7a5f9"],
Cell[157522, 4127, 250, 6, 56, "Output",ExpressionUUID->"a00fc81f-46bd-496d-a520-f468cdbdd10a"]
}, Open  ]],
Cell[CellGroupData[{
Cell[157809, 4138, 833, 25, 73, "Input",ExpressionUUID->"843d8962-b036-4b13-9a92-9497bf22180e"],
Cell[158645, 4165, 557, 16, 57, "Output",ExpressionUUID->"63ad53b2-68d7-47df-a759-f2d96e74aecf"]
}, Open  ]],
Cell[CellGroupData[{
Cell[159239, 4186, 1371, 35, 73, "Input",ExpressionUUID->"d65b89e3-bbd4-460e-979b-d9ae268aef9a"],
Cell[160613, 4223, 271, 7, 56, "Output",ExpressionUUID->"88bcf52b-f148-4225-b27e-89a9a01e133c"]
}, Open  ]],
Cell[CellGroupData[{
Cell[160921, 4235, 1558, 38, 73, "Input",ExpressionUUID->"e683acda-9a1e-40d4-bf10-af1cf02a5218"],
Cell[162482, 4275, 256, 6, 34, "Output",ExpressionUUID->"d5619d0e-ec80-4659-9ff8-af76cc955e85"]
}, Open  ]],
Cell[CellGroupData[{
Cell[162775, 4286, 517, 14, 30, "Input",ExpressionUUID->"7189e4bd-8c6e-4599-a414-a65b96152216"],
Cell[163295, 4302, 165, 3, 34, "Output",ExpressionUUID->"7db76eca-c302-4a63-8765-24671b09e6d6"]
}, Open  ]],
Cell[163475, 4308, 731, 17, 30, "Input",ExpressionUUID->"99c3bc22-3121-4a9b-b847-b0af9b662383"],
Cell[CellGroupData[{
Cell[164231, 4329, 458, 11, 30, "Input",ExpressionUUID->"2a9c36c4-9d0a-4517-b5fe-67c4182c1b92"],
Cell[164692, 4342, 218, 5, 34, "Output",ExpressionUUID->"861dfd95-750f-43b9-af6b-4f6e8a1924a0"]
}, Open  ]],
Cell[164925, 4350, 780, 18, 30, "Input",ExpressionUUID->"6d170436-9d64-459a-8878-ed5524720b66"],
Cell[CellGroupData[{
Cell[165730, 4372, 421, 11, 30, "Input",ExpressionUUID->"f00fb579-60df-4005-ab92-ffb82f548783"],
Cell[166154, 4385, 219, 5, 34, "Output",ExpressionUUID->"f5258800-c036-4254-a4a5-5c09cc4180e3"]
}, Open  ]],
Cell[166388, 4393, 767, 19, 30, "Input",ExpressionUUID->"759e6576-eee7-465f-863d-1256d86b429f"],
Cell[CellGroupData[{
Cell[167180, 4416, 509, 14, 30, "Input",ExpressionUUID->"5b0022f3-cdb3-4de7-9ef1-8ab6685f3cb1"],
Cell[167692, 4432, 256, 6, 34, "Output",ExpressionUUID->"acc59d6f-e9ac-40cc-a39d-cd620debf6a1"]
}, Open  ]],
Cell[CellGroupData[{
Cell[167985, 4443, 541, 15, 30, "Input",ExpressionUUID->"44dbdfb7-adcf-4e74-a5e6-30edf4740057"],
Cell[168529, 4460, 167, 3, 34, "Output",ExpressionUUID->"8f8fe75b-5daf-4941-914a-34ec2bfd9929"]
}, Open  ]],
Cell[168711, 4466, 705, 18, 30, "Input",ExpressionUUID->"e6487472-c95c-46fb-bf96-5d5aa4d8d7d0"],
Cell[CellGroupData[{
Cell[169441, 4488, 349, 9, 30, "Input",ExpressionUUID->"2a963476-056e-4aaf-b14b-6c1c37f1f21d"],
Cell[169793, 4499, 205, 4, 34, "Output",ExpressionUUID->"935c676b-87f9-4080-bda9-d2fb59e0a363"]
}, Open  ]],
Cell[170013, 4506, 769, 19, 30, "Input",ExpressionUUID->"82242bb5-d357-4703-ab17-5ca2150778b9"],
Cell[CellGroupData[{
Cell[170807, 4529, 440, 12, 30, "Input",ExpressionUUID->"9ebf9ea7-7a89-483a-a191-afac2c09ee83"],
Cell[171250, 4543, 205, 4, 34, "Output",ExpressionUUID->"e2dce1a7-afe6-4180-844e-1202d84271dd"]
}, Open  ]],
Cell[171470, 4550, 827, 19, 30, "Input",ExpressionUUID->"75029fca-9c12-4ac9-ba7a-680593ad2f40"],
Cell[CellGroupData[{
Cell[172322, 4573, 1118, 32, 55, "Input",ExpressionUUID->"83e6f954-df32-4300-b418-51f3c359163c"],
Cell[173443, 4607, 484, 10, 24, "Message",ExpressionUUID->"3c7ac794-1679-44c0-8cf0-c350fe925bdc"],
Cell[173930, 4619, 335, 8, 34, "Output",ExpressionUUID->"0f055e25-2fbb-403c-bcaa-ef2cf4694cad"]
}, Open  ]],
Cell[174280, 4630, 792, 18, 30, "Input",ExpressionUUID->"78a26b7a-98f9-4192-98f2-74a47d0e0864"],
Cell[CellGroupData[{
Cell[175097, 4652, 1096, 31, 55, "Input",ExpressionUUID->"6db7c3e6-2314-4155-aae4-c1d025eba59c"],
Cell[176196, 4685, 507, 11, 24, "Message",ExpressionUUID->"e664497f-1284-4d40-b534-5e768f0f29e2"],
Cell[176706, 4698, 363, 9, 34, "Output",ExpressionUUID->"e3609bb4-021f-4152-a2d7-1edc10c3ea3e"]
}, Open  ]],
Cell[177084, 4710, 705, 18, 30, "Input",ExpressionUUID->"024ff94d-c674-4fc0-ac83-9eb0040f948b"],
Cell[CellGroupData[{
Cell[177814, 4732, 1165, 33, 38, "Input",ExpressionUUID->"654bdb5a-7911-4207-be21-696c2a5b61d2"],
Cell[178982, 4767, 391, 9, 24, "Message",ExpressionUUID->"5d8eee3f-2a00-4426-8f7d-13e9c347fca2"],
Cell[179376, 4778, 361, 9, 34, "Output",ExpressionUUID->"15bff46a-64e3-4c77-86f4-16c44c507d49"]
}, Open  ]],
Cell[179752, 4790, 716, 18, 30, "Input",ExpressionUUID->"7923be57-8a86-4a5f-9ad6-4346c097f58f"],
Cell[CellGroupData[{
Cell[180493, 4812, 1022, 30, 38, "Input",ExpressionUUID->"3f6d601c-2594-447c-b231-2b51791e2b36"],
Cell[181518, 4844, 392, 9, 24, "Message",ExpressionUUID->"5ffa0520-f4b1-4a15-8017-7f511ca3895c"],
Cell[181913, 4855, 361, 9, 34, "Output",ExpressionUUID->"9fcceb56-255f-4bef-ad0d-a09166d185ab"]
}, Open  ]],
Cell[182289, 4867, 969, 20, 30, "Input",ExpressionUUID->"64cd3b0b-e73d-4a02-a637-16690203c3f3"],
Cell[CellGroupData[{
Cell[183283, 4891, 1421, 37, 80, "Input",ExpressionUUID->"6d9b57ce-c92f-4f42-98f5-bd083db53aba"],
Cell[184707, 4930, 512, 11, 34, "Output",ExpressionUUID->"7c5f9ce3-2fd8-46a7-a5e1-f45b409996ba"]
}, Open  ]],
Cell[185234, 4944, 983, 20, 30, "Input",ExpressionUUID->"a5151fb7-bb23-4f37-91be-47fbc3c1359e"],
Cell[CellGroupData[{
Cell[186242, 4968, 1303, 34, 51, "Input",ExpressionUUID->"b29301f8-39a8-42e9-9c15-ddcd1632df2c"],
Cell[187548, 5004, 460, 10, 34, "Output",ExpressionUUID->"518f1e99-5571-4bea-af3c-284a460f8763"]
}, Open  ]],
Cell[188023, 5017, 678, 17, 30, "Input",ExpressionUUID->"e63ae26b-e228-4eeb-ba96-e66307975300"],
Cell[CellGroupData[{
Cell[188726, 5038, 1249, 33, 51, "Input",ExpressionUUID->"82f54792-d511-497a-847b-3647aa4d4996"],
Cell[189978, 5073, 369, 9, 24, "Message",ExpressionUUID->"5f943e29-8d7c-4da5-9916-7a217592f501"],
Cell[190350, 5084, 414, 11, 34, "Output",ExpressionUUID->"2b239ee1-d19d-4943-b566-6df0f231438d"]
}, Open  ]],
Cell[190779, 5098, 785, 18, 30, "Input",ExpressionUUID->"16b693b2-ee3f-4570-ab86-10ca1de8aabe"],
Cell[CellGroupData[{
Cell[191589, 5120, 1031, 28, 51, "Input",ExpressionUUID->"ed2f6988-1a55-40d4-910b-42c4a327c31d"],
Cell[192623, 5150, 370, 9, 24, "Message",ExpressionUUID->"85f808d6-a839-4acd-8124-5b1058916033"],
Cell[192996, 5161, 413, 11, 34, "Output",ExpressionUUID->"6b0cd029-d03d-47f2-9643-438af6c90ca1"]
}, Open  ]],
Cell[193424, 5175, 972, 21, 30, "Input",ExpressionUUID->"46263673-75df-4ed7-86a9-c1d466849076"],
Cell[CellGroupData[{
Cell[194421, 5200, 1288, 32, 30, "Input",ExpressionUUID->"7797bf27-f64c-4ceb-bf49-9f6633da8079"],
Cell[195712, 5234, 537, 12, 34, "Output",ExpressionUUID->"1e867e8d-a55c-40c3-a6c2-b31029338cca"]
}, Open  ]],
Cell[196264, 5249, 987, 21, 30, "Input",ExpressionUUID->"034b7b9b-1f6e-4ea6-9b24-5afd07b33905"],
Cell[CellGroupData[{
Cell[197276, 5274, 1147, 29, 30, "Input",ExpressionUUID->"9ccb4e91-6b8a-47c2-b7d1-a89cc56d9849"],
Cell[198426, 5305, 482, 10, 34, "Output",ExpressionUUID->"6561266b-2538-446d-8939-ab7e69f359de"]
}, Open  ]],
Cell[198923, 5318, 675, 17, 30, "Input",ExpressionUUID->"7bf24455-68d4-4abc-be7a-2c2f08af8758"],
Cell[CellGroupData[{
Cell[199623, 5339, 1115, 28, 50, "Input",ExpressionUUID->"c31a2af2-97b3-43e9-b2e4-49cbc9a324b2"],
Cell[200741, 5369, 391, 9, 24, "Message",ExpressionUUID->"1aaa0f64-fed0-4a30-81cc-31e8bb4a6193"],
Cell[201135, 5380, 438, 11, 34, "Output",ExpressionUUID->"6b664dfc-fb86-4f95-93e7-c8139d73a866"]
}, Open  ]],
Cell[201588, 5394, 791, 19, 30, "Input",ExpressionUUID->"4b249480-6c1f-4fdb-a145-74428e222416"],
Cell[CellGroupData[{
Cell[202404, 5417, 871, 23, 50, "Input",ExpressionUUID->"214d9124-f7be-454f-968a-3d4550ed30b3"],
Cell[203278, 5442, 392, 9, 24, "Message",ExpressionUUID->"3be7db27-21c4-4f82-b78e-fc097971255e"],
Cell[203673, 5453, 437, 11, 34, "Output",ExpressionUUID->"984859f6-6cea-4470-a1f9-8971c1ee18ad"]
}, Open  ]],
Cell[204125, 5467, 268, 7, 30, "Input",ExpressionUUID->"6c9e59ab-d8ba-4952-ab03-6e39ec98a811"],
Cell[CellGroupData[{
Cell[204418, 5478, 973, 28, 96, "Input",ExpressionUUID->"b6f64742-9395-49a8-be1b-d36e197fe7e1"],
Cell[205394, 5508, 5307, 160, 151, "Output",ExpressionUUID->"3371fc24-ec5f-4608-afaa-f34204978586"]
}, Open  ]],
Cell[CellGroupData[{
Cell[210738, 5673, 1415, 35, 97, "Input",ExpressionUUID->"d73e61bb-a263-43e8-8560-b1a779c63b4b"],
Cell[212156, 5710, 1539, 46, 62, "Output",ExpressionUUID->"9e6c633d-4c1b-474b-b6c9-7953b9873a1d"]
}, Open  ]],
Cell[213710, 5759, 605, 16, 30, "Input",ExpressionUUID->"80a3e68b-b83d-4d9b-afd3-2e4601a97d7d"],
Cell[214318, 5777, 839, 23, 56, "Input",ExpressionUUID->"ecf84a49-d0ed-46a9-94a7-564c281f19a8"],
Cell[215160, 5802, 476, 10, 30, "Input",ExpressionUUID->"3914f899-8902-478b-a67a-b85954c939e8"],
Cell[215639, 5814, 458, 11, 30, "Input",ExpressionUUID->"2e209128-501d-4141-a82c-eaf29bb5aed8"],
Cell[CellGroupData[{
Cell[216122, 5829, 811, 16, 52, "Input",ExpressionUUID->"3b90e184-a329-4103-b3f5-da4e03291a5e"],
Cell[216936, 5847, 1153, 35, 37, "Output",ExpressionUUID->"a19f6db9-9c91-44f0-ba03-04d136249b42"]
}, Open  ]],
Cell[CellGroupData[{
Cell[218126, 5887, 1655, 47, 56, "Input",ExpressionUUID->"cb8930fb-9e01-4482-95ab-513ef427e863"],
Cell[219784, 5936, 8308, 220, 163, "Output",ExpressionUUID->"21772aa2-b2bc-4f1d-9744-142b3304c9d5"]
}, Open  ]],
Cell[228107, 6159, 151, 3, 30, "Input",ExpressionUUID->"ba1c9fbb-bcef-4a34-b727-f6f3eca8e413"],
Cell[CellGroupData[{
Cell[228283, 6166, 472, 14, 38, "Input",ExpressionUUID->"1dd0fc5e-5552-4799-a121-75795c3f0472"],
Cell[228758, 6182, 301, 7, 34, "Output",ExpressionUUID->"32c595e9-ff8f-455e-8bc7-36bbb605b7dc"]
}, Open  ]],
Cell[CellGroupData[{
Cell[229096, 6194, 495, 16, 38, "Input",ExpressionUUID->"efb9ba4e-177c-4170-af91-3c3543842dc0"],
Cell[229594, 6212, 313, 7, 34, "Output",ExpressionUUID->"01173ec4-6620-4716-8886-d7ba7d54423f"]
}, Open  ]],
Cell[CellGroupData[{
Cell[229944, 6224, 601, 13, 73, "Input",ExpressionUUID->"4f83f3eb-9d9f-4220-89d9-3c05a187d298"],
Cell[230548, 6239, 399, 10, 38, "Output",ExpressionUUID->"897d8415-1d6f-4b81-9040-9536af5a55b3"]
}, Open  ]],
Cell[CellGroupData[{
Cell[230984, 6254, 625, 18, 33, "Input",ExpressionUUID->"0d5adff5-cede-48de-beac-dc7de78036e0"],
Cell[231612, 6274, 3307, 92, 69, "Output",ExpressionUUID->"810c673e-c432-45cc-8c39-54de16c3ddeb"]
}, Open  ]],
Cell[234934, 6369, 523, 12, 30, "Input",ExpressionUUID->"f80dd342-3be3-47d4-9da7-72795fbe7355"],
Cell[CellGroupData[{
Cell[235482, 6385, 436, 10, 30, "Input",ExpressionUUID->"cc44443d-0a0d-46e8-b281-54c52e5aacce"],
Cell[235921, 6397, 1229, 35, 62, "Output",ExpressionUUID->"ba12b273-e22a-4216-a1a0-123dff443942"]
}, Open  ]],
Cell[237165, 6435, 466, 11, 30, "Input",ExpressionUUID->"6c0c5a7d-9fad-4cbe-a487-d65baf1f403a"],
Cell[CellGroupData[{
Cell[237656, 6450, 371, 6, 30, "Input",ExpressionUUID->"2e00be6e-d1c8-43a8-90e5-0b3c1702a03a"],
Cell[238030, 6458, 906, 25, 37, "Output",ExpressionUUID->"1eaf6142-5175-4c37-9b1d-a1c65c3b9524"]
}, Open  ]],
Cell[CellGroupData[{
Cell[238973, 6488, 1168, 32, 54, "Input",ExpressionUUID->"9e6195e5-f7c5-4787-95dd-0b41f4ceb6f6"],
Cell[240144, 6522, 2949, 82, 53, "Output",ExpressionUUID->"86ab3891-6d93-43b5-8b7d-d4f056129d58"]
}, Open  ]],
Cell[CellGroupData[{
Cell[243130, 6609, 624, 14, 52, "Input",ExpressionUUID->"5f1d95ad-e817-4062-a8da-d41f9eef8099"],
Cell[243757, 6625, 350, 9, 38, "Output",ExpressionUUID->"e038cb84-d39e-401d-be58-7e08f51cccf1"]
}, Open  ]],
Cell[CellGroupData[{
Cell[244144, 6639, 625, 18, 33, "Input",ExpressionUUID->"f129a4b7-909a-49d1-a26a-1efa83c1725c"],
Cell[244772, 6659, 3260, 91, 69, "Output",ExpressionUUID->"08a5c10c-0f35-4bec-869f-99f2ac530d3e"]
}, Open  ]],
Cell[248047, 6753, 400, 9, 30, "Input",ExpressionUUID->"6be2443b-5c3a-4d13-a190-f81ca6e6c11a"],
Cell[248450, 6764, 234, 5, 30, "Input",ExpressionUUID->"461d3389-9f66-4c36-a981-2c3019f58d01"],
Cell[CellGroupData[{
Cell[248709, 6773, 301, 7, 30, "Input",ExpressionUUID->"f7c184f0-6bff-47ba-bea8-4ee0ccf8a84e"],
Cell[249013, 6782, 217, 4, 53, "Output",ExpressionUUID->"db415a9f-c4b5-4a12-bb6e-e6a63604faf2"]
}, Open  ]],
Cell[CellGroupData[{
Cell[249267, 6791, 436, 11, 52, "Input",ExpressionUUID->"692b8a13-6e0b-4dc6-a3ee-5c693d23fe8c"],
Cell[249706, 6804, 249, 5, 54, "Output",ExpressionUUID->"c239b0a1-8b09-4b78-8515-34bb746c39fc"]
}, Open  ]],
Cell[CellGroupData[{
Cell[249992, 6814, 330, 7, 30, "Input",ExpressionUUID->"aba20d63-bf2f-49e6-ab51-4a75e08b0c8b"],
Cell[250325, 6823, 242, 6, 54, "Output",ExpressionUUID->"db947cf0-fd5d-414f-a60a-061bd3ea006c"]
}, Open  ]],
Cell[CellGroupData[{
Cell[250604, 6834, 1227, 34, 74, "Input",ExpressionUUID->"b8bc7e16-2879-457d-b616-b61e7d2f4d4e"],
Cell[251834, 6870, 254, 6, 34, "Output",ExpressionUUID->"e3549416-e6ca-4b42-9d01-dbdf2b4657b2"]
}, Open  ]],
Cell[252103, 6879, 449, 11, 30, "Input",ExpressionUUID->"ba4aa40c-dcef-4bd7-b10e-9a40d69f1442"],
Cell[252555, 6892, 368, 10, 30, "Input",ExpressionUUID->"b4fc0262-7e6e-4575-bafd-aede05163500"],
Cell[CellGroupData[{
Cell[252948, 6906, 325, 7, 30, "Input",ExpressionUUID->"1d2facf4-1087-4612-b801-a4eff86ea644"],
Cell[253276, 6915, 174, 3, 53, "Output",ExpressionUUID->"362144a4-8187-4d20-ad8b-e55875bbc770"]
}, Open  ]],
Cell[253465, 6921, 368, 10, 30, "Input",ExpressionUUID->"b6abc117-0c18-4892-8877-147ce3c0313a"],
Cell[CellGroupData[{
Cell[253858, 6935, 281, 7, 30, "Input",ExpressionUUID->"10a11e13-2584-49ed-a48d-76511a90e23e"],
Cell[254142, 6944, 429, 14, 55, "Output",ExpressionUUID->"b601bb85-a955-4399-b64a-6117daeb7c4b"]
}, Open  ]],
Cell[CellGroupData[{
Cell[254608, 6963, 306, 7, 30, "Input",ExpressionUUID->"3f34ac81-c7d9-40a5-9060-130ac0c6ab3f"],
Cell[254917, 6972, 354, 10, 55, "Output",ExpressionUUID->"51b584c1-1d4d-4ed8-88a3-8d21711fd7a9"]
}, Open  ]],
Cell[255286, 6985, 369, 8, 30, "Input",ExpressionUUID->"aeba70c6-018f-49a7-bbf9-425fa07cf686"],
Cell[CellGroupData[{
Cell[255680, 6997, 1030, 32, 52, "Input",ExpressionUUID->"735831fd-485b-4fe6-9924-4626f61bd583"],
Cell[256713, 7031, 262, 6, 34, "Output",ExpressionUUID->"0606c296-161e-4e63-b5cd-7783d2663599"]
}, Open  ]],
Cell[256990, 7040, 443, 10, 30, "Input",ExpressionUUID->"c63a6cf0-5611-4ce9-b678-d81195eb6e2a"],
Cell[257436, 7052, 255, 6, 30, "Input",ExpressionUUID->"3d6069cb-cb8a-482d-a913-f15310107314"],
Cell[CellGroupData[{
Cell[257716, 7062, 383, 9, 30, "Input",ExpressionUUID->"b4220134-b5d5-4462-b038-09217a69e726"],
Cell[258102, 7073, 215, 4, 53, "Output",ExpressionUUID->"7673e567-fa02-4a78-b334-cc3326efc5e0"]
}, Open  ]],
Cell[258332, 7080, 261, 7, 30, "Input",ExpressionUUID->"3d99020b-92d2-4394-865a-21bc9c9c6fec"],
Cell[CellGroupData[{
Cell[258618, 7091, 337, 9, 30, "Input",ExpressionUUID->"7ad9bea7-75bf-4cd4-a13e-892b10e70da4"],
Cell[258958, 7102, 301, 9, 54, "Output",ExpressionUUID->"ee6807f5-b0e0-4ee1-8c4a-7a5102981120"]
}, Open  ]],
Cell[CellGroupData[{
Cell[259296, 7116, 386, 9, 30, "Input",ExpressionUUID->"ea3d9533-d53d-4db1-884e-af1ebc6a3085"],
Cell[259685, 7127, 295, 8, 55, "Output",ExpressionUUID->"52154477-5c88-493c-aa52-14c2ed95a22c"]
}, Open  ]],
Cell[259995, 7138, 509, 11, 30, "Input",ExpressionUUID->"b2b33848-af38-426a-a380-27f52fa58159"],
Cell[260507, 7151, 405, 11, 30, "Input",ExpressionUUID->"22ed68d0-c7a4-4106-80ad-86355af87002"],
Cell[CellGroupData[{
Cell[260937, 7166, 380, 9, 30, "Input",ExpressionUUID->"15634a69-7c57-4945-8ff8-aa3164f73081"],
Cell[261320, 7177, 151, 2, 34, "Output",ExpressionUUID->"de6c6e55-14bb-4110-9648-701995c1af0b"]
}, Open  ]],
Cell[261486, 7182, 411, 11, 30, "Input",ExpressionUUID->"b6bfd6be-bf0f-4f06-ac55-a321196a07e6"],
Cell[CellGroupData[{
Cell[261922, 7197, 356, 9, 30, "Input",ExpressionUUID->"347ffe5e-e905-45a0-a848-633b9eeeb53d"],
Cell[262281, 7208, 378, 12, 55, "Output",ExpressionUUID->"ddc6c6df-b6db-493d-9d37-716c0d8079d5"]
}, Open  ]],
Cell[CellGroupData[{
Cell[262696, 7225, 359, 9, 30, "Input",ExpressionUUID->"5e060cac-213e-4365-9ecc-4492a99cbe53"],
Cell[263058, 7236, 357, 10, 55, "Output",ExpressionUUID->"d5b5e011-5cd5-48eb-b857-d90313de8e94"]
}, Open  ]],
Cell[263430, 7249, 206, 5, 30, "Input",ExpressionUUID->"49b753de-6de6-45c7-bfe0-e26d13537a92"],
Cell[263639, 7256, 241, 4, 30, "Input",ExpressionUUID->"4af486ab-ea52-45eb-baeb-5d6ea4e94db6"],
Cell[CellGroupData[{
Cell[263905, 7264, 263, 6, 30, "Input",ExpressionUUID->"cc2cf346-af3f-473d-a957-15e090518bfd"],
Cell[264171, 7272, 387, 11, 58, "Output",ExpressionUUID->"91523b5a-bd52-4120-8df9-027f13ab2f69"]
}, Open  ]],
Cell[264573, 7286, 208, 5, 30, "Input",ExpressionUUID->"7446cdb4-517e-476d-918d-dfd04fbde5e3"],
Cell[CellGroupData[{
Cell[264806, 7295, 436, 12, 52, "Input",ExpressionUUID->"73b13a4f-bcf9-43be-862f-d9c67b2ec913"],
Cell[265245, 7309, 720, 24, 59, "Output",ExpressionUUID->"b8ddb720-029d-4c87-964c-13aa55f7860d"],
Cell[265968, 7335, 632, 20, 59, "Output",ExpressionUUID->"d9a8428b-ea6b-485f-b299-d9d9654ea7f1"]
}, Open  ]],
Cell[266615, 7358, 420, 11, 30, "Input",ExpressionUUID->"ed2dd5e4-d32a-4a33-952b-0698b16dacaa"],
Cell[CellGroupData[{
Cell[267060, 7373, 1026, 28, 66, "Input",ExpressionUUID->"5bdc4615-3682-498e-ad9e-4250cf652594"],
Cell[268089, 7403, 59127, 1281, 1179, "Output",ExpressionUUID->"7ecdb9c5-97e1-46d1-86ee-1db273e005bc"]
}, Open  ]],
Cell[327231, 8687, 2338, 63, 56, "Input",ExpressionUUID->"a507afaa-17e9-42a5-9e23-ee1f289b6979"],
Cell[CellGroupData[{
Cell[329594, 8754, 363, 10, 30, "Input",ExpressionUUID->"4d874e25-c487-4cbc-bad4-7782a9e14ede"],
Cell[329960, 8766, 1675, 49, 37, "Output",ExpressionUUID->"66ecd957-5f20-42a7-a19c-943c121747d2"]
}, Open  ]],
Cell[331650, 8818, 381, 7, 30, "Input",ExpressionUUID->"b0e7f97b-6aa9-4a32-bef8-651e87a7868c"],
Cell[CellGroupData[{
Cell[332056, 8829, 631, 19, 55, "Input",ExpressionUUID->"d48dc483-3ac5-4693-8b4d-811504cd1fcb"],
Cell[332690, 8850, 534, 15, 57, "Output",ExpressionUUID->"1315a790-15ae-4222-91da-f935e4094645"]
}, Open  ]],
Cell[333239, 8868, 284, 6, 30, "Input",ExpressionUUID->"12b65ea3-b756-4073-b1de-3b28d066e22b"],
Cell[CellGroupData[{
Cell[333548, 8878, 1913, 59, 107, "Input",ExpressionUUID->"c5433707-b2ad-488a-8518-dc3002e1fe32"],
Cell[335464, 8939, 853, 27, 57, "Output",ExpressionUUID->"1d1948e9-653f-4663-abe0-90f74dc6562e"],
Cell[336320, 8968, 881, 27, 60, "Output",ExpressionUUID->"15e112cc-6789-464d-9f3f-d482733f8aff"]
}, Open  ]],
Cell[337216, 8998, 280, 6, 30, "Input",ExpressionUUID->"8f542ba5-effc-4d7e-93c0-d7822944b445"],
Cell[CellGroupData[{
Cell[337521, 9008, 750, 22, 50, "Input",ExpressionUUID->"5b40a2ac-32ee-4ae7-b677-44ea2230cdde"],
Cell[338274, 9032, 6367, 176, 106, "Output",ExpressionUUID->"08ee339c-f577-46bd-8e4d-bf357da8e0fe"]
}, Open  ]],
Cell[344656, 9211, 502, 10, 30, "Input",ExpressionUUID->"83bfbb2f-5b05-40c4-8375-98b9eee84463"],
Cell[CellGroupData[{
Cell[345183, 9225, 248, 6, 30, "Input",ExpressionUUID->"2eeb9615-f388-4e01-a7cc-156539e3684e"],
Cell[345434, 9233, 5450, 163, 152, "Output",ExpressionUUID->"8b1f280e-f9e8-4180-9606-a631d9ffb0be"]
}, Open  ]],
Cell[350899, 9399, 516, 10, 30, "Input",ExpressionUUID->"345da9cb-91e5-428f-945b-f35297c908ad"],
Cell[CellGroupData[{
Cell[351440, 9413, 441, 10, 73, "Input",ExpressionUUID->"35625a4f-6967-4263-ad05-49b2c788e4ea"],
Cell[351884, 9425, 4833, 151, 129, "Output",ExpressionUUID->"fc3d2403-7d37-4894-8d2c-79831adeed25"],
Cell[356720, 9578, 387, 11, 38, "Output",ExpressionUUID->"eb9c14ae-f7c4-4469-a025-0bb2f80e7354"]
}, Open  ]],
Cell[357122, 9592, 253, 6, 30, "Input",ExpressionUUID->"678eff54-4fb3-4874-96b4-16c15af03522"],
Cell[CellGroupData[{
Cell[357400, 9602, 719, 19, 30, "Input",ExpressionUUID->"5908d8f7-b0d1-444c-9d64-a418e08eaf59"],
Cell[358122, 9623, 5447, 159, 106, "Output",ExpressionUUID->"1906e864-867f-40da-82a9-142bd81d6c5f"]
}, Open  ]],
Cell[363584, 9785, 656, 17, 30, "Input",ExpressionUUID->"cb39bc01-bff5-4a2f-8956-52c1c5986be1"],
Cell[364243, 9804, 4403, 129, 79, "Input",ExpressionUUID->"80bb3c11-917b-4cab-9891-2d99fa9b98b8"],
Cell[368649, 9935, 152, 3, 30, "Input",ExpressionUUID->"3a9c3419-db96-4679-8a60-9c5eec21e6f0"],
Cell[368804, 9940, 423, 9, 30, "Input",ExpressionUUID->"e25b10ff-f610-45cd-a4eb-c8611fc1e059"],
Cell[CellGroupData[{
Cell[369252, 9953, 555, 16, 58, "Input",ExpressionUUID->"35a709c1-1923-4274-add5-364592880eb2"],
Cell[369810, 9971, 680, 22, 38, "Output",ExpressionUUID->"9a742ec8-8d25-4493-8a3d-103c824a8cb6"],
Cell[370493, 9995, 586, 18, 38, "Output",ExpressionUUID->"ef253c3a-2989-496c-8b13-6b78df9ab47a"]
}, Open  ]],
Cell[371094, 10016, 316, 6, 30, "Input",ExpressionUUID->"b2d159bc-c2e8-4a88-8023-ea879b86b21f"],
Cell[CellGroupData[{
Cell[371435, 10026, 708, 20, 30, "Input",ExpressionUUID->"b02aed33-8bfb-4c61-bf81-a3693e7202a2"],
Cell[372146, 10048, 813, 24, 58, "Output",ExpressionUUID->"ed50934f-7032-4e70-8c64-8c328443c18e"]
}, Open  ]],
Cell[372974, 10075, 382, 8, 30, "Input",ExpressionUUID->"e941ee0e-6b47-4fb6-bf88-ad30a3bbc994"],
Cell[CellGroupData[{
Cell[373381, 10087, 713, 20, 30, "Input",ExpressionUUID->"d4b346fa-9075-4b08-9b97-60516698f53f"],
Cell[374097, 10109, 1563, 50, 59, "Output",ExpressionUUID->"269a7bc2-e155-4f65-84cc-406450bfc37a"]
}, Open  ]],
Cell[375675, 10162, 337, 8, 30, "Input",ExpressionUUID->"7337431d-1902-48d9-b55b-183f640cfeeb"],
Cell[CellGroupData[{
Cell[376037, 10174, 683, 19, 30, "Input",ExpressionUUID->"0bacbb8c-28a8-471c-82ac-828344113b3e"],
Cell[376723, 10195, 1444, 45, 59, "Output",ExpressionUUID->"24f5e771-0e1f-440e-afed-b8195d03315e"]
}, Open  ]],
Cell[378182, 10243, 371, 11, 30, "Input",ExpressionUUID->"26d4ffe6-1f40-4d64-ac19-f71208255fa7"],
Cell[CellGroupData[{
Cell[378578, 10258, 927, 27, 52, "Input",ExpressionUUID->"7a1764b0-33f0-4227-bf5a-8ddd1026f859"],
Cell[379508, 10287, 1666, 53, 58, "Output",ExpressionUUID->"2aa34aad-920b-4083-870f-b78db4e2b478"]
}, Open  ]],
Cell[381189, 10343, 369, 11, 30, "Input",ExpressionUUID->"5d3eb0ac-a8f1-4c2a-998f-2e08c59f8558"],
Cell[CellGroupData[{
Cell[381583, 10358, 936, 27, 52, "Input",ExpressionUUID->"4a3df5ea-6b20-49c1-8a11-811f9fb6cc28"],
Cell[382522, 10387, 1510, 48, 58, "Output",ExpressionUUID->"92d5dc34-4f88-418a-b6a8-4b518a3d98b9"]
}, Open  ]],
Cell[CellGroupData[{
Cell[384069, 10440, 1283, 38, 73, "Input",ExpressionUUID->"dcaa22ba-9874-4b8c-b22e-7f657dbb4166"],
Cell[385355, 10480, 666, 20, 59, "Output",ExpressionUUID->"d6086b5e-f51e-4b98-9403-a242f101bc19"]
}, Open  ]],
Cell[386036, 10503, 620, 13, 30, "Input",ExpressionUUID->"bfd77eb0-b363-42d1-83e1-b4f0c9d5347e"],
Cell[CellGroupData[{
Cell[386681, 10520, 405, 12, 30, "Input",ExpressionUUID->"daed21c2-7308-4de4-a66f-28328da84015"],
Cell[387089, 10534, 350, 10, 56, "Output",ExpressionUUID->"91b4b4a6-9efb-463b-9f47-cf1125c4556d"]
}, Open  ]],
Cell[387454, 10547, 171, 3, 52, "Input",ExpressionUUID->"12e3f324-7972-4b59-8d60-310580945a3e"],
Cell[387628, 10552, 152, 3, 30, "Input",ExpressionUUID->"fcc78fb8-449e-4b34-beb8-7c385037db00"],
Cell[387783, 10557, 362, 9, 30, "Input",ExpressionUUID->"8a1f5848-0aa2-4d6f-a754-0e25cc953aaa"],
Cell[CellGroupData[{
Cell[388170, 10570, 713, 20, 30, "Input",ExpressionUUID->"88bf0afa-5fe0-4279-841e-c96d16977fa3"],
Cell[388886, 10592, 1565, 50, 59, "Output",ExpressionUUID->"2fa639c6-380e-4506-b793-43ca3f00d4e5"]
}, Open  ]],
Cell[390466, 10645, 472, 9, 30, "Input",ExpressionUUID->"0c0eeb80-0a63-4b83-a7f7-6b0b68535d64"],
Cell[CellGroupData[{
Cell[390963, 10658, 1834, 54, 56, "Input",ExpressionUUID->"445efe22-d182-4efc-83b9-e1c25cb99694"],
Cell[392800, 10714, 575, 17, 56, "Output",ExpressionUUID->"3e165d80-7c2d-4a83-bb05-5c248e5ed28d"]
}, Open  ]],
Cell[393390, 10734, 575, 12, 30, "Input",ExpressionUUID->"27b590a9-b92f-45e3-bef8-db8e97de2e1e"],
Cell[CellGroupData[{
Cell[393990, 10750, 410, 12, 30, "Input",ExpressionUUID->"fa677965-17ff-4557-a475-9492242028d2"],
Cell[394403, 10764, 1062, 36, 59, "Output",ExpressionUUID->"e7981528-bdbb-4be8-8633-aced4a0aaa3f"]
}, Open  ]],
Cell[395480, 10803, 387, 9, 30, "Input",ExpressionUUID->"1b2a9323-8929-4e71-bb99-9bbd7f6b4151"],
Cell[CellGroupData[{
Cell[395892, 10816, 1058, 32, 52, "Input",ExpressionUUID->"34d049bd-74cf-4338-bae9-9225f55c972b"],
Cell[396953, 10850, 1312, 42, 62, "Output",ExpressionUUID->"bfe82cdb-74b3-4966-a53a-d8bd141a04e2"]
}, Open  ]],
Cell[398280, 10895, 528, 14, 30, "Input",ExpressionUUID->"26da55ac-d01b-4647-81ef-194e56f43d56"],
Cell[CellGroupData[{
Cell[398833, 10913, 1012, 31, 33, "Input",ExpressionUUID->"5ad5bc52-218d-4298-a124-7a2241b4e44b"],
Cell[399848, 10946, 494, 15, 37, "Output",ExpressionUUID->"4e2e53f0-d389-4487-80b8-1714d8d31c06"]
}, Open  ]],
Cell[400357, 10964, 412, 10, 30, "Input",ExpressionUUID->"edfbeba1-6a85-44c1-ba91-d26c95cfffc5"],
Cell[400772, 10976, 683, 19, 30, "Input",ExpressionUUID->"dc4dfb41-bc59-476e-8b88-6100675dc97f"],
Cell[401458, 10997, 1438, 45, 56, "Input",ExpressionUUID->"dd77379e-1e75-44b9-9caa-b9b87b05926f"],
Cell[402899, 11044, 305, 6, 30, "Input",ExpressionUUID->"858d9dda-2cfa-43a0-b3e3-442ee957fc7c"],
Cell[CellGroupData[{
Cell[403229, 11054, 1676, 50, 56, "Input",ExpressionUUID->"f12cf372-3afc-4a15-9ad6-072003b98e60"],
Cell[404908, 11106, 585, 18, 56, "Output",ExpressionUUID->"85734363-5820-4851-9aca-3150b0a77c90"]
}, Open  ]],
Cell[405508, 11127, 567, 12, 30, "Input",ExpressionUUID->"8b2381ee-2550-4c57-a87f-daf97a3bcdcf"],
Cell[CellGroupData[{
Cell[406100, 11143, 384, 12, 30, "Input",ExpressionUUID->"3d339f46-048a-4d01-9df4-48bb27c6d1ba"],
Cell[406487, 11157, 1007, 35, 59, "Output",ExpressionUUID->"8300efc3-030e-48a0-85ab-2747276e49dc"]
}, Open  ]],
Cell[407509, 11195, 265, 5, 30, "Input",ExpressionUUID->"630bdadd-99e2-4265-9a7e-3625fbbf2815"],
Cell[CellGroupData[{
Cell[407799, 11204, 1015, 32, 52, "Input",ExpressionUUID->"8802c1b8-f638-4b76-96f4-ea6cd8612d53"],
Cell[408817, 11238, 1260, 41, 62, "Output",ExpressionUUID->"c8575da2-9551-4f27-9b5f-17e9ff9000d6"]
}, Open  ]],
Cell[410092, 11282, 406, 11, 30, "Input",ExpressionUUID->"f8f35584-c9f7-4787-924d-a72631450d06"],
Cell[CellGroupData[{
Cell[410523, 11297, 978, 31, 33, "Input",ExpressionUUID->"dcaf8508-e11b-4e54-b16f-0e89875b75d5"],
Cell[411504, 11330, 449, 14, 37, "Output",ExpressionUUID->"ceb19a24-05e7-4328-9ddc-b6c2791be0eb"]
}, Open  ]],
Cell[411968, 11347, 563, 14, 30, "Input",ExpressionUUID->"edc56c89-9cae-49bd-9d09-f5605111b236"],
Cell[CellGroupData[{
Cell[412556, 11365, 476, 13, 30, "Input",ExpressionUUID->"1eed43a3-117d-46c0-b030-7f18821f8e66"],
Cell[413035, 11380, 851, 27, 59, "Output",ExpressionUUID->"212c786a-14d4-4b0c-ad33-64ea3222eacd"]
}, Open  ]],
Cell[413901, 11410, 338, 8, 30, "Input",ExpressionUUID->"0d964abf-ef78-43f0-8932-8d3996317cfa"],
Cell[CellGroupData[{
Cell[414264, 11422, 859, 25, 52, "Input",ExpressionUUID->"1b41cf86-0023-47c8-a641-286be56c35dc"],
Cell[415126, 11449, 624, 18, 60, "Output",ExpressionUUID->"c4b0cd55-30fb-452c-a141-f8c562d6cd13"]
}, Open  ]],
Cell[415765, 11470, 528, 14, 30, "Input",ExpressionUUID->"6ffe87f9-16bf-47d9-9f93-464cdd49e6a3"],
Cell[CellGroupData[{
Cell[416318, 11488, 804, 23, 52, "Input",ExpressionUUID->"70bf5562-e6a4-4eca-8c6d-baad2ee4357f"],
Cell[417125, 11513, 304, 8, 37, "Output",ExpressionUUID->"645531f6-ddf3-4e2f-9abd-765515458e7c"]
}, Open  ]],
Cell[417444, 11524, 512, 13, 30, "Input",ExpressionUUID->"1cb33d63-3471-4bd1-9b8b-16237cd06059"],
Cell[CellGroupData[{
Cell[417981, 11541, 447, 12, 30, "Input",ExpressionUUID->"82303478-46d4-4abb-aa48-bf065edefb81"],
Cell[418431, 11555, 556, 18, 59, "Output",ExpressionUUID->"345ef6e8-1383-412d-9684-38b18922d14b"]
}, Open  ]],
Cell[419002, 11576, 265, 5, 30, "Input",ExpressionUUID->"140d4113-39dd-49d1-9c46-80ef07ef044f"],
Cell[CellGroupData[{
Cell[419292, 11585, 753, 23, 56, "Input",ExpressionUUID->"9bf4d270-e623-4216-9dbc-4d398b38e4f0"],
Cell[420048, 11610, 641, 18, 60, "Output",ExpressionUUID->"02a544a1-c133-42e5-8879-c51d10acf2a0"]
}, Open  ]],
Cell[420704, 11631, 477, 13, 30, "Input",ExpressionUUID->"4367196e-c584-4cdf-84bf-cd475cd596f5"],
Cell[CellGroupData[{
Cell[421206, 11648, 724, 22, 56, "Input",ExpressionUUID->"02ffec23-4eba-4958-9374-d9f841217079"],
Cell[421933, 11672, 302, 8, 57, "Output",ExpressionUUID->"bbe433ce-a19c-418d-8bb6-e0e4b75bfe7d"]
}, Open  ]],
Cell[422250, 11683, 477, 10, 30, "Input",ExpressionUUID->"79498c87-8fd8-4e5d-a24f-158c29f2b8f1"],
Cell[422730, 11695, 316, 8, 30, "Input",ExpressionUUID->"e5bbac27-547b-483f-9b4b-823521ec8de9"],
Cell[CellGroupData[{
Cell[423071, 11707, 465, 13, 30, "Input",ExpressionUUID->"12d7c91b-f3b1-4dec-8b0d-5ee51ac666a4"],
Cell[423539, 11722, 1213, 36, 62, "Output",ExpressionUUID->"f5ae1eb6-c25d-42a0-88d6-937c2bac6f8b"]
}, Open  ]],
Cell[424767, 11761, 268, 7, 30, "Input",ExpressionUUID->"604f9c4d-3575-4707-befd-354ae337d42b"],
Cell[CellGroupData[{
Cell[425060, 11772, 498, 13, 30, "Input",ExpressionUUID->"6b3a23c1-5241-41a5-9764-7b8e78f3402e"],
Cell[425561, 11787, 1258, 37, 60, "Output",ExpressionUUID->"1d57ba06-4dfe-4b29-a7ff-9686d43b54cc"]
}, Open  ]],
Cell[426834, 11827, 531, 12, 30, "Input",ExpressionUUID->"b3b0b842-b9e5-431e-ae25-5f7a90ebf5ae"],
Cell[CellGroupData[{
Cell[427390, 11843, 2193, 64, 89, "Input",ExpressionUUID->"53e56f57-b8b3-4034-859a-2f58dd442d1b"],
Cell[429586, 11909, 9367, 234, 191, "Output",ExpressionUUID->"ff1aafec-15c8-4dc5-9c58-201ab6f77fc4"]
}, Open  ]],
Cell[438968, 12146, 389, 10, 30, "Input",ExpressionUUID->"c748eba9-0c04-4a39-a698-720649b37561"],
Cell[CellGroupData[{
Cell[439382, 12160, 2183, 64, 89, "Input",ExpressionUUID->"46f48a9f-3067-4649-9f4d-daa33f102abf"],
Cell[441568, 12226, 8431, 211, 103, "Output",ExpressionUUID->"d25d7ad3-fc9e-49a1-87b4-9da3af79c955"]
}, Open  ]],
Cell[450014, 12440, 393, 8, 30, "Input",ExpressionUUID->"10fa52e6-d0cf-4162-bd80-bd35ee476baa"],
Cell[450410, 12450, 774, 20, 30, "Input",ExpressionUUID->"a7a80709-437e-4fe8-8282-c03d546f5945"],
Cell[CellGroupData[{
Cell[451209, 12474, 1000, 32, 57, "Input",ExpressionUUID->"c6d51675-b17a-4370-a034-242251d1bc0d"],
Cell[452212, 12508, 325, 9, 53, "Output",ExpressionUUID->"f40986e9-6e82-45b6-9615-38725ff65f81"]
}, Open  ]],
Cell[452552, 12520, 772, 20, 30, "Input",ExpressionUUID->"8d1ca338-c05d-474a-9818-7e65f7957b19"],
Cell[CellGroupData[{
Cell[453349, 12544, 983, 31, 57, "Input",ExpressionUUID->"2c3f5b22-f644-47e9-bc27-991fa5ab150a"],
Cell[454335, 12577, 224, 5, 34, "Output",ExpressionUUID->"99f5ee60-2b2f-484c-844b-de87987d24f5"]
}, Open  ]],
Cell[454574, 12585, 363, 8, 30, "Input",ExpressionUUID->"a11fcecb-b000-4f54-90ed-3895b15669f4"],
Cell[454940, 12595, 1601, 47, 76, "Input",ExpressionUUID->"4dc9d249-c335-4d08-a90a-31bbf6c6d779"],
Cell[CellGroupData[{
Cell[456566, 12646, 564, 15, 52, "Input",ExpressionUUID->"8b346b62-d44f-40da-a0ed-bee7648b5bb3"],
Cell[457133, 12663, 485, 14, 50, "Output",ExpressionUUID->"6121ca7b-4a5d-4480-8ff3-fec1ae8a543b"],
Cell[457621, 12679, 876, 26, 58, "Output",ExpressionUUID->"ba5337e0-04c3-4623-9f70-172fdf6e80fe"]
}, Open  ]],
Cell[458512, 12708, 154, 3, 30, "Input",ExpressionUUID->"0ca4a183-369b-4df2-8f9d-eb0777ca825e"],
Cell[458669, 12713, 1566, 41, 65, "Input",ExpressionUUID->"18402bbd-9f00-48b4-ab91-230ce34e37c1"],
Cell[CellGroupData[{
Cell[460260, 12758, 354, 8, 30, "Input",ExpressionUUID->"84c4d89d-2cbf-4bb5-9164-a42281a47e4f"],
Cell[460617, 12768, 937, 31, 59, "Output",ExpressionUUID->"bc93fe7c-c727-487b-b7b8-62678fc53ed8"]
}, Open  ]],
Cell[461569, 12802, 664, 17, 30, "Input",ExpressionUUID->"f1f5ea75-ad1e-4478-b1e5-5a6cc87838a2"],
Cell[462236, 12821, 946, 30, 54, "Input",ExpressionUUID->"421ffd55-6648-4bba-af6d-3f57d29c473d"],
Cell[CellGroupData[{
Cell[463207, 12855, 554, 15, 52, "Input",ExpressionUUID->"a49d9050-b8c6-494f-b064-10e5191a2f73"],
Cell[463764, 12872, 475, 13, 50, "Output",ExpressionUUID->"fc62c688-99e6-43ca-9f56-8f67e41a3fbf"],
Cell[464242, 12887, 650, 19, 55, "Output",ExpressionUUID->"16637e07-05c9-4f15-a658-2ef71c590b53"]
}, Open  ]],
Cell[464907, 12909, 1221, 33, 65, "Input",ExpressionUUID->"a07a4dae-3185-4916-bfb5-1839ad64d86c"],
Cell[CellGroupData[{
Cell[466153, 12946, 351, 8, 30, "Input",ExpressionUUID->"956a9139-2ebf-4241-8897-074d8048534b"],
Cell[466507, 12956, 924, 29, 55, "Output",ExpressionUUID->"9bf05269-d6f9-43e1-a94b-7e3f53aba89e"]
}, Open  ]],
Cell[467446, 12988, 456, 11, 30, "Input",ExpressionUUID->"58dde0c7-60e4-47e6-835e-ffbb6be59ff5"],
Cell[467905, 13001, 240, 6, 30, "Input",ExpressionUUID->"0d476c03-1b94-4753-a826-01d068d9b7a8"],
Cell[CellGroupData[{
Cell[468170, 13011, 545, 16, 30, "Input",ExpressionUUID->"22f7920c-568b-4326-9c7f-e14dfef45263"],
Cell[468718, 13029, 460, 13, 56, "Output",ExpressionUUID->"603b5b96-90a2-49aa-8e6a-52d3138b8122"]
}, Open  ]],
Cell[469193, 13045, 463, 12, 30, "Input",ExpressionUUID->"108f771f-2cbe-44e1-84f7-69a5f79c7ae0"],
Cell[CellGroupData[{
Cell[469681, 13061, 631, 17, 30, "Input",ExpressionUUID->"aa170cb6-aca9-465d-bcf0-20985460220b"],
Cell[470315, 13080, 845, 28, 56, "Output",ExpressionUUID->"12a39c84-325a-4b0f-a138-5774d1dab65d"]
}, Open  ]],
Cell[471175, 13111, 202, 4, 30, "Input",ExpressionUUID->"ea2f32d8-9dd8-410c-907a-186ecee5a3df"],
Cell[471380, 13117, 242, 6, 30, "Input",ExpressionUUID->"53780b7e-11c8-4c7b-b093-4e88537eee1f"],
Cell[CellGroupData[{
Cell[471647, 13127, 512, 15, 30, "Input",ExpressionUUID->"1adf74c5-ef79-477b-86b0-404bbfbe462c"],
Cell[472162, 13144, 554, 16, 58, "Output",ExpressionUUID->"f91b22b1-e9b6-4d97-be13-48780833d4c5"]
}, Open  ]],
Cell[472731, 13163, 416, 11, 30, "Input",ExpressionUUID->"ebf67f0e-981b-44a2-a157-7cff3d6da31e"],
Cell[CellGroupData[{
Cell[473172, 13178, 600, 16, 30, "Input",ExpressionUUID->"014c8525-db9a-4bef-89d4-7874af5520f4"],
Cell[473775, 13196, 762, 24, 58, "Output",ExpressionUUID->"c30637da-f38e-44cf-b662-eaef8a41bfad"]
}, Open  ]],
Cell[474552, 13223, 277, 6, 30, "Input",ExpressionUUID->"7ede65c3-6666-4646-8bce-b44647a467b4"],
Cell[474832, 13231, 171, 4, 30, "Input",ExpressionUUID->"3ab1953f-dbce-461e-9fb3-8ba1ea2ff19d"],
Cell[CellGroupData[{
Cell[475028, 13239, 573, 16, 52, "Input",ExpressionUUID->"37f01f2d-32c5-4fd9-b697-2aacd795213f"],
Cell[475604, 13257, 1112, 33, 62, "Output",ExpressionUUID->"244c6cc9-8910-4aee-99db-66699889a6e2"]
}, Open  ]],
Cell[476731, 13293, 1125, 36, 59, "Input",ExpressionUUID->"65e8cce5-ef07-4121-ad3e-2e7e08412522"],
Cell[477859, 13331, 342, 8, 30, "Input",ExpressionUUID->"a63a923c-4c6d-4d79-a0e8-8b35bca5c0c8"],
Cell[CellGroupData[{
Cell[478226, 13343, 756, 22, 30, "Input",ExpressionUUID->"751cc04a-9dcd-4323-939d-430bebad369c"],
Cell[478985, 13367, 390, 9, 24, "Message",ExpressionUUID->"8feec346-31e3-4393-84cb-4017180e39c1"],
Cell[479378, 13378, 466, 12, 50, "Output",ExpressionUUID->"7d6ca24f-aac1-49ea-93a3-115e5124aa81"]
}, Open  ]],
Cell[CellGroupData[{
Cell[479881, 13395, 590, 15, 30, "Input",ExpressionUUID->"7fe9583d-3c2a-4d85-8264-ed3742734176"],
Cell[480474, 13412, 345, 8, 54, "Output",ExpressionUUID->"7d762697-2742-457d-8642-ed45ad4c394e"]
}, Open  ]],
Cell[480834, 13423, 918, 24, 73, "Input",ExpressionUUID->"e2b477e0-3cd5-446c-b101-9c44a5d3fb07"],
Cell[CellGroupData[{
Cell[481777, 13451, 498, 14, 30, "Input",ExpressionUUID->"5704ba44-3a99-4de7-b2ff-6e8a2a2be9bf"],
Cell[482278, 13467, 229, 4, 34, "Output",ExpressionUUID->"8a7db85a-b93c-4897-a8cf-6089744d3285"]
}, Open  ]],
Cell[CellGroupData[{
Cell[482544, 13476, 329, 8, 30, "Input",ExpressionUUID->"cb2ca5f6-1716-46d9-ae06-586fd4c08117"],
Cell[482876, 13486, 297, 8, 53, "Output",ExpressionUUID->"0b8af8e5-f6ce-4382-87bf-be8a184d80f9"]
}, Open  ]],
Cell[483188, 13497, 239, 6, 30, "Input",ExpressionUUID->"2ed13cc7-ff1c-4104-bb4a-cec3cc341e77"],
Cell[CellGroupData[{
Cell[483452, 13507, 582, 16, 52, "Input",ExpressionUUID->"df7e696a-f26a-46b8-96ba-be806d587d41"],
Cell[484037, 13525, 1131, 34, 62, "Output",ExpressionUUID->"921128a3-49f3-4e2c-a470-dff2d3ee5f97"]
}, Open  ]],
Cell[485183, 13562, 230, 5, 30, "Input",ExpressionUUID->"9f38716f-257d-4f54-92dd-c57087b0921e"],
Cell[CellGroupData[{
Cell[485438, 13571, 446, 13, 30, "Input",ExpressionUUID->"8f70ed32-d6e3-4e57-8047-b7c1e922f575"],
Cell[485887, 13586, 393, 12, 54, "Output",ExpressionUUID->"e8c63a6f-fe76-49db-910b-933e42e6c73c"]
}, Open  ]],
Cell[486295, 13601, 663, 18, 52, "Input",ExpressionUUID->"e86ad77e-eb92-4077-8f9a-883c85939a5a"],
Cell[CellGroupData[{
Cell[486983, 13623, 447, 13, 30, "Input",ExpressionUUID->"fcba76e1-05fe-43c4-8ec8-ed6711f38a35"],
Cell[487433, 13638, 225, 5, 34, "Output",ExpressionUUID->"6a14ad4b-34e6-4a6f-ac12-6ea461491a3c"]
}, Open  ]],
Cell[CellGroupData[{
Cell[487695, 13648, 350, 9, 30, "Input",ExpressionUUID->"124e6ce7-769e-4086-8e98-a58dbc5ed18e"],
Cell[488048, 13659, 276, 7, 53, "Output",ExpressionUUID->"ae617947-5ee1-4a4a-9207-7c7fce9d824d"]
}, Open  ]]
}
]
*)

